
#include <osl.h>
#include <dhd_linux.h>
#include <linux/gpio.h>

#ifdef CUSTOMER_HW_PLATFORM
#include <plat/sdhci.h>
#define	sdmmc_channel	sdmmc_device_mmc0
#endif /* CUSTOMER_HW_PLATFORM */

#if defined(BUS_POWER_RESTORE) && defined(BCMSDIO)
#include <linux/mmc/core.h>
#include <linux/mmc/card.h>
#include <linux/mmc/host.h>
#include <linux/mmc/sdio_func.h>
#endif /* defined(BUS_POWER_RESTORE) && defined(BCMSDIO) */

#ifdef CONFIG_DHD_USE_STATIC_BUF
extern void *dhd_wlan_mem_prealloc(int section, unsigned long size);
#endif /* CONFIG_DHD_USE_STATIC_BUF */

static int gpio_wl_reg_on = -1; // WL_HOST_WAKE is output pin of WLAN module
static int gpio_wl_host_wake = -1; // WL_HOST_WAKE is output pin of WLAN module
#ifdef CUSTOMER_OOB
static int host_oob_irq = -1;
#endif

#ifdef USE_ACPI
#include <linux/acpi.h>
#ifdef CUSTOMER_INTEL_BYT
#include <linux/acpi_gpio.h>
#else /* CUSTOMER_INTEL_BYT */
#include <linux/gpio.h>
#endif
#include <asm/intel-mid.h>

struct acpi_device_id bcm_acpi_id[] = {
/* ACPI IDs here */
#if defined(BCMSDIO)
	{ "RTL8723" },
	{ "BCM43241" },
	{ "BCM4321" },
	{ "BCM43341" },
	{ "BCM4334" },
#endif /* BCMSDIO */
	{ "BCM4356" },
	{ }
};
MODULE_DEVICE_TABLE(acpi, bcm_acpi_id);

static int wifi_acpi_match(struct device *dev, void *data)
{
	struct acpi_device_id *ids = data, *id;
	struct platform_device *pdev = to_platform_device(dev);

	for (id = ids; id->id[0]; id++) {
		if (!strncmp(id->id, pdev->name, strlen(id->id))) {
			printf("found wifi acpi device %s\n", id->id);
			return TRUE;
		}
	}
	return FALSE;
}

struct device *dhd_wlan_get_intel_dev(void) {
	struct device *dev;
	dev = bus_find_device(&platform_bus_type, NULL, bcm_acpi_id, wifi_acpi_match);
	return dev;
}
#endif /* USE_ACPI */

static int
dhd_wlan_set_power(bool on
#ifdef BUS_POWER_RESTORE
, wifi_adapter_info_t *adapter
#endif /* BUS_POWER_RESTORE */
)
{
	int err = 0;
#if defined(USE_ACPI) && !defined(CUSTOMER_INTEL_BYT)
	struct device *dev;
	struct acpi_device *adev;
	acpi_handle handle;
	struct platform_device *pdev;
#endif /* USE_ACPI && !CUSTOMER_INTEL_BYT */

#if defined(USE_ACPI) && !defined(CUSTOMER_INTEL_BYT)
	dev = bus_find_device(&platform_bus_type, NULL, bcm_acpi_id, wifi_acpi_match);
	if (!dev) {
		printf("%s: could not get dev!\n", __FUNCTION__);
		return -1;
	}
	pdev = to_platform_device(dev);
	if (!pdev) {
		printf("%s: could not get pdev!\n", __FUNCTION__);
		return -1;
	}
	handle = ACPI_HANDLE(&pdev->dev);
	/* Dont try to do acpi pm for the wifi module */
	if (!handle || acpi_bus_get_device(handle, &adev)) {
		printf("%s: could not get acpi pointer!\n", __FUNCTION__);
		return -1;
	}
	/* Make sure ACPI PM functions will perform PM requests */
	adev->flags.power_manageable = 1;
#endif /* USE_ACPI && !CUSTOMER_INTEL_BYT */

	if (on) {
		printf("======== PULL WL_REG_ON(%d) HIGH! ========\n", gpio_wl_reg_on);
		if (gpio_wl_reg_on >= 0) {
			err = gpio_direction_output(gpio_wl_reg_on, 0);
			mdelay(1);
			err = gpio_direction_output(gpio_wl_reg_on, 1);
			if (err) {
				printf("%s: WL_REG_ON didn't output high\n", __FUNCTION__);
				return -EIO;
			}
		}
#if defined(USE_ACPI) && !defined(CUSTOMER_INTEL_BYT)
/*		acpi_device_set_power(adev, ACPI_STATE_D0);*/
#endif /* USE_ACPI && !CUSTOMER_INTEL_BYT */
#if defined(BUS_POWER_RESTORE)
#if defined(BCMSDIO)
		if (adapter->sdio_func && adapter->sdio_func->card && adapter->sdio_func->card->host) {
			printf("======== mmc_power_restore_host! ========\n");
			mmc_power_restore_host(adapter->sdio_func->card->host);
		}
#elif defined(BCMPCIE)
		OSL_SLEEP(50); /* delay needed to be able to restore PCIe configuration registers */
		if (adapter->pci_dev) {
			printf("======== pci_set_power_state PCI_D0! ========\n");
			pci_set_power_state(adapter->pci_dev, PCI_D0);
			if (adapter->pci_saved_state)
				pci_load_and_free_saved_state(adapter->pci_dev, &adapter->pci_saved_state);
			pci_restore_state(adapter->pci_dev);
			err = pci_enable_device(adapter->pci_dev);
			if (err < 0)
				printf("%s: PCI enable device failed", __FUNCTION__);
			pci_set_master(adapter->pci_dev);
		}
#endif /* BCMPCIE */
#endif /* BUS_POWER_RESTORE */
		/* Lets customer power to get stable */
		mdelay(100);
	} else {
#if defined(BUS_POWER_RESTORE)
#if defined(BCMSDIO)
		if (adapter->sdio_func && adapter->sdio_func->card && adapter->sdio_func->card->host) {
			printf("======== mmc_power_save_host! ========\n");
			mmc_power_save_host(adapter->sdio_func->card->host);
		}
#elif defined(BCMPCIE)
		if (adapter->pci_dev) {
			printf("======== pci_set_power_state PCI_D3hot! ========\n");
			pci_save_state(adapter->pci_dev);
			adapter->pci_saved_state = pci_store_saved_state(adapter->pci_dev);
			if (pci_is_enabled(adapter->pci_dev))
				pci_disable_device(adapter->pci_dev);
			pci_set_power_state(adapter->pci_dev, PCI_D3hot);
		}
#endif /* BCMPCIE */
#endif /* BUS_POWER_RESTORE */
		printf("======== PULL WL_REG_ON(%d) LOW! ========\n", gpio_wl_reg_on);
#if defined(USE_ACPI) && !defined(CUSTOMER_INTEL_BYT)
/*		acpi_device_set_power(adev, ACPI_STATE_D3_COLD); */
#endif /* USE_ACPI && !CUSTOMER_INTEL_BYT */
		if (gpio_wl_reg_on >= 0) {
			err = gpio_direction_output(gpio_wl_reg_on, 0);
			if (err) {
				printf("%s: WL_REG_ON didn't output low\n", __FUNCTION__);
				return -EIO;
			}
		}
	}

#if defined(USE_ACPI) && !defined(CUSTOMER_INTEL_BYT)
	/* Make sure ACPI PM is not performed outside of this function  */
	adev->flags.power_manageable = 0;
#endif /* USE_ACPI && !CUSTOMER_INTEL_BYT */

	return err;
}

static int dhd_wlan_set_reset(int onoff)
{
	return 0;
}

static int dhd_wlan_set_carddetect(bool present)
{
	int err = 0;

#if !defined(BUS_POWER_RESTORE)
	if (present) {
#if defined(BCMSDIO)
		printf("======== Card detection to detect SDIO card! ========\n");
#ifdef CUSTOMER_HW_PLATFORM
		err = sdhci_force_presence_change(&sdmmc_channel, 1);
#endif /* CUSTOMER_HW_PLATFORM */
#elif defined(BCMPCIE)
		printf("======== Card detection to detect PCIE card! ========\n");
#endif
	} else {
#if defined(BCMSDIO)
		printf("======== Card detection to remove SDIO card! ========\n");
#ifdef CUSTOMER_HW_PLATFORM
		err = sdhci_force_presence_change(&sdmmc_channel, 0);
#endif /* CUSTOMER_HW_PLATFORM */
#elif defined(BCMPCIE)
		printf("======== Card detection to remove PCIE card! ========\n");
#endif
	}
#endif /* BUS_POWER_RESTORE */

	return err;
}

#if 0
#define MAC_ADDRESS_LEN 12
int wifi_get_mac_addr_intel(unsigned char *buf){
	int ret = 0;
	int i;
	struct file *fp = NULL;
	unsigned char c_mac[MAC_ADDRESS_LEN];
	char fname[]="/config/wifi/mac.txt";

	fp = dhd_os_open_image(fname);
	if (fp== NULL){
		printf("%s: unable to open %s\n",__FUNCTION__, fname);
		return 1;
	}

	if ( dhd_os_get_image_block(c_mac, MAC_ADDRESS_LEN, fp) != MAC_ADDRESS_LEN ){
		printf("%s: Error on reading mac address from %s \n",__FUNCTION__, fname);
		dhd_os_close_image(fp);
		return 1;
	}
	dhd_os_close_image(fp);

	for (i =0; i< MAC_ADDRESS_LEN ; i+=2){
		c_mac[i] = bcm_isdigit(c_mac[i]) ? c_mac[i]-'0' : bcm_toupper(c_mac[i])-'A'+10;
		c_mac[i+1] = bcm_isdigit(c_mac[i+1]) ? c_mac[i+1]-'0' : bcm_toupper(c_mac[i+1])-'A'+10;
		buf[i/2] = c_mac[i]*16 + c_mac[i+1];
	}

	printf("%s: read from file mac address: %02x:%02x:%02x:%02x:%02x:%02x\n",
			 __FUNCTION__, buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);

	return ret;
}
#endif

static int dhd_wlan_get_mac_addr(unsigned char *buf)
{
	int err = 0;

	printf("======== %s ========\n", __FUNCTION__);
#if 0
	wifi_get_mac_addr_intel(buf);
#endif
#ifdef EXAMPLE_GET_MAC
	/* EXAMPLE code */
	{
		struct ether_addr ea_example = {{0x00, 0x11, 0x22, 0x33, 0x44, 0xFF}};
		bcopy((char *)&ea_example, buf, sizeof(struct ether_addr));
	}
#endif /* EXAMPLE_GET_MAC */

	return err;
}

#if !defined(WL_WIRELESS_EXT)
struct cntry_locales_custom {
	char iso_abbrev[WLC_CNTRY_BUF_SZ];	/* ISO 3166-1 country abbreviation */
	char custom_locale[WLC_CNTRY_BUF_SZ];	/* Custom firmware locale */
	int32 custom_locale_rev;		/* Custom local revisin default -1 */
};
#endif

static struct cntry_locales_custom brcm_wlan_translate_custom_table[] = {
	/* Table should be filled out based on custom platform regulatory requirement */
	{"",   "XT", 49},  /* Universal if Country code is unknown or empty */
	{"US", "US", 0},
};

#ifdef CUSTOM_FORCE_NODFS_FLAG
struct cntry_locales_custom brcm_wlan_translate_nodfs_table[] = {
	{"",   "XT", 50},  /* Universal if Country code is unknown or empty */
	{"US", "US", 0},
};
#endif

static void *dhd_wlan_get_country_code(char *ccode
#ifdef CUSTOM_FORCE_NODFS_FLAG
	, u32 flags
#endif
)
{
	struct cntry_locales_custom *locales;
	int size;
	int i;

	if (!ccode)
		return NULL;

#ifdef CUSTOM_FORCE_NODFS_FLAG
	if (flags & WLAN_PLAT_NODFS_FLAG) {
		locales = brcm_wlan_translate_nodfs_table;
		size = ARRAY_SIZE(brcm_wlan_translate_nodfs_table);
	} else {
#endif
		locales = brcm_wlan_translate_custom_table;
		size = ARRAY_SIZE(brcm_wlan_translate_custom_table);
#ifdef CUSTOM_FORCE_NODFS_FLAG
	}
#endif

	for (i = 0; i < size; i++)
		if (strcmp(ccode, locales[i].iso_abbrev) == 0)
			return &locales[i];
	return NULL;
}

struct resource dhd_wlan_resources[] = {
	[0] = {
		.name	= "bcmdhd_wlan_irq",
		.start	= 0, /* Dummy */
		.end	= 0, /* Dummy */
		.flags	= IORESOURCE_IRQ | IORESOURCE_IRQ_SHAREABLE
			| IORESOURCE_IRQ_LOWEDGE, /* Dummy */
	},
};

struct wifi_platform_data dhd_wlan_control = {
	.set_power	= dhd_wlan_set_power,
	.set_reset	= dhd_wlan_set_reset,
	.set_carddetect	= dhd_wlan_set_carddetect,
	.get_mac_addr	= dhd_wlan_get_mac_addr,
#ifdef CONFIG_DHD_USE_STATIC_BUF
	.mem_prealloc	= dhd_wlan_mem_prealloc,
#endif /* CONFIG_DHD_USE_STATIC_BUF */
	.get_country_code = dhd_wlan_get_country_code,
};

int dhd_wlan_init_gpio(void)
{
	int err = 0;
	struct gpio_desc *gpiod_reg_on;
	struct gpio_desc *gpiod_host_wake;
#ifdef CUSTOMER_OOB
	uint host_oob_irq_flags = 0;
#endif
#if defined(CUSTOMER_OOB) && defined(USE_ACPI)
	struct device *dev;
	struct acpi_device *adev;
	acpi_handle handle;
	struct platform_device *pdev;
#endif /* USE_ACPI */

	/* Please check your schematic and fill right GPIO number which connected to
	* WL_REG_ON and WL_HOST_WAKE.
	*/
	gpio_wl_reg_on = -1;
	gpio_wl_host_wake = -1;
	/* xiayang change
	printf("%s: GPIO(WL_REG_ON) = %d\n", __FUNCTION__, gpio_wl_reg_on);
	if (gpio_wl_reg_on >= 0) {
		err = gpio_request(gpio_wl_reg_on, "WL_REG_ON");
		if (err < 0) {
			printf("%s: Faiiled to request gpio %d for WL_REG_ON\n",
				__FUNCTION__, gpio_wl_reg_on);
			gpio_wl_reg_on = -1;
		}
	} */

#ifdef CUSTOMER_OOB
#if defined(USE_ACPI)
	dev = bus_find_device(&platform_bus_type, NULL, bcm_acpi_id, wifi_acpi_match);
	pdev = to_platform_device(dev);

	if (ACPI_HANDLE(&pdev->dev)) {
		handle = ACPI_HANDLE(&pdev->dev);

		/* Dont try to do acpi pm for the wifi module */
		if (!handle || acpi_bus_get_device(handle, &adev))
			printf("%s: could not get acpi pointer!\n", __FUNCTION__);
		else {
			/* Ignore SDIO ACPI power states and
			 * prevent ACPI PM at probing stage.
			 * power_manageable is reenabled when
			 * setting power for the first time
			 */
			adev->flags.power_manageable = 0;
#if !defined(CUSTOMER_INTEL_BYT)
			/* Ignore SDH SDIO controller ACPI PM state */
			adev->power.flags.ignore_parent = 1;
#endif /* !CUSTOMER_INTEL_BYT */
		}
#if !defined(CUSTOMER_INTEL_BYT)
		gpiod_reg_on = gpiod_get_index(&pdev->dev, NULL, 1, GPIOD_OUT_HIGH);
		if(IS_ERR(gpiod_reg_on))
			{
				err = PTR_ERR(gpiod_reg_on);
				printf("%s: GPIO(WL_REG_ON) failed,err= %d\n", __FUNCTION__, err);
				return err;
			}
		gpio_wl_reg_on = desc_to_gpio(gpiod_reg_on);
		/****xiayang add ******/
		/*gpio_wl_reg_on = desc_to_gpio(gpiod_get_index(&pdev->dev, NULL, 1, GPIOD_OUT_HIGH));*/
		printf("%s: GPIO(WL_REG_ON) = %d\n", __FUNCTION__, gpio_wl_reg_on);
		if (!gpio_is_valid(gpio_wl_reg_on)) {
				printf("%s: gpio %d for WL_REG_ON is invalid\n",
					__FUNCTION__, gpio_wl_reg_on);
				gpio_wl_reg_on = -1;
		}
		/****change end****/
		/***change by xiayang***/
		/*gpio_wl_host_wake = desc_to_gpio(gpiod_get_index(&pdev->dev, NULL, 0));*/
		gpiod_host_wake = gpiod_get_index(&pdev->dev, NULL, 0, GPIOD_IN);
		if(IS_ERR(gpiod_host_wake))
                        {
                                err = PTR_ERR(gpiod_host_wake);
                                printf("%s: GPIO(WL_HOST WAKE) failed,err= %d\n", __FUNCTION__, err);
                                return err;
                        }
		gpio_wl_host_wake = desc_to_gpio(gpiod_host_wake);
		/*gpio_wl_host_wake = desc_to_gpio(gpiod_get_index(&pdev->dev, NULL, 0, GPIOD_IN));*/
		if (gpio_wl_host_wake < 0) {
			printf("%s: Fail to get GPIO numbe from ACPI table: %d\n", __FUNCTION__, gpio_wl_host_wake);
			gpio_wl_host_wake = -1;
			return 0;
		}
#else
		gpio_wl_host_wake = acpi_get_gpio_by_index(&pdev->dev, 0, NULL);
		if (gpio_wl_host_wake < 0) {
			if (INTEL_MID_BOARD(2, TABLET, BYT, BLB, PRO) ||
			    INTEL_MID_BOARD(2, TABLET, BYT, BLB, ENG)) {
				printf("%s: BYT-M hardcoding\n", __FUNCTION__);
				gpio_wl_host_wake = acpi_get_gpio("\\_SB.GPO2", 17);
			}
			else {
				printf("%s: BYT-T hardcoding\n", __FUNCTION__);
				gpio_wl_host_wake = acpi_get_gpio("\\_SB.GPO2", 15);
			}
		}
#endif
	} else {
		printf("%s: Null ACPI_HANDLE\n", __FUNCTION__);
		return -1;
	}
#endif /* USE_ACPI */

	printf("%s: GPIO(WL_HOST_WAKE) = %d\n", __FUNCTION__, gpio_wl_host_wake);
	if (gpio_wl_host_wake >= 0) {
#if defined(CUSTOMER_INTEL_BYT)
		err = gpio_request(gpio_wl_host_wake, "bcm43xx_irq");
		if (err < 0) {
			printf("%s: gpio_request failed\n", __FUNCTION__);
			return -1;
		}
		err = gpio_direction_input(gpio_wl_host_wake);
		if (err < 0) {
			printf("%s: gpio_direction_input failed\n", __FUNCTION__);
			gpio_free(gpio_wl_host_wake);
			return -1;
		}
		if (gpio_set_debounce(gpio_wl_host_wake, 0) < 0)
			printf("%s: Error on gpio_set_debounce\n", __func__);
#endif
		host_oob_irq = gpio_to_irq(gpio_wl_host_wake);
		if (host_oob_irq < 0) {
			printf("%s: gpio_to_irq failed\n", __FUNCTION__);
			gpio_free(gpio_wl_host_wake);
			return -1;
		}
	}
	printf("%s: host_oob_irq: %d\n", __FUNCTION__, host_oob_irq);

#ifdef HW_OOB
#ifdef HW_OOB_LOW_LEVEL
	host_oob_irq_flags = IORESOURCE_IRQ | IORESOURCE_IRQ_LOWLEVEL | IORESOURCE_IRQ_SHAREABLE;
#else
	host_oob_irq_flags = IORESOURCE_IRQ | IORESOURCE_IRQ_HIGHLEVEL | IORESOURCE_IRQ_SHAREABLE;
#endif
#else
	host_oob_irq_flags = IORESOURCE_IRQ | IORESOURCE_IRQ_HIGHEDGE | IORESOURCE_IRQ_SHAREABLE;
#endif

#if defined(CUSTOMER_HW_INTEL)
	host_oob_irq_flags = IRQF_TRIGGER_FALLING;
#endif /* CUSTOMER_INTEL_ANDROID */

	dhd_wlan_resources[0].flags = host_oob_irq_flags;
	printf("%s: host_oob_irq_flags=0x%x\n", __FUNCTION__, host_oob_irq_flags);
#endif /* CUSTOMER_OOB */

	return 0;
}

static void dhd_wlan_deinit_gpio(void)
{
	if (gpio_wl_reg_on >= 0) {
		printf("%s: gpio_free(WL_REG_ON %d)\n", __FUNCTION__, gpio_wl_reg_on);
		gpio_free(gpio_wl_reg_on);
	}
#ifdef CUSTOMER_OOB
	if (host_oob_irq >= 0 && gpio_wl_host_wake >= 0) {
		printf("%s: gpio_free(WL_HOST_WAKE %d)\n", __FUNCTION__, gpio_wl_host_wake);
		gpio_free(gpio_wl_host_wake);
	}
#endif /* CUSTOMER_OOB */
}

int dhd_wlan_init_plat_data(void)
{
	int err = 0;

	printf("======== %s ========\n", __FUNCTION__);
	err = dhd_wlan_init_gpio();
#ifdef CUSTOMER_OOB
	dhd_wlan_resources[0].start = dhd_wlan_resources[0].end = host_oob_irq;
#endif /* CUSTOMER_OOB */
	return err;
}

void dhd_wlan_deinit_plat_data(wifi_adapter_info_t *adapter)
{
	printf("======== %s ========\n", __FUNCTION__);
	dhd_wlan_deinit_gpio();
}
