/*
 * HID sensor-related constants and names translations
 *
 * Copyright (c) 2014-2015, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 */

#ifndef _HID_STRINGS_DEF_H_
#define _HID_STRINGS_DEF_H_


static const struct sensor_map {
	unsigned code;
	char *msg;
} code_msg_arr[] = {
	{0x01,	"type_collection"},
	{0x10,	"category_biometric"},
	{0x11,	"type_biometric_presence"},
	{0x12,	"type_biometric_proximity"},
	{0x13,	"type_biometric_touch"},
	{0x20,	"category_electrical"},
	{0x21,	"type_electrical_capacitance"},
	{0x22,	"type_electrical_current"},
	{0x23,	"type_electrical_power"},
	{0x24,	"type_electrical_inductance"},
	{0x25,	"type_electrical_resistance"},
	{0x26,	"type_electrical_voltage"},
	{0x27,	"type_electrical_potentiometer"},
	{0x28,	"type_electrical_frequency"},
	{0x29,	"type_electrical_period"},
	{0x30,	"category_environmental"},
	{0x31,	"type_environmental_atmospheric_pressure"},
	{0x32,	"type_environmental_humidity"},
	{0x33,	"type_environmental_temperature"},
	{0x34,	"type_environmental_wind_direction"},
	{0x35,	"type_environmental_wind_speed"},
	{0x40,	"category_light"},
	{0x41,	"type_light_ambientlight"},
	{0x42,	"type_light_consumer_infrared"},
	{0x50,	"category_location"},
	{0x51,	"type_location_broadcast"},
	{0x52,	"type_location_dead_reckoning"},
	{0x53,	"type_location_gps"},
	{0x54,	"type_location_lookup"},
	{0x55,	"type_location_other"},
	{0x56,	"type_location_static"},
	{0x57,	"type_location_triangulation"},
	{0x60,	"category_mechanical"},
	{0x61,	"type_mechanical_boolean_switch"},
	{0x62,	"type_mechanical_boolean_switch_array"},
	{0x63,	"type_mechanical_multivalue_switch"},
	{0x64,	"type_mechanical_force"},
	{0x65,	"type_mechanical_pressure"},
	{0x66,	"type_mechanical_strain"},
	{0x67,	"type_mechanical_scale_weight"},
	{0x68,	"type_mechanical_vibrator"},
	{0x69,	"type_mechanical_hall_effect_switch"},
	{0x70,	"category_motion"},
	{0x71,	"type_motion_accelerometer_1d"},
	{0x72,	"type_motion_accelerometer_2d"},
	{0x73,	"type_motion_accelerometer_3d"},
	{0x74,	"type_motion_gyrometer_1d"},
	{0x75,	"type_motion_gyrometer_2d"},
	{0x76,	"type_motion_gyrometer_3d"},
	{0x77,	"type_motion_motion_detector"},
	{0x78,	"type_motion_speedometer"},
	{0x79,	"type_motion_accelerometer"},
	{0x7A,	"type_motion_gyrometer"},
	{0x80,	"category_orientation"},
	{0x81,	"type_orientation_compass_1d"},
	{0x82,	"type_orientation_compass_2d"},
	{0x83,	"type_orientation_compass_3d"},
	{0x84,	"type_orientation_inclinometer_1d"},
	{0x85,	"type_orientation_inclinometer_2d"},
	{0x86,	"type_orientation_inclinometer_3d"},
	{0x87,	"type_orientation_distance_1d"},
	{0x88,	"type_orientation_distance_2d"},
	{0x89,	"type_orientation_distance_3d"},
	{0x8A,	"type_orientation_device_orientation"},
	{0x8B,	"type_orientation_compass"},
	{0x8C,	"type_orientation_inclinometer"},
	{0x8D,	"type_orientation_distance"},
	{0x90,	"category_scanner"},
	{0x91,	"type_scanner_barcode"},
	{0x92,	"type_scanner_rfid"},
	{0x93,	"type_scanner_nfc"},
	{0xA0,	"category_time"},
	{0xA1,	"type_time_alarm"},
	{0xA2,	"type_time_rtc"},
	{0xE0,	"category_other"},
	{0xE1,	"type_other_custom"},
	{0xE2,	"type_other_generic"},
	{0xE3,	"type_other_generic_enumerator"},
	{0xE4,	"type_other_health_monitor"},
	{0x0201,	"property_sensor_state"},
	{0x0800,	"state_unknown_sel"},
	{0x0801,	"state_ready_sel"},
	{0x0802,	"state_not_available_sel"},
	{0x0803,	"state_no_data_sel"},
	{0x0804,	"state_initializing_sel"},
	{0x0805,	"state_access_denied_sel"},
	{0x0806,	"state_error_sel"},
	{0x0202,	"event"},
	{0x0810,	"event_unknown_sel"},
	{0x0811,	"event_state_changed_sel"},
	{0x0812,	"event_property_changed_sel"},
	{0x0813,	"event_data_updated_sel"},
	{0x0814,	"event_poll_response_sel"},
	{0x0815,	"event_change_sensitivity_sel"},
	{0x0816,	"event_max_reached_sel"},
	{0x0817,	"event_min_reached_sel"},
	{0x0818,	"event_high_threshold_cross_upward_sel"},
	{0x0819,	"event_high_threshold_cross_downward_sel"},
	{0x081A,	"event_low_threshold_cross_upward_sel"},
	{0x081B,	"event_low_threshold_cross_downward_sel"},
	{0x081C,	"event_zero_threshold_cross_upward_sel"},
	{0x081D,	"event_zero_threshold_cross_downward_sel"},
	{0x081E,	"event_period_exceeded_sel"},
	{0x081F,	"event_frequency_exceeded_sel"},
	{0x0820,	"event_complex_trigger_sel"},
	{0x0300,	"property"},
	{0x0301,	"property_friendly_name"},
	{0x0302,	"property_persistent_unique_id"},
	{0x0303,	"property_sensor_status"},
	{0x0304,	"property_minimum_report_interval"},
	{0x0305,	"property_sensor_manufacturer"},
	{0x0306,	"property_sensor_model"},
	{0x0307,	"property_sensor_serial_number"},
	{0x0308,	"property_sensor_description"},
	{0x0309,	"property_sensor_connection_type"},
	{0x0830,	"property_connection_type_pc_integrated_sel"},
	{0x0831,	"property_connection_type_pc_attached_sel"},
	{0x0832,	"property_connection_type_pc_external_sel"},
	{0x030A,	"property_sensor_device_path"},
	{0x030B,	"property_hardware_revision"},
	{0x030C,	"property_firmware_version"},
	{0x030D,	"property_release_date"},
	{0x030E,	"property_report_interval"},
	{0x030F,	"property_change_sensitivity_abs"},
	{0x0310,	"property_change_sensitivity_range_pct"},
	{0x0311,	"property_change_sensitivity_rel_pct"},
	{0x0312,	"property_accuracy"},
	{0x0313,	"property_resolution"},
	{0x0314,	"property_range_maximum"},
	{0x0315,	"property_range_minimum"},
	{0x0316,	"property_reporting_state"},
	{0x0840,	"property_reporting_state_no_events_sel"},
	{0x0841,	"property_reporting_state_all_events_sel"},
	{0x0842,	"property_reporting_state_threshold_events_sel"},
	{0x0843,	"property_reporting_state_no_events_wake_sel"},
	{0x0844,	"property_reporting_state_all_events_wake_sel"},
	{0x0845,	"property_reporting_state_threshold_events_wake_sel"},
	{0x0317,	"property_sampling_rate"},
	{0x0318,	"property_response_curve"},
	{0x0319,	"property_power_state"},
	{0x0850,	"property_power_state_undefined_sel"},
	{0x0851,	"property_power_state_d0_full_power_sel"},
	{0x0852,	"property_power_state_d1_low_power_sel"},
	{0x0853,	"property_power_state_d2_standby_with_wake_sel"},
	{0x0854,	"property_power_state_d3_sleep_with_wake_sel"},
	{0x0855,	"property_power_state_d4_power_off_sel"},
	{0x08E0,	"property_orientation_magnetometer_accuracy_low"},
	{0x08E1,	"property_orientation_magnetometer_accuracy_medium"},
	{0x08E2,	"property_orientation_magnetometer_accuracy_high"},
	{0x0400,	"data_location"},
	{0x0401,	"data_location_desired_accuracy"},
	{0x0402,	"data_location_altitude_antenna_sealevel"},
	{0x0403,	"data_location_differential_reference_station_id"},
	{0x0404,	"data_location_altitide_elipsoid_error"},
	{0x0405,	"data_location_altitide_elipsoid"},
	{0x0406,	"data_location_altitude_sealevel_error"},
	{0x0407,	"data_location_altitude_sealevel"},
	{0x0408,	"data_location_dgps_data_age"},
	{0x0409,	"data_location_error_radius"},
	{0x040A,	"data_location_fix_quality"},
	{0x0870,	"data_fix_quality_no_fix"},
	{0x0871,	"data_fix_quality_gps"},
	{0x0872,	"data_fix_quality_dgps"},
	{0x040B,	"data_location_fix_type"},
	{0x0880,	"data_fix_type_no_fix"},
	{0x0881,	"data_fix_type_gps_sps_mode_fix_valid"},
	{0x0882,	"data_fix_type_dgps_sps_mode_fix_valid"},
	{0x0883,	"data_fix_type_gps_pps_mode_fix_valid"},
	{0x0884,	"data_fix_type_real_time_kinematic"},
	{0x0885,	"data_fix_type_float_rtk"},
	{0x0886,	"data_fix_type_estimated_dead_reckoning"},
	{0x0887,	"data_fix_type_manual_input_mode"},
	{0x0888,	"data_fix_type_simulator_mode"},
	{0x040C,	"data_location_geoidal_separation"},
	{0x040D,	"data_location_gps_operation_mode"},
	{0x0890,	"data_gps_op_mode_manual"},
	{0x0891,	"data_gps_op_mode_automatic"},
	{0x040E,	"data_location_gps_selection_mode"},
	{0x08A0,	"data_gps_sel_mode_autonomous"},
	{0x08A1,	"data_gps_sel_mode_dgps"},
	{0x08A2,	"data_gps_sel_mode_estimated_dead_reckoning"},
	{0x08A3,	"data_gps_sel_mode_manual_input"},
	{0x08A4,	"data_gps_sel_mode_simulator"},
	{0x08A5,	"data_gps_sel_mode_data_not_valid"},
	{0x040F,	"data_location_gps_status"},
	{0x08B0,	"data_gps_status_data_valid"},
	{0x08B1,	"data_gps_status_data_not_valid"},
	{0x0410,	"data_location_position_dilution_of_precision"},
	{0x0411,	"data_location_horizontal_dilution_of_precision"},
	{0x0412,	"data_location_vertical_dilution_of_precision"},
	{0x0413,	"data_location_latitude"},
	{0x0414,	"data_location_longitude"},
	{0x0415,	"data_location_true_heading"},
	{0x0416,	"data_location_magnetic_heading"},
	{0x0417,	"data_location_magnetic_variation"},
	{0x0418,	"data_location_speed"},
	{0x0419,	"data_location_satellites_in_view"},
	{0x041A,	"data_location_satellites_in_view_azimuth"},
	{0x041B,	"data_location_satellites_in_view_elevation"},
	{0x041C,	"data_location_satellites_in_view_id"},
	{0x041D,	"data_location_satellites_in_view_prns"},
	{0x041E,	"data_location_satellites_in_view_stn_ratio"},
	{0x041F,	"data_location_satellites_used_count"},
	{0x0420,	"data_location_satellites_used_prns"},
	{0x0421,	"data_location_nmea_sentence"},
	{0x0422,	"data_location_address_line_1"},
	{0x0423,	"data_location_address_line_2"},
	{0x0424,	"data_location_city"},
	{0x0425,	"data_location_state_or_province"},
	{0x0426,	"data_location_country_or_region"},
	{0x0427,	"data_location_postal_code"},
	{0x042A,	"property_location"},
	{0x042B,	"property_location_desired_accuracy"},
	{0x0860,	"desired_accuracy_default"},
	{0x0861,	"desired_accuracy_high"},
	{0x0862,	"desired_accuracy_medium"},
	{0x0863,	"desired_accuracy_low"},
	{0x0430,	"data_environmental"},
	{0x0431,	"data_environmental_atmospheric_pressure"},
	{0x0432,	"data_environmental_reference_pressure"},
	{0x0433,	"data_environmental_relative_humidity"},
	{0x0434,	"data_environmental_temperature"},
	{0x0435,	"data_environmental_wind_direction"},
	{0x0436,	"data_environmental_wind_speed"},
	{0x0440,	"property_environmental"},
	{0x0441,	"property_environmental_reference_pressure"},
	{0x0450,	"data_motion"},
	{0x0451,	"data_motion_state"},
	{0x0452,	"data_motion_acceleration"},
	{0x0453,	"data_motion_acceleration_x_axis"},
	{0x0454,	"data_motion_acceleration_y_axis"},
	{0x0455,	"data_motion_acceleration_z_axis"},
	{0x0456,	"data_motion_angular_velocity"},
	{0x0457,	"data_motion_angular_velocity_x_axis"},
	{0x0458,	"data_motion_angular_velocity_y_axis"},
	{0x0459,	"data_motion_angular_velocity_z_axis"},
	{0x045A,	"data_motion_angular_position"},
	{0x045B,	"data_motion_angular_position_x_axis"},
	{0x045C,	"data_motion_angular_position_y_axis"},
	{0x045D,	"data_motion_angular_position_z_axis"},
	{0x045E,	"data_motion_speed"},
	{0x045F,	"data_motion_intensity"},
	{0x0470,	"data_orientation"},
	{0x0471,	"data_orientation_magnetic_heading"},
	{0x0472,	"data_orientation_magnetic_heading_x"},
	{0x0473,	"data_orientation_magnetic_heading_y"},
	{0x0474,	"data_orientation_magnetic_heading_z"},
	{0x0475,	"data_orientation_compensated_magnetic_north"},
	{0x0476,	"data_orientation_compensated_true_north"},
	{0x0477,	"data_orientation_magnetic_north"},
	{0x0478,	"data_orientation_true_north"},
	{0x0479,	"data_orientation_distance"},
	{0x047A,	"data_orientation_distance_x"},
	{0x047B,	"data_orientation_distance_y"},
	{0x047C,	"data_orientation_distance_z"},
	{0x047D,	"data_orientation_distance_out_of_range"},
	{0x047E,	"data_orientation_tilt"},
	{0x047F,	"data_orientation_tilt_x"},
	{0x0480,	"data_orientation_tilt_y"},
	{0x0481,	"data_orientation_tilt_z"},
	{0x0482,	"data_orientation_rotation_matrix"},
	{0x0483,	"data_orientation_quaternion"},
	{0x0484,	"data_orientation_magnetic_flux"},
	{0x0485,	"data_orientation_magnetic_flux_x_axis"},
	{0x0486,	"data_orientation_magnetic_flux_y_axis"},
	{0x0487,	"data_orientation_magnetic_flux_z_axis"},
	{0x0488,	"data_orientation_magnetometer_accuracy"},
	{0x0490,	"data_mechanical"},
	{0x0491,	"data_mechanical_boolean_switch_state"},
	{0x0492,	"data_mechanical_boolean_switch_array_states"},
	{0x0493,	"data_mechanical_multivalue_switch_value"},
	{0x0494,	"data_mechanical_force"},
	{0x0495,	"data_mechanical_absolute_pressure"},
	{0x0496,	"data_mechanical_gauge_pressure"},
	{0x0497,	"data_mechanical_strain"},
	{0x0498,	"data_mechanical_weight"},
	{0x04A0,	"property_mechanical"},
	{0x04A1,	"property_mechanical_vibration_state"},
	{0x04A2,	"data_mechanical_vibration_speed_forward"},
	{0x04A3,	"data_mechanical_vibration_speed_backward"},
	{0x04B0,	"data_biometric"},
	{0x04B1,	"data_biometric_human_presence"},
	{0x04B2,	"data_biometric_human_proximity_range"},
	{0x04B3,	"data_biometric_human_proximity_out_of_range"},
	{0x04B4,	"data_biometric_human_touch_state"},
	{0x04D0,	"data_light"},
	{0x04D1,	"data_light_illuminance"},
	{0x04D2,	"data_light_color_temperature"},
	{0x04D3,	"data_light_chromaticity"},
	{0x04D4,	"data_light_chromaticity_x"},
	{0x04D5,	"data_light_chromaticity_y"},
	{0x04D6,	"data_light_consumer_ir_sentence_receive"},
	{0x04E0,	"property_light"},
	{0x04E1,	"property_light_consumer_ir_sentence_send"},
	{0x04F0,	"data_scanner"},
	{0x04F1,	"data_scanner_rfid_tag"},
	{0x04F2,	"data_scanner_nfc_sentence_receive"},
	{0x04F8,	"property_scanner"},
	{0x04F9,	"property_scanner_nfc_sentence_send"},
	{0x0500,	"data_electrical"},
	{0x0501,	"data_electrical_capacitance"},
	{0x0502,	"data_electrical_current"},
	{0x0503,	"data_electrical_power"},
	{0x0504,	"data_electrical_inductance"},
	{0x0505,	"data_electrical_resistance"},
	{0x0506,	"data_electrical_voltage"},
	{0x0507,	"data_electrical_frequency"},
	{0x0508,	"data_electrical_period"},
	{0x0509,	"data_electrical_percent_of_range"},
	{0x0520,	"data_time"},
	{0x0521,	"data_time_year"},
	{0x0522,	"data_time_month"},
	{0x0523,	"data_time_day"},
	{0x0524,	"data_time_day_of_week"},
	{0x0525,	"data_time_hour"},
	{0x0526,	"data_time_minute"},
	{0x0527,	"data_time_second"},
	{0x0528,	"data_time_millisecond"},
	{0x0529,	"data_time_timestamp"},
	{0x052A,	"data_time_julian_day_of_year"},
	{0x0530,	"property_time"},
	{0x0531,	"property_time_time_zone_offset_from_utc"},
	{0x0532,	"property_time_time_zone_name"},
	{0x0533,	"property_time_daylight_savings_time_observed"},
	{0x0534,	"property_time_time_trim_adjustment"},
	{0x0535,	"property_time_arm_alarm"},
	{0x0540,	"data_custom"},
	{0x0541,	"data_custom_usage"},
	{0x0542,	"data_custom_boolean_array"},
	{0x0543,	"data_custom_value"},
	{0x0544,	"data_custom_value_1"},
	{0x0545,	"data_custom_value_2"},
	{0x0546,	"data_custom_value_3"},
	{0x0547,	"data_custom_value_4"},
	{0x0548,	"data_custom_value_5"},
	{0x0549,	"data_custom_value_6"},
	{0x054A,	"data_custom_value_7"},
	{0x054B,	"data_custom_value_8"},
	{0x054C,	"data_custom_value_9"},
	{0x054D,	"data_custom_value_10"},
	{0x054E,	"data_custom_value_11"},
	{0x054F,	"data_custom_value_12"},
	{0x0550,	"data_custom_value_13"},
	{0x0551,	"data_custom_value_14"},
	{0x0552,	"data_custom_value_15"},
	{0x0553,	"data_custom_value_16"},
	{0x0554,	"data_custom_value_17"},
	{0x0555,	"data_custom_value_18"},
	{0x0556,	"data_custom_value_19"},
	{0x0557,	"data_custom_value_20"},
	{0x0558,	"data_custom_value_21"},
	{0x0559,	"data_custom_value_22"},
	{0x055A,	"data_custom_value_23"},
	{0x055B,	"data_custom_value_24"},
	{0x055C,	"data_custom_value_25"},
	{0x055D,	"data_custom_value_26"},
	{0x055E,	"data_custom_value_27"},
	{0x055F,	"data_custom_value_28"},
	{0x0560,	"data_generic"},
	{0x0561,	"data_generic_guid_or_propertykey"},
	{0x0562,	"data_generic_category_guid"},
	{0x0563,	"data_generic_type_guid"},
	{0x0564,	"data_generic_event_propertykey"},
	{0x0565,	"data_generic_property_propertykey"},
	{0x0566,	"data_generic_datafield_propertykey"},
	{0x0567,	"data_generic_event"},
	{0x0568,	"data_generic_property"},
	{0x0569,	"data_generic_datafield"},
	{0x056A,	"data_enumerator_table_row_index"},
	{0x056B,	"data_enumerator_table_row_count"},
	{0x056C,	"data_generic_guid_or_propertykey_kind"},
	{0x08D0,	"gorpk_kind_category"},
	{0x08D1,	"gorpk_kind_type"},
	{0x08D2,	"gorpk_kind_event"},
	{0x08D3,	"gorpk_kind_property"},
	{0x08D4,	"gorpk_kind_datafield"},
	{0x056D,	"data_generic_guid"},
	{0x056E,	"data_generic_propertykey"},
	{0x056F,	"data_generic_top_level_collection_id"},
	{0x0570,	"data_generic_report_id"},
	{0x0571,	"data_generic_report_item_position_index"},
	{0x0572,	"data_generic_firmware_vartype"},
	{0x0900,	"firmware_vartype_vt_null"},
	{0x0901,	"firmware_vartype_vt_bool"},
	{0x0902,	"firmware_vartype_vt_ui1"},
	{0x0903,	"firmware_vartype_vt_i1"},
	{0x0904,	"firmware_vartype_vt_ui2"},
	{0x0905,	"firmware_vartype_vt_i2"},
	{0x0906,	"firmware_vartype_vt_ui4"},
	{0x0907,	"firmware_vartype_vt_i4"},
	{0x0908,	"firmware_vartype_vt_ui8"},
	{0x0909,	"firmware_vartype_vt_i8"},
	{0x090A,	"firmware_vartype_vt_r4"},
	{0x090B,	"firmware_vartype_vt_r8"},
	{0x090C,	"firmware_vartype_vt_wstr"},
	{0x090D,	"firmware_vartype_vt_str"},
	{0x090E,	"firmware_vartype_vt_clsid"},
	{0x090F,	"firmware_vartype_vt_vector_vt_ui1"},
	{0x0910,	"firmware_vartype_vt_f16e0"},
	{0x0911,	"firmware_vartype_vt_f16e1"},
	{0x0912,	"firmware_vartype_vt_f16e2"},
	{0x0913,	"firmware_vartype_vt_f16e3"},
	{0x0914,	"firmware_vartype_vt_f16e4"},
	{0x0915,	"firmware_vartype_vt_f16e5"},
	{0x0916,	"firmware_vartype_vt_f16e6"},
	{0x0917,	"firmware_vartype_vt_f16e7"},
	{0x0918,	"firmware_vartype_vt_f16e8"},
	{0x0919,	"firmware_vartype_vt_f16e9"},
	{0x091A,	"firmware_vartype_vt_f16ea"},
	{0x091B,	"firmware_vartype_vt_f16eb"},
	{0x091C,	"firmware_vartype_vt_f16ec"},
	{0x091D,	"firmware_vartype_vt_f16ed"},
	{0x091E,	"firmware_vartype_vt_f16ee"},
	{0x091F,	"firmware_vartype_vt_f16ef"},
	{0x0920,	"firmware_vartype_vt_f32e0"},
	{0x0921,	"firmware_vartype_vt_f32e1"},
	{0x0922,	"firmware_vartype_vt_f32e2"},
	{0x0923,	"firmware_vartype_vt_f32e3"},
	{0x0924,	"firmware_vartype_vt_f32e4"},
	{0x0925,	"firmware_vartype_vt_f32e5"},
	{0x0926,	"firmware_vartype_vt_f32e6"},
	{0x0927,	"firmware_vartype_vt_f32e7"},
	{0x0928,	"firmware_vartype_vt_f32e8"},
	{0x0929,	"firmware_vartype_vt_f32e9"},
	{0x092A,	"firmware_vartype_vt_f32ea"},
	{0x092B,	"firmware_vartype_vt_f32eb"},
	{0x092C,	"firmware_vartype_vt_f32ec"},
	{0x092D,	"firmware_vartype_vt_f32ed"},
	{0x092E,	"firmware_vartype_vt_f32ee"},
	{0x092F,	"firmware_vartype_vt_f32ef"},
	{0x0573,	"data_generic_unit_of_measure"},
	{0x0940,	"generic_unit_not_specified"},
	{0x0941,	"generic_unit_lux"},
	{0x0942,	"generic_unit_degrees_kelvin"},
	{0x0943,	"generic_unit_degrees_celsius"},
	{0x0944,	"generic_unit_pascal"},
	{0x0945,	"generic_unit_newton"},
	{0x0946,	"generic_unit_meters_per_second"},
	{0x0947,	"generic_unit_kilogram"},
	{0x0948,	"generic_unit_meter"},
	{0x0949,	"generic_unit_meters_per_sec_sqrd"},
	{0x094A,	"generic_unit_farad"},
	{0x094B,	"generic_unit_ampere"},
	{0x094C,	"generic_unit_watt"},
	{0x094D,	"generic_unit_henry"},
	{0x094E,	"generic_unit_ohm"},
	{0x094F,	"generic_unit_volt"},
	{0x0950,	"generic_unit_hertz"},
	{0x0951,	"generic_unit_bar"},
	{0x0952,	"generic_unit_degrees_anti_clockwise"},
	{0x0953,	"generic_unit_degrees_clockwise"},
	{0x0954,	"generic_unit_degrees"},
	{0x0955,	"generic_unit_degrees_per_second"},
	{0x0956,	"generic_unit_degrees_per_sec_sqrd"},
	{0x0957,	"generic_unit_knot"},
	{0x0958,	"generic_unit_percent"},
	{0x0959,	"generic_unit_second"},
	{0x095A,	"generic_unit_millisecond"},
	{0x095B,	"generic_unit_g"},
	{0x095C,	"generic_unit_bytes"},
	{0x095D,	"generic_unit_milligauss"},
	{0x095E,	"generic_unit_bits"},
	{0x0574,	"data_generic_unit_exponent"},
	{0x0970,	"generic_exponent_0"},
	{0x0971,	"generic_exponent_1"},
	{0x0972,	"generic_exponent_2"},
	{0x0973,	"generic_exponent_3"},
	{0x0974,	"generic_exponent_4"},
	{0x0975,	"generic_exponent_5"},
	{0x0976,	"generic_exponent_6"},
	{0x0977,	"generic_exponent_7"},
	{0x0978,	"generic_exponent_8"},
	{0x0979,	"generic_exponent_9"},
	{0x097A,	"generic_exponent_a"},
	{0x097B,	"generic_exponent_b"},
	{0x097C,	"generic_exponent_c"},
	{0x097D,	"generic_exponent_d"},
	{0x097E,	"generic_exponent_e"},
	{0x097F,	"generic_exponent_f"},
	{0x0575,	"data_generic_report_size"},
	{0x0576,	"data_generic_report_count"},
	{0x0580,	"property_generic"},
	{0x0581,	"property_enumerator_table_row_index"},
	{0x0582,	"property_enumerator_table_row_count"},
	{0,	0}
};

static const char *modifiers[16] = {"none", "chg_sensitivity_abs", "max", "min",
	"accuracy", "resolution", "thres_high", "thres_low",
	"calibration_offset", "calibration_multiplier", "report_interval",
	"freq_max", "period_max", "chg_sensitivity_percent_range",
	"chg_sensitivity_percent_rel", "custom"};


#endif /* _HID_STRINGS_DEF_H_ */

