#!/bin/bash

# Script to generate bdsignore based on base reference commit and private repo
# Author: Sergio Aguirre <sergio.a.aguirre.rodriguez@intel.com>

tempdir=$(mktemp -d)

echo "Using temp folder path: ${tempdir}"

# First, get reference xenial base commit
upstream_commit=$(git log -1 --pretty=oneline -- debian.master/changelog | cut -d" " -f1)

# Make sure there's no bdsignore files checked-in
bdsignorelist=$(find . -name \.bdsignore | sort)
if [ ! -z "${bdsignorelist}" ]; then
	find . -name \.bdsignore -exec rm {} \;
fi

# Generate full existing list
git ls-files | sort | grep -v .bdsignore > ${tempdir}/full_list.txt

# Generate affected file list
git diff ${upstream_commit}..HEAD --stat=1000,1000 | cut -d" " -f2 | sed '$d' | sort > ${tempdir}/affected_list.txt

# Store list unaffected files
comm -2 -3 ${tempdir}/full_list.txt ${tempdir}/affected_list.txt > ${tempdir}/unaffected_list.txt

echo "Processing initial unaffected file list: "
COUNTER1=0
for f in $(cat ${tempdir}/unaffected_list.txt)
do
	destdir=$(dirname ${f})
	basename ${f} >> ${destdir}/.bdsignore
	COUNTER1=$((COUNTER1 + 1))
	echo -en "\e[1A"; echo -e "\e[0K\rProcessing initial unaffected file list: $COUNTER1"
done

rm -rf ${tempdir}

echo "Ignore list optimization starting"
repeatme=1
COUNTER1=1
while [ $repeatme == 1 ]
do
	repeatme=0
	bdsignorelist=$(find . -name \.bdsignore | sort)

	basedir=$PWD

	COUNTER2=0
	echo "Pass #$COUNTER1: "
	for f in $bdsignorelist
	do
		targetdir=$(dirname ${f})
		if [ ! -z "$(find ${targetdir} -name \.bdsignore | grep -v ${f})" ]; then
			continue
		fi
		pushd ${targetdir} > /dev/null
			list1="$(ls -a -1 | sed -e '1,2d' | grep -v .bdsignore | sort)"
			list2="$(cat .bdsignore | sort)"
			if [ "${list1}" == "${list2}" ]; then
				oneup=$(dirname $(readlink -f .))
				currdir=$(basename $(readlink -f .))
				COUNTER2=$((COUNTER2 + 1))
				echo -en "\e[1A"; echo -e "\e[0K\rPass #$COUNTER1: $COUNTER2"
				rm .bdsignore
				echo ${currdir} >> ${oneup}/.bdsignore
				sort ${oneup}/.bdsignore -o ${oneup}/.bdsignore
				uniq ${oneup}/.bdsignore > ${oneup}/.bdsignore2
				mv ${oneup}/.bdsignore2 ${oneup}/.bdsignore
				repeatme=1
			fi
		popd > /dev/null
	done
	if [ $repeatme == 1 ]; then
		COUNTER1=$((COUNTER1 + 1))
	fi
done

echo ".git" >> .bdsignore
sort .bdsignore -o .bdsignore
uniq .bdsignore > .bdsignore2
mv .bdsignore2 .bdsignore

echo "Final pass: "
bdsignorelist=$(find . -name \.bdsignore | sort)

COUNTER1=0
for f in $bdsignorelist
do
	targetdir=$(dirname ${f})
	pushd ${targetdir} > /dev/null
		list1="$(cat .bdsignore | sort)"
		for t in $list1
		do
			if [ ! -d $t ]; then
				cat .bdsignore | grep -v "^$t$" > .bdsignore2
				if [ -z "$(cat .bdsignore2)" ]; then
					rm .bdsignore2 .bdsignore
				else
					mv .bdsignore2 .bdsignore
				fi
				COUNTER1=$((COUNTER1 + 1))
				echo -en "\e[1A"; echo -e "\e[0K\rFinal pass: $COUNTER1"
			fi
		done
	popd > /dev/null
done

echo "Done!!"

