/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_GADGETS_ITEM_H_
#define _NL_GADGETS_ITEM_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <netbook-launcher/netbook-launcher.h>

#define NL_TYPE_GADGETS_ITEM (nl_gadget_item_get_type ())

#define NL_GADGETS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
        NL_TYPE_GADGETS_ITEM, NlGadgetItem))

#define NL_GADGETS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass),\
        NL_TYPE_GADGETS_ITEM, NlGadgetItemClass))

#define NL_IS_GADGETS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
        NL_TYPE_GADGETS_ITEM))

#define NL_IS_GADGETS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), NL_TYPE_GADGETS_ITEM))

#define NL_GADGETS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS \
        ((obj), NL_TYPE_GADGETS_ITEM, NlGadgetItemClass))

typedef struct _NlGadgetItem        NlGadgetItem;
typedef struct _NlGadgetItemClass   NlGadgetItemClass;
typedef struct _NlGadgetItemPrivate NlGadgetItemPrivate;
 
struct _NlGadgetItem
{
  GObject        parent;	

  NlGadgetItemPrivate *priv;
};

struct _NlGadgetItemClass
{
  GObjectClass   parent_class;
};

GType          nl_gadget_item_get_type (void) G_GNUC_CONST;

NlGadgetItem * nl_gadget_item_new      (NlShell *shell);

#endif /* _NL_GADGETS_ITEM_H_ */

