/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/*************************************************************** -*- c -*-
 * Tcl/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Tcl_TypeRegister
#define SWIG_TypeCheck       SWIG_Tcl_TypeCheck
#define SWIG_TypeCast        SWIG_Tcl_TypeCast
#define SWIG_TypeDynamicCast SWIG_Tcl_TypeDynamicCast
#define SWIG_TypeName        SWIG_Tcl_TypeName
#define SWIG_TypeQuery       SWIG_Tcl_TypeQuery
#define SWIG_TypeClientData  SWIG_Tcl_TypeClientData
#define SWIG_PackData        SWIG_Tcl_PackData 
#define SWIG_UnpackData      SWIG_Tcl_UnpackData 


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/*
 * $Header: /cvsroot/SWIG/Lib/tcl/swigtcl8.swg,v 1.19 2003/12/09 12:44:49 beazley Exp $
 * 
 * swigtcl8.swg
 */

#include <tcl.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Constant table */

#define SWIG_TCL_INT     1
#define SWIG_TCL_FLOAT   2
#define SWIG_TCL_STRING  3
#define SWIG_TCL_POINTER 4
#define SWIG_TCL_BINARY  5

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Swig fail macro */

#define SWIG_fail   goto fail

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

typedef int   (*swig_wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef int   (*swig_wrapper_func)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef char *(*swig_variable_func)(ClientData, Tcl_Interp *, char *, char *, int);
typedef void  (*swig_delete_func)(ClientData);

typedef struct swig_method {
  const char     *name;
  swig_wrapper   method;
} swig_method;

typedef struct swig_attribute {
  const char     *name;
  swig_wrapper   getmethod;
  swig_wrapper   setmethod;
} swig_attribute;

typedef struct swig_class {
  const char         *name;
  swig_type_info   **type;
  swig_wrapper       constructor;
  void              (*destructor)(void *);
  swig_method        *methods;
  swig_attribute     *attributes;
  struct swig_class **bases;
} swig_class;

typedef struct swig_instance {
  Tcl_Obj       *thisptr;
  void          *thisvalue;
  swig_class   *classptr;
  int            destroy;
  Tcl_Command    cmdtok;
} swig_instance;

#define SWIG_NewPointerObj(ptr, type, flags) \
  SWIG_Tcl_NewPointerObj(ptr, type, flags)
#define SWIG_ConvertPtr(oc, ptr, ty, flags) \
  SWIG_Tcl_ConvertPtr(interp, oc, ptr, ty, flags)
#define SWIG_ConvertPtrFromString(c, ptr, ty, flags) \
  SWIG_Tcl_ConvertPtrFromString(interp, c, ptr, ty, flags)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Tcl_ConvertPacked(interp, obj, ptr, sz, ty, flags)
#define SWIG_MakePtr(c, ptr, ty, flags) \
  SWIG_Tcl_MakePtr(c, ptr, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type, flags) \
  SWIG_Tcl_NewPackedObj(ptr, sz, type, flags)
#define SWIG_GetArgs SWIG_Tcl_GetArgs
#define SWIG_PointerTypeFromString(c) \
  SWIG_Tcl_PointerTypeFromString(c)
#define SWIG_Acquire(ptr) \
  SWIG_Tcl_Acquire(ptr)
#define SWIG_Disown(ptr) \
  SWIG_Tcl_Disown(ptr)
#define SWIG_Thisown(ptr) \
  SWIG_Tcl_Thisown(ptr)
#define SWIG_InstallConstants(interp, constants) \
  SWIG_Tcl_InstallConstants(interp, constants)
#define SWIG_GetConstant(key) \
  SWIG_Tcl_GetConstant(key)
#define SWIG_NewInstanceObj(thisvalue, type, flags) \
  SWIG_Tcl_NewInstanceObj(interp, thisvalue, type, flags)
#define SWIG_ObjectConstructor SWIG_Tcl_ObjectConstructor
#define SWIG_MethodCommand SWIG_Tcl_MethodCommand
#define SWIG_ObjectDelete SWIG_Tcl_ObjectDelete

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(int)       SWIG_Tcl_ConvertPtrFromString(Tcl_Interp *, char *, void **, swig_type_info *,int flags);
SWIGIMPORT(int)       SWIG_Tcl_ConvertPtr(Tcl_Interp *, Tcl_Obj *, void **, swig_type_info *, int flags);
SWIGIMPORT(int)       SWIG_Tcl_ConvertPacked(Tcl_Interp *, Tcl_Obj *, void *, int sz, swig_type_info *, int flags);
SWIGIMPORT(void)      SWIG_Tcl_MakePtr(char *, void *, swig_type_info *, int flags);
SWIGIMPORT(Tcl_Obj *) SWIG_Tcl_NewPointerObj(void *, swig_type_info *, int flags);
SWIGIMPORT(Tcl_Obj *) SWIG_Tcl_NewPackedObj(void *, int sz, swig_type_info *, int flags);
SWIGIMPORT(int)       SWIG_Tcl_GetArgs(Tcl_Interp *, int, Tcl_Obj *CONST [], const char *, ...);
SWIGIMPORT(char *)    SWIG_Tcl_PointerTypeFromString(char *c);
SWIGIMPORT(void)      SWIG_Tcl_Acquire(void *ptr);
SWIGIMPORT(int)       SWIG_Tcl_Disown(void *ptr);
SWIGIMPORT(int)       SWIG_Tcl_Thisown(void *ptr);
SWIGIMPORT(void)      SWIG_Tcl_InstallConstants(Tcl_Interp *interp, struct swig_const_info constants[]);
SWIGIMPORT(Tcl_Obj *) SWIG_Tcl_GetConstant(const char *key);
SWIGIMPORT(Tcl_Obj *) SWIG_Tcl_NewInstanceObj(Tcl_Interp *interp, void *, swig_type_info *, int flags);
SWIGIMPORT(int)       SWIG_Tcl_ObjectConstructor(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST objv[]);
SWIGIMPORT(int)       SWIG_Tcl_MethodCommand(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST objv[]);
SWIGIMPORT(void)      SWIG_Tcl_ObjectDelete(ClientData);

#else

/* Object support */
static Tcl_HashTable  swigobjectTable;
static int            swigobjectTableinit = 0;

/* Acquire ownership of a pointer */
SWIGRUNTIME(void)
SWIG_Tcl_Acquire(void *ptr) {
  Tcl_HashEntry *entryPtr;
  int newobj;
  if (!swigobjectTableinit) {
    Tcl_InitHashTable(&swigobjectTable, TCL_ONE_WORD_KEYS);
    swigobjectTableinit = 1;
  }
  entryPtr = Tcl_CreateHashEntry(&swigobjectTable, (char *) ptr, &newobj);
}

/* Disown a pointer.  Returns 1 if we owned it to begin with */
SWIGRUNTIME(int)
SWIG_Tcl_Disown(void *ptr) {
  Tcl_HashEntry *entryPtr;
  if (!swigobjectTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigobjectTable, (char *) ptr);
  if (entryPtr) {
    Tcl_DeleteHashEntry(entryPtr);
    return 1;
  }
  return 0;
}

SWIGRUNTIME(int)
SWIG_Tcl_Thisown(void *ptr) {
  if (!swigobjectTableinit) return 0;
  if (Tcl_FindHashEntry(&swigobjectTable, (char *) ptr)) {
    return 1;
  }
  return 0;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Tcl_ConvertPtrFromString(Tcl_Interp *interp, char *c, void **ptr, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  /* Pointer values must start with leading underscore */
  while (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return TCL_OK;
    /* Hmmm. It could be an object name. */
    if (Tcl_VarEval(interp,c," cget -this", (char *) NULL) == TCL_OK) {
      Tcl_Obj *result = Tcl_GetObjResult(interp);
      c = Tcl_GetStringFromObj(result, NULL);
      continue;
    }
    Tcl_ResetResult(interp);
    if (flags & SWIG_POINTER_EXCEPTION) 
      Tcl_SetResult(interp, (char *) "Type error. Expected a pointer", TCL_STATIC);
    return TCL_ERROR;
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if ((!tc) && (flags & SWIG_POINTER_EXCEPTION)) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else if (!tc) {
      Tcl_ResetResult(interp);
      return TCL_ERROR;
    }
    if (flags & SWIG_POINTER_DISOWN) {
      SWIG_Disown((void *) *ptr);
    }
    *ptr = SWIG_TypeCast(tc,(void *) *ptr);
  }
  return TCL_OK;
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Tcl_ConvertPtr(Tcl_Interp *interp, Tcl_Obj *oc, void **ptr, swig_type_info *ty, int flags) {
  return SWIG_Tcl_ConvertPtrFromString(interp, Tcl_GetStringFromObj(oc,NULL), ptr, ty, flags);
}

/* Convert a pointer value */
SWIGRUNTIME(char *)
SWIG_Tcl_PointerTypeFromString(char *c) {
  char d;
  /* Pointer values must start with leading underscore. NULL has no type */
  if (*c != '_') {
    return 0;
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if (!(((d >= '0') && (d <= '9')) || ((d >= 'a') && (d <= 'f')))) break;
    c++;
  }
  return c;
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_Tcl_ConvertPacked(Tcl_Interp *interp, Tcl_Obj *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (!obj) goto type_error;
  c = Tcl_GetStringFromObj(obj,NULL);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return TCL_OK;

type_error:

  if (flags) {
    if (ty) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else {
      Tcl_SetResult(interp, (char *) "Expected packed data.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  return TCL_ERROR;
}


/* Take a pointer and convert it to a string */
SWIGRUNTIME(void)
SWIG_Tcl_MakePtr(char *c, void *ptr, swig_type_info *ty, int flags) {
  if (ptr) {
    *(c++) = '_';
    c = SWIG_PackData(c,&ptr,sizeof(void *));
    strcpy(c,ty->name);
  } else {
    strcpy(c,(char *)"NULL");
  }
  flags = 0;
}

/* Create a new pointer object */
SWIGRUNTIME(Tcl_Obj *)
SWIG_Tcl_NewPointerObj(void *ptr, swig_type_info *type, int flags) {
  Tcl_Obj *robj;
  char result[512];
  SWIG_MakePtr(result,ptr,type,flags);
  robj = Tcl_NewStringObj(result,-1);
  return robj;
}

SWIGRUNTIME(Tcl_Obj *)
SWIG_Tcl_NewPackedObj(void *ptr, int sz, swig_type_info *type, int flags) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  flags = 0;
  return Tcl_NewStringObj(result,-1);
}

static Tcl_HashTable   swigconstTable;
static int             swigconstTableinit = 0;

/* Install Constants */
SWIGRUNTIME(void)
SWIG_Tcl_InstallConstants(Tcl_Interp *interp, swig_const_info constants[]) {
  int i;
  Tcl_Obj *obj;
  Tcl_HashEntry *entryPtr;
  int            newobj;

  if (!swigconstTableinit) {
    Tcl_InitHashTable(&swigconstTable, TCL_STRING_KEYS);
    swigconstTableinit = 1;
  }
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_TCL_INT:
      obj = Tcl_NewIntObj(constants[i].lvalue);
      break;
    case SWIG_TCL_FLOAT:
      obj = Tcl_NewDoubleObj(constants[i].dvalue);
      break;
    case SWIG_TCL_STRING:
      obj = Tcl_NewStringObj((char *) constants[i].pvalue,-1);
      break;
    case SWIG_TCL_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_TCL_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype),0);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      Tcl_ObjSetVar2(interp,Tcl_NewStringObj(constants[i].name,-1), NULL, obj, TCL_GLOBAL_ONLY);
      entryPtr = Tcl_CreateHashEntry(&swigconstTable, constants[i].name, &newobj);
      Tcl_SetHashValue(entryPtr, (ClientData) obj);
    }
  }
}

SWIGRUNTIME(Tcl_Obj *)
SWIG_Tcl_GetConstant(const char *key) {
  Tcl_HashEntry *entryPtr;
  if (!swigconstTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigconstTable, key);
  if (entryPtr) {
    return (Tcl_Obj *) Tcl_GetHashValue(entryPtr);
  }
  printf("Searching %s\n", key);
  return 0;
}

/* Get arguments */
SWIGRUNTIME(int)
SWIG_Tcl_GetArgs(Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], const char *fmt, ...) {
  int        argno = 0, opt = 0;
  long       tempi;
  double     tempd;
  const char *c;
  va_list    ap;
  void      *vptr;
  Tcl_Obj   *obj = 0;
  swig_type_info *ty;

  va_start(ap,fmt);
  for (c = fmt; (*c && (*c != ':') && (*c != ';')); c++,argno++) {
    if (*c == '|') {
      opt = 1;
      c++;
    }
    if (argno >= (objc-1)) {
      if (!opt) {
        Tcl_SetResult(interp, (char *) "Wrong # args. ", TCL_STATIC);
        goto argerror;
      } else {
        va_end(ap);
        return TCL_OK;
      }
    }

    vptr = va_arg(ap,void *);
    if (vptr) {
      if (isupper(*c)) {
        obj = SWIG_GetConstant(Tcl_GetStringFromObj(objv[argno+1],0));
        if (!obj) obj = objv[argno+1];
      } else {
        obj = objv[argno+1];
      }
      switch(*c) {
      case 'i': case 'I':
      case 'l': case 'L':
      case 'h': case 'H':
      case 'b': case 'B':
        if (Tcl_GetLongFromObj(interp,obj,&tempi) != TCL_OK) goto argerror;
        if ((*c == 'i') || (*c == 'I')) *((int *)vptr) = (int)tempi;
        else if ((*c == 'l') || (*c == 'L')) *((long *)vptr) = (long)tempi;
        else if ((*c == 'h') || (*c == 'H')) *((short*)vptr) = (short)tempi;
        else if ((*c == 'b') || (*c == 'B')) *((unsigned char *)vptr) = (unsigned char)tempi;
        break;
      case 'f': case 'F':
      case 'd': case 'D':
        if (Tcl_GetDoubleFromObj(interp,obj,&tempd) != TCL_OK) goto argerror;
        if ((*c == 'f') || (*c == 'F')) *((float *) vptr) = (float)tempd;
        else if ((*c == 'd') || (*c == 'D')) *((double*) vptr) = tempd;
        break;
      case 's': case 'S':
        if (*(c+1) == '#') {
          int *vlptr = (int *) va_arg(ap, void *);
          *((char **) vptr) = Tcl_GetStringFromObj(obj, vlptr);
          c++;
        } else {
          *((char **)vptr) = Tcl_GetStringFromObj(obj,NULL);
        }
        break;
      case 'c': case 'C':
        *((char *)vptr) = *(Tcl_GetStringFromObj(obj,NULL));
        break;
      case 'p': case 'P':
        ty = (swig_type_info *) va_arg(ap, void *);
        if (SWIG_Tcl_ConvertPtr(interp, obj, (void **) vptr, ty, SWIG_POINTER_EXCEPTION) == TCL_ERROR) goto argerror;
        break;
      case 'o': case 'O':
        *((Tcl_Obj **)vptr) = objv[argno+1];
        break;
      default:
        break;
      }
    }
  }

  if ((*c != ';') && ((objc-1) > argno)) {
    Tcl_SetResult(interp, (char *) "Wrong # args.", TCL_STATIC);
    goto argerror;
  }
  va_end(ap);
  return TCL_OK;

 argerror:
  {
    char temp[32];
    sprintf(temp,"%d", argno+1);
    c = strchr(fmt,':');
    if (!c) c = strchr(fmt,';');
    if (!c) c = (char *)"";
    Tcl_AppendResult(interp,c," argument ", temp, NULL);
    va_end(ap);
    return TCL_ERROR;
  }
}

SWIGRUNTIME(void)
SWIG_Tcl_ObjectDelete(ClientData clientData) {
  swig_instance *si = (swig_instance *) clientData;
  if ((si) && (si->destroy) && (SWIG_Disown(si->thisvalue))) {
    if (si->classptr->destructor) {
      (si->classptr->destructor)(si->thisvalue);
    }
  }
  Tcl_DecrRefCount(si->thisptr);
  free(si);
}

/* Function to invoke object methods given an instance */
SWIGRUNTIME(int)
SWIG_Tcl_MethodCommand(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  char *method,   *attrname;
  swig_instance   *inst = (swig_instance *) clientData;
  swig_method     *meth;
  swig_attribute  *attr;
  Tcl_Obj         *oldarg;
  Tcl_Obj         **objv;
  int              rcode;
  swig_class      *cls;
  swig_class      *cls_stack[64];
  int              cls_stack_bi[64];
  int              cls_stack_top = 0;
  int              numconf = 2;
  int              bi;

  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
    return TCL_ERROR;
  }
  method = Tcl_GetStringFromObj(objv[1],NULL);
  if (strcmp(method,"-acquire") == 0) {
    inst->destroy = 1;
    SWIG_Acquire(inst->thisvalue);
    return TCL_OK;
  }
  if (strcmp(method,"-disown") == 0) {
    if (inst->destroy) {
      SWIG_Disown(inst->thisvalue);
    }
    inst->destroy = 0;
    return TCL_OK;
  }
  if (strcmp(method,"-delete") == 0) {
    Tcl_DeleteCommandFromToken(interp,inst->cmdtok);
    return TCL_OK;
  }
  cls_stack[cls_stack_top] = inst->classptr;
  cls_stack_bi[cls_stack_top] = -1;
  cls = inst->classptr;
  while (1) {
    bi = cls_stack_bi[cls_stack_top];
    cls = cls_stack[cls_stack_top];
    if (bi != -1) {
      cls = cls->bases[bi];
      if (cls) {
        cls_stack_bi[cls_stack_top]++;
        cls_stack_top++;
        cls_stack[cls_stack_top] = cls;
        cls_stack_bi[cls_stack_top] = -1;
        continue;
      }
    }
    if (!cls) {
      cls_stack_top--;
      if (cls_stack_top < 0) break;
      else continue;
    }
    cls_stack_bi[cls_stack_top]++;

    meth = cls->methods;
    /* Check for methods */
    while (meth && meth->name) {
      if (strcmp(meth->name,method) == 0) {
        oldarg = objv[1];
        objv[1] = inst->thisptr;
        Tcl_IncrRefCount(inst->thisptr);
        rcode = (*meth->method)(clientData,interp,objc,objv);
        objv[1] = oldarg;
        Tcl_DecrRefCount(inst->thisptr);
        return rcode;
      }
      meth++;
    }
    /* Check class methods for a match */
    if (strcmp(method,"cget") == 0) {
      if (objc < 3) {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
      attrname = Tcl_GetStringFromObj(objv[2],NULL);
      attr = cls->attributes;
      while (attr && attr->name) {
        if ((strcmp(attr->name, attrname) == 0) && (attr->getmethod)) {
          oldarg = objv[1];
          objv[1] = inst->thisptr;
          Tcl_IncrRefCount(inst->thisptr);
          rcode = (*attr->getmethod)(clientData,interp,2, objv);
          objv[1] = oldarg;
          Tcl_DecrRefCount(inst->thisptr);
          return rcode;
        }
        attr++;
      }
      if (strcmp(attrname, "-this") == 0) {
        Tcl_SetObjResult(interp, Tcl_DuplicateObj(inst->thisptr));
        return TCL_OK;
      }
      if (strcmp(attrname, "-thisown") == 0) {
        if (SWIG_Thisown(inst->thisvalue)) {
          Tcl_SetResult(interp,(char*)"1",TCL_STATIC);
        } else {
          Tcl_SetResult(interp,(char*)"0",TCL_STATIC);
        }
        return TCL_OK;
      }
    } else if (strcmp(method, "configure") == 0) {
      int i;
      if (objc < 4) {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
      i = 2;
      while (i < objc) {
        attrname = Tcl_GetStringFromObj(objv[i],NULL);
        attr = cls->attributes;
        while (attr && attr->name) {
          if ((strcmp(attr->name, attrname) == 0) && (attr->setmethod)) {
            oldarg = objv[i];
            objv[i] = inst->thisptr;
            Tcl_IncrRefCount(inst->thisptr);
            rcode = (*attr->setmethod)(clientData,interp,3, &objv[i-1]);
            objv[i] = oldarg;
            Tcl_DecrRefCount(inst->thisptr);
            if (rcode != TCL_OK) return rcode;
            numconf += 2;
          }
          attr++;
        }
        i+=2;
      }
    }
  }
  if (strcmp(method,"configure") == 0) {
    if (numconf >= objc) {
      return TCL_OK;
    } else {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  if (strcmp(method,"cget") == 0) {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
  }

  Tcl_SetResult(interp, (char *) "Invalid method. Must be one of: configure cget -acquire -disown -delete", TCL_STATIC);
  cls = inst->classptr;
  bi = 0;
  while (cls) {
    meth = cls->methods;
    while (meth && meth->name) {
      char *cr = (char *) Tcl_GetStringResult(interp);
      if (!strstr(strchr(cr,':'), meth->name))
        Tcl_AppendElement(interp, (char *) meth->name);
      meth++;
    }
    cls = inst->classptr->bases[bi++];
  }
  return TCL_ERROR;
}

/* Function to create objects */
SWIGRUNTIME(int)
SWIG_Tcl_ObjectConstructor(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj          *newObj = 0;
    void             *thisvalue = 0;
    swig_instance   *newinst = 0;
    swig_class      *classptr = (swig_class *) clientData;
    swig_wrapper     cons = 0;
    char             *name = 0;
    int               firstarg = 0;
    int               thisarg = 0;
    int               destroy = 1;

    if (!classptr) {
      Tcl_SetResult(interp, (char *) "swig: internal runtime error. No class object defined.", TCL_STATIC);
      return TCL_ERROR;
    }
    cons = classptr->constructor;
    if (objc > 1) {
      char *s = Tcl_GetStringFromObj(objv[1],NULL);
      if (strcmp(s,"-this") == 0) {
        thisarg = 2;
        cons = 0;
      } else if (strcmp(s,"-args") == 0) {
        firstarg = 1;
      } else if (objc == 2) {
        firstarg = 1;
        name = s;
      } else if (objc >= 3) {
        char *s1;
        name = s;
        s1 = Tcl_GetStringFromObj(objv[2],NULL);
        if (strcmp(s1,"-this") == 0) {
          thisarg = 3;
          cons = 0;
        } else {
          firstarg = 1;
        }
      }
    }
    if (cons) {
      int result;
      result = (*cons)(0, interp, objc-firstarg, &objv[firstarg]);
      if (result != TCL_OK) {
        return result;
      }
      newObj = Tcl_DuplicateObj(Tcl_GetObjResult(interp));
      if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
    } else if (thisarg > 0) {
      if (thisarg < objc) {
        destroy = 0;
        newObj = Tcl_DuplicateObj(objv[thisarg]);
        if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
      } else {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
    } else {
      Tcl_SetResult(interp, (char *) "No constructor available.", TCL_STATIC);
      return TCL_ERROR;
    }
    if (SWIG_Tcl_ConvertPtr(interp,newObj, (void **) &thisvalue, *(classptr->type), SWIG_POINTER_EXCEPTION) == TCL_ERROR) {
      Tcl_DecrRefCount(newObj);
      return TCL_ERROR;
    }
    newinst = (swig_instance *) malloc(sizeof(swig_instance));
    newinst->thisptr = newObj;
    Tcl_IncrRefCount(newObj);
    newinst->thisvalue = thisvalue;
    newinst->classptr = classptr;
    newinst->destroy = destroy;
    if (destroy) {
      SWIG_Acquire(thisvalue);
    }
    newinst->cmdtok = Tcl_CreateObjCommand(interp,name, (swig_wrapper) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
    return TCL_OK;
}


/* This function takes the current result and turns it into an object command */
SWIGRUNTIME(Tcl_Obj *)
SWIG_Tcl_NewInstanceObj(Tcl_Interp *interp, void *thisvalue, swig_type_info *type, int flags) {
  Tcl_Obj *robj = SWIG_NewPointerObj(thisvalue, type,0);
  /* Check to see if this pointer belongs to a class or not */
  if ((type->clientdata) && (interp)) {
    Tcl_CmdInfo    ci;
    char          *name;
    name = Tcl_GetStringFromObj(robj,NULL);
    if (!Tcl_GetCommandInfo(interp,name, &ci) || (flags)) {
      swig_instance *newinst = (swig_instance *) malloc(sizeof(swig_instance));
      newinst->thisptr = Tcl_DuplicateObj(robj);
      Tcl_IncrRefCount(newinst->thisptr);
      newinst->thisvalue = thisvalue;
      newinst->classptr = (swig_class *) type->clientdata;
      newinst->destroy = flags;
      newinst->cmdtok = Tcl_CreateObjCommand(interp, Tcl_GetStringFromObj(robj,NULL), (swig_wrapper_func) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
      if (flags) {
        SWIG_Acquire(thisvalue);
      }
    }
  }
  return robj;
}

#endif

/* Structure for command table */
typedef struct {
  const char *name;
  int       (*wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
  ClientData  clientdata;
} swig_command_info;

/* Structure for variable linking table */
typedef struct {
  const char *name;
  void *addr;
  char * (*get)(ClientData, Tcl_Interp *, char *, char *, int);
  char * (*set)(ClientData, Tcl_Interp *, char *, char *, int);
} swig_var_info;


/* Contract support */

#define SWIG_contract_assert(expr, msg)  if (!(expr)) { Tcl_SetResult(interp, (char *) msg, TCL_STATIC ); goto fail; } else

#ifdef __cplusplus
}
#endif






/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_p_char swig_types[0] 
#define  SWIGTYPE_p_p_p_char swig_types[1] 
#define  SWIGTYPE_p_iter_t swig_types[2] 
#define  SWIGTYPE_iter_t swig_types[3] 
#define  SWIGTYPE_p_profile_t swig_types[4] 
#define  SWIGTYPE_profile_t swig_types[5] 
#define  SWIGTYPE_p_int swig_types[6] 
static swig_type_info *swig_types[8];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Profile_Init
#define SWIG_name    "profile"
#define SWIG_prefix  ""
#define SWIG_version "0.0"


#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int) SWIG_init(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif



/*
 * Copyright 2004 by the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 * 
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Furthermore if you modify this software you must label
 * your software as modified software and not distribute it in such a
 * fashion that it might be confused with the original M.I.T. software.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 *
 * Input for wrapper generator program SWIG for profile routines.
 */
#include <errno.h>
#include "com_err.h"
#include "profile.h"

#ifdef SWIGTCL
/* Reduce warnings about cast discarding const to just this one, from
   every SWIG-generated call to Tcl_SetResult.  */
static void my_tcl_setresult(Tcl_Interp *i, const char *str, Tcl_FreeProc *f)
{
    Tcl_SetResult(i, (char *) str, f);
}
#undef Tcl_SetResult
#define Tcl_SetResult my_tcl_setresult
#endif


typedef void **iter_t; /* ick */

extern errcode_t profile_get_string(profile_t,char const *,char const *,char const *,char const *,char **);

static errcode_t iter_create(profile_t p, const char **nullterm,
			     int flags, iter_t *OUTPUT)
{
    iter_t it;
    errcode_t err;
    char **args;

    it = malloc(sizeof(*it));
    if (it == NULL)
	return errno;
    {
	/* Memory leak!

	   The profile code seems to assume that I'll keep the string
	   array around for as long as the iterator is valid; I can't
	   create the iterator and then throw them away.

	   But right now, I can't be bothered to track the necessary
	   information to do the cleanup later.  */
	int count, j;
	for (count = 0; nullterm[count]; count++) ;
	args = calloc(count+1, sizeof(char *));
	if (args == NULL)
	    return errno;
	for (j = 0; j < count; j++) {
	    args[j] = strdup(nullterm[j]);
	    if (args[j] == NULL)
		return errno;
	}
	args[j] = NULL;
    }
    err = profile_iterator_create(p, args, flags, it);
    if (err)
	free(it);
    else
	*OUTPUT = it;
    return err;
}
static errcode_t iter_free(iter_t i)
{
    profile_iterator_free(i);
    free(i);
}



/* A TCL_AppInit() function that lets you build a new copy
 * of tclsh.
 *
 * The macro SWIG_init contains the name of the initialization
 * function in the wrapper file.
 */

#ifndef SWIG_RcFileName
char *SWIG_RcFileName = "~/.myapprc";
#endif


#ifdef MAC_TCL
extern int		MacintoshInit _ANSI_ARGS_((void));
#endif

int Tcl_AppInit(Tcl_Interp *interp){

  if (Tcl_Init(interp) == TCL_ERROR) 
    return TCL_ERROR;

  /* Now initialize our functions */

  if (SWIG_init(interp) == TCL_ERROR)
    return TCL_ERROR;
#if TCL_MAJOR_VERSION > 7 || TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION >= 5
   Tcl_SetVar(interp, (char *) "tcl_rcFileName",SWIG_RcFileName,TCL_GLOBAL_ONLY);
#else
   tcl_RcFileName = SWIG_RcFileName;
#endif
#ifdef SWIG_RcRsrcName
  Tcl_SetVar(interp, (char *) "tcl_rcRsrcName",SWIG_RcRsrcName,TCL_GLOBAL);
#endif
  
  return TCL_OK;
}

#if TCL_MAJOR_VERSION > 7 || TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION >= 4
int main(int argc, char **argv) {
#ifdef MAC_TCL
    char *newArgv[2];
    
    if (MacintoshInit()  != TCL_OK) {
	Tcl_Exit(1);
    }

    argc = 1;
    newArgv[0] = "tclsh";
    newArgv[1] = NULL;
    argv = newArgv;
#endif

  Tcl_Main(argc, argv, Tcl_AppInit);
  return(0);

}
#else
extern int main();
#endif


#ifdef __cplusplus
extern "C" {
#endif
static int
_wrap_profile_init_path(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) NULL ;
    profile_t *arg2 = (profile_t *) 0 ;
    errcode_t result;
    profile_t tmp2 ;
    
    {
        /*generic swigtype hack*/ arg2 = &tmp2;
    }
    if (SWIG_GetArgs(interp, objc, objv,"|s:profile_init_path ?path? ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (errcode_t)profile_init_path((char const *)arg1,arg2);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    /*generic swigtype hack*/ Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) *arg2, SWIGTYPE_profile_t,0));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_init(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char **arg1 = (char **) NULL ;
    profile_t *arg2 = (profile_t *) 0 ;
    errcode_t result;
    profile_t tmp2 ;
    
    {
        /*generic swigtype hack*/ arg2 = &tmp2;
    }
    if (SWIG_GetArgs(interp, objc, objv,"|o:profile_init ?nullterm? ",0) == TCL_ERROR) SWIG_fail;
    if (objc > 1) {
        {
            /* in char **nullterm */
            int n;
            if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[1],NULL), &n, &arg1) == TCL_ERROR) SWIG_fail;
        }
    }
    result = (errcode_t)profile_init((char const **)arg1,arg2);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    /*generic swigtype hack*/ Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) *arg2, SWIGTYPE_profile_t,0));
    {
        /* freearg char **nullterm */
        if (arg1) {
            Tcl_Free((char *)arg1); arg1 = (char **) NULL; 
        }
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg1) {
            Tcl_Free((char *)arg1); arg1 = (char **) NULL; 
        }
    }
    return TCL_ERROR;
}


static int
_wrap_profile_flush(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:profile_flush profile_t ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_flush(arg1);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_flush_to_file(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char *arg2 ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:profile_flush_to_file profile_t path ",0,&arg2) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_flush_to_file(arg1,(char const *)arg2);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_abandon(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:profile_abandon profile_t ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    profile_abandon(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_release(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:profile_release profile_t ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    profile_release(arg1);
    
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_get_values(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    char ***arg3 = (char ***) 0 ;
    errcode_t result;
    char **tmp3 ;
    
    {
        /* in char ***OUTPUT */
        tmp3 = NULL;
        arg3 = &tmp3;
    }
    if (SWIG_GetArgs(interp, objc, objv,"oo:profile_get_values p nullterm ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_get_values(arg1,(char const **)arg2,arg3);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* argout char ***OUTPUT */
        int i;
        for (i = 0; (*arg3)[i]; i++)
        Tcl_AppendElement(interp, (*arg3)[i]);
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    {
        /* freearg char ***OUTPUT */
        profile_free_list(*arg3);
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    {
        /* freearg char ***OUTPUT */
        profile_free_list(*arg3);
    }
    return TCL_ERROR;
}


static int
_wrap_profile_get_string(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 = (char *) NULL ;
    char *arg5 = (char *) NULL ;
    char **arg6 = (char **) 0 ;
    errcode_t result;
    char *tmp6 ;
    
    {
        /* in char **OUTPUT */
        tmp6 = NULL;
        arg6 = &tmp6;
    }
    if (SWIG_GetArgs(interp, objc, objv,"oss|ss:profile_get_string p name subname ?subsubname? ?defval? ",0,&arg2,&arg3,&arg4,&arg5) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_get_string(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,arg6);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* argout char **OUTPUT */
        /*    Tcl_SetResult(interp, *arg6, TCL_DYNAMIC); */
        char *s = (arg6 && *arg6) ? *arg6 : "";
        Tcl_ListObjAppendElement(interp, Tcl_GetObjResult(interp),
        Tcl_NewStringObj(s, strlen(s)));
    }
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg6); */
    }
    return TCL_OK;
    fail:
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg6); */
    }
    return TCL_ERROR;
}


static int
_wrap_profile_get_integer(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 = (char *) NULL ;
    int arg5 = (int) 0 ;
    int *arg6 = (int *) 0 ;
    errcode_t result;
    int temp6 ;
    
    arg6 = &temp6;
    if (SWIG_GetArgs(interp, objc, objv,"oss|si:profile_get_integer p name subname ?subsubname? ?defval? ",0,&arg2,&arg3,&arg4,&arg5) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_get_integer(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5,arg6);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        Tcl_Obj *o;
        o = Tcl_NewIntObj((int) *(arg6));
        Tcl_ListObjAppendElement(interp,Tcl_GetObjResult(interp),o);
    }
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_get_boolean(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char *arg2 ;
    char *arg3 ;
    char *arg4 = (char *) NULL ;
    int arg5 = (int) 0 ;
    int *arg6 = (int *) 0 ;
    errcode_t result;
    int temp6 ;
    
    arg6 = &temp6;
    if (SWIG_GetArgs(interp, objc, objv,"oss|si:profile_get_boolean p name subname ?subsubname? ?defval? ",0,&arg2,&arg3,&arg4,&arg5) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_get_boolean(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5,arg6);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        Tcl_Obj *o;
        o = Tcl_NewIntObj((int) *(arg6));
        Tcl_ListObjAppendElement(interp,Tcl_GetObjResult(interp),o);
    }
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_get_relation_names(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    char ***arg3 = (char ***) 0 ;
    errcode_t result;
    char **tmp3 ;
    
    {
        /* in char ***OUTPUT */
        tmp3 = NULL;
        arg3 = &tmp3;
    }
    if (SWIG_GetArgs(interp, objc, objv,"oo:profile_get_relation_names p nullterm ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_get_relation_names(arg1,(char const **)arg2,arg3);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* argout char ***OUTPUT */
        int i;
        for (i = 0; (*arg3)[i]; i++)
        Tcl_AppendElement(interp, (*arg3)[i]);
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    {
        /* freearg char ***OUTPUT */
        profile_free_list(*arg3);
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    {
        /* freearg char ***OUTPUT */
        profile_free_list(*arg3);
    }
    return TCL_ERROR;
}


static int
_wrap_profile_get_subsection_names(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    char ***arg3 = (char ***) 0 ;
    errcode_t result;
    char **tmp3 ;
    
    {
        /* in char ***OUTPUT */
        tmp3 = NULL;
        arg3 = &tmp3;
    }
    if (SWIG_GetArgs(interp, objc, objv,"oo:profile_get_subsection_names p nullterm ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_get_subsection_names(arg1,(char const **)arg2,arg3);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* argout char ***OUTPUT */
        int i;
        for (i = 0; (*arg3)[i]; i++)
        Tcl_AppendElement(interp, (*arg3)[i]);
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    {
        /* freearg char ***OUTPUT */
        profile_free_list(*arg3);
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    {
        /* freearg char ***OUTPUT */
        profile_free_list(*arg3);
    }
    return TCL_ERROR;
}


static int
_wrap_profile_iterator_create(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    int arg3 ;
    iter_t *arg4 = (iter_t *) 0 ;
    errcode_t result;
    iter_t tmp4 ;
    
    {
        /*generic swigtype hack*/ arg4 = &tmp4;
    }
    if (SWIG_GetArgs(interp, objc, objv,"ooi:profile_iterator_create p nullterm flags ",0,0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)iter_create(arg1,(char const **)arg2,arg3,arg4);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    /*generic swigtype hack*/ Tcl_SetObjResult(interp,SWIG_NewInstanceObj((void *) *arg4, SWIGTYPE_iter_t,0));
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_ERROR;
}


static int
_wrap_profile_iterator_free(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    iter_t arg1 = (iter_t) 0 ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:profile_iterator_free i ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_iter_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)iter_free(arg1);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_profile_iterator(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    iter_t arg1 = (iter_t) 0 ;
    char **arg2 = (char **) 0 ;
    char **arg3 = (char **) 0 ;
    errcode_t result;
    char *tmp2 ;
    char *tmp3 ;
    
    {
        /* in char **OUTPUT */
        tmp2 = NULL;
        arg2 = &tmp2;
    }
    {
        /* in char **OUTPUT */
        tmp3 = NULL;
        arg3 = &tmp3;
    }
    if (SWIG_GetArgs(interp, objc, objv,"o:profile_iterator iter_t ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_iter_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_iterator(arg1,arg2,arg3);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* argout char **OUTPUT */
        /*    Tcl_SetResult(interp, *arg2, TCL_DYNAMIC); */
        char *s = (arg2 && *arg2) ? *arg2 : "";
        Tcl_ListObjAppendElement(interp, Tcl_GetObjResult(interp),
        Tcl_NewStringObj(s, strlen(s)));
    }
    {
        /* argout char **OUTPUT */
        /*    Tcl_SetResult(interp, *arg3, TCL_DYNAMIC); */
        char *s = (arg3 && *arg3) ? *arg3 : "";
        Tcl_ListObjAppendElement(interp, Tcl_GetObjResult(interp),
        Tcl_NewStringObj(s, strlen(s)));
    }
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg2); */
    }
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg3); */
    }
    return TCL_OK;
    fail:
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg2); */
    }
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg3); */
    }
    return TCL_ERROR;
}


static int
_wrap_profile_update_relation(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 ;
    char *arg4 = (char *) NULL ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oos|s:profile_update_relation p nullterm oldval ?newval? ",0,0,&arg3,&arg4) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_update_relation(arg1,(char const **)arg2,(char const *)arg3,(char const *)arg4);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_ERROR;
}


static int
_wrap_profile_clear_relation(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo:profile_clear_relation p nullterm ",0,0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_clear_relation(arg1,(char const **)arg2);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_ERROR;
}


static int
_wrap_profile_rename_section(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 = (char *) NULL ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo|s:profile_rename_section p nullterm ?new_name? ",0,0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_rename_section(arg1,(char const **)arg2,(char const *)arg3);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_ERROR;
}


static int
_wrap_profile_add_relation(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    char *arg3 = (char *) NULL ;
    errcode_t result;
    
    if (SWIG_GetArgs(interp, objc, objv,"oo|s:profile_add_relation p nullterm ?new_val? ",0,0,&arg3) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    {
        /* in char **nullterm */
        int n;
        if (Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[2],NULL), &n, &arg2) == TCL_ERROR) SWIG_fail;
    }
    result = (errcode_t)profile_add_relation(arg1,(char const **)arg2,(char const *)arg3);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_OK;
    fail:
    {
        /* freearg char **nullterm */
        if (arg2) {
            Tcl_Free((char *)arg2); arg2 = (char **) NULL; 
        }
    }
    return TCL_ERROR;
}


static int
_wrap_profile_flush_to_buffer(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    profile_t arg1 = (profile_t) 0 ;
    char **arg2 = (char **) 0 ;
    errcode_t result;
    char *tmp2 ;
    
    {
        /* in char **OUTPUT */
        tmp2 = NULL;
        arg2 = &tmp2;
    }
    if (SWIG_GetArgs(interp, objc, objv,"o:profile_flush_to_buffer p ",0) == TCL_ERROR) SWIG_fail;
    if ((SWIG_ConvertPtr(objv[1], (void **) &arg1, SWIGTYPE_profile_t,SWIG_POINTER_EXCEPTION | 0) != TCL_OK)) SWIG_fail;
    result = (errcode_t)profile_flush_to_buffer(arg1,arg2);
    
    {
        /* out errcode_t result */
        if (result) {
            /* There could be a memory leak here in the SWIG-Tcl layer,
            	   I'm not sure.  Not going to worry about it though.  */
            Tcl_SetResult(interp, (char *) error_message(result), TCL_STATIC);
            SWIG_fail;
        }
    }
    {
        /* argout char **OUTPUT */
        /*    Tcl_SetResult(interp, *arg2, TCL_DYNAMIC); */
        char *s = (arg2 && *arg2) ? *arg2 : "";
        Tcl_ListObjAppendElement(interp, Tcl_GetObjResult(interp),
        Tcl_NewStringObj(s, strlen(s)));
    }
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg2); */
    }
    return TCL_OK;
    fail:
    {
        /* There may be a memory leak here.  Investigate later, if anyone
               cares.  */
        /*    profile_release_string(*arg2); */
    }
    return TCL_ERROR;
}



static swig_command_info swig_commands[] = {
    { SWIG_prefix "profile_init_path", (swig_wrapper_func) _wrap_profile_init_path, NULL},
    { SWIG_prefix "profile_init", (swig_wrapper_func) _wrap_profile_init, NULL},
    { SWIG_prefix "profile_flush", (swig_wrapper_func) _wrap_profile_flush, NULL},
    { SWIG_prefix "profile_flush_to_file", (swig_wrapper_func) _wrap_profile_flush_to_file, NULL},
    { SWIG_prefix "profile_abandon", (swig_wrapper_func) _wrap_profile_abandon, NULL},
    { SWIG_prefix "profile_release", (swig_wrapper_func) _wrap_profile_release, NULL},
    { SWIG_prefix "profile_get_values", (swig_wrapper_func) _wrap_profile_get_values, NULL},
    { SWIG_prefix "profile_get_string", (swig_wrapper_func) _wrap_profile_get_string, NULL},
    { SWIG_prefix "profile_get_integer", (swig_wrapper_func) _wrap_profile_get_integer, NULL},
    { SWIG_prefix "profile_get_boolean", (swig_wrapper_func) _wrap_profile_get_boolean, NULL},
    { SWIG_prefix "profile_get_relation_names", (swig_wrapper_func) _wrap_profile_get_relation_names, NULL},
    { SWIG_prefix "profile_get_subsection_names", (swig_wrapper_func) _wrap_profile_get_subsection_names, NULL},
    { SWIG_prefix "profile_iterator_create", (swig_wrapper_func) _wrap_profile_iterator_create, NULL},
    { SWIG_prefix "profile_iterator_free", (swig_wrapper_func) _wrap_profile_iterator_free, NULL},
    { SWIG_prefix "profile_iterator", (swig_wrapper_func) _wrap_profile_iterator, NULL},
    { SWIG_prefix "profile_update_relation", (swig_wrapper_func) _wrap_profile_update_relation, NULL},
    { SWIG_prefix "profile_clear_relation", (swig_wrapper_func) _wrap_profile_clear_relation, NULL},
    { SWIG_prefix "profile_rename_section", (swig_wrapper_func) _wrap_profile_rename_section, NULL},
    { SWIG_prefix "profile_add_relation", (swig_wrapper_func) _wrap_profile_add_relation, NULL},
    { SWIG_prefix "profile_flush_to_buffer", (swig_wrapper_func) _wrap_profile_flush_to_buffer, NULL},
    {0, 0, 0}
};

static swig_var_info swig_variables[] = {
    {0,0,0,0}
};

static swig_const_info swig_constants[] = {
    {0,0,0,0,0,0}
};

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_p_char[] = {{"_p_p_char", 0, "char **", 0},{"_p_p_char"},{0}};
static swig_type_info _swigt__p_p_p_char[] = {{"_p_p_p_char", 0, "char ***", 0},{"_p_p_p_char"},{0}};
static swig_type_info _swigt__p_iter_t[] = {{"_p_iter_t", 0, "iter_t *", 0},{"_p_iter_t"},{0}};
static swig_type_info _swigt__iter_t[] = {{"_iter_t", 0, "iter_t", 0},{"_iter_t"},{0}};
static swig_type_info _swigt__p_profile_t[] = {{"_p_profile_t", 0, "profile_t *", 0},{"_p_profile_t"},{0}};
static swig_type_info _swigt__profile_t[] = {{"_profile_t", 0, "profile_t", 0},{"_profile_t"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0},{"_p_int"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_p_char, 
_swigt__p_p_p_char, 
_swigt__p_iter_t, 
_swigt__iter_t, 
_swigt__p_profile_t, 
_swigt__profile_t, 
_swigt__p_int, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

#ifdef __cplusplus
}
#endif

SWIGEXPORT(int) SWIG_init(Tcl_Interp *interp) {
    int i;
    static int _init = 0;
    if (interp == 0) return TCL_ERROR;
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, (char*)"8.1", 0) == NULL) {
        return TCL_ERROR;
    }
#endif
    
    Tcl_PkgProvide(interp, (char*)SWIG_name, (char*)SWIG_version);
    
#ifdef SWIG_namespace
    Tcl_Eval(interp, "namespace eval " SWIG_namespace " { }");
#endif
    if (!_init) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }
        _init = 1;
    }
    for (i = 0; swig_commands[i].name; i++) {
        Tcl_CreateObjCommand(interp, (char *) swig_commands[i].name, (swig_wrapper_func) swig_commands[i].wrapper, swig_commands[i].clientdata, NULL);
    }
    for (i = 0; swig_variables[i].name; i++) {
        Tcl_SetVar(interp, (char *) swig_variables[i].name, (char *) "", TCL_GLOBAL_ONLY);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_READS | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].get, (ClientData) swig_variables[i].addr);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_WRITES | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].set, (ClientData) swig_variables[i].addr);
    }
    SWIG_InstallConstants(interp, swig_constants);
    
    return TCL_OK;
}
SWIGEXPORT(int) Profile_SafeInit(Tcl_Interp *interp) {
    return SWIG_init(interp);
}

