/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.swing.JPanel;
import org.kde.kjas.server.Main;
import org.kde.kjas.server.StatusListener;

public class KJASAppletPanel
extends JPanel
implements StatusListener {
    private static final int LOADING = 1;
    private static final int RUNNING = 2;
    private static final int FAILED = 3;
    private Image load_img = null;
    private Image fail_img = null;
    private int status = 1;
    private Font font = new Font("SansSerif", 0, 10);
    private String msg = "Loading Applet...";

    public KJASAppletPanel() {
        super(new BorderLayout());
        URL uRL = this.getClass().getClassLoader().getResource("images/animbean.gif");
        this.load_img = this.getToolkit().createImage(uRL);
    }

    void setApplet(Applet applet) {
        this.add("Center", applet);
        this.validate();
    }

    public void showStatus(String string) {
        this.msg = string;
        if (this.status != 2) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paint(graphics);
        if (this.status == 2) {
            return;
        }
        Image image = this.status == 1 ? this.load_img : this.fail_img;
        int n4 = this.getWidth() / 2;
        int n5 = this.getHeight() / 2;
        if (image != null) {
            int n6 = image.getWidth(this);
            n3 = image.getHeight(this);
            n2 = n4 - n6 / 2;
            n = n5 - n3 / 2;
            graphics.drawImage(image, n2, n, this);
            n5 += image.getHeight(this) / 2;
        }
        if (this.msg != null) {
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n3 = fontMetrics.getHeight();
            n2 = fontMetrics.stringWidth(this.msg);
            n = n4 - n2 / 2;
            int n7 = n5 + n3;
            graphics.drawString(this.msg, n, n7);
        }
    }

    void showFailed() {
        URL uRL = this.getClass().getClassLoader().getResource("images/brokenbean.gif");
        this.fail_img = this.getToolkit().createImage(uRL);
        this.status = 3;
        this.msg = "Applet Failed.";
        this.repaint();
    }

    void showFailed(String string) {
        this.showFailed();
        this.showStatus(string);
    }

    public void stopAnimation() {
        this.status = 2;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image != null && image == this.load_img && this.status != 1) {
            image.flush();
            this.load_img = null;
            Main.debug("flushing image");
            return false;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }
}

