//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  Provides basic functionality needed by nearly all dialogs.
    ///  It offers the standard action buttons you'd expect to find in a
    ///  dialog as well as the capability to define at most three configurable
    ///  buttons. You can define a main widget that contains your specific
    ///  dialog layout
    ///  The class takes care of the geometry management. You only need to define
    ///  a minimum size for the widget you want to use as the main widget.
    ///  By default, the dialog is non-modal.
    ///  <li><b>Standard buttons (action buttons):</b></li>
    ///  You select which buttons should be displayed, but you do not choose the
    ///  order in which they are displayed. This ensures a standard interface in
    ///  KDE. The button order can be changed, but this ability is only available
    ///  for a central KDE control tool. The following buttons are available:
    ///  OK, Cancel/Close, Apply/Try, Default, Help and three user definable
    ///  buttons: User1, User2 and User3. You must specify the text of the UserN
    ///  buttons. Each button emit a signal, so you can choose to connect that signal.
    ///  The default action of the Help button will open the help system if you have
    ///  provided a path to the help text.
    ///  The default action of Ok and Cancel will run QDialog.Accept() and QDialog.Reject(),
    ///  which you can override by reimplementing slotButtonClicked(). The default
    ///  action of the Close button will close the dialog.
    ///  Note that the KDialog will animate a button press
    ///  when the user presses Escape. The button that is enabled is either Cancel,
    ///  Close or the button that is defined by setEscapeButton().
    ///  Your custom dialog code should reimplement the keyPressEvent and
    ///  animate the cancel button so that the dialog behaves like regular
    ///  dialogs.
    ///  <li><b>Layout:</b></li>
    ///  The dialog consists of a help area on top (becomes visible if you define
    ///  a help path and use enableLinkedHelp()), the main area which is
    ///  the built-in dialog face or your own widget in the middle and by default
    ///  a button box at the bottom. The button box can also be placed at the
    ///  right edge (to the right of the main widget). Use
    ///  setButtonsOrientation() to control this behavior. A separator
    ///  can be placed above the button box (or to the left when the button box
    ///  is at the right edge).
    ///  <li><b>Standard compliance:</b></li>
    ///  The marginHint() and spacingHint() sizes shall be used
    ///  whenever you lay out the interior of a dialog. One special note. If
    ///  you make your own action buttons (OK, Cancel etc), the space
    ///  between the buttons shall be spacingHint(), whereas the space
    ///  above, below, to the right and to the left shall be marginHint().
    ///  If you add a separator line above the buttons, there shall be a
    ///  marginHint() between the buttons and the separator and a
    ///  marginHint() above the separator as well.
    ///  <li><b>Example:</b></li>
    ///  <pre>
    ///    KDialog dialog = new KDialog( this );
    ///    dialog.SetCaption( "My title" );
    ///    dialog.SetButtons( KDialog.Ok | KDialog.Cancel | KDialog.Apply );
    ///    FooWidget widget = new FooWidget( dialog );
    ///    dialog.SetMainWidget( widget );
    ///    connect( dialog, SIGNAL("applyClicked()"), widget, SLOT("save()") );
    ///    connect( dialog, SIGNAL("okClicked()"), widget, SLOT("save()") );
    ///    connect( widget, SIGNAL("changed( bool )"), dialog, SLOT("enableButtonApply( bool )") );
    ///    dialog.EnableButtonApply( false );
    ///    dialog.Show();
    ///  </pre>
    ///  This class can be used in many ways. Note that most KDE ui widgets
    ///  and many of KDE core applications use the KDialog so for more
    ///  inspiration you should study the code for these.
    ///  See <see cref="IKDialogSignals"></see> for signals emitted by KDialog
    /// </remarks>        <author> Tobias Koenig <tokoe@kde.org>
    ///  </author>
    ///         <short> A dialog base class with standard buttons and predefined layouts. </short>
    ///         <see> KPageDialog</see>
    [SmokeClass("KDialog")]
    public class KDialog : QDialog, IDisposable {
        protected KDialog(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KDialog), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KDialog() {
            staticInterceptor = new SmokeInvocation(typeof(KDialog), null);
        }
        public enum ButtonCode {
            None = 0x00000000,
            Help = 0x00000001,
            Default = 0x00000002,
            Ok = 0x00000004,
            Apply = 0x00000008,
            Try = 0x00000010,
            Cancel = 0x00000020,
            Close = 0x00000040,
            No = 0x00000080,
            Yes = 0x00000100,
            Reset = 0x00000200,
            Details = 0x00000400,
            User1 = 0x00001000,
            User2 = 0x00002000,
            User3 = 0x00004000,
            NoDefault = 0x00008000,
        }
        public enum ButtonPopupMode {
            InstantPopup = 0,
            DelayedPopup = 1,
        }
        /// <remarks>
        ///  @enum StandardCaptionFlag
        ///  Used to specify how to construct a window caption
        ///  @value AppName Indicates that the method shall include
        ///  the application name when making the caption string.
        ///  @value Modified Causes a 'modified' sign will be included in the
        ///  returned string. This is useful when indicating that a file is
        ///  modified, i.e., it contains data that has not been saved.
        ///  @value HIGCompliant The base minimum flags required to align a
        ///  caption with the KDE Human Interface Guidelines
        ///      </remarks>        <short>    @enum StandardCaptionFlag  Used to specify how to construct a window caption </short>
        public enum CaptionFlag {
            NoCaptionFlags = 0,
            AppNameCaption = 1,
            ModifiedCaption = 2,
            HIGCompliantCaption = AppNameCaption,
        }
        // KDialog* KDialog(KDialogPrivate& arg1,QWidget* arg2,Qt::WindowFlags arg3); >>>> NOT CONVERTED
        // KDialog* KDialog(KDialogPrivate& arg1,QWidget* arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates a dialog.
        /// <param> name="parent" The parent of the dialog.
        /// </param><param> name="flags" The widget flags passed to the QDialog constructor
        ///      </param></remarks>        <short>    Creates a dialog.</short>
        public KDialog(QWidget parent, uint flags) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDialog#$", "KDialog(QWidget*, Qt::WindowFlags)", typeof(void), typeof(QWidget), parent, typeof(uint), flags);
        }
        public KDialog(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDialog#", "KDialog(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KDialog() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KDialog", "KDialog()", typeof(void));
        }
        /// <remarks>
        ///  Creates (or recreates) the button box and all the buttons in it.
        ///  This will reset all default KGuiItem of all button.
        /// <param> name="buttonMask" Specifies what buttons will be made.
        ///      </param></remarks>        <short>    Creates (or recreates) the button box and all the buttons in it.</short>
        public void SetButtons(uint buttonMask) {
            interceptor.Invoke("setButtons$", "setButtons(KDialog::ButtonCodes)", typeof(void), typeof(uint), buttonMask);
        }
        /// <remarks>
        ///  Sets the orientation of the button box.
        ///  It can be <code>Vertical</code> or <code>Horizontal.</code> If <code>Horizontal</code>
        ///  (default), the button box is positioned at the bottom of the
        ///  dialog. If <code>Vertical</code> it will be placed at the right edge of the
        ///  dialog.
        /// <param> name="orientation" The button box orientation.
        ///      </param></remarks>        <short>    Sets the orientation of the button box.</short>
        public void SetButtonsOrientation(Qt.Orientation orientation) {
            interceptor.Invoke("setButtonsOrientation$", "setButtonsOrientation(Qt::Orientation)", typeof(void), typeof(Qt.Orientation), orientation);
        }
        /// <remarks>
        ///  Sets the button that will be activated when the Escape key
        ///  is pressed.
        ///  By default, the Escape key is mapped to either the Cancel or the Close button
        ///  if one of these buttons are defined. The user expects that Escape will
        ///  cancel an operation so use this function with caution.
        /// <param> name="id" The button code.
        ///      </param></remarks>        <short>    Sets the button that will be activated when the Escape key  is pressed.</short>
        public void SetEscapeButton(KDialog.ButtonCode id) {
            interceptor.Invoke("setEscapeButton$", "setEscapeButton(KDialog::ButtonCode)", typeof(void), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Sets the button that will be activated when the Enter key
        ///  is pressed.
        ///  By default, this is the Ok button if it is present
        /// <param> name="id" The button code.
        ///      </param></remarks>        <short>    Sets the button that will be activated when the Enter key  is pressed.</short>
        public void SetDefaultButton(KDialog.ButtonCode id) {
            interceptor.Invoke("setDefaultButton$", "setDefaultButton(KDialog::ButtonCode)", typeof(void), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Returns the button code of the default button.
        ///      </remarks>        <short>    Returns the button code of the default button.</short>
        public KDialog.ButtonCode DefaultButton() {
            return (KDialog.ButtonCode) interceptor.Invoke("defaultButton", "defaultButton() const", typeof(KDialog.ButtonCode));
        }
        /// <remarks>
        ///  Hide or display the a separator line drawn between the action
        ///  buttons an the main widget.
        ///      </remarks>        <short>    Hide or display the a separator line drawn between the action  buttons an the main widget.</short>
        public void ShowButtonSeparator(bool state) {
            interceptor.Invoke("showButtonSeparator$", "showButtonSeparator(bool)", typeof(void), typeof(bool), state);
        }
        /// <remarks>
        ///  Hide or display a general action button.
        ///   Only buttons that have
        ///  been created in the constructor can be displayed. This method will
        ///  not create a new button.
        /// <param> name="id" Button identifier.
        /// </param><param> name="state" true display the button(s).
        ///      </param></remarks>        <short>    Hide or display a general action button.</short>
        public void ShowButton(KDialog.ButtonCode id, bool state) {
            interceptor.Invoke("showButton$$", "showButton(KDialog::ButtonCode, bool)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(bool), state);
        }
        /// <remarks>
        ///  Sets the text of any button.
        /// <param> name="id" The button identifier.
        /// </param><param> name="text" Button text.
        ///      </param></remarks>        <short>    Sets the text of any button.</short>
        public void SetButtonText(KDialog.ButtonCode id, string text) {
            interceptor.Invoke("setButtonText$$", "setButtonText(KDialog::ButtonCode, const QString&)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(string), text);
        }
        /// <remarks>
        ///  Returns the text of any button.
        ///      </remarks>        <short>    Returns the text of any button.</short>
        public string ButtonText(KDialog.ButtonCode id) {
            return (string) interceptor.Invoke("buttonText$", "buttonText(KDialog::ButtonCode) const", typeof(string), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Sets the icon of any button.
        /// <param> name="id" The button identifier.
        /// </param><param> name="icon" Button icon.
        ///      </param></remarks>        <short>    Sets the icon of any button.</short>
        public void SetButtonIcon(KDialog.ButtonCode id, KIcon icon) {
            interceptor.Invoke("setButtonIcon$#", "setButtonIcon(KDialog::ButtonCode, const KIcon&)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(KIcon), icon);
        }
        /// <remarks>
        ///  Returns the icon of any button.
        ///      </remarks>        <short>    Returns the icon of any button.</short>
        public KIcon ButtonIcon(KDialog.ButtonCode id) {
            return (KIcon) interceptor.Invoke("buttonIcon$", "buttonIcon(KDialog::ButtonCode) const", typeof(KIcon), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Sets the tooltip text of any button.
        /// <param> name="id" The button identifier.
        /// </param><param> name="text" Button text.
        ///      </param></remarks>        <short>    Sets the tooltip text of any button.</short>
        public void SetButtonToolTip(KDialog.ButtonCode id, string text) {
            interceptor.Invoke("setButtonToolTip$$", "setButtonToolTip(KDialog::ButtonCode, const QString&)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(string), text);
        }
        /// <remarks>
        ///  Returns the tooltip of any button.
        ///      </remarks>        <short>    Returns the tooltip of any button.</short>
        public string ButtonToolTip(KDialog.ButtonCode id) {
            return (string) interceptor.Invoke("buttonToolTip$", "buttonToolTip(KDialog::ButtonCode) const", typeof(string), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Sets the "What's this?" text of any button.
        /// <param> name="id" The button identifier.
        /// </param><param> name="text" Button text.
        ///      </param></remarks>        <short>    Sets the "What's this?" text of any button.</short>
        public void SetButtonWhatsThis(KDialog.ButtonCode id, string text) {
            interceptor.Invoke("setButtonWhatsThis$$", "setButtonWhatsThis(KDialog::ButtonCode, const QString&)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(string), text);
        }
        /// <remarks>
        ///  Returns the "What's this?" text of any button.
        ///      </remarks>        <short>    Returns the "What's this?" text of any button.</short>
        public string ButtonWhatsThis(KDialog.ButtonCode id) {
            return (string) interceptor.Invoke("buttonWhatsThis$", "buttonWhatsThis(KDialog::ButtonCode) const", typeof(string), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Sets the KGuiItem directly for the button instead of using 3 methods to
        ///  set the text, tooltip and whatsthis strings. This also allows to set an
        ///  icon for the button which is otherwise not possible for the extra
        ///  buttons beside Ok, Cancel and Apply.
        /// <param> name="id" The button identifier.
        /// </param><param> name="item" The KGuiItem for the button.
        ///      </param></remarks>        <short>    Sets the KGuiItem directly for the button instead of using 3 methods to  set the text, tooltip and whatsthis strings.</short>
        public void SetButtonGuiItem(KDialog.ButtonCode id, KGuiItem item) {
            interceptor.Invoke("setButtonGuiItem$#", "setButtonGuiItem(KDialog::ButtonCode, const KGuiItem&)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(KGuiItem), item);
        }
        /// <remarks>
        ///  Sets the menu of any button.
        /// <param> name="id" The button identifier.
        /// </param><param> name="menu" The menu.
        /// </param><param> name="popupmode" Choose if KPushButton setMenu or setDelayedMenu is used
        ///      </param></remarks>        <short>    Sets the menu of any button.</short>
        public void SetButtonMenu(KDialog.ButtonCode id, QMenu menu, KDialog.ButtonPopupMode popupmode) {
            interceptor.Invoke("setButtonMenu$#$", "setButtonMenu(KDialog::ButtonCode, QMenu*, KDialog::ButtonPopupMode)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(QMenu), menu, typeof(KDialog.ButtonPopupMode), popupmode);
        }
        public void SetButtonMenu(KDialog.ButtonCode id, QMenu menu) {
            interceptor.Invoke("setButtonMenu$#", "setButtonMenu(KDialog::ButtonCode, QMenu*)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(QMenu), menu);
        }
        /// <remarks>
        ///  Sets the focus to the button of the passed <code>id.</code>
        ///      </remarks>        <short>    Sets the focus to the button of the passed <code>id.</code></short>
        public void SetButtonFocus(KDialog.ButtonCode id) {
            interceptor.Invoke("setButtonFocus$", "setButtonFocus(KDialog::ButtonCode)", typeof(void), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Convenience method. Sets the initial dialog size.
        ///  This method should only be called right before show() or exec().
        ///  The initial size will be ignored if smaller than
        ///  the dialog's minimum size.
        /// <param> name="size" Startup size.
        ///      </param></remarks>        <short>    Convenience method.</short>
        public void SetInitialSize(QSize size) {
            interceptor.Invoke("setInitialSize#", "setInitialSize(const QSize&)", typeof(void), typeof(QSize), size);
        }
        /// <remarks>
        ///  Convenience method. Add a size to the default minimum size of a
        ///  dialog.
        ///  This method should only be called right before show() or exec().
        /// <param> name="size" Size added to minimum size.
        ///      </param></remarks>        <short>    Convenience method.</short>
        public void IncrementInitialSize(QSize size) {
            interceptor.Invoke("incrementInitialSize#", "incrementInitialSize(const QSize&)", typeof(void), typeof(QSize), size);
        }
        /// <remarks>
        ///  Restores the dialog's size from the configuration according to
        ///  the screen size.
        ///  @note the group must be set before calling
        /// <param> name="config" The config group to read from.
        ///      </param></remarks>        <short>    Restores the dialog's size from the configuration according to  the screen size.</short>
        public void RestoreDialogSize(KConfigGroup config) {
            interceptor.Invoke("restoreDialogSize#", "restoreDialogSize(const KConfigGroup&)", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  Saves the dialog's size dependent on the screen dimension either to the
        ///  global or application config file.
        ///  @note the group must be set before calling
        /// <param> name="config" The config group to read from.
        /// </param><param> name="options" passed to KConfigGroup.WriteEntry()
        ///      </param></remarks>        <short>    Saves the dialog's size dependent on the screen dimension either to the  global or application config file.</short>
        public void SaveDialogSize(KConfigGroup config, uint options) {
            interceptor.Invoke("saveDialogSize#$", "saveDialogSize(KConfigGroup&, KConfigBase::WriteConfigFlags) const", typeof(void), typeof(KConfigGroup), config, typeof(uint), options);
        }
        public void SaveDialogSize(KConfigGroup config) {
            interceptor.Invoke("saveDialogSize#", "saveDialogSize(KConfigGroup&) const", typeof(void), typeof(KConfigGroup), config);
        }
        /// <remarks>
        ///  Returns the help link text.
        ///   If no text has been defined,
        ///  "Get help..." (internationalized) is returned.
        /// </remarks>        <return> The help link text.
        /// </return>
        ///         <short>    Returns the help link text.</short>
        ///         <see> enableLinkedHelp</see>
        ///         <see> setHelpLinkText</see>
        ///         <see> setHelp</see>
        public string HelpLinkText() {
            return (string) interceptor.Invoke("helpLinkText", "helpLinkText() const", typeof(string));
        }
        /// <remarks>
        ///  Returns whether any button is enabled.
        ///      </remarks>        <short>    Returns whether any button is enabled.</short>
        public bool IsButtonEnabled(KDialog.ButtonCode id) {
            return (bool) interceptor.Invoke("isButtonEnabled$", "isButtonEnabled(KDialog::ButtonCode) const", typeof(bool), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Returns the button that corresponds to the <code>id.</code>
        ///  Normally you should not use this function.
        ///  <b>Never</b> delete the object returned by this function.
        ///  See also enableButton(), showButton(), setButtonGuiItem().
        /// <param> name="id" Identifier of the button.
        /// </param></remarks>        <return> The button or 0 if the button does not exist.
        ///      </return>
        ///         <short>    Returns the button that corresponds to the <code>id.</code></short>
        public KPushButton Button(KDialog.ButtonCode id) {
            return (KPushButton) interceptor.Invoke("button$", "button(KDialog::ButtonCode) const", typeof(KPushButton), typeof(KDialog.ButtonCode), id);
        }
        /// <remarks>
        ///  Sets the main widget of the dialog.
        ///      </remarks>        <short>    Sets the main widget of the dialog.</short>
        public void SetMainWidget(QWidget widget) {
            interceptor.Invoke("setMainWidget#", "setMainWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        /// </remarks>        <return> The current main widget. Will create a QWidget as the mainWidget
        ///  if none was set before. This way you can write
        ///  <pre>
        ///    ui.setupUi(mainWidget());
        ///  </pre>
        ///  when using designer.
        ///      </return>
        ///         <short>   </short>
        public QWidget MainWidget() {
            return (QWidget) interceptor.Invoke("mainWidget", "mainWidget()", typeof(QWidget));
        }
        /// <remarks>
        ///  Reimplemented from QDialog.
        ///      </remarks>        <short>    Reimplemented from QDialog.</short>
        [SmokeMethod("sizeHint() const")]
        public override QSize SizeHint() {
            return (QSize) interceptor.Invoke("sizeHint", "sizeHint() const", typeof(QSize));
        }
        /// <remarks>
        ///  Reimplemented from QDialog.
        ///      </remarks>        <short>    Reimplemented from QDialog.</short>
        [SmokeMethod("minimumSizeHint() const")]
        public override QSize MinimumSizeHint() {
            return (QSize) interceptor.Invoke("minimumSizeHint", "minimumSizeHint() const", typeof(QSize));
        }
        /// <remarks>
        ///  Make a KDE compliant caption.
        /// <param> name="caption" Your caption. Do <code>not</code> include the application name
        ///  in this string. It will be added automatically according to the KDE
        ///  standard.
        ///      </param></remarks>        <short>    Make a KDE compliant caption.</short>
        [Q_SLOT("void setCaption(QString)")]
        [SmokeMethod("setCaption(const QString&)")]
        public virtual void SetCaption(string caption) {
            interceptor.Invoke("setCaption$", "setCaption(const QString&)", typeof(void), typeof(string), caption);
        }
        /// <remarks>
        ///  Makes a KDE compliant caption.
        /// <param> name="caption" Your caption. <b>Do</b> <b>not</b> include the application name
        ///  in this string. It will be added automatically according to the KDE
        ///  standard.
        /// </param><param> name="modified" Specify whether the document is modified. This displays
        ///  an additional sign in the title bar, usually "**".
        ///      </param></remarks>        <short>    Makes a KDE compliant caption.</short>
        [Q_SLOT("void setCaption(QString, bool)")]
        [SmokeMethod("setCaption(const QString&, bool)")]
        public virtual void SetCaption(string caption, bool modified) {
            interceptor.Invoke("setCaption$$", "setCaption(const QString&, bool)", typeof(void), typeof(string), caption, typeof(bool), modified);
        }
        /// <remarks>
        ///  Make a plain caption without any modifications.
        /// <param> name="caption" Your caption. This is the string that will be
        ///  displayed in the window title.
        ///      </param></remarks>        <short>    Make a plain caption without any modifications.</short>
        [Q_SLOT("void setPlainCaption(QString)")]
        [SmokeMethod("setPlainCaption(const QString&)")]
        public virtual void SetPlainCaption(string caption) {
            interceptor.Invoke("setPlainCaption$", "setPlainCaption(const QString&)", typeof(void), typeof(string), caption);
        }
        /// <remarks>
        ///  Enable or disable (gray out) a general action button.
        /// <param> name="id" Button identifier.
        /// </param><param> name="state" <code>true</code> enables the button(s).
        ///      </param></remarks>        <short>    Enable or disable (gray out) a general action button.</short>
        [Q_SLOT("void enableButton(ButtonCode, bool)")]
        public void EnableButton(KDialog.ButtonCode id, bool state) {
            interceptor.Invoke("enableButton$$", "enableButton(KDialog::ButtonCode, bool)", typeof(void), typeof(KDialog.ButtonCode), id, typeof(bool), state);
        }
        /// <remarks>
        ///  Enable or disable (gray out) the OK button.
        /// <param> name="state" <code>true</code> enables the button.
        ///      </param></remarks>        <short>    Enable or disable (gray out) the OK button.</short>
        [Q_SLOT("void enableButtonOk(bool)")]
        public void EnableButtonOk(bool state) {
            interceptor.Invoke("enableButtonOk$", "enableButtonOk(bool)", typeof(void), typeof(bool), state);
        }
        /// <remarks>
        ///  Enable or disable (gray out) the Apply button.
        /// <param> name="state" true enables the button.
        ///      </param></remarks>        <short>    Enable or disable (gray out) the Apply button.</short>
        [Q_SLOT("void enableButtonApply(bool)")]
        public void EnableButtonApply(bool state) {
            interceptor.Invoke("enableButtonApply$", "enableButtonApply(bool)", typeof(void), typeof(bool), state);
        }
        /// <remarks>
        ///  Enable or disable (gray out) the Cancel button.
        /// <param> name="state" true enables the button.
        ///      </param></remarks>        <short>    Enable or disable (gray out) the Cancel button.</short>
        [Q_SLOT("void enableButtonCancel(bool)")]
        public void EnableButtonCancel(bool state) {
            interceptor.Invoke("enableButtonCancel$", "enableButtonCancel(bool)", typeof(void), typeof(bool), state);
        }
        /// <remarks>
        ///  Display or hide the help link area on the top of the dialog.
        /// <param> name="state" <code>true</code> will display the area.
        /// </param></remarks>        <short>    Display or hide the help link area on the top of the dialog.</short>
        ///         <see> helpLinkText</see>
        ///         <see> setHelpLinkText</see>
        ///         <see> setHelp</see>
        [Q_SLOT("void enableLinkedHelp(bool)")]
        public void EnableLinkedHelp(bool state) {
            interceptor.Invoke("enableLinkedHelp$", "enableLinkedHelp(bool)", typeof(void), typeof(bool), state);
        }
        /// <remarks>
        ///  Sets the text that is shown as the linked text.
        ///  If text is empty,
        ///  the text "Get help..." (internationalized) is used instead.
        /// <param> name="text" The link text.
        /// </param></remarks>        <short>    Sets the text that is shown as the linked text.</short>
        ///         <see> helpLinkText</see>
        ///         <see> enableLinkedHelp</see>
        ///         <see> setHelp</see>
        [Q_SLOT("void setHelpLinkText(QString)")]
        public void SetHelpLinkText(string text) {
            interceptor.Invoke("setHelpLinkText$", "setHelpLinkText(const QString&)", typeof(void), typeof(string), text);
        }
        /// <remarks>
        ///  Sets the help path and topic.
        /// <param> name="anchor" Defined anchor in your docbook sources
        /// </param><param> name="appname" Defines the appname the help belongs to
        ///                 If empty it's the current one
        /// </param> @note The help button works differently for the class
        ///  KCMultiDialog, so it does not make sense to call this
        ///  function for Dialogs of that type.  See
        ///  KCMultiDialog.SlotHelp() for more information.
        ///      </remarks>        <short>    Sets the help path and topic.</short>
        [Q_SLOT("void setHelp(QString, QString)")]
        public void SetHelp(string anchor, string appname) {
            interceptor.Invoke("setHelp$$", "setHelp(const QString&, const QString&)", typeof(void), typeof(string), anchor, typeof(string), appname);
        }
        [Q_SLOT("void setHelp(QString)")]
        public void SetHelp(string anchor) {
            interceptor.Invoke("setHelp$", "setHelp(const QString&)", typeof(void), typeof(string), anchor);
        }
        /// <remarks>
        ///  Returns the status of the Details button.
        ///      </remarks>        <short>    Returns the status of the Details button.</short>
        [Q_SLOT("bool isDetailsWidgetVisible()")]
        public bool IsDetailsWidgetVisible() {
            return (bool) interceptor.Invoke("isDetailsWidgetVisible", "isDetailsWidgetVisible() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets the status of the Details button.
        ///      </remarks>        <short>    Sets the status of the Details button.</short>
        [Q_SLOT("void setDetailsWidgetVisible(bool)")]
        public void SetDetailsWidgetVisible(bool visible) {
            interceptor.Invoke("setDetailsWidgetVisible$", "setDetailsWidgetVisible(bool)", typeof(void), typeof(bool), visible);
        }
        /// <remarks>
        ///  Sets the widget that gets shown when "Details" is enabled.
        ///  The dialog takes over ownership of the widget.
        ///  Any previously set widget gets deleted.
        ///      </remarks>        <short>    Sets the widget that gets shown when "Details" is enabled.</short>
        [Q_SLOT("void setDetailsWidget(QWidget*)")]
        public void SetDetailsWidget(QWidget detailsWidget) {
            interceptor.Invoke("setDetailsWidget#", "setDetailsWidget(QWidget*)", typeof(void), typeof(QWidget), detailsWidget);
        }
        /// <remarks>
        ///  Destruct the dialog delayed.
        ///  You can call this function from slots like closeClicked() and hidden().
        ///  You should not use the dialog any more after calling this function.
        ///      </remarks>        <short>    Destruct the dialog delayed.</short>
        [Q_SLOT("void delayedDestruct()")]
        public void DelayedDestruct() {
            interceptor.Invoke("delayedDestruct", "delayedDestruct()", typeof(void));
        }
        /// <remarks>
        ///  Emits the #hidden signal. You can connect to that signal to
        ///  detect when a dialog has been closed.
        ///      </remarks>        <short>    Emits the #hidden signal.</short>
        [SmokeMethod("hideEvent(QHideEvent*)")]
        protected override void HideEvent(QHideEvent arg1) {
            interceptor.Invoke("hideEvent#", "hideEvent(QHideEvent*)", typeof(void), typeof(QHideEvent), arg1);
        }
        /// <remarks>
        ///  Detects when a dialog is being closed from the window manager
        ///  controls. If the Cancel or Close button is present then the button
        ///  is activated. Otherwise standard QDialog behavior
        ///  will take place.
        ///      </remarks>        <short>    Detects when a dialog is being closed from the window manager  controls.</short>
        [SmokeMethod("closeEvent(QCloseEvent*)")]
        protected override void CloseEvent(QCloseEvent e) {
            interceptor.Invoke("closeEvent#", "closeEvent(QCloseEvent*)", typeof(void), typeof(QCloseEvent), e);
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [SmokeMethod("keyPressEvent(QKeyEvent*)")]
        protected override void KeyPressEvent(QKeyEvent arg1) {
            interceptor.Invoke("keyPressEvent#", "keyPressEvent(QKeyEvent*)", typeof(void), typeof(QKeyEvent), arg1);
        }
        /// <remarks>
        ///  Activated when the button <code>button</code> is clicked
        ///  Sample that shows how to catch and handle button clicks within
        ///  an own dialog;
        ///  @code
        ///  class MyDialog : public KDialog {
        ///      protected Q_SLOTS:
        ///          void slotButtonClicked(int button) {
        ///              if (button == KDialog.Ok)
        ///                  accept();
        ///              else
        ///                  KDialog.SlotButtonClicked(button);
        ///          }
        ///  }
        ///  @endcode
        /// <param> name="button" is the type <b>KDialog.ButtonCode</b>
        ///      </param></remarks>        <short>    Activated when the button <code>button</code> is clicked </short>
        [Q_SLOT("void slotButtonClicked(int)")]
        [SmokeMethod("slotButtonClicked(int)")]
        protected virtual void SlotButtonClicked(int button) {
            interceptor.Invoke("slotButtonClicked$", "slotButtonClicked(int)", typeof(void), typeof(int), button);
        }
        /// <remarks>
        ///  Updates the margins and spacings.
        ///      </remarks>        <short>    Updates the margins and spacings.</short>
        [Q_SLOT("void updateGeometry()")]
        protected new void UpdateGeometry() {
            interceptor.Invoke("updateGeometry", "updateGeometry()", typeof(void));
        }
        ~KDialog() {
            interceptor.Invoke("~KDialog", "~KDialog()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KDialog", "~KDialog()", typeof(void));
        }
        /// <remarks>
        ///  Return the number of pixels you shall use between a
        ///  dialog edge and the outermost widget(s) according to the KDE standard.
        ///      </remarks>        <short>    Return the number of pixels you shall use between a  dialog edge and the outermost widget(s) according to the KDE standard.</short>
        public static int MarginHint() {
            return (int) staticInterceptor.Invoke("marginHint", "marginHint()", typeof(int));
        }
        /// <remarks>
        ///  Return the number of pixels you shall use between
        ///  widgets inside a dialog according to the KDE standard.
        ///      </remarks>        <short>    Return the number of pixels you shall use between  widgets inside a dialog according to the KDE standard.</short>
        public static int SpacingHint() {
            return (int) staticInterceptor.Invoke("spacingHint", "spacingHint()", typeof(int));
        }
        /// <remarks>
        ///  Builds a caption that contains the application name along with the
        ///  userCaption using a standard layout.
        ///  To make a compliant caption for your window, simply do:
        ///  <code>setWindowTitle</code>(KDialog.MakeStandardCaption(yourCaption));
        ///  To ensure that the caption is appropriate to the desktop in which the
        ///  application is running, pass in a pointer to the window the caption will
        ///  be applied to.
        ///  If using a KDialog or KMainWindow subclass, call setCaption instead and
        ///  an appropraite standard caption will be created for you
        /// <param> name="userCaption" The caption string you want to display in the
        ///  window caption area. Do not include the application name!
        /// </param><param> name="window" a pointer to the window this application will apply to
        /// </param></remarks>        <return> the created caption
        ///      </return>
        ///         <short>    Builds a caption that contains the application name along with the  userCaption using a standard layout.</short>
        public static string MakeStandardCaption(string userCaption, QWidget window, uint flags) {
            return (string) staticInterceptor.Invoke("makeStandardCaption$#$", "makeStandardCaption(const QString&, QWidget*, KDialog::CaptionFlags)", typeof(string), typeof(string), userCaption, typeof(QWidget), window, typeof(uint), flags);
        }
        public static string MakeStandardCaption(string userCaption, QWidget window) {
            return (string) staticInterceptor.Invoke("makeStandardCaption$#", "makeStandardCaption(const QString&, QWidget*)", typeof(string), typeof(string), userCaption, typeof(QWidget), window);
        }
        public static string MakeStandardCaption(string userCaption) {
            return (string) staticInterceptor.Invoke("makeStandardCaption$", "makeStandardCaption(const QString&)", typeof(string), typeof(string), userCaption);
        }
        /// <remarks>
        ///  Resize every layout manager used in <code>widget</code> and its nested children.
        /// <param> name="widget" The widget used.
        /// </param><param> name="margin" The new layout margin.
        /// </param><param> name="spacing" The new layout spacing.
        ///      </param></remarks>        <short>    Resize every layout manager used in <code>widget</code> and its nested children.</short>
        public static void ResizeLayout(QWidget widget, int margin, int spacing) {
            staticInterceptor.Invoke("resizeLayout#$$", "resizeLayout(QWidget*, int, int)", typeof(void), typeof(QWidget), widget, typeof(int), margin, typeof(int), spacing);
        }
        /// <remarks>
        ///  Resize every layout associated with <code>lay</code> and its children.
        /// <param> name="lay" layout to be resized
        /// </param><param> name="margin" The new layout margin
        /// </param><param> name="spacing" The new layout spacing
        ///      </param></remarks>        <short>    Resize every layout associated with <code>lay</code> and its children.</short>
        public static void ResizeLayout(QLayout lay, int margin, int spacing) {
            staticInterceptor.Invoke("resizeLayout#$$", "resizeLayout(QLayout*, int, int)", typeof(void), typeof(QLayout), lay, typeof(int), margin, typeof(int), spacing);
        }
        /// <remarks>
        ///  Centers <code>widget</code> on the desktop, taking multi-head setups into
        ///  account. If <code>screen</code> is -1, <code>widget</code> will be centered on its
        ///  current screen (if it was shown already) or on the primary screen.
        ///  If <code>screen</code> is -3, <code>widget</code> will be centered on the screen that
        ///  currently contains the mouse pointer.
        ///  <code>screen</code> will be ignored if a merged display (like Xinerama) is not
        ///  in use, or merged display placement is not enabled in kdeglobals.
        ///      </remarks>        <short>    Centers <code>widget</code> on the desktop, taking multi-head setups into  account.</short>
        public static void CenterOnScreen(QWidget widget, int screen) {
            staticInterceptor.Invoke("centerOnScreen#$", "centerOnScreen(QWidget*, int)", typeof(void), typeof(QWidget), widget, typeof(int), screen);
        }
        public static void CenterOnScreen(QWidget widget) {
            staticInterceptor.Invoke("centerOnScreen#", "centerOnScreen(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        ///  Places <code>widget</code> so that it doesn't cover a certain <code>area</code> of the screen.
        ///  This is typically used by the "find dialog" so that the match it finds can
        ///  be read.
        ///  For <code>screen</code>, see centerOnScreen
        /// </remarks>        <return> true on success (widget doesn't cover area anymore, or never did),
        ///  false on failure (not enough space found)
        ///      </return>
        ///         <short>    Places <code>widget</code> so that it doesn't cover a certain <code>area</code> of the screen.</short>
        public static bool AvoidArea(QWidget widget, QRect area, int screen) {
            return (bool) staticInterceptor.Invoke("avoidArea##$", "avoidArea(QWidget*, const QRect&, int)", typeof(bool), typeof(QWidget), widget, typeof(QRect), area, typeof(int), screen);
        }
        public static bool AvoidArea(QWidget widget, QRect area) {
            return (bool) staticInterceptor.Invoke("avoidArea##", "avoidArea(QWidget*, const QRect&)", typeof(bool), typeof(QWidget), widget, typeof(QRect), area);
        }
        protected new IKDialogSignals Emit {
            get { return (IKDialogSignals) Q_EMIT; }
        }
    }

    public interface IKDialogSignals : IQDialogSignals {
        /// <remarks>
        ///  Emitted when the margin size and/or spacing size
        ///  have changed.
        ///  Use marginHint() and spacingHint() in your slot
        ///  to get the new values.
        ///      </remarks>        <short>    Emitted when the margin size and/or spacing size  have changed.</short>
        [Q_SIGNAL("void layoutHintChanged()")]
        void LayoutHintChanged();
        /// <remarks>
        ///  The Help button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Help button was pressed.</short>
        [Q_SIGNAL("void helpClicked()")]
        void HelpClicked();
        /// <remarks>
        ///  The Default button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Default button was pressed.</short>
        [Q_SIGNAL("void defaultClicked()")]
        void DefaultClicked();
        /// <remarks>
        ///  The Reset button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Reset button was pressed.</short>
        [Q_SIGNAL("void resetClicked()")]
        void ResetClicked();
        /// <remarks>
        ///  The User3 button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The User3 button was pressed.</short>
        [Q_SIGNAL("void user3Clicked()")]
        void User3Clicked();
        /// <remarks>
        ///  The User2 button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The User2 button was pressed.</short>
        [Q_SIGNAL("void user2Clicked()")]
        void User2Clicked();
        /// <remarks>
        ///  The User1 button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The User1 button was pressed.</short>
        [Q_SIGNAL("void user1Clicked()")]
        void User1Clicked();
        /// <remarks>
        ///  The Apply button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Apply button was pressed.</short>
        [Q_SIGNAL("void applyClicked()")]
        void ApplyClicked();
        /// <remarks>
        ///  The Try button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Try button was pressed.</short>
        [Q_SIGNAL("void tryClicked()")]
        void TryClicked();
        /// <remarks>
        ///  The OK button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The OK button was pressed.</short>
        [Q_SIGNAL("void okClicked()")]
        void OkClicked();
        /// <remarks>
        ///  The Yes button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Yes button was pressed.</short>
        [Q_SIGNAL("void yesClicked()")]
        void YesClicked();
        /// <remarks>
        ///  The No button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The No button was pressed.</short>
        [Q_SIGNAL("void noClicked()")]
        void NoClicked();
        /// <remarks>
        ///  The Cancel button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Cancel button was pressed.</short>
        [Q_SIGNAL("void cancelClicked()")]
        void CancelClicked();
        /// <remarks>
        ///  The Close button was pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        ///      </remarks>        <short>    The Close button was pressed.</short>
        [Q_SIGNAL("void closeClicked()")]
        void CloseClicked();
        /// <remarks>
        ///  A button has been pressed. This signal is only emitted if
        ///  slotButtonClicked() is not replaced
        /// <param> name="button" is the code of the pressed button.
        ///      </param></remarks>        <short>    A button has been pressed.</short>
        [Q_SIGNAL("void buttonClicked(KDialog::ButtonCode)")]
        void ButtonClicked(KDialog.ButtonCode button);
        /// <remarks>
        ///  The dialog is about to be hidden.
        ///  A dialog is hidden after a user clicks a button that ends
        ///  the dialog or when the user switches to another desktop or
        ///  minimizes the dialog.
        ///      </remarks>        <short>    The dialog is about to be hidden.</short>
        [Q_SIGNAL("void hidden()")]
        void Hidden();
        /// <remarks>
        ///  The dialog has finished.
        ///  A dialog emits finished after a user clicks a button that ends
        ///  the dialog.
        ///  This signal is also emitted when you call hide()
        ///  If you have stored a pointer to the
        ///  dialog do <b>not</b> try to delete the pointer in the slot that is
        ///  connected to this signal.
        ///  You should use deleteLater() instead.
        ///      </remarks>        <short>    The dialog has finished.</short>
        [Q_SIGNAL("void finished()")]
        void Finished();
        /// <remarks>
        ///  The detailsWidget is about to get shown. This is your last chance
        ///  to call setDetailsWidget if you haven't done so yet.
        ///      </remarks>        <short>    The detailsWidget is about to get shown.</short>
        [Q_SIGNAL("void aboutToShowDetails()")]
        void AboutToShowDetails();
    }
}
