/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include <glib.h>
#include <time.h>

#include "egg-pixbuf-thumbnail.h"

G_BEGIN_DECLS

gboolean kz_utils_cp			(const gchar *from,
					 const gchar *to);

gboolean key_seems_sequential        (const gchar *key,
				      const gchar *prefix);
gchar   *remove_tag                  (const gchar *string, gsize len);
gchar   *html_to_text                (const gchar *string);

gchar   *create_filename_from_uri    (const gchar *uri);

gchar   *create_filename_with_path_from_uri (const gchar *uri);

gchar   *create_uri_from_filename    (const gchar *filename);

gchar   *create_profile_key_from_uri (const gchar *string);

gchar   *url_encode                  (const gchar *utf8src);
gchar   *url_decode                  (const gchar *src);
gchar   *ensure_encode_string        (const gchar *text, 
				      const gchar *encode,
				      gboolean urlencode);

GTime   thumbnail_get_last_modified  (const gchar *uri, EggPixbufThumbSize size);
GTime   history_get_last_modified    (const gchar *uri);

gchar   *kz_utils_complement_scheme  (const gchar *url);

gchar   *xml_get_content	     (const gchar *buffer);
gchar   *xml_get_attr		     (const gchar *buffer, const gchar *attr_name);

void     kz_utils_make_time_stamp	(const gchar	*target_dir,
					 const gchar	*time_stamp_path);
void     kz_utils_append_time_stamp	(const gchar	*target_file,
					 const gchar	*time_stamp_path);
void     kz_utils_purge_files		(const gchar	*path,
					 time_t		 limit_seconds);
void     kz_utils_purge_files_by_time_stamp	(const gchar	*target_dir,
						 const gchar	*time_stamp_path,
						 time_t		 limit_seconds);
gboolean str_isdigit 		     (const gchar *str);

GSList  *find_file                   (const gchar *path,
				      const gchar *fname,
				      gint maxdepth);
void	 kz_str_replace_char         (gchar *str,
				      gchar replace_char,
				      gchar new_char);

gchar	*kz_uri_encode_last_component	(const gchar *uri);

gchar	*kz_utils_get_system_name       (void);

#ifdef G_OS_WIN32
const gchar	*kz_win32_base_path	(void);
#endif

G_END_DECLS

#endif /* __UTILS_H__ */
