
/*
* INTEL CONFIDENTIAL
* Copyright (c) 2025 Intel Corporation
* All Rights Reserved.
*
* The source code contained or described herein and all documents related to
* the source code ("Material") are owned by Intel Corporation or its
* suppliers or licensors. Title to the Material remains with Intel
* Corporation or its suppliers and licensors. The Material may contain trade
* secrets and proprietary and confidential information of Intel Corporation
* and its suppliers and licensors, and is protected by worldwide copyright
* and trade secret laws and treaty provisions. No part of the Material may be
* used, copied, reproduced, modified, published, uploaded, posted,
* transmitted, distributed, or disclosed in any way without Intel's prior
* express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or
* delivery of the Materials, either expressly, by implication, inducement,
* estoppel or otherwise. Any license under such intellectual property rights
* must be express and approved by Intel in writing.
*
* Unless otherwise agreed by Intel in writing, you may not remove or alter
* this notice or any other notice embedded in Materials by Intel or Intels
* suppliers or licensors in any way.
*/

#ifndef STATIC_GRAPH_READER_H
#define STATIC_GRAPH_READER_H

#include "Ipu7xStaticGraphBinaryAutogen.h"
#include "Ipu7xStaticGraphAutogen.h"

struct StaticReaderBinaryData {
    void*        data = nullptr;
    uint32_t size = 0;
};

typedef enum
{
    enPreview,
    enVideo,
    enStills,
    enRaw,
    enIr,
    enNumOfOutPins

} DataRangePins;

typedef struct DriverDesc {

    uint32_t format;
    uint32_t width;
    uint32_t height;
    uint32_t fps;

} DriverDesc;

typedef struct DataRangeHeader {

    uint32_t NumberOfPinResolutions[enNumOfOutPins];

} DataRangeHeader;

typedef struct
{
    uint32_t key;
    uint32_t value;
}GraphHashCode;

typedef struct
{
    uint32_t numOfGraphs;
    GraphHashCode* hashCodes;
}GraphHashCodesTable;

class StaticGraphReader
{
public:
    StaticGraphReader() = default;
    StaticGraphStatus Init(StaticReaderBinaryData& binaryGraphSettings);
    StaticGraphStatus GetStaticGraphConfig(GraphConfigurationKey& settingsKey, IStaticGraphConfig** graph);
    static const uint32_t staticGraphCommonHashCode = 604505709; // autogenerated
private:
    void GetSinkMappingConfiguration(GraphConfigurationHeader* baseGraphConfigurationHeader, VirtualSinkMapping* baseSinkMappingConfiguration,
                                     GraphConfigurationHeader* selectedGraphConfigurationHeader, VirtualSinkMapping* selectedSinkMappingConfiguration);
    BinaryHeader _binaryHeader;
    GraphConfigurationHeader* _graphConfigurationHeaders = nullptr;
    SensorMode* _sensorModes = nullptr;
    int8_t* _configurationData = nullptr;
    ZoomKeyResolutions _zoomKeyResolutions;
};

#endif