/*
 * Copyright 2014-2025 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _IA_DVS_DEPRECATED_H_
#define _IA_DVS_DEPRECATED_H_

#include "ia_dvs_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/** DVS configuration.
 * This structure contains DVS configuration.
 */
typedef struct
{
    ia_dvs_algorithm_version num_axis;          /**< Algorithm mode */
    float nonblanking_ratio;                    /**< Effective vertical scan ratio, used for rolling correction (Non-blanking ration of frame interval) */
    ia_dvs_bq_resolution source_bq;             /**< Input image size [BQ] for GDC block */
    ia_dvs_bq_resolution output_bq;             /**< Output image size [BQ] from GDC block */
    ia_dvs_bq_resolution envelope_bq;           /**< GDC effective envelope size [BQ] */
    ia_dvs_bq_resolution ispfilter_bq;          /**< Padding of the image which is corrupted and should not be visible in the output image [BQ] */
    int gdc_shift_x;                            /**< Shift value of morphing table depend on ISP pipe. [chroma pixel] */
    int gdc_shift_y;                            /**< Shift value of morphing table depend on ISP pipe. [chroma pixel] */
    unsigned int oxdim_y;                       /**< Output block width  for Y plane [pixel] */
    unsigned int oydim_y;                       /**< Output block height for Y plane [pixel] */
    unsigned int oxdim_uv;                      /**< Output block width  for U/V plane [chroma pixel] */
    unsigned int oydim_uv;                      /**< Output block height for U/V plane [chroma pixel] */
    ia_dvs_gdc_hw_configuration hw_config;      /**< GDC h/w configuration. DVS does not set these values anywhere so it's only
                                                     used when validating outgoing morphing table. */
    bool use_lens_distortion_correction;        /**< False disables LDC, true enables */
    int frame_rate;                             /**< Frame rate */
    ia_dvs_gdc_buffer_config gdc_buffer_config; /**< Configuration of the GDC buffer is used inside DVS to prevent morphing table to point
                                                     invalid memory locations in GDC.

                                                     This configuration should come from FW
                                                     to inform how large buffer is allocated for GDC processing.
                                                     Morphing table coordinates generated by DVS must fit inside
                                                     GDC buffer limits. GDC buffer is allocated by FW and
                                                     it needs to allocate extra padding for each side of the image data.
                                                     This allows DVS to generate morphing table which points are outside of the image area
                                                     but still inside GDC buffer (padding area). This might be the case e.g. if LDC grid is
                                                     barrel shaped. */
    ia_dvs_crop_params crop_params;             /**< Sensor and ISP cropping parameters in native resolution (without any scaling or binning).
                                                     If scaling is performed before cropping, cropping offsets need to be calculated in native
                                                     resolution. Also if cropping is done in multiple places, everything needs to be combined
                                                     together.
                                                     Lens distortion correction is calculated from the full sensor resolution and
                                                     DVS needs to know how distortion grids need to be cropped so that they will match with
                                                     the GDC input image.*/
    bool validate_morph_table;                  /**< False disables morph table validation, true enables. Morph table needs to be validated to
                                                     protect FW. Starting from IPU4 validation is performed in PAL. */
    bool gdc_uses_floats;                       /**< False keeps dvs providing fixed point Y and UV morphing tables (legacy). True changes dvs to
                                                     provide only UV table in floating point format. */
    float quaternion_clip_max_angle;            /**< Maximum allowed angle [degrees] of rotation for rotational motion compensation. The value is
                                                     used to clip the angle of rotation for shake motion or rolling shutter compensation. The clipping
                                                     value does not depend on the orientation of the axis of rotation. This should be non-negative
                                                     value and depends on the resolution and envelope and GDC HW limitations.*/
    float gyro_to_cam_orientation[9];           /**< Contains the orientation of gyro sensor in relation to camera sensor. */
} ia_dvs_configuration;

/*! \brief Configure the DVS module.
 *
 * \param[in]   dvs_state           dvs state.
 * \param[in]   config              dvs configuration
 * \param[in]   digital_zoom_ratio  digital zoom ratio.
 * \return                          0 for no error, others for error.
 *
 * This function configures the DVS module. This allocates and initializes
 * internal data structures. This function must always be called after ia_dvs_init
 * and before any other ia_dvs function is called.
 */
LIBEXPORT ia_err
ia_dvs_config(ia_dvs_state *dvs_state,
              const ia_dvs_configuration *config,
              float digital_zoom_ratio);

#ifdef __cplusplus
}
#endif

#endif /* _IA_DVS_DEPRECATED_H_ */
