/*
 * indicator-network
 * Copyright 2010-2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ANDROID_SERVICE_
#define _ANDROID_SERVICE_

#include "android-service-constants.h"
#include "android-service-network.h"

#include <glib-object.h>

G_BEGIN_DECLS

#define ANDROID_SERVICE_TYPE (android_service_get_type ())
#define ANDROID_SERVICE(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), ANDROID_SERVICE_TYPE, AndroidService))
#define ANDROID_SERVICE_CLASS(k) G_TYPE_CHECK_CLASS_CAST ((k), ANDROID_SERVICE_TYPE, AndroidServiceClass))
#define IS_ANDROID_SERVICE(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), ANDROID_SERVICE_TYPE))
#define IS_ANDROID_SERVICE_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k), ANDROID_SERVICE_TYPE))
#define ANDROID_SERVICE_GET_CLASS(o) (G_TYPE_INTANCE_GET_CLASS ((o), ANDROID_SERVICE_TYPE, AndroidServiceClass))

typedef struct _AndroidService      AndroidService;
typedef struct _AndroidServiceClass AndroidServiceClass;

struct _AndroidService
{
  GObject parent;
};

struct _AndroidServiceClass
{
  GObjectClass parent_class;
};

GType android_service_get_type();

AndroidService *android_service_new();

// methods

/// @todo naming of these network state functions is not great..
AndroidNetworkState android_service_get_state(AndroidService *self, AndroidNetworkType type);
const gchar  *android_service_get_connected_name(AndroidService *self);
void          android_service_start_scan(AndroidService *self);

gint android_service_get_rssi(AndroidService *self);

const GSList *android_service_get_networks(AndroidService *self);

// see comment in .c
//gint          android_service_add_network(AndroidService *self, AndroidServiceNetwork *network);

void          android_service_enable_network(AndroidService *self, AndroidServiceNetwork *network);
void          android_service_enable_network_with_identifier(AndroidService *self, const gchar *identifier);
void          android_service_disconnect (AndroidService *self, AndroidServiceNetwork *network);
void          android_service_disconnect_with_identifier(AndroidService *self,
							 const gchar *identifier);

gboolean android_service_get_airplane_mode(AndroidService *self);
void     android_service_set_airplane_mode(AndroidService *self, gboolean value);

gboolean android_service_get_mobile_data_enabled(AndroidService *self);
void     android_service_set_mobile_data_enabled(AndroidService *self, gboolean value);

gboolean android_service_get_wifi_enabled(AndroidService *self);
void     android_service_set_wifi_enabled(AndroidService *self, gboolean value);

GHashTable *android_service_get_connection_information(AndroidService *self);

G_END_DECLS

#endif
