/*
 * indicator-network
 * Copyright 2010-2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ANDROID_SERVICE_NETWORK_
#define _ANDROID_SERVICE_NETWORK_

#include "android-service-constants.h"

#include <glib-object.h>

G_BEGIN_DECLS

#define ANDROID_SERVICE_NETWORK_TYPE (android_service_network_get_type ())
#define ANDROID_SERVICE_NETWORK(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), ANDROID_SERVICE_NETWORK_TYPE, AndroidServiceNetwork))
#define ANDROID_SERVICE_NETWORK_CLASS(k) G_TYPE_CHECK_CLASS_CAST ((k), ANDROID_SERVICE_NETWORK_TYPE, AndroidServiceNetworkClass))
#define IS_ANDROID_SERVICE_NETWORK(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), ANDROID_SERVICE_NETWORK_TYPE))
#define IS_ANDROID_SERVICE_NETWORK_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k), ANDROID_SERVICE_NETWORK_TYPE))
#define ANDROID_SERVICE_NETWORK_GET_CLASS(o) (G_TYPE_INTANCE_GET_CLASS ((o), ANDROID_SERVICE_NETWORK_TYPE, AndroidServiceNetworkClass))

typedef struct _AndroidServiceNetwork      AndroidServiceNetwork;
typedef struct _AndroidServiceNetworkClass AndroidServiceNetworkClass;

struct _AndroidServiceNetwork
{
  GObject                 parent;
  gchar                  *identifier;
  gchar                  *ssid;
  AndroidNetworkSecurity  security;
  gchar                  *capabilities;
  AndroidNetworkType      type;
  gchar                  *passphrase;
};

struct _AndroidServiceNetworkClass
{
  GObjectClass parent_class;
};

GType android_service_network_get_type();

AndroidServiceNetwork *android_service_network_new(const char *identifier,
						   const gchar *ssid,
						   AndroidNetworkSecurity security,
						   const gchar *capabilities,
						   gint strength,
						   AndroidNetworkType type);

gint android_service_network_get_strength(AndroidServiceNetwork *self);
void android_service_network_set_strength(AndroidServiceNetwork *self,
					  gint strength);

AndroidNetworkState android_service_network_get_state(AndroidServiceNetwork *self);
void android_service_network_set_state(AndroidServiceNetwork *self,
				       AndroidNetworkState state);

G_END_DECLS

#endif
