/*
 * indicator-network
 * Copyright 2010-2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ANDROID_SERVICE_CONSTANTS_
#define _ANDROID_SERVICE_CONSTANTS_

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
  ANDROID_NETWORK_TYPE_UNKNOWN = -1,
  ANDROID_NETWORK_TYPE_MOBILE  =  0,
  ANDROID_NETWORK_TYPE_WIFI    =  1,
} AndroidNetworkType;


typedef enum {
  ANDROID_NETWORK_SECURITY_NONE,
  ANDROID_NETWORK_SECURITY_WEP,
  ANDROID_NETWORK_SECURITY_WPA,
} AndroidNetworkSecurity;

typedef enum {
  ANDROID_NETWORK_STATE_CONNECTING     = 0,
  ANDROID_NETWORK_STATE_CONNECTED      = 1,
  ANDROID_NETWORK_STATE_SUSPENDED      = 2,
  ANDROID_NETWORK_STATE_DISCONNECTING  = 3, 
  ANDROID_NETWORK_STATE_DISCONNECTED   = 4,
  ANDROID_NETWORK_STATE_UNKNOWN        = 5,  
} AndroidNetworkState;

G_END_DECLS

#endif
