/*
An indicator to show information that is in messaging applications
that the user is using.

Copyright 2010 Canonical Ltd.

Authors:
    David Barth <david.barth@canonical.com>
	Ted Gould <ted@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ENTRY_MENU_ITEM_H__
#define __ENTRY_MENU_ITEM_H__

#include <glib.h>
#include <glib-object.h>

#include <libdbusmenu-glib/menuitem.h>

G_BEGIN_DECLS

#define ENTRY_MENU_ITEM_TYPE            (entry_menu_item_get_type ())
#define ENTRY_MENU_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENTRY_MENU_ITEM_TYPE, EntryMenuItem))
#define ENTRY_MENU_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ENTRY_MENU_ITEM_TYPE, EntryMenuItemClass))
#define IS_ENTRY_MENU_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENTRY_MENU_ITEM_TYPE))
#define IS_ENTRY_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENTRY_MENU_ITEM_TYPE))
#define ENTRY_MENU_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ENTRY_MENU_ITEM_TYPE, EntryMenuItemClass))

#define ENTRY_MENU_ITEM_SIGNAL_ACTIVATE   "activate"
#define ENTRY_MENUITEM_PROP_TEXT          "text"

typedef struct _EntryMenuItem      EntryMenuItem;
typedef struct _EntryMenuItemClass EntryMenuItemClass;

struct _EntryMenuItemClass {
	DbusmenuMenuitemClass parent_class;
};

struct _EntryMenuItem {
	DbusmenuMenuitem parent;
};

GType entry_menu_item_get_type (void);
EntryMenuItem * entry_menu_item_new ();
const gchar * entry_menu_item_get_text (EntryMenuItem * appitem);

G_END_DECLS

#endif /* __ENTRY_MENU_ITEM_H__ */

