#include <glib.h>

#include "hrn-viewer.h"

static void
hrn_viewer_base_init (gpointer klass)
{
    static gboolean initialized = FALSE;

    if (initialized) {
        return;
    }
    initialized = TRUE;
}

GType
hrn_viewer_get_type (void)
{
    static GType type = 0;

    if (!type) {
        const GTypeInfo info = {
            sizeof (HrnViewerInterface),
            hrn_viewer_base_init, NULL,
        };

        type = g_type_register_static (G_TYPE_INTERFACE,
                                       "HrnViewer", &info, 0);
    }

    return type;
}

guint
hrn_viewer_get_level_count (HrnViewer *viewer)
{
    return HRN_VIEWER_GET_CLASS (viewer)->get_level_count (viewer);
}
