#include "hrn.h"

#include "hrn-toolbar.h"
#include "hrn-searchbar.h"

enum
{
  PROP_0,
};

enum {
  QUERY_CHANGED,
  PINNED,
  QUIT_REQUESTED,
  LAST_SIGNAL
};

struct _HrnToolbarPrivate
{
    NbtkWidget *view_table;

    NbtkWidget *close_button;

    /* Things in view_group */
    NbtkWidget *filter_bar;
    guint32 pinned_id;

    guint32 search_handler;
    guint32 text_changed_id;

    HrnPinManager *pin_manager;
};

#define GET_PRIVATE(obj)    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                                                          HRN_TYPE_TOOLBAR, \
                                                          HrnToolbarPrivate))
G_DEFINE_TYPE (HrnToolbar, hrn_toolbar, NBTK_TYPE_TABLE);
static guint32 signals[LAST_SIGNAL] = {0, };

static void
hrn_toolbar_finalize (GObject *object)
{
  G_OBJECT_CLASS (hrn_toolbar_parent_class)->finalize (object);
}

static void
hrn_toolbar_dispose (GObject *object)
{
  HrnToolbar        *self = (HrnToolbar *) object;
  HrnToolbarPrivate *priv = self->priv;

  if (priv->search_handler > 0)
    {
      g_source_remove (priv->search_handler);
      priv->search_handler = 0;
    }

  G_OBJECT_CLASS (hrn_toolbar_parent_class)->dispose (object);
}

static void
hrn_toolbar_set_property (GObject *object, guint prop_id, const GValue *value,
                          GParamSpec   *pspec)
{
  switch (prop_id)
    {
      default:
        break;
    }
}

static void
hrn_toolbar_get_property (GObject *object, guint prop_id, GValue     *value,
                          GParamSpec *pspec)
{
  switch (prop_id)
    {
      default:
        break;
    }
}

static void
hrn_toolbar_allocate (ClutterActor *self, const ClutterActorBox *box,
                      ClutterAllocationFlags flags)
{
  HrnToolbar        *toolbar = (HrnToolbar *) self;
  HrnToolbarPrivate *priv    = toolbar->priv;
  float              x, y;

  CLUTTER_ACTOR_CLASS (hrn_toolbar_parent_class)->allocate (self, box, flags);

  clutter_actor_get_transformed_position ((ClutterActor *) priv->filter_bar,
                                          &x, &y);
}

static void
hrn_toolbar_map (ClutterActor *self)
{
  CLUTTER_ACTOR_CLASS (hrn_toolbar_parent_class)->map (self);
}

static void
hrn_toolbar_unmap (ClutterActor *self)
{
  CLUTTER_ACTOR_CLASS (hrn_toolbar_parent_class)->unmap (self);
}

static void
hrn_toolbar_paint (ClutterActor *actor)
{
  CLUTTER_ACTOR_CLASS (hrn_toolbar_parent_class)->paint (actor);
}

static void
hrn_toolbar_pick (ClutterActor *actor, const ClutterColor *color)
{
  HrnToolbar        *toolbar = (HrnToolbar *) actor;
  HrnToolbarPrivate *priv    = toolbar->priv;

  if (CLUTTER_ACTOR_IS_VISIBLE (priv->view_table))
    {
      clutter_actor_paint ((ClutterActor *) priv->view_table);
    }

  clutter_actor_paint ((ClutterActor *) priv->close_button);
}

static void
hrn_toolbar_class_init (HrnToolbarClass *klass)
{
  GObjectClass      *o_class = (GObjectClass *) klass;
  ClutterActorClass *a_class = (ClutterActorClass *) klass;

  o_class->dispose      = hrn_toolbar_dispose;
  o_class->finalize     = hrn_toolbar_finalize;
  o_class->set_property = hrn_toolbar_set_property;
  o_class->get_property = hrn_toolbar_get_property;

  a_class->map      = hrn_toolbar_map;
  a_class->unmap    = hrn_toolbar_unmap;
  a_class->allocate = hrn_toolbar_allocate;
  a_class->paint    = hrn_toolbar_paint;
  a_class->pick     = hrn_toolbar_pick;

  g_type_class_add_private (klass, sizeof (HrnToolbarPrivate));

  signals[QUERY_CHANGED] = g_signal_new ("query-changed",
                                         G_TYPE_FROM_CLASS (klass),
                                         G_SIGNAL_RUN_FIRST |
                                         G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                         g_cclosure_marshal_VOID__STRING,
                                         G_TYPE_NONE, 1,
                                         G_TYPE_STRING);
  signals[QUIT_REQUESTED] = g_signal_new ("quit-requested",
                                          G_TYPE_FROM_CLASS (klass),
                                          G_SIGNAL_RUN_FIRST |
                                          G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                          g_cclosure_marshal_VOID__VOID,
                                          G_TYPE_NONE, 0);
  signals[PINNED] = g_signal_new ("pinned",
                                  G_TYPE_FROM_CLASS (klass),
                                  G_SIGNAL_RUN_FIRST |
                                  G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                  g_cclosure_marshal_VOID__BOOLEAN,
                                  G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static gboolean
search_updated (ClutterActor *entry,
                HrnToolbar   *toolbar)
{
  const char *search_text;

  search_text = clutter_text_get_text (CLUTTER_TEXT (entry));
  hrn_toolbar_set_pinned (toolbar, FALSE);

  g_signal_emit (toolbar, signals[QUERY_CHANGED], 0, search_text);

  return TRUE;
}

static void
hrn_toolbar_quit_clicked_cb (ClutterActor *actor,
                             HrnToolbar   *toolbar)
{
  g_signal_emit (toolbar, signals[QUIT_REQUESTED], 0);
}

static void
search_pinned_cb (HrnSearchBar *search_bar,
                  gboolean      pinned,
                  HrnToolbar   *toolbar)
{
    g_signal_emit (toolbar, signals[PINNED], 0, pinned);
#if 0
#endif
}

static gboolean
entry_keypress_cb (ClutterActor *actor,
                   ClutterEvent *event,
                   HrnToolbar   *toolbar)
{
    HrnToolbarPrivate *priv = toolbar->priv;

    if (clutter_event_get_key_symbol (event) == CLUTTER_Escape) {
        nbtk_entry_set_text (NBTK_ENTRY (priv->filter_bar), "");
        return TRUE;
    }

    return FALSE;
}

static void
hrn_toolbar_init (HrnToolbar *self)
{
  HrnToolbarPrivate *priv;
  NbtkWidget        *filter_bin;
  ClutterActor      *text;

  self->priv = GET_PRIVATE (self);
  priv       = self->priv;

  clutter_actor_set_name ((ClutterActor *) self, "toolbar");

  /* FIXME: This is a mess. The toolbar have been redesigned between 2.0 and
   * 2.1, this has to be rewritten anyway for 2.2, just hack it for now */
  priv->view_table = nbtk_table_new ();
  nbtk_table_add_actor_with_properties (NBTK_TABLE (self),
                                        (ClutterActor *) priv->view_table,
                                        0, 0,
                                        "x-align", 0.0,
                                        "y-align", 0.0,
                                        NULL);

  priv->filter_bar = g_object_new (HRN_TYPE_SEARCH_BAR, NULL);
  clutter_actor_set_name ((ClutterActor *) priv->filter_bar, "filter-bar");
  priv->pinned_id = g_signal_connect (priv->filter_bar, "search-pinned",
                                      G_CALLBACK (search_pinned_cb), self);

  text = nbtk_entry_get_clutter_text (NBTK_ENTRY (priv->filter_bar));
  g_signal_connect (text, "key-press-event",
                    G_CALLBACK (entry_keypress_cb), self);
  priv->text_changed_id = g_signal_connect (text, "text-changed",
                                            G_CALLBACK (search_updated), self);
  clutter_stage_set_key_focus (CLUTTER_STAGE (hrn_window_get_stage (window)),
                               CLUTTER_ACTOR (text));

  filter_bin = nbtk_bin_new ();
  clutter_actor_set_name (CLUTTER_ACTOR (filter_bin), "filter-bin");
  nbtk_bin_set_child (NBTK_BIN (filter_bin), CLUTTER_ACTOR (priv->filter_bar));
  nbtk_bin_set_fill (NBTK_BIN (filter_bin), TRUE, FALSE);
  nbtk_table_add_actor_with_properties (NBTK_TABLE (priv->view_table),
                                        (ClutterActor *) filter_bin,
                                        0, 0,
                                        "y-fill", TRUE,
                                        "y-expand", TRUE,
                                        NULL);

  priv->close_button = nbtk_button_new ();
  clutter_actor_set_name ((ClutterActor *) priv->close_button,
                          "close-button");
  clutter_actor_set_size ((ClutterActor *) priv->close_button, 57, 51);
  g_object_set (G_OBJECT(priv->close_button), "transition-duration", 100, NULL);

  g_signal_connect (priv->close_button, "clicked",
                    G_CALLBACK (hrn_toolbar_quit_clicked_cb), self);
  nbtk_table_add_actor_with_properties (NBTK_TABLE (self),
                                        (ClutterActor *) priv->close_button,
                                        0, 3,
                                        "x-expand", FALSE,
                                        "y-expand", FALSE,
                                        "x-fill", FALSE,
                                        "y-fill", FALSE,
                                        NULL);
}

static void
pin_selected_cb (HrnPinManager *pin_manager,
                 HrnPin        *pin,
                 HrnToolbar    *toolbar)
{
  if (pin) {
    hrn_toolbar_set_filter_mode (toolbar, pin->filter);
  } else {
    hrn_toolbar_set_filter_mode (toolbar, 7);
  }
}

NbtkWidget *
hrn_toolbar_new (HrnPinManager *pin_manager)
{
  HrnToolbar *toolbar;
  HrnToolbarPrivate *priv;

  toolbar = g_object_new (HRN_TYPE_TOOLBAR, NULL);
  priv = toolbar->priv;

  priv->pin_manager = pin_manager;
  g_signal_connect (pin_manager, "pin-selected",
                    G_CALLBACK (pin_selected_cb), toolbar);

  hrn_searchbar_set_pin_manager ((HrnSearchBar *) priv->filter_bar,
                                 pin_manager);

  return (NbtkWidget *) toolbar;
}

void
hrn_toolbar_set_pinned (HrnToolbar *toolbar, gboolean pinned)
{
  HrnToolbarPrivate *priv = toolbar->priv;

  g_signal_handler_block (priv->filter_bar, priv->pinned_id);
  hrn_search_bar_set_pinned (HRN_SEARCH_BAR (priv->filter_bar), pinned);
  g_signal_handler_unblock (priv->filter_bar, priv->pinned_id);
}

void
hrn_toolbar_focused (HrnToolbar *toolbar)
{
  HrnToolbarPrivate *priv = toolbar->priv;
  ClutterActor      *stage, *text;

  stage = hrn_window_get_stage (window);

  text = nbtk_entry_get_clutter_text ((NbtkEntry *) priv->filter_bar);
  clutter_stage_set_key_focus ((ClutterStage *) stage, text);
}

void
hrn_toolbar_set_filter_mode (HrnToolbar *toolbar, int mode)
{
}

guint
hrn_toolbar_get_filter_mode (HrnToolbar *toolbar)
{
    g_warning ("FIXME: hrn_toolbar_get_filter_mode");
    return 0;
}

void
hrn_toolbar_set_query (HrnToolbar *toolbar,
                       const char *query)
{
    HrnToolbarPrivate *priv = toolbar->priv;
    ClutterActor *text;

    text = nbtk_entry_get_clutter_text (NBTK_ENTRY (priv->filter_bar));

    /* We don't want the toolbar being updated manually to trigger a search */
    g_signal_handler_block (text, priv->text_changed_id);
    nbtk_entry_set_text (NBTK_ENTRY (priv->filter_bar), query);
    g_signal_handler_unblock (text, priv->text_changed_id);
}

const char *
hrn_toolbar_get_query (HrnToolbar *toolbar)
{
  HrnToolbarPrivate *priv = toolbar->priv;
  ClutterActor *text;

  text = nbtk_entry_get_clutter_text (NBTK_ENTRY (priv->filter_bar));
  return clutter_text_get_text ((ClutterText *) text);
}

void
hrn_toolbar_set_zoom (HrnToolbar *toolbar,
                      double      zoom)
{
    g_warning ("FIXME: hrn_toolbar_set_zoom");
}

double
hrn_toolbar_get_zoom (HrnToolbar *toolbar)
{
    g_warning ("FIXME: hrn_toolbar_get_zoom");
    return 1.0;
}
