#ifndef __HRN_THEATRE_H__
#define __HRN_THEATRE_H__

#include <clutter/clutter.h>
#include "hrn-state-manager.h"

G_BEGIN_DECLS

#define HRN_TYPE_THEATRE                                                \
  (hrn_theatre_get_type ())
#define HRN_THEATRE(obj)                                                \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                               HRN_TYPE_THEATRE,                       \
                               HrnTheatre))
#define HRN_THEATRE_CLASS(klass)                                        \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                            HRN_TYPE_THEATRE,                          \
                            HrnTheatreClass))
#define IS_HRN_THEATRE(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                               HRN_TYPE_THEATRE))
#define IS_HRN_THEATRE_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                            HRN_TYPE_THEATRE))
#define HRN_THEATRE_GET_CLASS(obj)                                      \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                              HRN_TYPE_THEATRE,                        \
                              HrnTheatreClass))

typedef struct _HrnTheatrePrivate HrnTheatrePrivate;
typedef struct _HrnTheatre HrnTheatre;
typedef struct _HrnTheatreClass HrnTheatreClass;

struct _HrnTheatre
{
  ClutterGroup parent;

  HrnTheatrePrivate *priv;
};

struct _HrnTheatreClass
{
  ClutterGroupClass parent_class;
};

GType       hrn_theatre_get_type   (void) G_GNUC_CONST;
HrnTheatre *hrn_theatre_new        (HrnStateManager *state);
gboolean    hrn_theatre_get_active (HrnTheatre *theatre);
void        hrn_theatre_show       (HrnTheatre *theatre);
void        hrn_theatre_hide       (HrnTheatre *theatre);
void hrn_theatre_set_image_slideshow (HrnTheatre *theatre,
                                      gboolean    enabled);


G_END_DECLS

#endif /* __HRN_THEATRE_H__ */
