#ifndef QFILESYSTEMMODELQML_H
#define QFILESYSTEMMODELQML_H

#include <QAbstractListModel>
#include <QFileInfo>
#include <QStringList>
#include <QFileSystemWatcher>

/* This is a custom, simplistic implementation of a QFileSystemModel that can be
   exposed to QML. The original implementation subclassed QFileSystemModel,
   logically. However, this uncovered a number of hairy bugs in Qt (including,
   but not limited to, http://bugreports.qt.nokia.com/browse/QTBUG-13038 and
   http://bugreports.qt.nokia.com/browse/QTBUG-13664). Working around those bugs
   was tricky and introduced even nastier issues. */
class QFileSystemModelQML : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(QString rootPath READ rootPath WRITE setRootPath NOTIFY rootPathChanged)
    Q_PROPERTY(QStringList nameFilters READ nameFilters WRITE setNameFilters)
    Q_PROPERTY(bool nameFilterDisables READ nameFilterDisables WRITE setNameFilterDisables)

public:
    QFileSystemModelQML(QObject * parent = 0);

    // getters
    QString rootPath() const;
    QStringList nameFilters() const;
    bool nameFilterDisables() const;

    // setters
    void setRootPath(const QString& newPath);
    void setNameFilters(const QStringList& filters);
    void setNameFilterDisables(bool disable);

    // reimplemented
    int rowCount(const QModelIndex& parent = QModelIndex()) const;
    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const;

signals:
    void rootPathChanged(const QString& newPath);

private:
    QString m_rootPath;
    QStringList m_nameFilters;
    bool m_nameFilterDisables;

    QFileInfoList m_files;
    QFileSystemWatcher m_watcher;

private slots:
    void updateFiles();
    void onDirectoryChanged(const QString& path);
};

#endif // QFILESYSTEMMODELQML_H

