#ifndef XFCE4_PANEL_WINDOW_PROPERTY_H
#define XFCE4_PANEL_WINDOW_PROPERTY_H

#include <QObject>
#include <QFileSystemWatcher>

class Xfce4PanelWindowProperty : public QObject
{
  Q_OBJECT
  
  Q_PROPERTY(int size READ getSize WRITE setSize NOTIFY sizeChanged)
  Q_PROPERTY(int position READ getPosition WRITE setPosition NOTIFY positionChanged)

public:
  Xfce4PanelWindowProperty(QObject *parent=0);

  void setSize(int size);
  void setPosition(int position);
  int getSize() const;
  int getPosition() const;

signals:
  void sizeChanged(int);
  void positionChanged(int);

private slots:
  void loadPanelConfiguration();

private:
  QFileSystemWatcher fileWatcher;
  int size;
  int position;
};

#endif // XFCE4_PANEL_WINDOW_PROPERTY_H
