#ifndef LAUNCHERAPPLICATION_H
#define LAUNCHERAPPLICATION_H

#include <launcher/launcher.h>
#include <QObject>
#include <QUrl>

class QLauncherApplication : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool running READ running NOTIFY runningChanged)
    Q_PROPERTY(QString name READ name NOTIFY nameChanged)
    Q_PROPERTY(QString icon_name READ icon_name NOTIFY iconNameChanged)
    Q_PROPERTY(QString desktop_file READ desktop_file WRITE setDesktopFile NOTIFY desktopFileChanged)
    Q_PROPERTY(QString startup_wm_class READ startup_wm_class NOTIFY startupWMClassChanged)
    Q_PROPERTY(QString connection_type READ connection_type NOTIFY connectionTypeChanged)

public:
    QLauncherApplication(QObject *parent = 0);
    QLauncherApplication(QString desktop_file);
    ~QLauncherApplication();

    /* getters */
    bool running() const;
    QString name() const;
    QString icon_name() const;
    QString desktop_file() const;
    QString startup_wm_class() const;
    QString connection_type() const;

    /* setters */
    void setDesktopFile(QString desktop_file);

    /* methods */
    Q_INVOKABLE bool launch_with_parameter(QString parameter);
    Q_INVOKABLE bool launch();
    Q_INVOKABLE void show();
    Q_INVOKABLE void close();
    /* the following  methods are original, ie. not wrappers around liblauncher*/
    Q_INVOKABLE void removeFromConnectionsList(QString id);
    Q_INVOKABLE void removeDesktopFile();
    Q_INVOKABLE void setIsSystemSettings() const;
    Q_INVOKABLE void setIsConnectionEditor() const;

    /* static notifiers */
    static void runningChangedStatic(GObject    *gobject __attribute__ ((unused)),
                                     GParamSpec *pspec __attribute__ ((unused)),
                                     QLauncherApplication *app) {app->runningChanged();}
    static void nameChangedStatic(GObject    *gobject __attribute__ ((unused)),
                                     GParamSpec *pspec __attribute__ ((unused)),
                                     QLauncherApplication *app) {app->nameChanged();}
    static void iconNameChangedStatic(GObject    *gobject __attribute__ ((unused)),
                                     GParamSpec *pspec __attribute__ ((unused)),
                                     QLauncherApplication *app) {app->iconNameChanged();}
    static void desktopFileChangedStatic(GObject    *gobject __attribute__ ((unused)),
                                     GParamSpec *pspec __attribute__ ((unused)),
                                     QLauncherApplication *app) {app->desktopFileChanged();}
    static void startupWMClassChangedStatic(GObject    *gobject __attribute__ ((unused)),
                                     GParamSpec *pspec __attribute__ ((unused)),
                                     QLauncherApplication *app) {app->startupWMClassChanged();}
    static void connectionTypeChangedStatic(GObject    *gobject __attribute__ ((unused)),
                                     GParamSpec *pspec __attribute__ ((unused)),
                                     QLauncherApplication *app) {app->connectionTypeChanged();}
signals:
    void runningChanged();
    void nameChanged();
    void iconNameChanged();
    void desktopFileChanged();
    void startupWMClassChanged();
    void connectionTypeChanged();

public slots:

private:
    LauncherApplication *m_application;

    void addToClass(const QString& className) const;
};

#endif // LAUNCHERAPPLICATION_H
