#include <string>

#include <QApplication>
#include <QDesktopWidget>
#include <QTranslator>
#include <QLibraryInfo>
#include <QLocale>

#include <qdeclarativecontext.h>
#include <qdeclarativeview.h>
#include "launcherdeclarativeview.h"
#include "customapplication.h"


int main(int argc, char ** argv)
{
    QApplication::setGraphicsSystem("raster");

    CustomApplication app(argc, argv);
    LauncherDeclarativeView view;

    /* translations */
    QTranslator qt_translator;
    qt_translator.load("qt_" + QLocale::system().name(), QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qt_translator);
    QTranslator app_translator;
    app_translator.load("launcher_qt_" + QLocale::system().name(), "/usr/share/hedley-launcher/translations");
    app.installTranslator(&app_translator);

    /* Performance tricks */
    view.setAttribute(Qt::WA_OpaquePaintEvent);
    view.setAttribute(Qt::WA_NoSystemBackground);
    //view.setOptimizationFlags(QGraphicsView::DontAdjustForAntialiasing);

    /* Make the launcher a desktop window:
        - below other windows
        - frameless
        - fullscreen
        - not showing up in the task manager
    */
    //view.setWindowState(Qt::WindowFullScreen);
    //view.setWindowFlags(Qt::WindowStaysOnBottomHint);
    view.setAttribute(Qt::WA_X11NetWmWindowTypeDesktop);

    /* Expose the view to QML */
    view.rootContext()->setContextProperty("launcherView", &view);

    /* Load the QML UI, focus and show the window */
    view.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    view.setFocus();
    view.setSource(QUrl("hedley.qml"));

    /* Always match the size of the desktop */
    int current_screen = QApplication::desktop()->screenNumber(&view);
    view.fitToScreenSize(current_screen);
    QObject::connect(QApplication::desktop(), SIGNAL(workAreaResized(int)), &view, SLOT(fitToScreenSize(int)));

    view.show();

    return app.exec();
}
