#include <launcher/launcher.h>

#include "customapplication.h"
#include "launcherdbusservice.h"

CustomApplication::CustomApplication(int &argc, char **argv) :
    QApplication(argc, argv)
{
    new LauncherDBusService(this);
    registerDBusService();
}

bool CustomApplication::registerDBusService() {
    QDBusConnection connection = QDBusConnection::sessionBus();
     if ( !connection.registerService("com.canonical.HedleyLauncher") ) {
         qDebug() << "error registering service.";
         return false;
     }
     if ( !connection.registerObject("/", this) ) {
         qDebug() << "error registering object";
         return false;
     }

     return true;

}

static LauncherApplication* getApplicationForDesktopFile(const QString &desktop_file)
{
    LauncherAppman *appman = launcher_appman_get_default();
    QByteArray byte_array = desktop_file.toUtf8();
    gchar *filename = byte_array.data();
    return launcher_appman_get_application_for_desktop_file(appman, filename);
}

void CustomApplication::NotifyApplicationStarted(const QString &desktop_file)
{
    GValue value = {0,};
    g_value_init(&value, G_TYPE_BOOLEAN);
    g_value_set_boolean(&value, TRUE);
    LauncherApplication *application = getApplicationForDesktopFile(desktop_file);
    g_object_set_property(G_OBJECT(application), "running", &value);
}

void CustomApplication::NotifyApplicationStopped(const QString &desktop_file)
{
    GValue value = {0,};
    g_value_init(&value, G_TYPE_BOOLEAN);
    g_value_set_boolean(&value, FALSE);
    LauncherApplication *application = getApplicationForDesktopFile(desktop_file);
    g_object_set_property(G_OBJECT(application), "running", &value);
}
