import Qt 4.7
import gconf 1.0

/* Main entry point of the launcher.

   It contains a background image and a tabulated element holding:
    - the connections page
    - the system settings page

    Switching between pages is done through a GConf key storing the index of
    the page that is to be shown:

     /apps/hedley_launcher/current_page
*/
FocusScope {
    /* Minimal size */
    width: 1024
    height: 768

    focus: true

    Image {
        id: background

        /* Activating antialiasing would increase CPU usage */
        smooth: false
        fillMode: Image.PreserveAspectCrop
        anchors.fill: parent
        source: gconf_background_path.value ? gconf_background_path.value : "/usr/share/backgrounds/hedley.png"
    }

    Xfce4PanelWindowProperty {
        id: panel

        property bool isTop: position >= 1 && position <= 3
        property bool isLeft: position >= 4 && position <= 6
        property bool isRight: position >= 7 && position <= 9
        property bool isBottom: position >= 10 && position <= 12

        property bool isVertical: isLeft || isRight
        property bool isHorizontal: isTop || isBottom
    }

    FocusScope {
        id: launcher
        /* The launcher is a desktop window (fullscreen with no decorations).
           We need to account for the panel overlapping on the window.
         */
        anchors.fill: parent
        anchors.topMargin: panel.isTop ? panel.size : 0
        anchors.leftMargin: panel.isLeft ? panel.size : 0
        anchors.rightMargin: panel.isRight ? panel.size : 0
        anchors.bottomMargin: panel.isBottom ? panel.size : 0

        focus: true

        QLauncherApplication {
            id: update_background
            desktop_file: "/usr/share/gdm/autostart/LoginWindow/background.desktop"
        }

        GConfItem {
            id: gconf_background_path
            key: "/apps/hedley_launcher/background_path"
            onValueChanged: update_background.launch()
        }

        GConfItem {
            id: gconf_current_page
            key: "/apps/hedley_launcher/current_page"
            value: 0
        }

        BorderImage {
            id: frame

            anchors.fill: parent
            anchors.topMargin: 25
            anchors.bottomMargin: 40
            anchors.leftMargin: 40
            anchors.rightMargin: 40

            border.bottom: 9
            border.top: 9
            border.right: 9
            border.left: 9
            /* Warning: not setting the tile mode to 'repeat' incurs a performance
                        cost */
            horizontalTileMode: BorderImage.Repeat
            verticalTileMode: BorderImage.Repeat
            smooth: false
            source: "artwork/applications_border.png"
        }

        Tab {
            id: pages

            anchors.fill: frame
            currentPage: gconf_current_page.value
            focus: true

            property color information_bar_color: "#faaf42"
            property color power_bar_color: "#f16724"

            ConnectionsPage {
                id: connections_page
                property color color: "#28a8e0"
                opacity: 1
            }

            LazyPage {
                id: system_settings_page
                qmlFile: "SystemSettingsPage.qml"
                property color color: "#00aa21"
            }

            LazyPage {
                id: add_connection_page
                qmlFile: "AddConnectionPage.qml"
                property color color: connections_page.color
            }

            ConnectionEditorPage {
                id: connection_editor_page
                property color color: connections_page.color
            }
        }


        GConfItem {
            id: gconf_system_information_visible
            key: "/apps/hedley_launcher/system_information_visible"
            value: false
        }

        GConfItem {
            id: gconf_session_logout_visible
            key: "/apps/hedley_launcher/session_logout_visible"
            value: false
        }


        /* Very thin color bar positioned next to the panel and indicating what
           page is currently on */
        Row {
            id: horizontal_color_bar

            visible: panel.isHorizontal
            x: 0
            y: panel.isBottom ? parent.height-(height+1) : 1
            width: parent.width
            height: 2

            Rectangle {
                id: hconnections_page_bar

                width: panel.size+8
                height: parent.height
                color: connections_page.color
            }

            Rectangle {
                id: hcurrent_page_bar

                width: parent.width
                       - hconnections_page_bar.width
                       - hsystem_settings_page_bar.width
                       - hinformation_page_bar.width
                       - hpower_page_bar.width
                height: parent.height
                color: {
                    if(gconf_session_logout_visible.value)
                        return pages.power_bar_color
                    else if(gconf_system_information_visible.value)
                        return pages.information_bar_color
                    else
                        return pages.children[pages.currentPage].color
                }
            }

            Rectangle {
                id: hsystem_settings_page_bar

                width: panel.size
                height: parent.height
                color: system_settings_page.color
            }

            Rectangle {
                id: hinformation_page_bar

                width: panel.size
                height: parent.height
                color: pages.information_bar_color
            }

            Rectangle {
                id: hpower_page_bar

                width: panel.size
                height: parent.height
                color: pages.power_bar_color
            }
        }

        Column {
            id: vertical_color_bar

            visible: panel.isVertical
            x: panel.isRight ? parent.width-(width+1) : 1
            y: 0
            width: 2
            height: parent.height

            Rectangle {
                id: vconnections_page_bar

                width: parent.width
                height: panel.size+8
                color: connections_page.color
            }

            Rectangle {
                id: vcurrent_page_bar

                width: parent.width
                height: parent.height
                       - vconnections_page_bar.height
                       - vsystem_settings_page_bar.height
                       - vinformation_page_bar.height
                       - vpower_page_bar.height
                color: hcurrent_page_bar.color
            }

            Rectangle {
                id: vsystem_settings_page_bar

                width: parent.width
                height: panel.size
                color: system_settings_page.color
            }

            Rectangle {
                id: vinformation_page_bar

                width: parent.width
                height: panel.size
                color: pages.information_bar_color
            }

            Rectangle {
                id: vpower_page_bar

                width: parent.width
                height: panel.size
                color: pages.power_bar_color
            }
        }
    }

    FocusScope {
        id: popup

        property bool enabled: false

        function show(type, connection) {
            popup_loader.connection = connection
            popup_loader.source = type
            popup.enabled = true
            popup.focus = true
        }

        function hide() {
            launcher.focus = true
            popup.enabled = false
            popup_loader.source = ""
            popup_loader.connection = null
        }

        anchors.fill: parent

        /* Eating all events so that elements under the popup do not
           receive them and essentially become inactive */
        MouseArea {
            anchors.fill: parent
            enabled: popup.enabled
            hoverEnabled: popup.enabled
        }

        Loader {
            id: popup_loader

            property variant connection

            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            opacity: popup.enabled ? 0.9 : 0.0
            Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}

            focus: true

            onLoaded: {
                item.connection = popup_loader.connection
            }

            Connections {
                target: popup_loader.item
                onExited: {
                    popup.hide()
                }
            }
        }
    }
}
