import Qt 4.7

/* Item displaying a system setting.

   It contains:
    - a generic bordered background image
    - an icon representing the application
    - a text describing the application

   It supports mouse hover by changing the appearance of the background.

   The 'icon' property holds the source of the image to load as an icon.
   The 'label' property holds the text to display.
   The 'running' property is a boolean indicating whether or not the
   application is launched.

   The 'clicked' signal is emitted upon clicking on the item.
*/
Item {
    property alias label: label.text
    property alias icon: icon.source
    property bool running: false

    signal clicked


    Keys.onPressed: {
        if (event.key == Qt.Key_Return || event.key == Qt.Key_Enter) {
            clicked()
            event.accepted = true;
        }
    }

    MouseArea {
        id: mouse

        /* FIXME: workaround double click bug
                  http://bugreports.qt.nokia.com/browse/QTBUG-12250 */
        property bool double_clicked: false

        hoverEnabled: true
        anchors.fill: parent
        onClicked: {
            if(double_clicked)
                double_clicked = false
            else
                parent.clicked()
        }
        onDoubleClicked: {
            double_clicked = true
        }
    }

    BorderImage {
        id: background

        opacity: mouse.containsMouse ? 1.0 : 0.7
        border.bottom: 1
        border.top: 1
        border.right: 1
        border.left: 1
        anchors.fill: parent

        source: "artwork/system_settings_item_border.png"
        smooth: false
        horizontalTileMode: BorderImage.Repeat
        verticalTileMode: BorderImage.Repeat

        Behavior on opacity {NumberAnimation {duration: 100}}
    }

    Rectangle {
        id: background_launched

        anchors.fill: background
        anchors.leftMargin: 1
        anchors.rightMargin: 1
        anchors.topMargin: 1
        anchors.bottomMargin: 1

        opacity: running ? 1.0 : 0.0
        color: "#00adee"

        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}
    }

    Image {
        id: icon

        width: 32
        height: 32
        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.verticalCenter: background.verticalCenter
        fillMode: Image.PreserveAspectFit
        sourceSize.width: width
        sourceSize.height: height
        smooth: false

        asynchronous: true
        opacity: status == Image.Ready ? 1 : 0
        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}
    }

    Rectangle {
        id: label_background

        anchors.left: icon.right
        anchors.leftMargin: 8
        anchors.right: parent.right
        anchors.rightMargin: 5
        anchors.verticalCenter: label.verticalCenter
        height: label.paintedHeight + 4
        color: "black"
        opacity: running ? 0.0 : 0.3
        radius: 5
    } 

    TextCustom {
        id: label

        font.pointSize: 10
        anchors.left: icon.right
        anchors.leftMargin: 10
        anchors.right: parent.right
        anchors.rightMargin: 7
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        elide: Text.ElideRight
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignLeft
        font.underline: parent.activeFocus
    }

}
