import Qt 4.7

/* DOCME */
FocusScope {
    id: popup

    property int padding: 35
    property int minimal_width: 280
    property alias text: label.text

    focus: true

    signal exited

    height: 180
    /* Make sure the title row never overflows outside the popup */
    width: Math.max(title.width, minimal_width) + 2*padding

    BorderImage {
        /* background with the border */
        id: border

        border.bottom: 9
        border.top: 9
        border.right: 9
        border.left: 9
        anchors.fill: parent
        anchors.margins: 7

        source: "artwork/popup_background_border.png"
        opacity: 0.9
    }

    Row {
        id: title

        spacing: 22
        anchors.top: parent.top
        anchors.topMargin: parent.height*0.2
        anchors.horizontalCenter: parent.horizontalCenter

        Image {
            id: icon

            source: "artwork/attention.png"
            asynchronous: true
            smooth: false
            fillMode: Image.PreserveAspectFit
            sourceSize.width: width
            sourceSize.height: height
            width: 45
            height: 45
        }

        TextCustom {
            id: label

            anchors.verticalCenter: icon.verticalCenter

            width: paintedWidth
            height: paintedHeight
            clip: true
        }
    }
}
