import Qt 4.7

Page {
    id: lazypage
    property Page pageItem
    property bool loaded: false
    property string qmlFile

    onEntered: {
        if (!loaded) {
            var component = Qt.createComponent(qmlFile)
            if (component.status == Component.Ready) {
                pageItem = component.createObject(lazypage)
                loaded = true
            }
            else if (component.status == Component.Error) {
                console.log(component.errorString())
            }
        }
        if (loaded) {
            pageItem.enter()
        }
    }

    onExited: {
        if (loaded) {
            pageItem.exit()
        }
    }
}
