import Qt 4.7
import gconf 1.0

/* FIXME: unfinished */
Page {
    id: connection_editor

    property QLauncherApplication application

    function edit_connection(editor_desktop_file, connection_id) {
        _prepare_edition(editor_desktop_file)
        var result = application.launch_with_parameter(connection_id)
        if(!result) {
            /* Switch to connections_page */
            gconf_current_page.value = 0
        }
        return result
    }

    function create_connection(editor_desktop_file) {
        _prepare_edition(editor_desktop_file)
        var result = application.launch()
        if(!result) {
            /* Switch to connections_page */
            gconf_current_page.value = 0
        }
        return result
    }

    function _prepare_edition(editor_desktop_file) {
        /* Switch to connection_editor_page */
        gconf_current_page.value = 3
        application =  Qt.createQmlObject("QLauncherApplication {}",
                                          connection_editor, "dynamicSnippet1")

        application.desktop_file = editor_desktop_file
        application.setIsConnectionEditor()
    }

    GConfItem {
        id: gconf_connection_editors_classes
        key: "/apps/hedley_launcher/connection_editors/classes"
    }

    /* Close any connection editor application when exiting */
    onExited: {
        if(application != null && application.running) {
            application.close()
            application = null
        }

        /* Empty the list of windows that should be treated as connection
           editors by the window manager (xfwm4); that list is populated
           via the app.setIsConnectionEditor() call above
           (in function _prepare_edition()).
        */
        gconf_connection_editors_classes.value = []
    }

    Connections {
        target: application
        onRunningChanged: {
            if(!application.running) {
                /* Switch to connections_page */
                gconf_current_page.value = 0
            }
        }
    }

    Image {
        id: stripes

        z: -1
        source: "artwork/stripes.png"
        opacity: 0.18

        anchors.fill: parent
        anchors.margins: 6
        fillMode: Image.Tile
    }

    Rectangle {
        id: page_title_background

        anchors.top: parent.top
        anchors.topMargin: 35
        anchors.leftMargin: 55
        anchors.horizontalCenter: page_title.horizontalCenter
        color: "black"
        opacity: 0.3
        height: page_title.height + 12
        width: page_title.width + 22
        radius: 5
    }

    Row {
        id: page_title

        anchors.left: parent.left
        anchors.leftMargin: 60
        anchors.top: parent.top
        anchors.topMargin: 40
        spacing: 20

        Image {
            id: icon

            source: application ? "image://icons/"+application.icon_name : source
            width: 64
            height: 64
            sourceSize.width: width
            sourceSize.height: height

            Image {
                id: settings

                source: "artwork/cog.png"
                asynchronous: true
                smooth: false
                fillMode: Image.PreserveAspectFit
                width: sourceSize.width - 12
                height: sourceSize.width
                opacity: 0.8
                anchors.fill: parent
            }
        }

        Item {
            id: labels

            anchors.verticalCenter: icon.verticalCenter
            width: childrenRect.width
            height: childrenRect.height

            TextCustom {
                id: title

                text: application ? application.name : text
                width: paintedWidth
                height: paintedHeight
            }
        }
    }
}
