import Qt 4.7

/* Button item showing a text on top of a frame.

   The 'text' property holds the string to be displayed.
   The 'clicked' signal is emitted when the item is clicked.
*/
FocusScope {
    property alias text: label.text

    signal clicked

    width: 110
    height: 35

    MouseArea {
        id: mouse

        /* FIXME: workaround double click bug
                  http://bugreports.qt.nokia.com/browse/QTBUG-12250 */
        property bool double_clicked: false
        hoverEnabled: true

        anchors.fill: parent
        onClicked: {
            if(double_clicked)
                double_clicked = false
            else
                parent.clicked()
        }
        onDoubleClicked: {
            double_clicked = true
        }
        onPressed: parent.state = "pressed"
        onReleased: parent.state = "default"
    }

    BorderImage {
        id: frame

        border.bottom: 5
        border.top: 5
        border.right: 5
        border.left: 5
        anchors.fill: parent
        source: "artwork/button_frame/default.png"
        opacity: mouse.containsMouse ? 0.8 : 1
    }


    TextCustom {
        id: label
        focus: true
        color: "#000000"
        style: Text.Normal
        width: paintedWidth
        height: paintedHeight
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter
        font.underline: activeFocus

        Keys.onPressed: {
            if (event.key == Qt.Key_Return || event.key == Qt.Key_Enter) {
                parent.clicked()
                event.accepted = true;
            }
        }
    }

    states: [
        State {
            name: "pressed"
            PropertyChanges {
                   target: label
                   color: "#ffffff"
                   style: Text.Sunken
            }
            PropertyChanges {
                   target: frame
                   source: "artwork/button_frame/pressed.png"
            }
        }
    ]
}
