import Qt 4.7
import gconf 1.0

/* DOCME */
Page {
    FocusScope {
        id: add_connection

        focus: true

        anchors.fill: parent

        Image {
            id: stripes

            z: -1
            source: "artwork/stripes.png"
            opacity: 0.18

            anchors.fill: parent
            anchors.margins: 6
            fillMode: Image.Tile
        }

        Rectangle {
            id: title_background

            x: 70
            y: 65
            height: icon.height + 16
            width: icon.anchors.leftMargin + icon.width + title.anchors.leftMargin + title.paintedWidth + 16
            color: "black"
            opacity: 0.3
            radius: 5
        }

        Image {
            id: icon

            anchors.top: title_background.top
            anchors.topMargin: 6
            anchors.left: title_background.left
            anchors.leftMargin: 11
            source: "artwork/add_38x38.png"
            height: sourceSize.height
            width: sourceSize.width
        }

        TextCustom {
            id: title

            anchors.top: title_background.top
            anchors.topMargin: 11
            anchors.left: icon.right
            anchors.leftMargin: 15
            width: 200
            height: 20
            font.pointSize: 19
            text: qsTr("Add Item")
        }

        /* Commenting out as per request of Wyse’s GUI designer:
         * https://bugs.launchpad.net/hedley/+bug/655974
        Rectangle {
            id: instructions_background
           
            anchors.top: icon.bottom
            anchors.topMargin: 43
            anchors.left: title_background.left
            color: "black"
            opacity: 0.3
            radius: 5
            height: instructions.height + 6
            width: instructions.paintedWidth + 4
        }

        TextCustom {
            id: instructions

            anchors.top: icon.bottom
            anchors.topMargin: 45
            anchors.left: title_background.left 
            anchors.leftMargin: 3

            width: title.width
            height: title.height
            text: qsTr("Select type of item to add:")
        }
        */

        /*
        GConfItem {
            id: gconf_connections_types
            key: "/apps/hedley_launcher/connection_types/list"
        }
        */

        QFileSystemModelQML {
            id: desktop_files

            rootPath: "/usr/share/applications/wyse_addons/"
            nameFilters: ["*.desktop"]
            nameFilterDisables: false
        }

        CenteredGridView {
            id: items

            min_horizontal_spacing: 5
            min_vertical_spacing: 5
            delegate_width: 130
            delegate_height: 120

            anchors.left: title_background.left
            anchors.top: title.bottom
            anchors.topMargin: 45
            anchors.bottom: cancel.top
            anchors.bottomMargin: 40
            anchors.right: parent.right
            anchors.rightMargin: title_background.x

            flow: GridView.LeftToRight
            focus: count > 0
            clip: true
            currentIndex: 0

            //model: gconf_connections_types.value
            model: desktop_files

            delegate: AddConnectionItem {
                id: application_delegate

                /*
                property string gconf_key
                property string gconf_desktop_file
                property GConfItem gconf_desktop_file_subscriber:
                    GConfItem {
                        key: "/apps/hedley_launcher/connection_types/"+model.modelData
                    }
                */
                property QLauncherApplication app

                //app: QLauncherApplication {desktop_file: gconf_desktop_file_subscriber.value}
                app: QLauncherApplication {desktop_file: filePath}

                width: items.delegate_width
                height: items.delegate_height
                icon: "image://icons/"+app.icon_name
                label: app.name
                onClicked: {
                    connection_editor_page.create_connection(filePath)
                }
            }

            KeyNavigation.down: cancel
        }

        ButtonText {
            id: cancel

            focus: items.count == 0

            anchors.horizontalCenter: add_connection.horizontalCenter
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 80
            icon: "artwork/cancel.png"
            text: qsTr("Cancel")
            onClicked:{
                /* Switch to connections_page */
                gconf_current_page.value = 0
            }

            KeyNavigation.up: (items.count > 0)?items:null
        }
    }
}
