<?xml version="1.0" encoding="UTF-8"?>
<!-- STYLESHEET PARAMETERS

	* withlabel (1|0) [numeric]
	  -> 1 if links labels must be displayed
	
	* withnum (1|0) [numeric]
	  -> 1 if lists must be numbered

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" version="1.0" encoding="iso-8859-1" indent="yes"/>
	
<xsl:template match="project">
	<html>
	<head>
	<style>
	  ol {
        	font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 10px;
		font-weight: bold;
	  }
	
	  h2 {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		text-align: center;
	  }
	
	  table {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 10px;
		width: 90%;
		border: solid 1px black;
	  }
	
	  table.report {
		background: silver;
	  }
	
	  table.host_details {
		width: 50%;
		background: silver;
	  }

	  table.links {
		border: 0;
		width: 100%;
	  }

	  td.label {
		font-weight: bold;
		text-align: right;
	  }

	  td.status_code {
		color: white;
		border: black solid;
		border-width: 0px 0px 0px 2px;
	  }
	</style>
	</head>
	<body>
	  <h2>gURLChecker Project Report</h2>
	  
	  <p>
	  <table class="host_details" align="center">
	    <tr><td valign="top" class="label" width="50%">Host :</td><td width="50%"><xsl:value-of select="website/@current_host"/></td></tr>
	    <tr><td valign="top" class="label">Port :</td><td><xsl:value-of select="website/@current_port"/></td></tr>
	    <tr><td valign="top" class="label">Protocol :</td><td><xsl:value-of select="website/page/properties/url/@proto"/></td></tr>
	    <tr><td valign="top" class="label">URL :</td><td><xsl:value-of select="website/@url"/></td></tr>
	  </table>
	  </p>
		
	  <xsl:apply-templates select="report/links"/>
	  <xsl:apply-templates select="website"/>
	</body>
	</html>
</xsl:template>

<xsl:template match="report/links">
	<p>
	<table class="report" align="center">
	  <tr><td valign="top" class="label" width="50%">Total :</td><td width="50%"><xsl:value-of select="@all"/> links discovered</td></tr>
	  <tr><td valign="top" class="label" width="50%">Checked :</td><td width="50%"><xsl:value-of select="@checked"/> links really checked</td></tr>
	  <tr><td valign="top" class="label" width="50%">Goods :</td><td width="50%"><xsl:value-of select="@good"/></td></tr>
	  <tr><td valign="top" class="label">Bads :</td><td><xsl:value-of select="@bad"/> (Both not found and restricted)</td></tr>
	  <tr><td valign="top" class="label">Timeouts :</td><td><xsl:value-of select="@timeout"/></td></tr>
	  <tr><td valign="top" class="label">Malformed :</td><td><xsl:value-of select="@malformed"/></td></tr>
	  <tr><td valign="top" class="label">Ignored :</td><td><xsl:value-of select="@ignored"/></td></tr>
	</table>
	</p>
</xsl:template>

<xsl:template match="website">
	<!-- if we must numbered lists -->
	<xsl:choose>
	  <xsl:when test="$withnum = 1">
	    <ol>
	      <xsl:apply-templates />
	    </ol>
	  </xsl:when>
	  <xsl:otherwise>
	    <ul>
	      <xsl:apply-templates />
	    </ul>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="page|childs/page">
	<xsl:variable name="href" select="@href"/>
	<xsl:variable name="status" select="properties/header/item[position()=1]/@value"/>

	<li>
	<table class="links"><tr>
	<xsl:choose>
	<!-- good -->
	<xsl:when test="
		substring($status,1,1) = 2 or
		(
			$status = 301 or
			$status = 302 or
			$status = 303 or
			$status = 798 or
		        $status = 702
		)">
		<td valign="top" width="10" bgcolor="green" class="status_code">Good</td>
	</xsl:when>
	<!-- bad -->
	<xsl:when test="
		substring($status, 1, 1) != 2 and
		substring($status, 1, 1) != 9 and
		substring($status, 1, 1) != 8 and
		$status != 301 and
		$status != 302 and
		$status != 303 and
		$status != 401 and
		$status != 408 and
		$status != 503 and
		$status != 797 and
		$status != 702
		">
		<td valign="top" width="10" bgcolor="red" class="status_code">Bad</td>
	</xsl:when>
	<!-- timeout -->
	<xsl:when test="
		(
			substring($status, 1, 1) = 9 or
			$status = 503 or
			$status = 408
		) 
		and
		(
			$status != 997 and
			$status != 899 and
			$status != 898
		)
		">
 		<td valign="top" width="10" bgcolor="purple" class="status_code">Timeout</td>
	</xsl:when>
	<!-- ignored -->
	<xsl:when test="$status = 997">
 		<td valign="top" width="10" bgcolor="pink" class="status_code">Ignored</td>
	</xsl:when>
	<!-- malformed -->
	<xsl:when test="$status = 899 or $status = 898">
 		<td valign="top" width="10" bgcolor="brown" class="status_code">Malformed</td>
	</xsl:when>
	<!-- restricted -->
	<xsl:when test="$status = 401">
 		<td valign="top" width="10" bgcolor="blue" class="status_code">Restricted</td>
	</xsl:when>
	</xsl:choose>
	<td valign="top"><a href="{$href}"><xsl:value-of select="@href" /></a>
	<!-- if we must display links labels -->
	<xsl:if test="$withlabel = 1">
	  - 
	  <i>
	  <xsl:choose>
	    <xsl:when test="string-length(@title)>50">
              <xsl:value-of select="substring(@title,1,50)"/>[...]
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:value-of select="@title"/>
	    </xsl:otherwise>
	  </xsl:choose>
	  </i>
	</xsl:if>
	</td>
	</tr></table>
	</li>
	<!-- if we must numbered lists -->
	<xsl:choose>
	  <xsl:when test="$withnum = 1">
	    <ol>
	      <xsl:apply-templates select="childs/page"/>
	    </ol>
	  </xsl:when>
	  <xsl:otherwise>
	    <ul>
	      <xsl:apply-templates select="childs/page"/>
	    </ul>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>


