#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.gpm"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[2303]; const double alignment; void * const ptr;}  gpm_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x05, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
  0x05, 0x00, 0x00, 0x00, 0xd4, 0xb5, 0x02, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xac, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x4c, 0x00, 0xb0, 0x00, 0x00, 0x00, 
  0xb4, 0x00, 0x00, 0x00, 0x4b, 0x50, 0x90, 0x0b, 
  0x00, 0x00, 0x00, 0x00, 0xb4, 0x00, 0x00, 0x00, 
  0x04, 0x00, 0x4c, 0x00, 0xb8, 0x00, 0x00, 0x00, 
  0xbc, 0x00, 0x00, 0x00, 0x34, 0xc8, 0xd0, 0xb5, 
  0x03, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 
  0x0e, 0x00, 0x4c, 0x00, 0xcc, 0x00, 0x00, 0x00, 
  0xd0, 0x00, 0x00, 0x00, 0xb0, 0xb7, 0x24, 0x30, 
  0x01, 0x00, 0x00, 0x00, 0xd0, 0x00, 0x00, 0x00, 
  0x06, 0x00, 0x4c, 0x00, 0xd8, 0x00, 0x00, 0x00, 
  0xdc, 0x00, 0x00, 0x00, 0x1c, 0xa2, 0xa6, 0x0c, 
  0x02, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00, 
  0x11, 0x00, 0x76, 0x00, 0xf0, 0x00, 0x00, 0x00, 
  0xff, 0x08, 0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x6f, 0x72, 0x67, 0x2f, 
  0x03, 0x00, 0x00, 0x00, 0x70, 0x6f, 0x77, 0x65, 
  0x72, 0x2d, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 
  0x72, 0x2f, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0x67, 0x6e, 0x6f, 0x6d, 0x65, 0x2f, 0x00, 0x00, 
  0x02, 0x00, 0x00, 0x00, 0x67, 0x70, 0x6d, 0x2d, 
  0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 
  0x63, 0x73, 0x2e, 0x75, 0x69, 0x00, 0x00, 0x00, 
  0xdd, 0x75, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0xed, 0x5d, 0x4d, 0x6f, 0xdb, 0x38, 
  0x10, 0xbd, 0xf7, 0x57, 0x08, 0xbc, 0x2e, 0x1c, 
  0x47, 0x76, 0x92, 0x6d, 0x0a, 0xdb, 0x05, 0xb6, 
  0x41, 0xdb, 0xc3, 0x62, 0x51, 0x20, 0x69, 0x7b, 
  0x14, 0x68, 0x6a, 0x62, 0x71, 0x43, 0x93, 0x5a, 
  0x91, 0x8e, 0xed, 0x7f, 0xbf, 0x94, 0xe4, 0x38, 
  0x51, 0xac, 0x6f, 0x29, 0x89, 0xe4, 0xf0, 0x94, 
  0x58, 0x16, 0x29, 0xce, 0x23, 0xe7, 0xcd, 0x0c, 
  0xf5, 0x2c, 0x4d, 0x3e, 0x6f, 0x96, 0xcc, 0xba, 
  0x87, 0x40, 0x52, 0xc1, 0xa7, 0xc8, 0x3e, 0x39, 
  0x45, 0x16, 0x70, 0x22, 0x5c, 0xca, 0x17, 0x53, 
  0xf4, 0xf3, 0xe6, 0xeb, 0xe0, 0x23, 0xfa, 0x3c, 
  0xfb, 0x30, 0xa1, 0x5c, 0x41, 0x70, 0x8b, 0x09, 
  0xcc, 0x3e, 0x58, 0xd6, 0x24, 0x80, 0xff, 0x56, 
  0x34, 0x00, 0x69, 0x31, 0x3a, 0x9f, 0xa2, 0x85, 
  0xba, 0xfb, 0x03, 0x3d, 0xf6, 0x31, 0x3a, 0xb1, 
  0x2f, 0xd0, 0x30, 0x3a, 0x4f, 0xcc, 0xff, 0x05, 
  0xa2, 0x2c, 0xc2, 0xb0, 0x94, 0x53, 0xf4, 0x4d, 
  0xdd, 0x5d, 0x51, 0xcc, 0xc4, 0x02, 0x59, 0xd4, 
  0x9d, 0x22, 0x37, 0xfa, 0xdf, 0x91, 0x0a, 0x2b, 
  0x89, 0xc2, 0xd3, 0x75, 0x03, 0x3f, 0x10, 0x3e, 
  0x04, 0x6a, 0x6b, 0x71, 0xbc, 0x84, 0x29, 0x22, 
  0x98, 0x3b, 0xb7, 0x82, 0xac, 0xf4, 0xf7, 0x5f, 
  0x31, 0x93, 0x30, 0x19, 0x3e, 0x9c, 0x90, 0x7e, 
  0xfe, 0x5c, 0x04, 0x2e, 0x04, 0xce, 0x9a, 0xba, 
  0xca, 0x43, 0xb3, 0x8b, 0xa2, 0xd3, 0x15, 0x55, 
  0x0c, 0x90, 0xa5, 0x02, 0xcc, 0x25, 0xc3, 0x0a, 
  0xcf, 0x99, 0x3e, 0xb8, 0x05, 0x7d, 0xb5, 0x1f, 
  0x62, 0x0d, 0x81, 0x75, 0xad, 0x87, 0x46, 0xa5, 
  0xa2, 0x44, 0x16, 0xf5, 0xb4, 0xa6, 0xdc, 0x15, 
  0x6b, 0xc7, 0x17, 0x92, 0x2a, 0x0d, 0x02, 0x9a, 
  0x11, 0x08, 0x01, 0x1b, 0x08, 0x3e, 0xf0, 0x71, 
  0xa0, 0xff, 0x2f, 0x1c, 0xca, 0xd6, 0x07, 0xc7, 
  0xd3, 0x28, 0xa3, 0x59, 0x8c, 0xcb, 0x41, 0x03, 
  0xe2, 0x51, 0xe6, 0x5a, 0xd1, 0x3c, 0x70, 0xcc, 
  0x06, 0xd1, 0xc7, 0x29, 0xba, 0x9f, 0x8b, 0xcd, 
  0x0e, 0xbc, 0x34, 0xbc, 0xff, 0xd2, 0xdf, 0x3e, 
  0x01, 0x7b, 0x10, 0x9e, 0x6e, 0xef, 0xcf, 0x3f, 
  0x1c, 0xc6, 0x3d, 0x95, 0x54, 0xa3, 0x80, 0x66, 
  0x37, 0xc1, 0xea, 0x00, 0xed, 0x3a, 0x33, 0x94, 
  0xd6, 0x46, 0x04, 0x54, 0x23, 0x82, 0x63, 0xa0, 
  0xf4, 0xb2, 0xd1, 0x00, 0x63, 0x56, 0xa6, 0xa1, 
  0xf4, 0x31, 0xd1, 0xeb, 0x12, 0xcd, 0x46, 0xa9, 
  0x67, 0xa7, 0x23, 0x84, 0x49, 0x78, 0x21, 0x47, 
  0xcf, 0x02, 0x7e, 0x62, 0x78, 0x2a, 0x58, 0x2b, 
  0xa5, 0x04, 0x7f, 0x0e, 0xd9, 0x93, 0xf6, 0x76, 
  0xa2, 0x83, 0x1a, 0xe8, 0xd5, 0x45, 0x30, 0xad, 
  0x1d, 0xc3, 0x5b, 0xb1, 0x52, 0xda, 0x7d, 0xb6, 
  0xe1, 0x15, 0x81, 0xbb, 0x99, 0x0d, 0x23, 0x20, 
  0x92, 0xc7, 0xb2, 0xcd, 0x8f, 0x6d, 0x9f, 0x47, 
  0xff, 0x3b, 0x84, 0x09, 0x09, 0xe8, 0x79, 0xd3, 
  0xb4, 0xb1, 0xcc, 0x81, 0xa1, 0x99, 0x26, 0x82, 
  0x41, 0xd4, 0x24, 0x6b, 0x28, 0xb5, 0x41, 0x2b, 
  0x00, 0xae, 0x4e, 0x53, 0x17, 0x6e, 0xf1, 0x8a, 
  0xa9, 0xea, 0x8d, 0x03, 0x20, 0x40, 0xef, 0x41, 
  0x3e, 0xf6, 0x90, 0x3b, 0x6f, 0x69, 0x5d, 0xac, 
  0x24, 0x38, 0x0f, 0xeb, 0xca, 0xf7, 0x01, 0x6b, 
  0x02, 0x22, 0x50, 0xb3, 0x1f, 0xa9, 0x04, 0xb9, 
  0x2b, 0xb2, 0x62, 0x32, 0x8c, 0xa7, 0xfb, 0xe0, 
  0xb8, 0xf6, 0xa8, 0x3b, 0xed, 0x52, 0xc5, 0x97, 
  0x82, 0x8d, 0x8f, 0xb9, 0x5b, 0x63, 0x8c, 0xb7, 
  0x94, 0xb1, 0x1a, 0xcd, 0x1e, 0xa9, 0xd4, 0xce, 
  0x33, 0x2b, 0x75, 0xfc, 0x93, 0xe1, 0xc1, 0x92, 
  0x3f, 0x04, 0xe0, 0xe0, 0xa4, 0x43, 0x3f, 0x39, 
  0xf4, 0x91, 0xef, 0x7b, 0x76, 0xf0, 0x9e, 0x31, 
  0xe9, 0x9b, 0xf3, 0x41, 0x41, 0xec, 0x2b, 0xe4, 
  0xd4, 0x8b, 0xa6, 0xfc, 0x71, 0x4d, 0x02, 0xc1, 
  0x18, 0xb8, 0xbf, 0xa3, 0x58, 0x18, 0xa3, 0x24, 
  0x77, 0xc7, 0xe2, 0xf8, 0x38, 0x42, 0xdd, 0xa4, 
  0x03, 0x2f, 0x1e, 0xe6, 0x1c, 0x07, 0x3a, 0x82, 
  0x33, 0x4a, 0xb6, 0x68, 0xc6, 0x41, 0x07, 0xa6, 
  0x2a, 0x7d, 0x48, 0x0f, 0x87, 0x19, 0x40, 0x18, 
  0xc7, 0xd1, 0x8c, 0xf2, 0xdc, 0xa6, 0xa9, 0x80, 
  0xa6, 0x83, 0x7a, 0x13, 0x00, 0xfc, 0xa2, 0xb0, 
  0x83, 0x53, 0xe9, 0x4f, 0xf7, 0xfa, 0x93, 0xa6, 
  0x9e, 0x7b, 0x4a, 0x40, 0xa2, 0xb4, 0x4e, 0x1a, 
  0x60, 0xda, 0x10, 0xd7, 0x54, 0x6c, 0x01, 0xeb, 
  0x65, 0x29, 0x9d, 0xfd, 0x18, 0x0a, 0x99, 0x20, 
  0x27, 0x96, 0x4b, 0x60, 0x40, 0x62, 0x56, 0x48, 
  0x6d, 0x96, 0x85, 0xe0, 0xf5, 0xbe, 0x5d, 0x02, 
  0xc6, 0xc1, 0xbe, 0x3f, 0x3b, 0x4e, 0x58, 0x53, 
  0xfa, 0x1b, 0x66, 0x4f, 0x56, 0x06, 0xa7, 0x66, 
  0x36, 0x7a, 0x73, 0x12, 0xae, 0xea, 0x17, 0x8f, 
  0x1c, 0x7c, 0xda, 0x06, 0x07, 0x97, 0xa7, 0x92, 
  0x7f, 0x84, 0x82, 0xb9, 0x10, 0x77, 0xf1, 0x74, 
  0xf1, 0xdd, 0x27, 0xbb, 0x2b, 0xf4, 0x51, 0xc1, 
  0x7f, 0x8b, 0x49, 0xd1, 0xee, 0x81, 0x13, 0x27, 
  0x63, 0xcb, 0x65, 0xd5, 0xe6, 0x15, 0xb8, 0x31, 
  0x1f, 0xdf, 0x4a, 0x1c, 0x49, 0xf9, 0xad, 0xc8, 
  0xe4, 0x89, 0x86, 0xf8, 0xb6, 0x80, 0x71, 0x23, 
  0x9a, 0x6b, 0x40, 0x75, 0xa3, 0x2c, 0xaa, 0x2b, 
  0xa0, 0xbb, 0x7c, 0xca, 0x6b, 0x9b, 0x2b, 0xf7, 
  0xd8, 0x84, 0x8b, 0x46, 0x9b, 0x81, 0xe7, 0xa8, 
  0x9c, 0xc3, 0xfd, 0x1d, 0x95, 0x22, 0x91, 0xed, 
  0x51, 0x55, 0xf2, 0xda, 0xee, 0x55, 0x2e, 0xbc, 
  0xa5, 0xd6, 0x4f, 0x69, 0x1b, 0x11, 0x57, 0xa0, 
  0x30, 0x65, 0x32, 0xbf, 0xc3, 0xbc, 0x69, 0xc9, 
  0x0e, 0x2e, 0xa9, 0xdb, 0x10, 0x78, 0xee, 0x94, 
  0x4c, 0xd8, 0x33, 0x99, 0xbf, 0xc4, 0xac, 0x96, 
  0x9b, 0xca, 0x5f, 0xfb, 0x64, 0x3b, 0xdc, 0xb6, 
  0x38, 0xeb, 0xc3, 0x44, 0x36, 0x25, 0xca, 0x87, 
  0x64, 0xfc, 0xb2, 0x6d, 0x8e, 0x4c, 0x16, 0x2e, 
  0x67, 0x6f, 0xc4, 0x8b, 0xa5, 0x30, 0xcd, 0x05, 
  0xc6, 0x1e, 0x95, 0xe7, 0xd5, 0x6a, 0xe4, 0x99, 
  0x44, 0x68, 0x94, 0x4b, 0xbd, 0x2d, 0xa0, 0xd4, 
  0x16, 0x52, 0xf5, 0x6a, 0xba, 0xea, 0x80, 0x95, 
  0x63, 0xdb, 0x73, 0x54, 0xd4, 0x47, 0x4b, 0xd0, 
  0xb5, 0x09, 0x5f, 0x35, 0x46, 0xfe, 0x16, 0x60, 
  0xdf, 0x8b, 0xc2, 0xd2, 0xa7, 0xf2, 0x17, 0xc8, 
  0x0f, 0x9c, 0x65, 0xd9, 0xba, 0x95, 0xd2, 0xa0, 
  0x9d, 0x52, 0xa1, 0x95, 0xd2, 0xa1, 0x42, 0x40, 
  0xa9, 0x90, 0xa4, 0x34, 0x5b, 0xd1, 0x5f, 0xc4, 
  0x72, 0x2e, 0x34, 0x15, 0xdc, 0xc0, 0x46, 0xc5, 
  0x0b, 0x9b, 0x84, 0x47, 0x34, 0x25, 0x38, 0x1e, 
  0x95, 0x4a, 0x04, 0xdb, 0x5d, 0x1e, 0x7b, 0x1c, 
  0xeb, 0x1c, 0xb8, 0x0a, 0x2d, 0xd2, 0xc6, 0x3a, 
  0x44, 0xb0, 0xd5, 0xb2, 0xea, 0x84, 0xbd, 0xd6, 
  0xb2, 0x6e, 0x8a, 0x59, 0xdb, 0xab, 0xda, 0x7e, 
  0x8b, 0x55, 0x5d, 0x06, 0xee, 0x72, 0x50, 0xb7, 
  0x01, 0x73, 0x73, 0x88, 0x1b, 0x93, 0x46, 0x09, 
  0x68, 0x0b, 0x61, 0x6d, 0x9e, 0x2b, 0x9c, 0x9b, 
  0x5c, 0xa1, 0x4e, 0xae, 0x70, 0x76, 0xfc, 0xb9, 
  0xc2, 0x95, 0xfe, 0x64, 0x31, 0xe0, 0x0b, 0xe5, 
  0x99, 0x64, 0xe1, 0x9d, 0x26, 0x0b, 0x74, 0x69, 
  0x92, 0x05, 0x93, 0x2c, 0x98, 0x64, 0xe1, 0xe5, 
  0x92, 0x05, 0xfb, 0xb5, 0x92, 0x85, 0x22, 0x48, 
  0x8b, 0xe1, 0x6c, 0x4c, 0xc4, 0xcd, 0x70, 0x6c, 
  0x44, 0xbc, 0x05, 0xf8, 0xe5, 0x62, 0x57, 0x75, 
  0xbb, 0x2a, 0xb9, 0xf5, 0x37, 0xee, 0xfc, 0x76, 
  0x55, 0xe3, 0x1c, 0xf2, 0x21, 0x5e, 0x98, 0x54, 
  0xb2, 0x4e, 0x2a, 0xe9, 0xe0, 0x0d, 0x95, 0xfb, 
  0x90, 0xbb, 0x3d, 0xae, 0xc4, 0x72, 0xb6, 0x1d, 
  0x84, 0xe6, 0x35, 0xe9, 0x08, 0xf3, 0x45, 0x68, 
  0xdb, 0xe5, 0xa9, 0x49, 0x42, 0x8f, 0x2f, 0x09, 
  0x3d, 0x70, 0x86, 0x07, 0x3f, 0xe0, 0xc2, 0xd5, 
  0xf5, 0xc7, 0xf1, 0x57, 0x59, 0x37, 0x1e, 0x04, 
  0x60, 0x51, 0x69, 0x71, 0x61, 0x85, 0x16, 0x5b, 
  0x4a, 0xff, 0xa5, 0xd2, 0x67, 0x78, 0x7b, 0x62, 
  0xd2, 0x53, 0x93, 0x9e, 0x9a, 0xbd, 0xac, 0xfa, 
  0xb1, 0x74, 0xd3, 0xe7, 0x84, 0x64, 0x17, 0x3f, 
  0x37, 0x15, 0xe2, 0xe7, 0xcb, 0x2f, 0xcb, 0x46, 
  0x16, 0x99, 0xb2, 0xa9, 0x96, 0x8b, 0xbf, 0x54, 
  0xd5, 0x64, 0x77, 0xab, 0x6a, 0x4a, 0x96, 0x14, 
  0x97, 0xbd, 0xbd, 0xc9, 0x7f, 0x51, 0xa7, 0xb5, 
  0x27, 0x96, 0x62, 0x01, 0x1c, 0x44, 0x75, 0x01, 
  0x56, 0x35, 0xc2, 0xfc, 0xe2, 0x01, 0x49, 0xfc, 
  0x58, 0x82, 0x84, 0x07, 0x76, 0xbf, 0x98, 0x90, 
  0x4b, 0x21, 0x94, 0x57, 0xb3, 0x9a, 0xcb, 0x4e, 
  0x71, 0x7e, 0x4a, 0xb0, 0xe2, 0xae, 0xc1, 0xb5, 
  0x18, 0xe5, 0xb5, 0xdd, 0xbf, 0x6d, 0x7e, 0x6e, 
  0xd2, 0x4d, 0x8d, 0x1f, 0x52, 0xe4, 0x75, 0x57, 
  0xf7, 0x47, 0x15, 0x79, 0x7d, 0xba, 0x01, 0x0e, 
  0x85, 0x84, 0x2e, 0x25, 0x58, 0xcf, 0x67, 0x15, 
  0x73, 0xdf, 0x51, 0x20, 0xe9, 0x78, 0x82, 0x93, 
  0xeb, 0xaf, 0xbe, 0xa0, 0x5c, 0xc9, 0xd6, 0xfd, 
  0xf5, 0xda, 0x13, 0xeb, 0xb8, 0x16, 0x89, 0x2f, 
  0x60, 0xdc, 0xd5, 0xb8, 0xab, 0xc9, 0xfb, 0x8e, 
  0x67, 0xbb, 0x7c, 0xf4, 0x92, 0x89, 0x5f, 0x7b, 
  0x72, 0xde, 0xd2, 0x93, 0x5e, 0x5f, 0xca, 0xdb, 
  0x58, 0xa0, 0x3d, 0xea, 0xb7, 0x40, 0xfb, 0x7b, 
  0x1c, 0x39, 0x5e, 0x4b, 0xa0, 0x5d, 0xc1, 0x8d, 
  0x7b, 0xa4, 0xed, 0x1e, 0x19, 0x6d, 0x77, 0x6b, 
  0x65, 0xdf, 0xc5, 0x91, 0x97, 0x7d, 0x2d, 0x6c, 
  0x71, 0x5d, 0xf4, 0x7f, 0x53, 0xab, 0x15, 0x65, 
  0xb2, 0xa9, 0x51, 0x3a, 0x53, 0xa3, 0x64, 0x0b, 
  0x89, 0xa2, 0xe7, 0xa3, 0x94, 0xd1, 0x1c, 0x77, 
  0x7a, 0xd5, 0xd6, 0x97, 0x0e, 0x19, 0x1d, 0x8b, 
  0x49, 0xcc, 0x8f, 0x44, 0xc7, 0x72, 0xfe, 0x0e, 
  0x74, 0x2c, 0x72, 0xff, 0xcc, 0x24, 0x23, 0x65, 
  0xa9, 0x7f, 0xfb, 0x2d, 0x26, 0x7d, 0x23, 0x64, 
  0x31, 0x42, 0x96, 0xf7, 0x2c, 0x64, 0x89, 0xbd, 
  0xc0, 0xc8, 0x58, 0x8c, 0x8c, 0xc5, 0xc8, 0x58, 
  0x4c, 0x05, 0x55, 0x3f, 0x8e, 0x1a, 0x11, 0x8b, 
  0xb9, 0x99, 0x61, 0x44, 0x2c, 0xcf, 0x20, 0xc4, 
  0xae, 0x1b, 0x65, 0xb8, 0xe3, 0x23, 0x96, 0xc0, 
  0xd8, 0xa7, 0x46, 0x03, 0xf3, 0x66, 0x1a, 0x98, 
  0xa7, 0x0f, 0xf6, 0x35, 0x0a, 0x18, 0x73, 0x4b, 
  0xdd, 0xec, 0x2e, 0x77, 0x59, 0x01, 0xd3, 0xae, 
  0xb7, 0x1a, 0xfd, 0x8b, 0x71, 0x56, 0x93, 0x32, 
  0x1a, 0xfd, 0x4b, 0x67, 0xf4, 0x2f, 0xa3, 0xce, 
  0xea, 0x5f, 0xc6, 0xfd, 0xd6, 0xbf, 0x64, 0xbf, 
  0x23, 0xe1, 0xcd, 0x27, 0xb5, 0x57, 0x12, 0x18, 
  0xdb, 0x48, 0x60, 0x5a, 0x2b, 0xfb, 0xc6, 0xbd, 
  0xad, 0xfa, 0xc6, 0xaf, 0x25, 0x81, 0xf9, 0x78, 
  0x9c, 0x12, 0x98, 0x1f, 0x81, 0x20, 0x20, 0xa5, 
  0x08, 0xac, 0x35, 0xbe, 0x83, 0x95, 0x2f, 0x2d, 
  0xdd, 0xce, 0x92, 0x40, 0x04, 0x77, 0x8d, 0x28, 
  0xa6, 0xef, 0x5b, 0xba, 0x4a, 0x28, 0xcc, 0x9c, 
  0xdd, 0xcc, 0x1e, 0xe7, 0x02, 0x3e, 0x35, 0x8b, 
  0xd4, 0xa4, 0xeb, 0xc7, 0xae, 0x8a, 0x29, 0x7e, 
  0x28, 0xfe, 0xb8, 0xeb, 0x0f, 0x6e, 0x6f, 0xf6, 
  0x84, 0xfb, 0xba, 0x8c, 0x98, 0xf1, 0xa4, 0xfb, 
  0x6e, 0x30, 0x62, 0xa5, 0x6e, 0x9a, 0x3c, 0xf8, 
  0x3e, 0x1b, 0x9b, 0xc2, 0x87, 0xdf, 0x8f, 0xf3, 
  0x1e, 0x7e, 0xdf, 0xda, 0x2d, 0x5f, 0xf3, 0x7b, 
  0xe8, 0xbe, 0x6c, 0x0b, 0x8c, 0x3b, 0xbb, 0x2d, 
  0xf0, 0x67, 0xbf, 0xb7, 0x05, 0x7e, 0xc7, 0x94, 
  0xf4, 0xfa, 0x7b, 0x02, 0xe3, 0x8e, 0xed, 0x09, 
  0xb4, 0xf7, 0xd2, 0x9f, 0xaa, 0x6f, 0xb4, 0x69, 
  0xfa, 0xce, 0x9f, 0x17, 0x7a, 0xef, 0x5a, 0x96, 
  0xe9, 0x75, 0xcc, 0xae, 0x6e, 0x72, 0x65, 0x73, 
  0x53, 0x4c, 0x7d, 0x66, 0x66, 0xd2, 0xc4, 0xc4, 
  0x97, 0x93, 0x78, 0x83, 0x7f, 0xb0, 0xa6, 0xee, 
  0x02, 0x94, 0xdc, 0xb7, 0x48, 0x1c, 0xb6, 0x02, 
  0x90, 0xbe, 0xe0, 0x52, 0x8f, 0xe6, 0x14, 0xcd, 
  0x9e, 0xbe, 0x79, 0x71, 0x32, 0x4c, 0x9c, 0xf8, 
  0x70, 0x81, 0xc3, 0x4e, 0x1f, 0x87, 0x30, 0x19, 
  0x3e, 0x79, 0x53, 0xeb, 0xff, 0x51, 0x82, 0x20, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29
} };

static GStaticResource static_resource = { gpm_resource_data.data, sizeof (gpm_resource_data.data) };
extern GResource *gpm_get_resource (void);
GResource *gpm_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif


#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
