/* DWARF2 EH unwinding support for PowerPC and PowerPC64 Linux.
   Copyright (C) 2004, 2005 Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 2, or (at your
   option) any later version.

   In addition to the permissions in the GNU General Public License,
   the Free Software Foundation gives you unlimited permission to link
   the compiled version of this file with other programs, and to
   distribute those programs without any restriction coming from the
   use of this file.  (The General Public License restrictions do
   apply in other respects; for example, they cover modification of
   the file, and distribution when not linked into another program.)

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING.  If not, write to the
   Free Software Foundation, 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.  */

/* This file defines our own versions of various kernel and user
   structs, so that system headers are not needed, which otherwise
   can make bootstrapping a new toolchain difficult.  Do not use
   these structs elsewhere;  Many fields are missing, particularly
   from the end of the structures.  */

struct gcc_vregs
{
  __attribute__ ((vector_size (16))) int vr[32];
#ifdef __powerpc64__
  unsigned int pad1[3];
  unsigned int vscr;
  unsigned int vsave;
  unsigned int pad2[3];
#else
  unsigned int vsave;
  unsigned int pad[2];
  unsigned int vscr;
#endif
};

struct gcc_regs
{
  unsigned long gpr[32];
  unsigned long nip;
  unsigned long msr;
  unsigned long orig_gpr3;
  unsigned long ctr;
  unsigned long link;
  unsigned long xer;
  unsigned long ccr;
  unsigned long softe;
  unsigned long trap;
  unsigned long dar;
  unsigned long dsisr;
  unsigned long result;
  unsigned long pad1[4];
  double fpr[32];
  unsigned int pad2;
  unsigned int fpscr;
#ifdef __powerpc64__
  struct gcc_vregs *vp;
#else
  unsigned int pad3[2];
#endif
  struct gcc_vregs vregs;
};

struct gcc_ucontext
{
#ifdef __powerpc64__
  unsigned long pad[28];
#else
  unsigned long pad[12];
#endif
  struct gcc_regs *regs;
  struct gcc_regs rsave;
};

#ifdef __powerpc64__

enum { SIGNAL_FRAMESIZE = 128 };

/* If the current unwind info (FS) does not contain explicit info
   saving R2, then we have to do a minor amount of code reading to
   figure out if it was saved.  The big problem here is that the
   code that does the save/restore is generated by the linker, so
   we have no good way to determine at compile time what to do.  */

#define MD_FROB_UPDATE_CONTEXT(CTX, FS)					\
  do {									\
    if ((FS)->regs.reg[2].how == REG_UNSAVED)				\
      {									\
	unsigned int *insn						\
	  = (unsigned int *)						\
	    _Unwind_GetGR ((CTX), LINK_REGISTER_REGNUM);		\
	if (*insn == 0xE8410028)					\
	  _Unwind_SetGRPtr ((CTX), 2, (CTX)->cfa + 40);			\
      }									\
  } while (0)

/* If PC is at a sigreturn trampoline, return a pointer to the
   regs.  Otherwise return NULL.  */

#define PPC_LINUX_GET_REGS(CONTEXT) \
({									\
  const unsigned char *pc = (CONTEXT)->ra;				\
  struct gcc_regs *regs = NULL;						\
									\
  /* addi r1, r1, 128; li r0, 0x0077; sc  (sigreturn) */		\
  /* addi r1, r1, 128; li r0, 0x00AC; sc  (rt_sigreturn) */		\
  if (*(unsigned int *) (pc + 0) != 0x38210000 + SIGNAL_FRAMESIZE	\
      || *(unsigned int *) (pc + 8) != 0x44000002)			\
    ;									\
  else if (*(unsigned int *) (pc + 4) == 0x38000077)			\
    {									\
      struct sigframe {							\
	char gap[SIGNAL_FRAMESIZE];					\
	unsigned long pad[7];						\
	struct gcc_regs *regs;						\
      } *frame = (struct sigframe *) (CONTEXT)->cfa;			\
      regs = frame->regs;						\
    }									\
  else if (*(unsigned int *) (pc + 4) == 0x380000AC)			\
    {									\
      /* This works for 2.4 kernels, but not for 2.6 kernels with vdso	\
	 because pc isn't pointing into the stack.  Can be removed when	\
	 no one is running 2.4.19 or 2.4.20, the first two ppc64	\
	 kernels released.  */						\
      struct rt_sigframe_24 {						\
	int tramp[6];							\
	void *pinfo;							\
	struct gcc_ucontext *puc;					\
      } *frame24 = (struct rt_sigframe_24 *) pc;			\
									\
      /* Test for magic value in *puc of vdso.  */			\
      if ((long) frame24->puc != -21 * 8)				\
	regs = frame24->puc->regs;					\
      else								\
	{								\
	  /* This works for 2.4.21 and later kernels.  */		\
	  struct rt_sigframe {						\
	    char gap[SIGNAL_FRAMESIZE];					\
	    struct gcc_ucontext uc;					\
	    unsigned long pad[2];					\
	    int tramp[6];						\
	    void *pinfo;						\
	    struct gcc_ucontext *puc;					\
	  } *frame = (struct rt_sigframe *) (CONTEXT)->cfa;		\
	  regs = frame->uc.regs;					\
	}								\
    }									\
  regs;									\
})

#define LINUX_HWCAP_DEFAULT 0xc0000000

#define PPC_LINUX_VREGS(REGS) (REGS)->vp

#else  /* !__powerpc64__ */

enum { SIGNAL_FRAMESIZE = 64 };

#define PPC_LINUX_GET_REGS(CONTEXT) \
({									\
  const unsigned char *pc = (CONTEXT)->ra;				\
  struct gcc_regs *regs = NULL;						\
									\
  /* li r0, 0x7777; sc  (sigreturn old)  */				\
  /* li r0, 0x0077; sc  (sigreturn new)  */				\
  /* li r0, 0x6666; sc  (rt_sigreturn old)  */				\
  /* li r0, 0x00AC; sc  (rt_sigreturn new)  */				\
  if (*(unsigned int *) (pc + 4) != 0x44000002)				\
    ;									\
  else if (*(unsigned int *) (pc + 0) == 0x38007777			\
	   || *(unsigned int *) (pc + 0) == 0x38000077)			\
    {									\
      struct sigframe {							\
	char gap[SIGNAL_FRAMESIZE];					\
	unsigned long pad[7];						\
	struct gcc_regs *regs;						\
      } *frame = (struct sigframe *) (CONTEXT)->cfa;			\
      regs = frame->regs;						\
    }									\
  else if (*(unsigned int *) (pc + 0) == 0x38006666			\
	   || *(unsigned int *) (pc + 0) == 0x380000AC)			\
    {									\
      struct rt_sigframe {						\
	char gap[SIGNAL_FRAMESIZE + 16];				\
	char siginfo[128];						\
	struct gcc_ucontext uc;						\
      } *frame = (struct rt_sigframe *) (CONTEXT)->cfa;			\
      regs = frame->uc.regs;						\
    }									\
  regs;									\
})

#define LINUX_HWCAP_DEFAULT 0x80000000

#define PPC_LINUX_VREGS(REGS) &(REGS)->vregs

#endif

/* Do code reading to identify a signal frame, and set the frame
   state data appropriately.  See unwind-dw2.c for the structs.  */

#define MD_FALLBACK_FRAME_STATE_FOR(CONTEXT, FS, SUCCESS)		\
  do {									\
    static long hwcap = 0;						\
    struct gcc_regs *regs = PPC_LINUX_GET_REGS (CONTEXT);		\
    long new_cfa;							\
    int i;								\
									\
    if (regs == NULL)							\
      break;								\
    									\
    new_cfa = regs->gpr[STACK_POINTER_REGNUM];				\
    (FS)->cfa_how = CFA_REG_OFFSET;					\
    (FS)->cfa_reg = STACK_POINTER_REGNUM;				\
    (FS)->cfa_offset = new_cfa - (long) (CONTEXT)->cfa;			\
    									\
    for (i = 0; i < 32; i++)						\
      if (i != STACK_POINTER_REGNUM)					\
	{	    							\
	  (FS)->regs.reg[i].how = REG_SAVED_OFFSET;			\
	  (FS)->regs.reg[i].loc.offset 					\
	    = (long) &regs->gpr[i] - new_cfa;				\
	}								\
									\
    (FS)->regs.reg[CR2_REGNO].how = REG_SAVED_OFFSET;			\
    (FS)->regs.reg[CR2_REGNO].loc.offset				\
      = (long) &regs->ccr - new_cfa;					\
									\
    (FS)->regs.reg[LINK_REGISTER_REGNUM].how = REG_SAVED_OFFSET;	\
    (FS)->regs.reg[LINK_REGISTER_REGNUM].loc.offset 			\
      = (long) &regs->link - new_cfa;					\
									\
    (FS)->regs.reg[ARG_POINTER_REGNUM].how = REG_SAVED_OFFSET;		\
    (FS)->regs.reg[ARG_POINTER_REGNUM].loc.offset 			\
      = (long) &regs->nip - new_cfa;					\
    (FS)->retaddr_column = ARG_POINTER_REGNUM;				\
									\
    if (hwcap == 0)							\
      {									\
	/* __libc_stack_end holds the original stack passed to a	\
	   process.  */							\
	extern long *__libc_stack_end;					\
	long argc;							\
	char **argv;							\
	char **envp;							\
	struct auxv							\
	{								\
	  long a_type;							\
	  long a_val;							\
	} *auxp;							\
									\
	/* The Linux kernel puts argc first on the stack.  */		\
	argc = __libc_stack_end[0];					\
	/* Followed by argv, NULL terminated.  */			\
	argv = (char **) __libc_stack_end + 1;				\
	/* Followed by environment string pointers, NULL terminated. */	\
	envp = argv + argc + 1;						\
	while (*envp++)							\
	  continue;							\
	/* Followed by the aux vector, zero terminated.  */		\
	for (auxp = (struct auxv *) envp; auxp->a_type != 0; ++auxp)	\
	  if (auxp->a_type == 16)					\
	    {								\
	      hwcap = auxp->a_val;					\
	      break;							\
	    }								\
									\
	/* These will already be set if we found AT_HWCAP.  A non-zero	\
	   value stops us looking again if for some reason we couldn't	\
	   find AT_HWCAP.  */						\
	hwcap |= LINUX_HWCAP_DEFAULT;					\
      }									\
									\
    /* If we have a FPU...  */						\
    if (hwcap & 0x08000000)						\
      for (i = 0; i < 32; i++)						\
	{								\
	  (FS)->regs.reg[i + 32].how = REG_SAVED_OFFSET;		\
	  (FS)->regs.reg[i + 32].loc.offset				\
	    = (long) &regs->fpr[i] - new_cfa;				\
	}								\
									\
    /* If we have a VMX unit...  */					\
    if (hwcap & 0x10000000)						\
      {									\
	struct gcc_vregs *vregs;					\
	vregs = PPC_LINUX_VREGS (regs);					\
	if (regs->msr & (1 << 25))					\
	  {								\
	    for (i = 0; i < 32; i++)					\
	      {								\
		(FS)->regs.reg[i + FIRST_ALTIVEC_REGNO].how		\
		  = REG_SAVED_OFFSET;					\
		(FS)->regs.reg[i + FIRST_ALTIVEC_REGNO].loc.offset	\
		  = (long) &vregs[i] - new_cfa;				\
	      }								\
									\
	    (FS)->regs.reg[VSCR_REGNO].how = REG_SAVED_OFFSET;		\
	    (FS)->regs.reg[VSCR_REGNO].loc.offset			\
	      = (long) &vregs->vscr - new_cfa;				\
	  }								\
									\
	(FS)->regs.reg[VRSAVE_REGNO].how = REG_SAVED_OFFSET;		\
	(FS)->regs.reg[VRSAVE_REGNO].loc.offset				\
	  = (long) &vregs->vsave - new_cfa;				\
      }									\
									\
    goto SUCCESS;							\
  } while (0)
