/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import java.applet.Applet;
import java.awt.Frame;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public abstract class GalleryRemote {
    public static final String MODULE = "GalRem";
    private static GalleryRemote singleton = null;
    public PropertiesFile defaults = null;
    public PropertiesFile properties = null;
    protected Applet applet = null;
    public static ImageIcon iLogin;
    public static ImageIcon iNewGallery;
    public static ImageIcon iAbout;
    public static ImageIcon iSave;
    public static ImageIcon iOpen;
    public static ImageIcon iPreferences;
    public static ImageIcon iNewAlbum;
    public static ImageIcon iNew;
    public static ImageIcon iQuit;
    public static ImageIcon iCut;
    public static ImageIcon iCopy;
    public static ImageIcon iPaste;
    public static ImageIcon iUp;
    public static ImageIcon iDown;
    public static ImageIcon iDelete;
    public static ImageIcon iRight;
    public static ImageIcon iLeft;
    public static ImageIcon iFlip;
    public static ImageIcon iComputer;
    public static ImageIcon iUploading;
    public static boolean IS_MAC_OS_X;
    public static int ACCELERATOR_MASK;

    protected GalleryRemote() {
    }

    protected void initializeGR() {
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if ((double)Float.parseFloat(System.getProperty("java.specification.version")) < 1.39) {
                JOptionPane.showMessageDialog(null, "Gallery Remote is not supported on Java Virtual Machines older than 1.4. Please install a recent VM and try running Gallery Remote again.", "VM too old", 0);
                System.exit(1);
            }
            this.createProperties();
            new GalleryProperties(System.getProperties()).logProperties(2, "SysProps");
            this.properties.logProperties(3, "UsrProps");
            this.loadIcons();
            this.setFontOverrides();
        }
        catch (Exception e) {
            Log.logException(0, "Startup", e);
            Log.shutdown();
            System.err.println("Exception during startup: " + e);
            e.printStackTrace();
        }
    }

    private void setFontOverrides() {
        String name = this.properties.getProperty("fontOverrideName");
        if (name != null) {
            int style = this.properties.getIntProperty("fontOverrideStyle");
            int size = this.properties.getIntProperty("fontOverrideSize");
            FontUIResource fur = new FontUIResource(name, style, size);
            UIManager.put("Label.font", fur);
            UIManager.put("List.font", fur);
            UIManager.put("Tree.font", fur);
            UIManager.put("TextArea.font", fur);
            UIManager.put("TextField.font", fur);
            UIManager.put("TextPane.font", fur);
        }
    }

    protected void runGR() {
        this.getCore().startup();
    }

    public boolean isAppletMode() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public abstract Frame getMainFrame();

    public abstract GalleryRemoteCore getCore();

    public static GalleryRemote _() {
        return singleton;
    }

    public static boolean createInstance(String className, Applet applet) {
        if (singleton == null) {
            System.out.println("Instanciating Gallery Remote...");
            GalleryRemote.setStaticProperties();
            try {
                singleton = (GalleryRemote)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            GalleryRemote.singleton.applet = applet;
            return true;
        }
        System.err.println("Trying to instanciate Gallery Remote more than once...");
        Thread.dumpStack();
        return false;
    }

    public static void shutdownInstance() {
        System.out.println("Shutting down Gallery Remote");
        singleton = null;
    }

    public static void main(String[] args) {
        GalleryRemote.createInstance("com.gallery.GalleryRemote.GalleryRemoteMainFrame", null);
        GalleryRemote._().initializeGR();
        GalleryRemote._().runGR();
    }

    public static void setStaticProperties() {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Gallery Remote");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("apple.awt.showGrowBox", "false");
        System.setProperty("apple.awt.brushMetalLook", "true");
        System.setProperty("swing.noxp", "true");
        try {
            if ((double)Float.parseFloat(System.getProperty("java.specification.version")) >= 1.6) {
                System.setProperty("sun.java2d.opengl", "true");
            }
        }
        catch (RuntimeException e) {
            Log.log(1, "Couldn't get property java.specification.version: " + System.getProperty("java.specification.version"));
        }
    }

    public void createProperties() {
        this.properties = this.defaults = new PropertiesFile("defaults", "defaults");
        this.properties.setReadOnly();
    }

    public PropertiesFile getAppletOverrides(PropertiesFile defaults, String prefix) {
        Log.log(3, MODULE, "Getting applet parameters for prefix " + prefix);
        PropertiesFile p = new PropertiesFile(defaults, null, prefix);
        Enumeration e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.applet.getParameter(prefix + name);
            if (value == null || value.length() == 0) continue;
            Log.log(3, MODULE, "Got: " + name + "= |" + value + "|");
            p.setProperty(name, value);
        }
        p.setReadOnly();
        return p;
    }

    protected void loadIcons() {
        if (iAbout != null) {
            return;
        }
        try {
            ACCELERATOR_MASK = !IS_MAC_OS_X ? 2 : 4;
            iComputer = new ImageIcon(GalleryRemote.class.getResource("/computer.gif"));
            iUploading = new ImageIcon(GalleryRemote.class.getResource("/uploading.gif"));
        }
        catch (Exception e) {
            Log.logException(1, MODULE, e);
        }
    }

    static {
        IS_MAC_OS_X = System.getProperty("mrj.version") != null;
        ACCELERATOR_MASK = 0;
    }
}

