//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

/*************************************************************************

Copyright(c) 1996  Microsoft Corporation

Module Name:

    MsAudioEnc.h

Abstract:

    Header file for CAudioObjectEncoder.

Author:

    Wei-ge Chen(wchen) 11-March-1998

Revision History:


*************************************************************************/

#ifndef __MSAUDIOENC_H_
#define __MSAUDIOENC_H_

#include <stdio.h>
#include "macros.h"
#include "strmenc_wma.h"
#include "tables_rc.h"
#include "constants.h"
#include "msaudio.h"
#include "config.h"
#include "lpfilter.h"
#include "wmaosenc.h"

// Buffer definitions
#define FRAME_SIZE_BYTES		2048*4	// 2k * 2 channels * 2 
#define NUMBER_OF_FRM			37
#define IN_BUFFER_SIZE			FRAME_SIZE_BYTES*NUMBER_OF_FRM

// From macros.h
// not integer build if encoder
#ifdef BUILD_INTEGER
#error Not supported for encoder. Previously #undef ed on encoder's behalf, but can't do anymore with combined encoder/decoder builds.
#endif  // BUILD_INTEGER

#if !defined(BUILD_INTEGER) && !defined(BUILD_INT_FLOAT)
#error You must define BUILD_INTEGER or BUILD_INT_FLOAT for entire project in compiler line. Previously BUILD_INT_FLOAT #defined on your behalf, not anymore with combined encoder/decoder builds.
#endif  // BUILD_INTEGER

#if defined(REFERENCE_RAND_24) || defined(REFERENCE_RAND_16)
#error Not supported for encoder.
#endif  // defined(REFERENCE_RAND_24) || defined(REFERENCE_RAND_16)


typedef struct CVarBitrateBuf 
{

  I32 m_ibBufHead;
  I32 m_ibBufTail;
  I32 m_ibOutputHead;

  U32 m_ibDstCurr;                     //needs to flush bitstream before writing out
  U32 m_cbBufLen;                      //total buffer length including tail in bytes
  U32 m_cbBuf;                         //excluding tail
  U32 m_cPacketInBuf;

  U32 m_cbUsed;                        //total no. of bytes used so far
                                       //relative to OutputHead, count all full bytes in 
                                       //bitstream including ones in the DW buffer
  U32 m_cBitFractionByte;              //counts the no. of bits of fractional byte in DW buffer

  U32 m_ibPacketHeadCurr;
  // CurrFrame In the Packet
  U32 m_cCurrFrameInPacket;            // CurrFrame In the Packet


  U8  m_uMaxSavingRate; 
  U8  m_uMaxBorrowRate; 
} CVarBitrateBuf;


typedef struct CVarBitrateOutBuf 
{

  //pointer to the physical beginning, never change, shared with CBitStream
  U8* m_pbBufHead;
  U32* m_pulTimeHead;

  //pointer to the tail of the buffer; content beyond tail must be copied
  //to Head after each frame; and all pointer should reset
  U8* m_pbBufTail;
  U32* m_pulTimeTail;

  //points to the beginning of packet ready for output, 
  //updated circularly when outputing
  U8* m_pbOutputHead;
  U32* m_pulTimeOutput;

  //points to the beginning of virtual buf, 
  //updated every frame; reset for OutputHead at output

  //current output byte; initialized to BufHead
  U8* m_pbDstCurr;            //may point to bytes already written but still in DW buffer
                                //needs to flush bitstream before writing out
  I32 m_cbBufLen;             //total buffer length including tail in bytes
  I32 m_cbBuf;                //excluding tail
  //  I32 m_cPacketInBuf;

  U32 m_cbUsed;               //total no. of bytes used so far
                                //relative to OutputHead, count all full bytes in 
                                //bitstream including ones in the DW buffer
  I32 m_cBitFractionByte;     //counts the no. of bits of fractional byte in DW buffer

  //current packet head
  U8* m_pbPacketHeadCurr;

  // CurrFrame In the Packet
  I32 m_bCurrFrameInPacket;

  U32* m_pulTimeCurr;

} CVarBitrateOutBuf;



typedef struct CSubFrmBucket
{
  U8*     m_pbOutput;
  I32     m_cBitOutput;
  I32     m_iTargetNmr;    // 9.23
  I32     m_iUnweightedNmr;  // 5.27 
  I32     m_cBitAlloc;
}CSubFrmBucket;

#define NUM_BUCKET (pauenc->m_cDelayFrm + 1)
typedef struct CFrmBucket
{
  CSubFrmBucket* m_rgsubfrmbckt;
  CVarBitrateBuf m_vbbFill;
  CVarBitrateBuf m_vbbRef;        //where to begin fill; for recording's ref
  own U8*        m_rgbOutput;             
  U32            m_cBitUsed;
  U16            m_iStatus;   //0, nothing to output 1, ready to output
  Bool           m_fHeaderReset;
  U16            m_uSizeHeader;
  SubFrameConfigInfo m_subfrmconfig;
  U32            m_ulTimeCurr;
  //  const U8*      m_pbBufCurrHeadRef; //at the beginning
  I32            m_pbBufCurrHeadRef;
  tRandState     m_tRandStateRef;

  //input data
  own I16*       m_piInputCurr;		//buffer of curr data
  own I16*       m_piSumDiff;         //sum/diff data for stereo
  U32            m_rgiPower [4];      //sum, diff, left, right

  own  PerChannelInfo* m_rgpcinfo;
  own  struct PerChannelInfoENC* m_rgpcinfoENC;
    
  // noise-suppression info
  Bool           m_fNoisyFrame;           // Is current frame noisy
  Int            m_iFramesSinceLastNoise; // Number of non-noise frames between curr frame and a noisy frame
  Int            m_cNoiseSample;          // Number of noise frames in the recent past
}CFrmBucket;

#if defined (NMR_PROFILE)
#define NUM_EXC (NUM_BARK_BAND + 1)
#define NUM_NMR pau->m_iMaxSubFrameDiv * 3 / 2
#define OFFSET_TO_SIZE NUM_NMR + 1
#define OFFSET_TO_NEXT NUM_NMR + 1 + pau->m_iMaxSubFrameDiv + 1
#endif //(NEW_TRANSDET)

#define QUANTIZER_CLIP_LIMIT 1

#define c_fltPow10LUT_QStep     0.0025F
#define c_cSizeOfPow10LUT       3800 // 9.5Bels max in steps of 0.0025

#define c_Pow04FracSigBits      12
#define c_cSizeOfPow04FracLUT   ((1 << c_Pow04FracSigBits) + 1) // Due to rounding we may exceed by one
#define c_cSizeOfPow04ExpLUT    0x100
#define c_iMaskFltFraction      0x007FFFFF
#define c_iMaskFltExp           0x7F800000
#define c_iTotalFractBits       23

// Ugly... we're assuming upper limit on m_iMaxSubFrameDiv such that pau->m_cPossibleWinSize = 5
#define BLENDFACTOR_SPECIALMODES    1
#define BLENDFACTOR_MAX             (5 + BLENDFACTOR_SPECIALMODES)
#define BLENDFACTOR_SM1_IDX         (BLENDFACTOR_MAX - 1)

// some constants
//

#define THRESH_HI 1.7F
#define THRESH_HI_U32 WBPS_U32( THRESH_HI )

#define WBITSPERSAMLPE_160_44_U32  781147177    // round(2.91 * 2^28)
#define WBITSPERSAMPLE_140_44_U32  684510413	// round(2.55 * 2^28)
#define WBITSPERSAMPLE_128_44_U32  625454612	// round(2.33 * 2^28)
#define WBITSPERSAMPLE_96_44_U32   475130757	// round(1.77 * 2^28)
#define WBITSPERSAMPLE_80_44_U32   391915766	// round(1.46 * 2^28)
#define WBITSPERSAMPLE_64_44_U32   314069484	// round(1.17 * 2^28)
#define WBITSPERSAMPLE_48_44_U32   236223201	// round(0.88 * 2^28)
#define WBITSPERSAMPLE_32_44_2_U32 158376919	// round(0.59 * 2^28)
#define WBITSPERSAMPLE_48_32_U32   324806902    // round(1.21 * 2^28)
#define WBITSPERSAMPLE_32_32_U32   217432719    // round(0.81 * 2^28)
#define WBITSPERSAMPLE_20_22_U32   195957883    // round(0.73 * 2^28)

#define WBITSPERSAMPLE_160_44       2.91
#define WBITSPERSAMPLE_140_44       2.55	// bps = fs * WeightedBitsPerSample / Weight * Channel
#define WBITSPERSAMPLE_128_44       2.33
#define WBITSPERSAMPLE_96_44        1.77
#define WBITSPERSAMPLE_80_44        1.46
#define WBITSPERSAMPLE_64_44        1.17
#define WBITSPERSAMPLE_48_44        0.88        // Dont use these. So left unconverted
#define WBITSPERSAMPLE_32_44_2      0.59
#define WBITSPERSAMPLE_48_32        1.21
#define WBITSPERSAMPLE_32_32        0.81
#define WBITSPERSAMPLE_32_22        1.17
#define WBITSPERSAMPLE_20_22        0.73

#define NUM_SUBBARK_BAND            (4 * NUM_BARK_BAND)		//Can be reduced to (1 * NUM_BARK_BAND)

// Forward Declaration
#ifndef __GNUC__
typedef struct CAudioObjectEncoder CAudioObjectEncoder;
#endif

typedef struct CAudioObjectEncoder
{
  // The mother class
  CAudioObject* pau;
  own      struct PerChannelInfoENC*  m_rgpcinfoENC;
  Bool     m_fVbr;           // output non-constant amount of bits per unit time; defalut false
  I32      m_iGlobalNmrF;  // global nmr for vbr mode
  Bool     m_fEntropy;       // When quantizing, we may not have any need for entropy
  Bool     m_fQuantizerInvQ; // When quantizing, we can combine invQ directly

  I16      *m_pbAudioBufHead;
  I16      *m_pbAudioBufTail;
  I16      *m_pbAudioBufEncode;
  I16      *m_pbAudioBufPrevEncode;
  I16      *m_pbAudioBufTransient;
  I16      *m_pbAudioBufInput;

 
  I32      m_nFrames;
  I32      m_cBitTargetCurr;           //Format : Integer 32 bit 
  U32      m_cCurrFrameInPacket;       //circular 
  U8       m_cOutFrameInPacket;

  U8       m_cFrameInPacketMax;        //should be 0x0F but encoder has liberty to limit
                                       // quality stuff
  Bool     m_fAutoBandTruncation;

  U32      m_uBandWidthRatio;          // instantaneous bw ratio   
                                       //Format : 1.31 Unsigned 

  U32      m_iNmrLowpass;	           // Format : 9.23 Unsigned
  U32      m_iNmrInNmrLoop;            // Right after Nmr loop, unless min bits get used
                                       // Format : 9.23 Unsigned

  Int      m_cBitsInNmrLoop;           // Right after Nmr loop, unless min bits get used
                                       // Format : 32-bit signed integer

  U32      m_uiExpectedNmrDeviation;   // Format : 8.24 unsigned integer

  I32      m_iNmrFloor;                // Format : 9.23
  I32      m_iNmrCeil;                 // Format : 9.23

  U32      m_uiMinCodedBw;             // Format : 1.31
                                       // max 1.0 and min is 0.0 : Ramesh. changes for diff Bitrates

  U32      m_uiMaxCodedBw;             // Format : 1.31
  U32      m_uiBwNmrCurveSlope;			
  /* Ramesh: 
   * 1.31, the Bw Vs Nmr curve has -ve slope. but i am taking abs value|m|.
   * I change the straight line eqn to y = c - |m|*x. This slope is always <=1 
   * for all bit rates < 128. for bit rates > 128 kbps,fAutoBandTruncation 
   * is 0, hence this is not needed at all. */
  
                                       // look ahead
  Int      m_cFrmInPacket;
  Bool     m_fLastFrameInPacket;  
  I32      m_cFrmLookAhead;            // no. of frames we want (maximum) to look ahead
  I32      m_cFrmAhead;                // no. of frames available for looking ahead
                                       // transient: detection and etc.
  const I32* m_rgiCoefNumLow;          // For the foramts of the filter coeffs, refer lpfilter 
  const I32* m_rgiCoefDenLow;
  const I32* m_rgiCoefNumMed;
  const I32* m_rgiCoefDenMed;
  const I32* m_rgiCoefNumHi;
  const I32* m_rgiCoefDenHi;

  U8*      m_rgpbTransMem [2];
  Int      m_iTransientWeight;         // Format : 32-bit signed integer
  Int      m_iWeakTransientWeight;     // Format : 32-bit signed integer
  Int      m_iNonTransientWeight;      // Format : 32-bit signed integer

  //Removed the floating point Threshold variables and put our fixed point variables instead
  U8 *     m_rgpbTransMem1[2];	//TBD : Ramesh : Use this buffer and get rid of m_rgpbTransMem [2] soon.
  U32      m_uiTransThresholdL;        // Format : 14.18
  U32      m_uiTransThresholdM;        // --do--
  U32      m_uiTransThresholdH;        // --do--

    
  I16      m_iWeakSubFrameDiv;         // signed integer
  U32      m_iCurrTransientStrength;   // Format : 17.15

    
  U32  m_iBufEmptyness;                // to determine max # of subframes
  I32  m_iTargetNmr;                   // to help decide stereo processing
#if !defined(BUILD_INTEGER)
  Float  *m_rgfltDitherNoise[2];
#endif  // !defined(BUILD_INTEGER)



  // data I/O
  own I16*        m_rgiTransientBuf;
  own I16*        m_piInputNext;
  const I16*      m_piSource;         //source data 
  const I16*      m_piSourcePrev;     //may point to either input or s/d data
  const I16*      m_piSourceNext;

  I32*            m_piInputW;          //I32 windowed current input
  // encoding utility buffers
  own I32*        m_rgiCoefOrig;

  own I32*        m_rgiCoef;           //this is needed for integer encoder

  Int             m_iSampleDelay;      // Delay input samples for transcoding purposes
  Int             m_cbSampleDelaySpace;// Number of bytes required by sample delay
  I16            *m_piDelayedSamples;  // Trans detect needs ptr to nextInput delayed samples

  own I32*        m_rgiCoefLR;         // for stereo, orig coeffs without stereo transform
  own I32*        m_rgiCoefReconLR;    // for stereo, recon coeffs without stereo transform
  own I16*        m_rgiCoefQRLC;       //Run length coded quantized coef
  own I16*        m_rgiCoefQRLC_DIFF;  // When doing differential quantization, we copy QRLC's here
  own I16*        m_rgiCoefQRLCOrig;  
  own I16*        m_rgiCoefQRLCOrig_DIFF; // When doing differential quantization, we copy QRLC's here
  Int             m_iLastQRLC_DIFFQuantStep;  // The quant step size of the last QRLC we saved

  //!!go
  own U8*         m_rgbLsfQ;
    
  // window switching
  Int             m_iSliceWidth;       // signed integer
  Int             m_iSliceIncr;
  Int             m_iSliceMemoryNear; 
  Int             m_iSliceMemoryFar;

  own U8*   m_rgbPeakRange;
  own U8*   m_rgbIsTone;

  Int m_cCoefTransFilterLow;           //Just 32-bit integers
  Int m_cCoefTransFilterMed;
  Int m_cCoefTransFilterHi;


  //quantization
  Int             m_iStepSizeDelta;
  Int             m_iQuantStepSizePrevFrame;
  Bool            m_fQuantOverflow;
  U32             m_iQuantStep;
  U32             m_rgiPwrToDB[PWRTODB_SIZE];
  U16             m_rgiDBToWeight[PWRTODB_SIZE];

  // masking
  // The excitation values for mask computation etc.
  Int             m_cSubBarksPerBark;
  own Int*        m_rgiSubBarkIndexOrig;
  Int*            m_rgiSubBarkIndex;
  own Int*        m_rgcValidSubBarkBand;
  Int             m_cValidSubBarkBand;
  own U64*        m_rgintMask;
  own Int*        m_rgiMinSubBarkIndexOrig;    // Min "Excitation Bark" indices of bark bands in each possible subframe coding size
  own Int*        m_rgiMaxSubBarkIndexOrig;    // Max "Excitation Bark" indices of bark bands in each possible subframe coding size
  EXC_U64ORU32 *  m_puiSubBarkExc;
  EXC_U64ORU32 *  m_puiSubBarkExcRecon;

  own I32*        m_rgiWeightFactorPerBark;

  // At some point these fixed arrays should be dynamically allocated to 1) save memory
  // (only need cValidBarkBand entries sometimes), and 2) start the arrays on aligned
  // memory blocks
  I32  m_rgintSubBarkNmrWt [NUM_SUBBARK_BAND];         // weights to be used in NMR comput.
    
  U32  m_rguiElineNumLS_Pow04SubBark[NUM_SUBBARK_BAND]; // Left slope factor in numerator
    
    // Waste of space, but we're only talking ~2.5 kB... we can potentially shave to ~1.5kB.
    
    
    // Lpc mask related
  Void (*m_pfnInvFftComplexConjugate) (Float rgfltData[], Int nLog2np);
    

          
  // misc.
#define NONE       0
#define VALID_COEF 1
#define VALID_PCM  2
  U16             m_iReconLevel;         // need to process reconstructed data?
  Bool            m_iRunNumber;           // current runnumber when recon
  Int             m_cBitPerFrame;
    
  Bool            m_fBitTargetIsFloor;       // If quantization-loop target is min-bits as opposed to max bits
  Bool            m_fCappingMode;

//RAMESH : UPDT_PLANT_FIX : TO REMOVE THE FOLL 4 declarations as
//soon as prvSetTargetQualityAndBits is Fixed Pointized.    
    // alpha = nmr * bits, for coding complexity based on the past

    // alpha = beta * exp(transientwts), for coding complexity based on the future
    
    // GammaAlpha: reliability of Alpha in predicting current coding complexity
    
    // GammaBeta: reliability of Beta in predicting current coding complexity
  // alpha = nmr * bits, for coding complexity based on the past
  U32           m_uiPlantAlphaUnfiltPrev; // Unfiltered plant alpha of previous subframe
  U32           m_uiPlantAlphaUnfiltCurr; // Unfiltered plant alpha of current subframe
  U32           m_uiPlantAlphaFiltPrev;   // Filtered plant alpha of previous subframe
  U32           m_uiPlantAlphaFiltCurr;   // Filtered plant alpha of current subframe

    // alpha = beta * exp(transientwts), for coding complexity based on the future
  U32           m_uiPlantBetaUnfiltPrev; // Unfiltered plant Beta of previous subframe
  U32           m_uiPlantBetaUnfiltCurr; // Unfiltered plant Beta of current subframe
  U32           m_uiPlantBetaFiltPrev;   // Filtered plant Beta of previous subframe
  U32           m_uiPlantBetaFiltCurr;   // Filtered plant Beta of current subframe

    // GammaAlpha: reliability of Alpha in predicting current coding complexity
  U32           m_uiPlantGammaAlphaUnfiltPrev; // Unfiltered plant reliability of alpha
  U32           m_uiPlantGammaAlphaUnfiltCurr; //
  U32           m_uiPlantGammaAlphaFiltPrev;   //
  U32           m_uiPlantGammaAlphaFiltCurr;   //

    // GammaBeta: reliability of Beta in predicting current coding complexity
  U32           m_uiPlantGammaBetaUnfiltPrev; // Unfiltered plant reliability of beta
  U32           m_uiPlantGammaBetaUnfiltCurr; //
  U32           m_uiPlantGammaBetaFiltPrev;   //
  U32           m_uiPlantGammaBetaFiltCurr;   //
    
  // Rate & quality control targets for the current frame, useful in case of packet boundary
  // related requantization to spread nmr across subframes.
  Int   m_cCappedBits;
    
  Bool  m_stereoModePrev;      // if the preceding frame had used sum-diff coding for stereo
  Bool  m_fOperateOnLeftRight; // if sumdiff coded, whether to measure excitation, nmr on left-right

  Bool  m_fEnableReencPrevFrame; // Enable re-encoding of previous frame or not
  Bool  m_fNmrOnReconExc;        // If nmr should be computed on the reconstructino's excitation pattern
    
    // Used by noise detection/suppression
  Bool   m_fSuppressNoise;
  Bool   m_fFatalMaxBits;
  Bool   m_fNoisyFrame;         // Copy from current bucket, to reach quant-loop

  I32*   m_rgiNoiseSpectrum;     // by Pushp 
    
  // Header squeezing
  Bool*      m_rgfMaskNeededForBark;  // only to allocate memory
    
  U32* m_rguiSubBarkEnergyOrig;   // only to allocate memory
    
  // multi-threaded data members
  Bool m_bWriteToBuffer;

    // buffer/bitstream related
  CVarBitrateBuf  m_vbb;                  //vbr buffer

  CVarBitrateOutBuf  m_vbbOut;     

  //  const U8       *m_pbBufCurrHead;
  I32             m_pbBufCurrHead;
  U16             m_cDelayFrm;
  CFrmBucket     *m_rgfrmbckt; //one for current and one for prev
  PerChannelInfo *m_rgpcinfoCom;                 //common one
  struct PerChannelInfoENC *m_rgpcinfoENCCom;           //common one
  U16             m_iCurrBucket;                 //which bucket to use currently
  I32             m_cBitBudget;
  COutBitStream   *m_pobstrm0;				       //output bitstream

#ifdef NMR_PROFILE
  //this will be made a data member and init all to zeros
  //put the excitations in a big array: 16 curr + 16 next
  Float* m_rgfltExcTD; // [832 * 2];
  CoefType* m_rgfltExcCoefOrig;// [2240 * 2]; //pau->m_cFrameSampleHalf + 3 * cSampleMinSubFrame / 2]; //extra at tail for for (re,im)
  //!!!get rid of all the hard coded constants
#endif // NMR_PROFILE

#ifndef WMA_SERIALIZE
  //new  THREADINFO  m_rThreadInfo;      // OS-specific info for threads
#endif


  // Function Pointers

    // Bitrate dependent function pointers
  Int (*m_pfnEncodeRunLevel)(struct CAudioObjectEncoder *pauenc,
			     struct PerChannelInfoENC *pcinfoENC, Int iCoefFirst, Int iCoefLim);

  // Encodering stage dependent function points
  Bool (*prvpfnDoneAdjustStepSizeNmr) (struct CAudioObjectEncoder* pauenc,
				       Int cBitsUsed,
				       Float fltActualNmr,
				       Int cMaxBits,  
				       Int cMinBits,
				       Float fltTargetNmr,
				       Int* piStepSize,
				       Int* piOkayStepSize,
				       Float* pfltNmrPrev,
				       Int* piBitsPrev,
				       Int* piStepSizePrev);

  // For new quant loop, Use a boolean to distinguish first subframe from the remainder
  Bool m_fFirstSubFrame;
  
  // Platform optimized function pointers
  WMARESULT (*m_pQuantizeSpectrumMonoNoInvQ)(struct CAudioObjectEncoder *pauenc,
					     struct PerChannelInfoENC *pcinfoENC);
  WMARESULT (*m_pQuantizeSpectrumMonoInvQ)(struct CAudioObjectEncoder *pauenc,
					   struct PerChannelInfoENC *pcinfoENC);
  WMARESULT (*m_pQuantizeSpectrumMonoDIFFNoInvQ)(struct CAudioObjectEncoder *pauenc,
						 struct PerChannelInfoENC *pcinfoENC);
  WMARESULT (*m_pQuantizeSpectrumMonoDIFFInvQ)(struct CAudioObjectEncoder *pauenc,
					       struct PerChannelInfoENC *pcinfoENC);
  WMARESULT (*m_pfnGetLpcSpectrum)(struct CAudioObjectEncoder *paudec,
				   struct PerChannelInfoENC *pcinfoENC);

#if !defined(BUILD_INTEGER)
  WMARESULT (*m_pfnInverseQuantizeSkipNoise) (struct CAudioObject* pau,
					      PerChannelInfo* ppcinfo, Int* rgiWeightFactor, Bool fSkipNoise);
#endif  // !defined(BUILD_INTEGER)

  void (*m_pfnComputeNoisePatternSubBark)(const struct CAudioObjectEncoder* pauenc,
					  I32* rgiCoefOrig, I32* rgiCoefRecon,
					  Int iLenCoef,
					  unsigned int* rgiNoisePattern, Bool* rgfNoisySubBark);


  void (*m_pfnGetLowMedHiPowerMono_48)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerMono_44)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerMono_32)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerMono_22)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerMono_16)(GET_LOW_MED_HI_ARGS);

  void (*m_pfnGetLowMedHiPowerStereo_48)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerStereo_44)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerStereo_32)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerStereo_22)(GET_LOW_MED_HI_ARGS);
  void (*m_pfnGetLowMedHiPowerStereo_16)(GET_LOW_MED_HI_ARGS);

  void (*m_pfnGetLowMedHiPower)(GET_LOW_MED_HI_ARGS);
} CAudioObjectEncoder;
#ifdef __GDEFASM__
@end :AUENC_:
#endif


#ifdef __cplusplus
extern "C" {
#endif

  //---------------------------------------------------------------------------
  // CAudioObjectEncoder Public Function Declarations
  //---------------------------------------------------------------------------
  CAudioObjectEncoder* auencNew(Void);
  Void auencDelete(CAudioObjectEncoder* pauenc);

  WMARESULT auencInit(CAudioObjectEncoder *pauenc,
		      WMAFormatInfo* wmafmt,
		      Int* piTimeOffset);


  WMARESULT auencEncode(CAudioObjectEncoder *pauenc,
			const U8*   pbSrc,
			Int         cbSrcLength,
			Int*        pcbSrcUsed);





  //---------------------------------------------------------------------------
  // CAudioObjectEncoder Private Function Declarations
  //---------------------------------------------------------------------------

  Bool prvInsertPacketHeader (CAudioObjectEncoder *pauenc,
			      CVarBitrateBuf* pvbb,
			      Bool fEmptyPacket);

  WMARESULT prvEncodeFrame(CAudioObjectEncoder *pauenc,  Bool m_bNoMoreData );

  WMARESULT prvEncodeSubFrame(CAudioObjectEncoder *pauenc, CVarBitrateBuf* pvbbCurr, Int *pcBitsUsed, Bool fWriteToBuffer);

  Void prvDecideFramePower (CAudioObjectEncoder *pauenc, CFrmBucket* pfrmbckt, CFrmBucket* pfrmbcktPrev);
  Void prvDecideStereoMode (CAudioObjectEncoder *pauenc, CFrmBucket* pfrmbckt, CFrmBucket* pfrmbcktPrev);

  WMARESULT prvEncAllocate(CAudioObjectEncoder *pauenc);
  WMARESULT prvPreFilteringSetup (CAudioObjectEncoder *pauenc, U32 nFilterOption);
  WMARESULT prvInitTransientDetection(CAudioObjectEncoder *pauenc);
  WMARESULT prvTransformMono(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC,
			     U32 *piMagnitude);
  Void      prvSetSubBarkIndex       (CAudioObjectEncoder* pauenc);
  Void      prvSetAvgSubBarkIndex    (CAudioObjectEncoder* pauenc);
  Void      prvInitSubBarkExcitation (CAudioObjectEncoder* pauenc);

  WMARESULT prvJustGetMaskingStereoA0(CAudioObjectEncoder *pauenc);
  WMARESULT prvJustGetMaskingStereoA1(CAudioObjectEncoder *pauenc);
  WMARESULT prvJustGetMaskingStereoB(CAudioObjectEncoder *pauenc, Bool fUseAchievedNmr);
  WMARESULT prvGetMaskingThresholdMono(CAudioObjectEncoder *pauenc,
				       struct PerChannelInfoENC *pcinfoENC);
  U32  prvMeasureCodingError (CAudioObjectEncoder *pauenc);
  WMARESULT prvZeroCoefficients(CAudioObjectEncoder *pauenc,
				struct PerChannelInfoENC *ppcinfoENC,
				Int cStartIndex);
  WMARESULT prvGetNoiseLikeBandsMono(CAudioObjectEncoder *pauenc,
				     struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvGetNoisePowerAndWeightSpectrum(CAudioObjectEncoder *pauenc,
					      struct PerChannelInfoENC *pcinfoENC,
					      Bool fEstNoisePower);
  WMARESULT prvWeightSpectrum(CAudioObjectEncoder *pauenc,
			      struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvWeightSpectrumNORM(CAudioObjectEncoder *pauenc,
				  struct PerChannelInfoENC *pcinfoENC);
  Void    auResampleWeightFactorBark (CAudioObject* pau, struct PerChannelInfoENC* ppcinfoENC);

  WMARESULT prvDetectTransientMono(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC, Int iFrame , Bool bNoMoreData);

  Void    prvConfigNextSubFrame(CAudioObjectEncoder *pauenc);

  Int     prvBitAllocFrame(CAudioObjectEncoder *pauenc, Int iCurrFrame,
			   Int cBitsLeft, Int cFrmInSuperFrm);
  Bool    prvAdjustBitAllocFrame (CAudioObjectEncoder *pauenc, Int* pcBitFrame, CVarBitrateBuf* pvbb, Bool* pfUnderFlow);
  Bool    prvAdjustBitAllocReEncode (CAudioObjectEncoder *pauenc, Int cBitCapCurr, Int cBitUsedPrev, 
				     Int cBitUsedPrevUncapped, Int cBitUsedCurr,
				     CVarBitrateBuf* pvbbPrev, Int *pcBitAllocPrev);
  Int     prvBitAllocSubFrame(CAudioObjectEncoder *pauenc, Int cBitsAvailable);
  Void    prvDecideTransientWeightForBitAlloc(CAudioObjectEncoder *pauenc);

#if 0 //RAMCHANG
#ifdef WMA_TARGET_X86
  WMARESULT prvTransformMono_KNI(CAudioObjectEncoder *pauenc,
				 const Float* pfltInput, Float* rgfltCoef,
				 Float* rgfltFFT_Buffer); //compute m_rgfltCoef
  WMARESULT prvWeightSpectrumMono_KNI(CAudioObjectEncoder *pauenc,
				      Float* rgfltWeightFactor,
				      Float* rgfltCoef);
  WMARESULT prvQuantizeRLCSpectrum_X86(CAudioObjectEncoder *pauenc, PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeRLCSpectrumInvQ_X86(CAudioObjectEncoder *pauenc,
					   PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeRLCSpectrumDIFFInvQ_X86(CAudioObjectEncoder *pauenc,
					       PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeSpectrumMono_X86(CAudioObjectEncoder *pauenc,
					PerChannelInfoENC *pcinfoENC);

  Void prvComputeNoisePattern_SIMD (const CAudioObjectEncoder*  pauenc, 
				    const Float*   rgfltCoefOrig, 
				    const Float*   rgfltCoefRecon, 
				    const Int      iLenCoef,
				    Float*         rgfltNoisePattern,
				    const Bool*    rgfNoisyBark);
#endif  // WMA_TARGET_x86
#endif //0
  WMARESULT prvQuantizationLoop(CAudioObjectEncoder *pauenc, Int cBitsAvailable);

  WMARESULT prvQuantizationLoopNmr(CAudioObjectEncoder *pauenc, 
				   Int cMaxBits, Int cMinBits,
				   Int *pcBitsUsed,
				   int intTargetNmr);
  WMARESULT prvDecodeAndComputeNmr(CAudioObjectEncoder *pauenc, Bool fTinkerMaskUpdate, Bool fMeasureNmr);
  				//The last param was added to avoid additional Decode if QntznLoop Stabilizes thru NmrLoop alone
  Bool prvDoneAdjustStepSizeNmr (CAudioObjectEncoder* pauenc,
				 Int cBitsUsed, 
				 Float fltActualNmr,
				 Int cBitsAvailable,
				 Int cMinBitsToSpend,
				 Float fltTargetNmr,
				 Int* piStepSize,
				 Int* piOkayStepSize,
				 Float* pfltNmrPrev,
				 Int*   piBitsPrev,
				 Int*   piStepSizePrev);
  Void prvUpdatePlantModel (CAudioObjectEncoder *pauenc, CVarBitrateBuf* pvbbCurr,U32 iNmr,Int cBits);
  WMARESULT prvSetTargetQualityAndBits(CAudioObjectEncoder *pauenc, CVarBitrateBuf* pvbbCurr, Int* pcMaxBits, Int *pcMinBits, Float *pfltTargetNmr, Int *piTargetNmr);

  I32 prvFutureTransWeight (CAudioObjectEncoder *pauenc, Int cFrmInSuperFrm);

  U32 prvCurrTransWeight   (CAudioObjectEncoder *pauenc, U32 *piCurrWeight);


#if defined (NMR_FLATTENING)
  Bool      prvAdjustMaskToFlattenNmr (CAudioObjectEncoder* pauenc);
  WMARESULT prvQuantizationLoopFlatNmr(CAudioObjectEncoder *pauenc, 
				       Int cMaxBits, Int cMinBits,
				       Int *pcBitsUsed,
				       Float fltTargetNmr);
#endif // NMR_FLATTENING

  WMARESULT prvQuantizeRLCSpectrum(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeRLCSpectrumInvQ(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeRLCSpectrumDIFFInvQ(CAudioObjectEncoder *pauenc,
					   struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeRLCSpectrumDIFFNoInvQ(CAudioObjectEncoder *pauenc,
					     struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvQuantizeSpectrumMono(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC);
  WMARESULT prvReconQuantizedSpectrum(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC);
  Int     prvEncodeSubFrameHeader(CAudioObjectEncoder *pauenc,
				  COutBitStream* pobstrm);//code the quant and mask
  Void    prvEncodeCoefficientsMono(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoEnc);
  Int     prvEncodeRunLevel(CAudioObjectEncoder *pauenc, struct PerChannelInfoENC *pcinfoENC,
			    Int iCoefFirst, Int iCoefLim);
  WMARESULT prvGetNextRunENC (Void* pvoid, PerChannelInfo* ppcinfo, Int *piBitCnt);


  Void prvComputeNoisePatternSubBark (const CAudioObjectEncoder*  pauenc,
				      const I32*     rgiCoefOrig,
				      const I32*     rgiCoefRecon,
				      const Int      iLenCoef,
				      U32*           rgiNoisePattern,
				      const Bool*    rgfNoisySubBark);


  WMARESULT prvProcess0 (CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess1 (CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess0A(CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess1A(CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess0B(CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess1B(CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess0C(CAudioObjectEncoder *pauenc);
  WMARESULT prvProcess1C(CAudioObjectEncoder *pauenc);
  WMARESULT prvQuantizeAndEntropy0(CAudioObjectEncoder *pauenc);
  WMARESULT prvQuantizeAndEntropy1(CAudioObjectEncoder *pauenc);
  WMARESULT prvSendStream0(CAudioObjectEncoder *pauenc);
  WMARESULT prvSendStream1(CAudioObjectEncoder *pauenc);
  WMARESULT prvDetectTransientChannel(CAudioObjectEncoder *pauenc, Int iChannel);

  WMARESULT prvProcessAMultiThreads(CAudioObjectEncoder *pauenc);
  WMARESULT prvProcessBMultiThreads (CAudioObjectEncoder *pauenc, Bool fUseAchievedNmr);
  WMARESULT prvProcessCMultiThreads(CAudioObjectEncoder *pauenc);

  WMARESULT prvQuantizeAndEntropyMultiThreads(CAudioObjectEncoder *pauenc);
  WMARESULT prvSendStreamMultiThreads(CAudioObjectEncoder *pauenc);
  WMARESULT prvDetectTransientMultiThreads(CAudioObjectEncoder *pauenc);


  WMARESULT prvDetectNoise(CAudioObjectEncoder *pauenc, CFrmBucket* pfrmbcktPrev, CFrmBucket* pfrmbckt);
  WMARESULT prvDetectNoiseMono(CAudioObjectEncoder *pauenc, CFrmBucket* pfrmbckt,
			       struct PerChannelInfoENC* ppcinfoENCPrev,
			       struct PerChannelInfoENC* ppcinfoENC, Int iCh);
  WMARESULT prvSuppressNoiseMono(CAudioObjectEncoder *pauenc, CFrmBucket* pfrmbckt,
				 struct PerChannelInfoENC* ppcinfoENC, Int iChannel);

  // From masking.c
  void InitPwrToDB(U32 *rgiPwrToDB, U16 *rgiDBToWeight);

  Void prvWeightInput (CAudioObjectEncoder *pauenc,
		       const I16* piSource,
		       const I16* piSourcePrev,
		       struct PerChannelInfoENC* pcinfoENC);

  Void prvInitBarkExcitation         (CAudioObjectEncoder *pauenc);
  typedef enum {EXC_ORIGINAL, EXC_RECON} ExcSourceType;
  Void prvComputeExcitationPatternSubBark (CAudioObjectEncoder *pauenc, 
					   Float           *rgfltBarkExcIn, 
					   Float           *rgfltBarkExcOut, 
					   Float**         ppfltBarkExcRef,
					   Float           *rgfltCoef,
					   Int             iLenCoef,
					   Int             iLenCoefPrev,
					   //const Float    *rgfltBlendFactor,
					   const U32      *rgiBlendFactor,
					   ExcSourceType   excSource,
					   Float           *rgfltBarkPowerOrig);
  Void prvComputeExcitationPatternSubBark_fix (CAudioObjectEncoder *pauenc,
					       const U32             *rguiBarkExcIn,
					       U32             *rguiBarkExcOut,
					       const I32             *rgiCoef,
					       const Int             iLenCoef,
					       const Int             iLenCoefPrev,
					       const U32      *rgiBlendFactor,
					       ExcSourceType   excSource,
					       U32            *rguiBarkPowerOrig);
  FLOATORI32 prvMeasureNmrMono (CAudioObjectEncoder*   pauenc, 
				Float*          rgfltCoefOrig, 
				Float*          rgfltCoefRecon,
				Int             iLenCoef,
				Float*          rgfltExc,
				Bool*           rgfNoisyBarks,
				Int             iLenExc,
				Float*          rgfltBarkNmrWt,
				Float*          rgfltBarkNmr);


  Void prvComputeMaskFromSubBarkExcitation (CAudioObjectEncoder *pauenc, 
					    const U32              *rguiBarkExcState,
					    U64              *rgintMask );

  //vbr functions
  Void    prvUpdateRateDist (CAudioObjectEncoder* pauenc, I32 cBitsUsed);
  Void    prvInitVbbControl (CAudioObjectEncoder* pauenc);
  WMARESULT prvBufRotate (CAudioObjectEncoder* pauenc);

  WMARESULT prvBufOutput (CAudioObjectEncoder* pauenc);

  U32 prvBufBitsInPacket (const CVarBitrateBuf* pvbb);
  WMARESULT dumpBucket (CAudioObjectEncoder* pauenc, Bool *pfBucketDumped);
  Void updateFillBuffer (CAudioObjectEncoder* pauenc);
  Void updatePcInfo (CAudioObjectEncoder* pauenc, struct PerChannelInfoENC* ppcinfoENCDst,
		     const struct PerChannelInfoENC* ppcinfoENCSrc);
  Bool checkPacketHeader (CAudioObjectEncoder* pauenc, CVarBitrateBuf* pvbb);
  Void checkPacketUnderflow (CAudioObjectEncoder* pauenc, CVarBitrateBuf* pvbb);
#ifdef __cplusplus
}; // extern "C"
#endif


//***************************************************************************
// Encoder/Decoder Separation
//***************************************************************************
typedef struct PerChannelInfoENC
{
  PerChannelInfo  *ppcinfoCommon;                // Ptr back to common PPC

  StereoMode       m_stereoMode;                 // would be per bucket per channel
    
//  Float*           m_rgfltMask;
  U64*             m_rgintMask;                  // NMR measured, per excitation bark basis
                                                 //
  // The excitation values for mask computation etc.
  Float*           m_rgfltSubBarkExc;            // enough for all subframes
  Bool*            m_rgfNoisySubBark;            // excitation barks with any kind of noise substition
  Float*           m_rgfltSubBarkNmr;            // NMR measured, per excitation bark basis
  U32*             m_rgiSubBarkNmr;              // NMR measured, per excitation bark basis
  Float*           m_rgfltSubBarkExcPrev;        // just pointer for v8
  Float*           m_rgfltSubBarkExcCurr;        // just pointer for v8
  Float*           m_rgfltSubBarkExcRef;         // just pointer for v8
    
  Float*           m_rgfltSubBarkExcRecon;       // enough for all subframes
  Float*           m_rgfltSubBarkExcReconPrev;   // just pointer for v8
  Float*           m_rgfltSubBarkExcReconCurr;   // just pointer for v8

  /**************Fixed point buffers*********************************************/
  U32 *     m_rguiSubBarkExc;        // enough for all subframes
  U32  *    m_rguiSubBarkExcPrev;
  U32  *    m_rguiSubBarkExcCurr;   //Ramesh : I put this here on 25 Apr, NMR test passed for 30.2

  //currently, thinking of 30.2 format format for this   TBD : U32
  U32  *    m_rguiSubBarkExcRef;

  U32  *    m_rguiSubBarkExcRecon;    // enough for all subframes
  U32  *    m_rguiSubBarkExcReconPrev;// just pointer for v8
  U32  *    m_rguiSubBarkExcReconCurr;  //Ramesh : TBD : make this U32 later, 30.2 format
	
  Float*           m_rgfltTargetSpectrum;    // for generating excitation=>mask=>lpc parameters.
    
  // Noise detection, suppression etc
  Float*           m_rgfltBandEnergy;        // to determine stationarity
  Float*           m_rgfltNoiseSpectrum;     // to perform noise filtering
  I32*           m_rgiNoiseSpectrum;     // by Pushp 
  Float*           m_rgfltSpectrumCurr;      // to perform noise filtering
  // The following was moved to PerChannelInfo to avoid requiring #include "msaudioenc.h"
  //Bool*            m_rgfMaskNeededForBark;   // for header squeezing
  Float*           m_rgfltSubBarkEnergyOrig;   // in computing nrmr, only pointer

  U32*           m_rguiSubBarkEnergyOrig;   // in computing nrmr, only pointer
    
  // Encoder-only members
  FLOATORI32*     m_pfltInputW;                    //weighted data: encoder only
  I32*            m_piInputW;                    //I32 weighted data: encoder only

  Float*          m_rgfltCoefOrig;                 // original coef: encoder only
  I32*            m_rgiCoefOrig;                 // original coef: encoder only
  Float*          m_rgfltCoef;                     //original coef: encoder only, weighted

  Float*          m_rgfltCoefLR;                   // original coef, straight through (without stereo matrixing)
  Float*          m_rgfltCoefReconLR;              // reconstructed coef, straight through (without stereo matrixing)
  I32*            m_rgiCoefLR;                   // original coef, straight through (without stereo matrixing)
  I32*            m_rgiCoefReconLR;              // reconstructed coef, straight through (without stereo matrixing)
    
  I32*            m_rgiCoef;                       // Integer version of m_rgfltCoef, not really used by anybody now
  U32             m_iCoefMagnitude;                // Magnitude (OR) of all coefs in m_rgiCoef; integer encoder
  Float*          m_rgfltWeightFactorPerBark;
  U8*             m_rgbLsfQ;                       //quantized lsf; encoder only
  I16*            m_rgiCoefQRLC;                   //Run length coded quantized coef
  I16*            m_rgiCoefQRLC_DIFF;              //Previous QRLC to be used for requant purposes
  U8*             m_rgbIsTone;                     //encoder only
  const U32*      m_rgiHffmanTblRunLevel;          //could be different for each stereo channel
  const I16*      m_rgiRunLevelVLCAtLevel;
  Int             m_iMaxLevelInRunLevelVLC;
  Int             m_cBitsUsed;                     //encoder only   
  Bool            m_fAnyNonZeroCoefQ;              //is coefQ all zero?
  Int             m_iFramePowerPrev;
  Int             m_iFramePower;
  WMARESULT       m_hr;                            // return code for multi-threaded operations
  FMU_STATUS      m_fNeedFullMaskUpdate;  // Scrunch bug #32: v4 decoder can resample
  // uninitialized weight factors
  I32*          m_rgiWeightFactorPerBark;
  float           m_fltLastFreq[LPCORDER];

  // transient detection (encoder only)
  I16           *m_piInputCurr;   //other preprocessing as well
  I16           *m_piInputNext;   //other preprocessing as well

  I16           *m_rgiTransient;


  TRANS_U64ORU32    *m_rgiTransientStrength;     //TBD: Ramesh : Should replace the float array. 17.15 format
  TRANS_U64ORU32    *m_rgiSlicePower;	 	 //32.0 format
  I64               m_iPowerPrevL;               //35.0
  I64               m_iPowerPrevM;               //35.0
  I64               m_iPowerPrevH;               //35.0

  I16           *m_rgiTransientSrcLow;           // 16.0 signed short input PCM
  Int           m_iTransientSrcLowCurr;          
  I32           *m_rgiTransientDstLow;
  Int           m_iTransientDstLowCurr;

  I16           *m_rgiTransientSrcMed;
  Int           m_iTransientSrcMedCurr;
  I32           *m_rgiTransientDstMed;
  Int           m_iTransientDstMedCurr;

  I16           *m_rgiTransientSrcHi;
  Int           m_iTransientSrcHiCurr;
  I32           *m_rgiTransientDstHi;
  Int           m_iTransientDstHiCurr;

#if !defined(BUILD_INTEGER)
  Float        *m_rgfltDitherNoise;
#endif  // !defined(BUILD_INTEGER)

  U32           m_iAchievedNmr;        // Format 9.23

    
  WeightType     m_wtMaxWeightActuallySent; // Needed for old players with broken logic.
  Bool           m_fMaskGotReset;
} PerChannelInfoENC;


#if !defined(BUILD_INTEGER) && !defined(UNDER_CE) && !defined(_Embedded_x86)
Void prvInvFftComplexConjugate_INTEL(Float rgfltData[], Int nLog2np);
#endif  // !defined(BUILD_INTEGER) && !defined(UNDER_CE)


#if !(defined(WMA_TARGET_MIPS) && defined(BUILD_INTEGER))
// Implemented in x86.c, fft.c
Void prvInvFftComplexConjugate(Float *rgfltData, Int nOrder);
#endif  // !(defined(WMA_TARGET_MIPS) && defined(BUILD_INTEGER))


#ifdef ENABLE_ALL_ENCOPT
#if !defined(BUILD_INTEGER)
WMARESULT prvInverseQuantizeMidRateSkipNoise (CAudioObject* pau, PerChannelInfo* ppcinfo,
                                              Int* rgiWeightFactor, Bool fSkipNoise);
#endif  // !defined(BUILD_INTEGER)
#endif  // ENABLE_ALL_ENCOPT
Void prvFillMaskNeededForBarkArray(CAudioObjectEncoder *pauenc,
                                   PerChannelInfoENC *pcinfoENC, const Status codecStatus);


#if 0	//RAMCHANG
#if defined(WMA_TARGET_X86) && !defined(BUILD_INTEGER) && !defined(UNDER_CE) && !defined(_Embedded_x86)

// From x86enc.c. X86-only stuff shouldn't be called directly from msaudioenc.c,
// but no time to fix now. Fix later.
WMARESULT auInitIntelCcsFFT(const CAudioObject *pau, const INTELFFT_INITCODE iCode);
WMARESULT auFreeIntelCcsFFT(CAudioObject *pau, const INTELFFT_INITCODE iCode);
#endif  // defined(WMA_TARGET_X86) && !defined(BUILD_INTEGER) && !defined(UNDER_CE)

#endif //RAMCHANG
// Used by noise detection/suppression
#define NOISE_DETECTION_HALFBLOCK 128

typedef enum tagWMAEncodeStatus
{
    WMA_Succeeded = 0,
    WMA_Failed,
    WMA_BadMemory,
    WMA_EncodeFailed,
    WMA_UnSupportedInputFormat,
    WMA_UnSupportedCompressedFormat,
    WMA_InValidArguments,
    WMA_BadSource,
} tWMAEncodeStatus;

CAudioObjectEncoder * InitAudioEncoder(U32 iDstAudioSampleRate, 
                    U32 iDstAudioChannels, U32 iDstAudioBitRate,
                    WMAFormatInfo *pFormat,Int *iResult);

Void prvMergeTransient(CAudioObjectEncoder *pauenc);

Void prvInitBandTruncation(CAudioObjectEncoder* pauenc);

Void prvSetEntropyTables(CAudioObjectEncoder *pauenc);

U64 mult_160u_302u_342u(U16 ix, U32 iy);

WMARESULT prvJustGetMaskingMono(CAudioObjectEncoder *pauenc, 
                                PerChannelInfoENC *pcinfoENC);

U32 prvBufEmptyness (const CAudioObjectEncoder* pauenc, 
                     const CVarBitrateBuf* pvbb);

I32 PushRawData(U8 *pRawDataBuffer, U32 nRawDataLen);

#endif  //__MSAUDIOENC_H_
