//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************
/*
 ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************
 */
/* test.c */
#if defined(WINCE_WARNLVL4_DISABLE)
//warning C4201: nonstandard extension used : nameless struct/union
//warning C4214: nonstandard extension used : bit field types other than int
#pragma warning (disable:4201 4214 4115 4057 4189)
#pragma warning (disable:4244 4102 4047 4127 4013)
#endif
#ifdef MICROSOFT_API

#if !defined(__arm) && defined(UNDER_CE)

#include <malloc.h> // for heapcheck

#include <tchar.h>
//#include <io.h>
//#include <direct.h>

#ifndef _XBOX
#ifdef UNDER_CE
#include <windows.h>
#endif //UNDER_CE
#else //_XBOX
#include <xtl.h>
#endif //_XBOX

#ifndef  UNDER_CE
#include <time.h>
#endif
#else //__arm
#include "wmatypes.h"
#define FALSE 0
#define TRUE  1
#define TEXT
//typedef long BOOL;
#define _tfopen   fopen
#define _ftprintf fprintf
#define _tprintf  printf
#define _tcslen   strlen
#define _tcscmp   strcmp
#define _tcstoul  strtoul
#define _ttoi     atoi
#define _istdigit isdigit
#endif //__arm

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "wmaudio.h"
//#include "assert.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

/*************************************************************************************************************/

#include "macros_app.h"
//#include "wmatyps.h"
#include "wmatypes.h"
//#include "pcmfmt.h"
#include "wavfileexio.h"

#include "wma10_dec_interface.h"

//***********REMOVING ASSERT******//
#define assert

/*************************************************************************************************************/
#ifdef WMDRM_NETWORK
#include "DrmXmr.h"
#include "WmdrmNet.h"
#include "OEMImpl.h"
#endif

#ifdef WAV_OUT
#include <windows.h>
#include <mmsystem.h>


/*  some good values for block size and count */
#define BLOCK_SIZE  8192
#define BLOCK_COUNT 4



/* module level variables */
static CRITICAL_SECTION waveCriticalSection;
static WAVEHDR*         waveBlocks;
static volatile int     waveFreeBlockCount;
static int              waveCurrentBlock;
int buffer_wav_out[8192];

static void writeAudio(HWAVEOUT hWaveOut, LPSTR data, int size)
{
    WAVEHDR* current;
    int remain;

    current = &waveBlocks[waveCurrentBlock];

    while(size > 0) {
        /*
         * first make sure the header we're going to use is unprepared
         */
        if(current->dwFlags & WHDR_PREPARED)
            waveOutUnprepareHeader(hWaveOut, current, sizeof(WAVEHDR));

        if(size < (int)(BLOCK_SIZE - current->dwUser)) {
            memcpy(current->lpData + current->dwUser, data, size);
            current->dwUser += size;
            break;
        }

        remain = BLOCK_SIZE - current->dwUser;
        memcpy(current->lpData + current->dwUser, data, remain);
        size -= remain;
        data += remain;
        current->dwBufferLength = BLOCK_SIZE;

        waveOutPrepareHeader(hWaveOut, current, sizeof(WAVEHDR));
        waveOutWrite(hWaveOut, current, sizeof(WAVEHDR));

        EnterCriticalSection(&waveCriticalSection);
        waveFreeBlockCount--;
        LeaveCriticalSection(&waveCriticalSection);

        /*
         * wait for a block to become free
         */
        while(!waveFreeBlockCount)
            Sleep(10);

        /*
         * point to the next block
         */
        waveCurrentBlock++;
        waveCurrentBlock %= BLOCK_COUNT;

        current = &waveBlocks[waveCurrentBlock];
        current->dwUser = 0;
    }
}

static WAVEHDR* allocateBlocks(int size, int count)
{
    unsigned char* buffer;
    int i;
    WAVEHDR* blocks;
    DWORD totalBufferSize = (size + sizeof(WAVEHDR)) * count;

    /*
     * allocate memory for the entire set in one go
     */
    if((buffer = HeapAlloc(
        GetProcessHeap(),
        HEAP_ZERO_MEMORY,
        totalBufferSize
    )) == NULL) {
        fprintf(stderr, "Memory allocation error\n");
        ExitProcess(1);
    }

    /*
     * and set up the pointers to each bit
     */
    blocks = (WAVEHDR*)buffer;
    buffer += sizeof(WAVEHDR) * count;
    for(i = 0; i < count; i++) {
        blocks[i].dwBufferLength = size;
        blocks[i].lpData = buffer;
        buffer += size;
    }

    return blocks;
}

static void freeBlocks(WAVEHDR* blockArray)
{
    /*
     * and this is why allocateBlocks works the way it does
     */
    HeapFree(GetProcessHeap(), 0, blockArray);
}

static void CALLBACK waveOutProc(
    HWAVEOUT hWaveOut,
    UINT uMsg,
    DWORD dwInstance,
    DWORD dwParam1,
    DWORD dwParam2
)
{
    int* freeBlockCounter = (int*)dwInstance;
    /*
     * ignore calls that occur due to openining and closing the
     * device.
     */
    if(uMsg != WOM_DONE)
        return;

    EnterCriticalSection(&waveCriticalSection);
    (*freeBlockCounter)++;
    LeaveCriticalSection(&waveCriticalSection);
}
#endif


//if defined (WMA2CMP)
// This is a hard fix. Both windows.h and wmatype.h define BOOL structuree
// and we got benign redefiniation of type warning. Now we forcefully define
// _BOOL_DEFINED here then windows.h will not define BOOL anymore. chao.
#define _BOOL_DEFINED
//ndif // WMA2CMP

#if defined(AUTOPC_STYLE)
#   pragma message (__FILE__ "(15) : Warning - Not 24-bit per sample ready!")
#endif

// Define MEASURE_CLOCK for top level timing
//#define MEASURE_CLOCK

// AUTOPC_STYLE has a very large buffer and calls our routines to repeatedly fill it up
//#define AUTOPC_STYLE

// Define DISCARD_OUTPUT for profiling.
#if defined(PROFILE) || defined(MEASURE_CLOCK)
// this must be commented out if you really want output
//#define DISCARD_OUTPUT
#endif

#ifdef PERFRM_TIMING
#define DISCARD_OUTPUT // really #define DISCARD_OUTPUT for this case
#endif

// comment out DUMP_WAV define below to output a raw .pcm file rather than a .wav file.
#define DUMP_WAV
//#ifdef DUMP_WAV
//#include "macros_app.h"
////#include "wmatyps.h"
//#include "wmatypes.h"
////#include "pcmfmt.h"
//
//#endif  /* DUMP_WAV */
//#include "pcmfmt.h"

#include "macros_app.h"
#include "wmatypes.h"

Void PCMFormat2WaveFormatEx(PCMFormat* pFormat, WAVEFORMATEX* wfx);
Void PCMFormat2WaveFormatExtensible(PCMFormat* pFormat, WAVEFORMATEXTENSIBLE* wfx);

// Obnoxious Tests
// un-comment out the define below to enable some modestly obnoxious tests for the interface (output should still be OK)
//#define OBNOXIOUS
// un-comment out the next define to enable interface tests which will not generate the correct output
//#define REAL_OBNOXIOUS

//#define _MARKERDEMO_
//#define TEST_SPEED

//#define TEST_MARKER

// #define WMALOSSLESS_TO_PCM
#ifdef WMALOSSLESS_TO_PCM
    #undef WMA_SEEK_TEST
    #undef WMA_SEEK_MATCH
    #undef DISCARD_OUTPUT
    #undef MEASURE_CLOCK
    #undef OBNOXIOUS
    #define DUMP_WAV
    #if defined WMA2CMP || defined WMA_SEEK_TEST ||  defined WMA_SEEK_MATCH || defined DISCARD_OUTPUT || defined OBNOXIOUS || defined OBNOXIOUS || !defined DUMP_WAV
        #error Should not define WMA2CMP, WMA_SEEK_TEST, WMA_SEEK_MATCH, DISCARD_OUTPUT, OBNOXIOUS, and  DUMP_WAV in WMALOSSLESS_TO_PCM project
    #endif
#endif //WMALOSSLESS_TO_PCM


// WMA2CMP - define in project settings to produce a .cmp output file from the .wma suitable for use with decapp
#ifdef WMA2CMP
#   ifndef WMAAPI_NO_DRM
#       define WMAAPI_NO_DRM
#   endif
#   include "wmaudio_type.h"
#   include "msaudio.h"
    FILE    *pfWma2Cmp = NULL;       // file (and flag) to output .cmp file
    // typically you would rename the execuable of this WMA2CMP build as Wma2Cmp.exe when moving it into your path
#endif


// HEAP_DEBUG_CHECK is the same as the defines in msaudio.h
// Although it is normally bad form to copy something out a .h instead of
// including the .h, in this test program, we want to make sure we do not
// inadvertently use anything from msaudio.h
#if defined(HEAP_DEBUG_TEST) && defined(_DEBUG)
void HeapDebugCheck();
#define HEAP_DEBUG_CHECK HeapDebugCheck()
#else
#define HEAP_DEBUG_CHECK
#endif

//#define PRINT_FROM_SAMPLE 67966
//#define PRINT_TO_SAMPLE   68228
//#define PRINT_FROM_SAMPLE 66000
//#define PRINT_TO_SAMPLE   68228
#if defined(PRINT_FROM_SAMPLE) && defined(PRINT_TO_SAMPLE)
    // One of the DCT print defines must be defined in fft.c to get this
    extern int bPrintDctAtFrame;    // used to print coefs before and after DCT
#endif


/* global */
static void* g_hdrstate = NULL;
static void* g_state = NULL;
tWMAFileHeader g_hdr;
tWMAFileLicParams g_lic;

//#ifndef TEST_SPEED
FILE *g_fp = NULL;
FILE *g_fpLic = NULL;
//#endif /* TEST_SPEED */
#ifdef TEST_SPEED
#define MAX_PERFORM_BUFFER_SIZE 15*1024*1024
FILE *g_fpperform = NULL;
#endif /* TEST_SPEED */

#ifdef TEST_SPEED
static unsigned char *g_pBuffer = NULL;
#else  /* TEST_SPEED */
const unsigned int MAX_BUFSIZE = WMA_MAX_DATA_REQUESTED;
unsigned char g_pBuffer[WMA_MAX_DATA_REQUESTED];
#endif /* TEST_SPEED */
tWMA_U32 g_cbBuffer = 0;
tWMA_U64 g_qwBufferOffset = 0;

#ifdef TEST_SPEED
#else  /* TEST_SPEED */
unsigned char g_pBufLic[WMA_MAX_DATA_REQUESTED];
#endif /* TEST_SPEED */
tWMA_U32 g_cbBufLic = 0;

time_t g_ulStartFirstSec, g_ulEndSec;
time_t g_ulFullSec = 0;
time_t g_ulOutputSamples = 0;
unsigned int  g_SampleRate;

unsigned int g_iSeekIndex = 0;

#if defined (TEST_PEAKRATE)
unsigned int g_iLargestFrame = 0;
unsigned int g_cSamplesPerFrame = 0;
#endif // TEST_PEAKRATE

/* Portable Media ID
 *
 * This is different for each portable medium (PM).  Should be
 * provided by the application by reading an identification from
 * the PD
 */

/*
unsigned char g_pmid[20] =
{
    // Jonas
//    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4D, 0x20,
//    0x33, 0x54, 0x31, 0x30, 0x31, 0x33, 0x37, 0x32, 0x37, 0x33
// Robert
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x69, 0x20,
  0x32, 0x30, 0x35, 0x30, 0x30, 0x32, 0x30, 0x31, 0x32, 0x31,
//    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
//    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x02, 0x03, 0x04,
};
*/

//train
unsigned char g_pmid[20] =
{
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4d, 0x20,
    0x33, 0x54, 0x31, 0x30, 0x30, 0x35, 0x30, 0x30, 0x39, 0x35
};


/*
unsigned char g_pmid[20] =
{
    0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0xef, 0x55, 0xef,
    0xee, 0xee, 0xef, 0xef, 0xef, 0xef, 0xef, 0xdf, 0xdf, 0xd9
};
*/

// This should work either with or without TEST_INTERLEAVED_DATA
//   TEST_INTERLEAVED_DATA should be more efficient for all platforms except perhaps ARM.
//   but some applications want separate right and left channel data returned.
// One should check-in with TEST_INTERLEAVED_DATA defined
//   but run appropriate tests both with and without TEST_INTERLEAVED_DATA


#if defined(AUTOPC_STYLE)
// This style uses a large buffer and repeatedly calls our interface to fill it up
#define MAX_SAMPLES 132000
#define TEST_INTERLEAVED_DATA

#else
// This style is like our sample programs
// should work with any buffer size.  No point in it being larger than 2048.
//#define MAX_SAMPLES 256
//#define MAX_SAMPLES 2048
#define MAX_SAMPLES 16384
#define TEST_INTERLEAVED_DATA

#endif
#if !defined (TEST_INTERLEAVED_DATA)
#   pragma message (__FILE__ "(170) : Warning - Not 24-bit per sample ready!")
#endif

#ifdef TEST_INTERLEAVED_DATA
    short g_pLeft [MAX_SAMPLES * 12];// Max 8 channels, upto 24-bit samples. should be malloc'd
    short *g_pRight = NULL;


#ifdef WMA_SEEK_TEST
    unsigned char g_pFirst [MAX_SAMPLES * 24]; //2 * g_pLeft; sloppy here
#endif
#else
    short g_pLeft [MAX_SAMPLES * 2]; // expand the container for 24-bit samples
    short g_pRight [MAX_SAMPLES * 2]; // expand the container for 24-bit samples
#   ifdef DUMP_WAV
        // this combo not supported below
#       undef DUMP_WAV
#   endif
#endif

#ifdef USE_SPDTX
#define MAX_BURST ( 2048 * 4 )
tWMA_U8 g_pBurst[ MAX_BURST ];  // support up to 2-channel, 16-bit spdif data
#endif

#ifdef WMDRM_NETWORK
//
// The WMDRM-ND PK refcode requires this function to be defined.
//
// In the real world, HrdManufactureDevice() should be used to set up the
// device information (including the private key). Refer to the documentation
// for details.
//
// This code only demonstrates the decrypting of WMDRM-ND encrypted content,
// so we will pass in the private key directly to the functions where its
// needed.
//
void *HrdGetPrivateKey() { return( NULL ); }
#endif

#define STRING_SIZE 2048
unsigned char g_szTitle[STRING_SIZE];
unsigned char g_szAuthor[STRING_SIZE];
unsigned char g_szCopyright[STRING_SIZE];
unsigned char g_szDescription[STRING_SIZE];
unsigned char g_szRating[STRING_SIZE];

#if 0
extern "C" void
SerialSendString(LPCTSTR pcString)
{
    fprintf(stderr, pcString);
}

extern "C" void
SerialPrintf(LPCTSTR format, ...)
{
    va_list a;
    TCHAR s[256];
    va_start( a, format );
    vsprintf(s, format, a);
    va_end(a);
    SerialSendString(s);
}
#endif /* 0 */

/**************************************************/
#ifndef __arm
#ifdef UNDER_CE
void SysDateToLicDate( LPSYSTEMTIME pSysDate, tWMADateParams *pbLicDate )
{
    pbLicDate->year        = (WORD)( pSysDate->wYear );
    pbLicDate->month       = (BYTE)( pSysDate->wMonth );
    pbLicDate->day         = (BYTE)( pSysDate->wDay );
}
#endif
#endif //__arm

/* WMAFileCBGetData */

tWMA_U32 WMAFileCBGetInput (
    tHWMAFileState state,
    tWMA_U64 offset,
    tWMA_U32 num_bytes,
    tWMA_U8  **ppData)
{
    tWMA_U32 ret;

#ifdef TEST_SPEED

    if(offset >= g_cbBuffer)
    {
        *ppData = g_pBuffer + g_cbBuffer;
        ret = 0;
    }
    else
    {
        *ppData = g_pBuffer + offset;

        if(offset + num_bytes > g_cbBuffer)
        {
            ret = g_cbBuffer - offset;
        }
        else
        {
            ret = num_bytes;
        }
    }

#else  /* TEST_SPEED */

    I64 iRelativeOffset = (tWMA_I64)offset - (tWMA_I64)g_qwBufferOffset;
    U32 iBytesRead;

    // Initialize return values
    *ppData = NULL;
    ret = 0;
    assert(num_bytes <= MAX_BUFSIZE);

    // The ANSI-C function fread seems to do fine with files which are > 4GB,
    // but fseek fails miserably. Therefore, never call fseek unless requested
    // read range is within first 0x7FFFFFFF.

    // Check if start of requested range is within our buffer
    if (iRelativeOffset >= 0 && iRelativeOffset < g_cbBuffer)
    {
        if (iRelativeOffset + num_bytes < g_cbBuffer)
        {
            // Entire request is entirely within range of current buffer
            *ppData = g_pBuffer + iRelativeOffset;
            ret = num_bytes;
            goto exit;
        }

        // Only the start of request range is in our buffer. Collapse memory.
        memmove(g_pBuffer, g_pBuffer + iRelativeOffset,
            (size_t)(g_cbBuffer - iRelativeOffset));
        g_cbBuffer -= (U32)iRelativeOffset;
        g_qwBufferOffset = offset;
    }
    else
    {
        // Start of requested range is outside of our buffer
        if (offset + num_bytes <= 0x7FFFFFFF)
        {
            if (0 != fseek (g_fp, (U32)offset, SEEK_SET))
                goto exit;
        }
        else
        {
            // If we reach this point, we can't use fseek
            if (iRelativeOffset < 0)
            {
                // Seeking backwards to > 32-bit offset is not supported
                assert(0);
                goto exit;
            }

            // Seek forward to the desired offset.
            iRelativeOffset -= g_cbBuffer;
            while (iRelativeOffset > 0)
            {
                U32 iBytesToRead;

                if (iRelativeOffset > MAX_BUFSIZE)
                    iBytesToRead = MAX_BUFSIZE;
                else
                    iBytesToRead = (U32)iRelativeOffset;

                iBytesRead = fread(g_pBuffer, 1, iBytesToRead, g_fp);
                if (iBytesRead < iBytesToRead)
                {
                    // Reached EOF before reaching requested offset!
                    goto exit;
                }

                iRelativeOffset -= iBytesRead;
            }
        }

        g_qwBufferOffset = offset;
        g_cbBuffer = 0;
    }

    iBytesRead = fread(g_pBuffer + g_cbBuffer, 1, MAX_BUFSIZE - g_cbBuffer, g_fp);
    g_cbBuffer += iBytesRead;
    assert(g_cbBuffer <= MAX_BUFSIZE);
    assert(offset == g_qwBufferOffset);
    *ppData = g_pBuffer;

    ret = num_bytes;

#endif /* TEST_SPEED */

exit:

//    fprintf(stderr, "++ WMAFileCBGetData: %lu bytes from %lu.\n", ret, offset);

    return ret;
}


// need to provide a platform independent fprintf to stderr for wmaudio.c and wmaudio_parse.c
void WMADebugMessage(const char* pszFmt, ... )
{
    va_list vargs;
    va_start(vargs, pszFmt);
    vfprintf(stderr, pszFmt, vargs );
    va_end(vargs);
}

#if defined(AUTOPC_STYLE)

// AutoPc reads into large 132000 byte buffers using the following code (much simplified)

#define LONG long
#define BYTE unsigned char
//
// llPos   - Starting position to read.
// lLength - Number of bytes to read.
// pBuffer - Ptr to buffer to populate with data.
WMARESULT
AutoPCReadNext(
    LONG lLength,
    short* pBuffer,
    LONG* lWritten)
{

    tWMAFileStatus rc;

    // calculate sample length
    tWMA_U32 sampleLength = (tWMA_U32)lLength / (g_hdr.num_channels << 1);

    short* pLeft = (short*)pBuffer;

    short* pTempLeft = pLeft;

    tWMA_U32 num_samples = 0;

    *lWritten = 0;

    if (g_hdr.bits_per_sample != 16) {
      // Code not ready to deal with 24-bit data
      return cWMA_Failed;
    }

    //Keep looping around until no samples are left.
    while(sampleLength)
    {
        tWMA_U32 nDecodedSamples;
        do
        {
#ifdef USE_SPDTX
            num_samples = WMAFileGetSpdifBurst(g_state, pTempLeft, NULL, sampleLength);
#else
            num_samples = WMAFileGetPCM(g_state, pTempLeft, NULL, sampleLength);
#endif
            *lWritten += num_samples*(g_hdr.num_channels << 1);
            sampleLength -= num_samples;
            pTempLeft += (num_samples * g_hdr.num_channels);
        } while(num_samples);

        if ( sampleLength == 0 )
            break;

#ifdef USE_SPDTX
        rc = WMAFileDecodeToSpdif(g_state, &nDecodedSamples);
#else
        rc = WMAFileDecodeData(g_state, &nDecodedSamples);
#endif
        if( rc == cWMA_NoMoreFrames )
        {
            return WMA_S_NO_MORE_SRCDATA;
        } else if( rc != cWMA_NoErr )
        {
            return rc;
        }
    }

    return cWMA_NoErr;
}

#endif  // defined(AUTOPC_STYLE)

#ifdef UNDER_CE
int decodeWMAFile2PCMRecursivelyInDir(LPCTSTR pWMADirName, LPCTSTR pWAVDirName, BOOL bForceExt, Bool bDropPacket, Bool bOutputCMP,
                                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask, U32 nInterpResampRate,
                                      U16 nMBRTargetStream,
                                      BOOL bLimitPTSErrors,
                                      U16  cMaxPTSErrors);
int decodeWMAFile2PCM(LPCTSTR pWMAFileName, LPCTSTR pWAVFileName, BOOL bForceExt, Bool bDropPacket, LPCTSTR pCMPFileName,
                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask, U32 nInterpResampRate,
                      U16 nMBRTargetStream,
                      BOOL bLimitPTSErrors,
                      U16  cMaxPTSErrors);
#else
int decodeWMAFile2PCMRecursivelyInDir(char * pWMADirName, char * pWAVDirName, BOOL bForceExt, Bool bDropPacket, Bool bOutputCMP,
                                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask,
                                      U32 nInterpResampRate,
                                      U16 nMBRTargetStream,
                                      BOOL bLimitPTSErrors,
                                      U16 cMaxPTSErrors);
int decodeWMAFile2PCM(char * pWMAFileName, char * pWAVFileName, BOOL bForceExt, Bool bDropPacket, char * pCMPFileName,
                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask,
                      U32 nInterpResampRate,
                      U16 nMBRTargetStream,
                      BOOL bLimitPTSErrors,
                      U16  cMaxPTSErrors);

#endif
/* main */
#ifdef __arm
#define HARDCODE_INPUT
#endif

#ifdef UNICODE
//int __cdecl wmain(int argc, __in_ecount(argc) LPCTSTR argv[])
int __cdecl wmain(int argc, LPCTSTR argv[])
#elif UNDER_CE
//Int MSVC_CDECL main(Int argc, __in_ecount(argc) LPCTSTR argv[])
Int MSVC_CDECL main(Int argc, LPCTSTR argv[])
#else
Int MSVC_CDECL main(Int argc, char * argv[])
#endif
{
    WMARESULT hr = 1; // assume error

#ifdef UNDER_CE
    LPCTSTR szInputName     = NULL;
    LPCTSTR szOutputName    = NULL;
    LPCTSTR szCmpOutputName = NULL;
#else
    char * szInputName     = NULL;
    char * szOutputName    = NULL;
    char * szCmpOutputName = NULL;
#endif

#ifdef WMALOSSLESS_TO_PCM
    TCHAR inputDir[_MAX_PATH];
    TCHAR outputDir[_MAX_PATH];
    TCHAR currDir[_MAX_PATH];
    intptr_t inputHandle = 0;
    struct _tfinddata_t inputFileOrDirInfo;
    intptr_t outputHandle = 0;
    struct _tfinddata_t outputFileOrDirInfo;
#endif //WMALOSSLESS_TO_PCM
    Bool bDirMode = 0;
    Bool bForceExt = WMAB_FALSE;
    Bool bOutputCMP = FALSE;
    Bool bDropPacket = FALSE;
    U16  nDRCSetting = 0;
    U16  nDecoderFlags = 0;
    U32  nDstChannelMask = 0;
    Int  iArgc, iError=0;
    U32  nInterpResampRate = 0;
    Int  iFileCnt = 0;
    U16  nMBRTargetStream = 1;
    Bool bLimitPTSErrors = WMAB_TRUE;
    U16  cMaxPTSErrors = 5;

//hard code input arg for Embedded ARM
#ifdef HARDCODE_INPUT
    char strInput[50] = "d:\\wmatest\\test.wma";
    char strOutput[50] = "d:\\wmatest\\test.wav";

    iFileCnt = 2;

    szInputName = strInput;
    szOutputName = strOutput;

    //fold-down to 2 channels, -cm 0x03
    nDecoderFlags  |= DECOPT_CHANNEL_DOWNMIXING;
    nDstChannelMask = (U32) 0x03;

    //resample to 16 bits, -pcm 16
    nDecoderFlags |= DECOPT_REQUANTTO16;

    //downsample to 44.1 or 48 kHZ
    nDecoderFlags |= DECOPT_DOWNSAMPLETO44OR48;
#else
    for (iArgc=1; iArgc < argc; iArgc++)
    {
        if (_tcslen(argv[iArgc]) > 512 || argc > 20)
        {
            // Arguments are too long
            fputs("Arguments are too long or too many arguments given\n\n", stderr);
            goto exit;
        }
#if !defined (WMALOSSLESS_TO_PCM)
        if (!_tcscmp(argv[iArgc], TEXT("-c")))
        {
            fputs("Option -c has been deprecated. Use -cm 0x-- instead.\n\n", stderr);
            goto exit;
        }
        else if (!_tcscmp(argv[iArgc], TEXT("-cm")))
        {
            if( ++iArgc < argc )
            {
                nDecoderFlags  |= DECOPT_CHANNEL_DOWNMIXING;
                nDstChannelMask = (U32) _tcstoul (argv[iArgc], NULL, 0);
            }
            else
            {
                fprintf( stderr, "Option -cm requires a channel mask. Use -cm 0x--.\n\n" );
                goto exit;
            }
        }
#if !defined(WMA_DECPK_BUILD)
        else if (!_tcscmp(argv[iArgc], TEXT("-ltrt")))
            nDecoderFlags |= DECOPT_LTRTDOWNMIX;
#endif
        else if (!_tcscmp(argv[iArgc], TEXT("-float")) ||
            !_tcscmp(argv[iArgc], TEXT("-f")))
            nDecoderFlags |= DECOPT_FLOAT_OUT;
        else if (!_tcscmp(argv[iArgc], TEXT("-pcm")))
        {
            if( ++iArgc < argc )
            {
                Int cbContainerSize = _ttoi(argv[iArgc]);
                switch (cbContainerSize)
                {
                case 16:
                    nDecoderFlags |= DECOPT_REQUANTTO16;
                    break;
                case 24:
                    nDecoderFlags |= DECOPT_PCM24_OUT;
                    break;
                case 32:
                    nDecoderFlags |= DECOPT_PCM32_OUT;
                    break;
                default:
                    fprintf(stderr, "-pcm %d is not allowed.\n\n", cbContainerSize);
                    goto exit;
                    break;
                }
            }
            else
            {
                fprintf( stderr, "option -pcm requires a bit size. Use -pcm [16|24|32].\n\n" );
                goto exit;
            }
        }
        else if (!_tcscmp(argv[iArgc], TEXT("-d")))
        {
            if( ++iArgc < argc && _istdigit(argv[iArgc][0]) )
            {
                nDecoderFlags |= DECOPT_DRC;
                nDRCSetting = (I16)_ttoi(argv[iArgc]);
            }
            else
            {
                fprintf( stderr, "Option -d requires a DRC setting. Use -d [0|1|2].\n\n" );
                goto exit;
            }
            if (nDRCSetting < 0 || nDRCSetting > 2) iError = 1;
        }
        else if (!_tcscmp(argv[iArgc], TEXT("-h")))
            nDecoderFlags |= DECOPT_HALF_TRANSFORM;
#if !defined(WMA_DECPK_BUILD)
        else if (!_tcscmp(argv[iArgc], TEXT("-i")))
        {
            nDecoderFlags |= DECOPT_INTERPOLATED_DOWNSAMPLE;
        }
        else if (!_tcscmp(argv[iArgc], TEXT("-ir")))
        {
            nDecoderFlags |= DECOPT_INTERPOLATED_DOWNSAMPLE;
            if( ++iArgc < argc && _istdigit(argv[iArgc][0]) )
            {
                nInterpResampRate = _ttoi(argv[iArgc]);
            }
            else
            {
                fprintf( stderr, "Option -ir requires a sample rate. Use -ir [rate].\n\n" );
                goto exit;
            }
        }
#ifndef BUILD_WMASTD
        // upsampling is only supported in WMA Std, not LSL or Pro.
        else if (!_tcscmp(argv[iArgc], TEXT("-hu")))
            nDecoderFlags |= DECOPT_HALF_UP_TRANSFORM;
        else if (!_tcscmp(argv[iArgc], TEXT("-u")))
            nDecoderFlags |= DECOPT_2X_TRANSFORM;
#endif // !BUILD_WMASTD
        else if (!_tcscmp(argv[iArgc], TEXT("-s")))
            nDecoderFlags |= DECOPT_DOWNSAMPLETO44OR48;
#endif // WMA_DECPK_BUILD
        else if (!_tcscmp(argv[iArgc], TEXT("-mbr")))
        {
            if( ++iArgc < argc && _istdigit(argv[iArgc][0]) )
            {
                nMBRTargetStream = (U16) _ttoi(argv[iArgc]);
            }
            else
            {
                fprintf( stderr, "Option -mbr requires a stream number. Use -mbr [stream].\n\n" );
                goto exit;
            }
        }
        else
#endif // !WMALOSSLESS_TO_PCM
        if (!_tcscmp(argv[iArgc], TEXT("-dlp" )))
            bDropPacket = TRUE;
        else if (!_tcscmp(argv[iArgc], TEXT("-ext")))
            bForceExt = TRUE;
        else if (!_tcscmp(argv[iArgc], TEXT("-nofreqex")))
        {
            nDecoderFlags |= DECOPT_IGNOREFREQEX;
        }
        else if (!_tcscmp(argv[iArgc], TEXT("-nocx")))
        {
            nDecoderFlags |= DECOPT_IGNORECX;
        }
#ifdef DBG_CX_STAGES
        else if (!_tcscmp(argv[iArgc], TEXT("-refresh")))
        {
            PARSE_REFR_ARGS;
        }
#endif
        else if (argv[iArgc][0] == '-') {
            _ftprintf(stderr, TEXT("Unknown option \"%s\" found. Exit.\n"), argv[iArgc]);
            iError = 1;
            break;
        }

        else if (iFileCnt == 0)
        {
            szInputName = argv[iArgc];
            iFileCnt++;
        }
        else if (iFileCnt == 1)
        {
            szOutputName = argv[iArgc];
            iFileCnt++;
        }
        else if (iFileCnt == 2)
        {
            szCmpOutputName = argv[iArgc];
            iFileCnt++;
        }
        else {
            iFileCnt++;
            _ftprintf(stderr, TEXT("Unknown option \"%s\" found. Exit.\n"), argv[iArgc]);
            iError = 1;
            break;
        }
    }

    if (iFileCnt < 2  || iFileCnt > 4 || iError)
    {
#ifdef WMALOSSLESS_TO_PCM
        fputs("Convert Lossless WMA file(s) to PCM WAV file(s).\n\n", stderr);
        fputs("wmal2pcm <input file or dir> <output file or dir> [-ext]\n\n", stderr);
        fputs("       input           Specifies a WMA file or a directory holding WMA files\n", stderr);
        fputs("       output          Specifies the output WAV file or the directory to hold the output WAV files\n", stderr);
        fputs("       -ext            Force the output WAV format to be WAVEFORMATEXTENSIBLE\n", stderr);
        fputs("\n\nExample:", stderr);
        fputs("\n    wmal2pcm c:\\wmadir c:\\recwavdir -ext", stderr);
        fputs("\n    wmal2pcm c:\\wmadir\\test.wma c:\\recwavdir\\testrec.wav -ext", stderr);
#else // WMALOSSLESS_TO_PCM
        fputs("\nConvert WMA file(s) to PCM WAV file(s).\n\n", stderr);
#if !defined (WMA2CMP)
        _ftprintf(stderr, TEXT("%s <input file> <output file> [-ext]\n\n"), argv[0]);
        fputs("       input           Specifies a WMA file\n", stderr);
        fputs("       output          Specifies the output WAV file\n", stderr);
        fputs("       -ext            Force the output WAV format to be WAVEFORMATEXTENSIBLE\n", stderr);
        fputs("\nOther options:\n", stderr);
        fputs("       [-cm nDstChanMask]  Perform channel down-mixing to 'nDstChanMask'\n", stderr);
        fputs("                           channel mask, e.g. 0x03\n", stderr);
#if !defined(WMA_DECPK_BUILD)
        fputs("       [-ltrt]             Perform Lt-Rt style channel down-mixing of surround\n", stderr);
#endif
        fputs("       [-pcm 16/24/32]     Requantize output to 16, 24, or 32-bits/sample\n", stderr);
        fputs("       [-float]            Generate floating point wav file\n", stderr);
        fputs("       [-d 0/1/2]          Dynamic Range Control (DRC) setting\n", stderr);
        fputs("                           0: High, 1: Med, 2: Low\n", stderr);
        fputs("       [-h]                Perform half-transform, with destination rate\n", stderr);
        fputs("                           equal to half the source wma rate\n", stderr);
#if !defined(WMA_DECPK_BUILD)
        fputs("       [-ir dstSampRate]   Interpolated resampling to desired sampling rate\n", stderr);
#ifndef BUILD_WMASTD // upsampling is only supported in WMA Std, not LSL or Pro
        fputs("       [-hu]               Perform half-transform, with destination rate matching source wma rate\n", stderr);
        fputs("       [-u]                Perform 2X trasform, with destination rate equal to double the source wma rate\n", stderr);
#endif // !BUILD_WMASTD
        fputs("       [-s]                Try to resample to 48KHz or 44.1KHz wav file\n", stderr);
#endif // !defined(WMA_DECPK_BUILD)
        fputs("       [-mbr audioStream]  audioStream to decode. Default: 1\n", stderr);
#ifdef DBG_CX_STAGES
        fputs("       [-refresh <ref/can> [<ref file if can>]] Refresh data from reference decoder in pipeline for LBR v2/v3\n", stderr);
#endif
        fputs("\n\nExample:", stderr);
        _ftprintf(stderr, TEXT("\n    %s c:\\wmadir\\test.wma c:\\recwavdir\\testrec.wav -ext"), argv[0]);
#else // so WMA2CMP
        _ftprintf(stderr, TEXT("\n    %s test.wma testrec.wav test.cmp [-ext].\n"), argv[0]);
        fputs("       input           Specifies a WMA file\n", stderr);
        fputs("       output          Specifies the output WAV file\n", stderr);
        fputs("       test.cmp        Specifies internal audio compressed file\n", stderr);
        fputs("       -ext            Force the output WAV format to be WAVEFORMATEXTENSIBLE\n", stderr);
#endif // WMA2CMP
#endif // WMALOSSLESS_TO_PCM
        fputs("\n Copyright (C) Microsoft Corporation. All rights reserved.\n", stderr);
        goto exit;
    }
#endif //HARDCODE_INPUT

#ifdef DBG_CX_STAGES
    COPY_REFR_FILENAME(szOutputName);
#endif

    {
        // Output the WMA 10 Decoder Version Information.
        printf( "%s \n", WMA10DoderVersionInfo() );
    }

#ifdef WMALOSSLESS_TO_PCM
    if( ( inputHandle = _tfindfirst((TCHAR*)szInputName, &inputFileOrDirInfo) ) == -1 )
    {
        fputs("Error: Input file or directory does not exist.\n", stderr);
        _findclose(inputHandle);
        goto exit;
    }
    else
    {
        bDirMode = (inputFileOrDirInfo.attrib & _A_SUBDIR);
    }

    if (bDirMode) {
        if( ( outputHandle = _tfindfirst((TCHAR*)szOutputName, &outputFileOrDirInfo) ) == -1 )
        {
            fputs("Error: Output directory does not exist.\n", stderr);
            goto exit;
        }
        else
        {
            if (bDirMode != (outputFileOrDirInfo.attrib & _A_SUBDIR))
            {
                fputs("Error: If input is directory, output must be directory too.\n", stderr);
                goto exit;
            }
        }
    }
    else {
        if( ( outputHandle = _tfindfirst((TCHAR*)szOutputName, &outputFileOrDirInfo) ) == 0 )
        {
            fputs("Error: Output wav file exists. Please choose another name.\n", stderr);
            goto exit;
        }
        if (outputFileOrDirInfo.attrib & _A_SUBDIR)
        {
            fputs("Error: If input is file, output must be file too.\n", stderr);
            goto exit;
        }
    }

    if (!bDirMode)
    {
        if ((argc == 3 && bForceExt == FALSE) || (argc == 4 && bForceExt == TRUE))
        {
            hr = decodeWMAFile2PCM(szInputName, szOutputName, bForceExt, bDropPacket, szCmpOutputName,
                nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
                nMBRTargetStream,
                bLimitPTSErrors,
                cMaxPTSErrors);
        }
        else
        {
            hr = decodeWMAFile2PCM(szInputName, szOutputName, bForceExt, bDropPacket, NULL,
                nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
                nMBRTargetStream,
                bLimitPTSErrors,
                cMaxPTSErrors);
        }
    }
    else
    {
        if( _tgetcwd(currDir, _MAX_PATH ) == NULL )
        {
            fputs("Error: _getcwd error.\n", stderr );
            goto exit;
        }

        // Pass the full path to decodeWMAFile2PCMRecursivelyInDir
        if (_tchdir(szInputName))
        {
            _ftprintf (stderr, TEXT("Error: Can't find directory %s.\n"), szInputName);
            goto exit;
        }
        /* Get the current working directory: */
        if( _tgetcwd(inputDir, _MAX_PATH ) == NULL )
        {
            fputs ("Error: _getcwd error.\n", stderr );
            goto exit;
        }

        if (_tchdir(currDir))
        {
            _ftprintf (stderr, TEXT("Error: Can't find directory %s.\n"), szInputName);
            goto exit;
        }

        if (_tchdir(szOutputName))
        {
            _ftprintf (stderr, TEXT("Error: Can't find directory %s.\n"), szOutputName);
            goto exit;
        }
        /* Get the current working directory: */
        if( _tgetcwd(outputDir, _MAX_PATH ) == NULL )
        {
            goto exit;
            fputs("Error: _getcwd error.\n", stderr );
        }

        hr = decodeWMAFile2PCMRecursivelyInDir(inputDir, outputDir, bForceExt, bDropPacket, bOutputCMP,
                nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
                nMBRTargetStream,
                bLimitPTSErrors,
                cMaxPTSErrors);
    }
#else
    if ((iFileCnt == 3 && bForceExt == FALSE) || (iFileCnt == 4 && bForceExt == TRUE))
    {
        hr = decodeWMAFile2PCM(szInputName, szOutputName, bForceExt, bDropPacket, szCmpOutputName,
                nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
                nMBRTargetStream,
                bLimitPTSErrors,
                cMaxPTSErrors);
    }
    else
    {
        hr = decodeWMAFile2PCM(szInputName, szOutputName, bForceExt, bDropPacket, NULL,
                nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
                nMBRTargetStream,
                bLimitPTSErrors,
                cMaxPTSErrors);
    }
#endif //WMALOSSLESS_TO_PCM

exit:

#ifdef WMALOSSLESS_TO_PCM
    if (inputHandle)
        _findclose(inputHandle);
    if (outputHandle)
        _findclose(outputHandle);
#endif //WMALOSSLESS_TO_PCM

    return hr;
}

#ifdef WMALOSSLESS_TO_PCM
#ifdef UNDER_CE
int decodeWMAFile2PCMRecursivelyInDir(LPCTSTR pWMADirName, LPCTSTR pWAVDirName, BOOL bForceExt, Bool bDropPacket, Bool bOutputCMP,
                                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask,
                                      U32 nInterpResampRate,
                                      U16 nMBRTargetStream,
                                      BOOL bLimitPTSErrors,
                                      U16 cMaxPTSErrors)
#else
int decodeWMAFile2PCMRecursivelyInDir(char * pWMADirName, char * pWAVDirName, BOOL bForceExt, Bool bDropPacket, Bool bOutputCMP,
                                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask,
                                      U32 nInterpResampRate,
                                      U16 nMBRTargetStream,
                                      BOOL bLimitPTSErrors,
                                      U16 cMaxPTSErrors)
#endif
{
    WMARESULT hr = 1; // assume error
    TCHAR newWMASubDirName[_MAX_PATH];
    TCHAR newWAVSubDirName[_MAX_PATH];
    TCHAR * pNextDirName;
    intptr_t WMADirHandle = 0;
    struct _tfinddata_t itemInfo;

    BOOL bGotOutDir = FALSE;
    U32  dwErrCode =0;

    if (_tchdir(pWMADirName))
    {
        _ftprintf (stderr, TEXT("Error: Can't find directory %s.\n"), pWMADirName);
        goto exit;
    }

    if( ( WMADirHandle= _tfindfirst(TEXT("*"), &itemInfo) ) == -1 )
    {
        _ftprintf (stderr, TEXT("\nError: Can't find any file in  %s.\n"), pWMADirName);
        goto exit;
    }

    do {
        pNextDirName = itemInfo.name;
        if ((_tcslen(pWMADirName) + _tcslen(TEXT("\\")) + _tcslen(pNextDirName) + _tcslen(TEXT("\\"))) >= _MAX_PATH)
        {
            fputs("Error: File path too long.\n", stderr);
            break;
        }
        if ((_tcslen(pWAVDirName) + _tcslen(TEXT("\\")) + _tcslen(pNextDirName) + _tcslen(TEXT("\\"))) >= _MAX_PATH)
        {
            fputs("Error: file path too long.\n", stderr);
            break;
        }
        _tcsncpy(newWMASubDirName, pWMADirName, _MAX_PATH);
        newWMASubDirName[_MAX_PATH-1] = (TCHAR)'\0'; // Force a null termination, in case array got completely full
        _tcscat(newWMASubDirName, TEXT("\\"));
        _tcscat(newWMASubDirName, pNextDirName);

        _tcsncpy(newWAVSubDirName, pWAVDirName, _MAX_PATH);
        newWAVSubDirName[_MAX_PATH-1] = (TCHAR)'\0'; // Force a null termination, in case array got completely full
        _tcscat(newWAVSubDirName, TEXT("\\"));
        _tcscat(newWAVSubDirName, pNextDirName);

        if (itemInfo.attrib& _A_SUBDIR ) {
            // We see a dir.
            if (_tcscmp(itemInfo.name, TEXT(".")) && _tcscmp(itemInfo.name, TEXT("..")) ) {
                bGotOutDir = CreateDirectory (newWAVSubDirName, NULL);
                if (bGotOutDir == 0)
                {
                    dwErrCode = GetLastError();
                    if (ERROR_ALREADY_EXISTS != dwErrCode)
                    {
                        _ftprintf (stderr, TEXT("Error: Can't create the output directory %s.\n"), newWAVSubDirName);
                        break;
                    }
                }
                hr = decodeWMAFile2PCMRecursivelyInDir(newWMASubDirName, newWAVSubDirName, bForceExt, bDropPacket, FALSE,
                    nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
                    nMBRTargetStream,
                    bLimitPTSErrors,
                    cMaxPTSErrors);
            }
        }
        else
        {
            // We see a file.
            if ((_tcslen(newWAVSubDirName) + 4) > _MAX_PATH) {
                fputs("Error: File path too long.\n", stderr);
                break;
            }
            if (!_tcsicmp((newWAVSubDirName + max(_tcslen(newWAVSubDirName),4) - 4), TEXT(".wma")))
            {
                _tcscpy((newWAVSubDirName + _tcslen(newWAVSubDirName) - 4), TEXT(".wav"));
            }
            else {
                _tcscat(newWAVSubDirName, TEXT(".wav"));
            }
            hr = decodeWMAFile2PCM(newWMASubDirName, newWAVSubDirName, bForceExt, bDropPacket, NULL,
               nDecoderFlags, nDRCSetting, nDstChannelMask, nInterpResampRate,
               nMBRTargetStream,
               bLimitPTSErrors,
               cMaxPTSErrors);
        }

        if (_tfindnext(WMADirHandle, &itemInfo) == -1)
        {
            break;
        }
    }while ( WMA_OK == hr );
exit:
    if (WMADirHandle)
        _findclose(WMADirHandle);
    return hr;
}
#endif //WMALOSSLESS_TO_PCM

#ifdef PERFRM_TIMING
FILE* g_fpPerfrmLog = NULL;
#endif

#ifdef UNDER_CE
int decodeWMAFile2PCM(LPCTSTR pWMAFileName, LPCTSTR pWAVFileName, BOOL bForceExt, Bool bDropPacket, LPCTSTR pCMPFileName,
                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask,
                      U32 nInterpResampRate,
                      U16 nMBRTargetStream,
                      BOOL bLimitPTSErrors,
                      U16  cMaxPTSErrors)
#else
int decodeWMAFile2PCM(char * pWMAFileName, char * pWAVFileName, BOOL bForceExt, Bool bDropPacket, char * pCMPFileName,
                      U16 nDecoderFlags, U16 nDRCSetting, U32 nDstChannelMask,
                      U32 nInterpResampRate,
                      U16 nMBRTargetStream,
                      BOOL bLimitPTSErrors,
                      U16  cMaxPTSErrors)

#endif
{
    tWMA_U32 msSeekTo;

#ifdef UNDER_CE         // for taking timing on wince platform
	BOOL Flag;
	LARGE_INTEGER lpFrequency ;
	LARGE_INTEGER lpPerformanceCountBegin;
	LARGE_INTEGER lpPerformanceCountEnd;
	__int64 TotalDecTime=0;
	__int64 Temp;
	FILE *fp_performance;
#endif
#ifdef TEST_MARKER
    int k;
    MarkerEntry pEntry[5];
#endif
    PCMFormat pcmFormat;

    tWMAFileStatus rc;
    tWMA_U32 num_samples;
    tWMA_U32 nDecodedSamples;
    tWMA_U32 cFetchedSamples;
    int cCountGetPCM = 0;
    int cSeek = 0;
    float fltTimeExpected = 0;
//    const char *strOut = "d:\\test\\output.pcm";
//    const char *strLic = "drmv1pm.lic";
    const char *strLic = "c:\\ti_test\\files\\drmv1pm.new";
    tWMAFileContDesc  *pdesc = NULL;
    tWMAExtendedContentDesc *pECDesc;
    unsigned char szTemp [STRING_SIZE];
    int iRV = 1;    // assume error exit return value
    float fltDiffMax = 0.0F;
    tWMA_I64 iSampleTotal = 0;
    tWMA_U16 wMBRTotalStreams = 0;
    U16  cPTSErrors = 0;

#ifdef WMA_SEEK_MATCH
    FILE *pfTime = NULL;
    char *pszTmpFilename = NULL;
#endif // WMA_SEEK_MATCH

#ifdef WMDRM_NETWORK
    FILE *fpPrivKey = NULL;
    FILE *fpMessage = NULL;
    DRM_RSA_PRIVATE_KEY *pPrivKey = NULL;
    XMR_LICENSE *pXmrLicense = NULL;
    DRM_AES_KEY *pAESKey = NULL;
#endif

#ifdef WMALOSSLESS_TO_PCM
    Bool bUseWAVEXT = FALSE;
#endif //WMALOSSLESS_TO_PCM

#ifndef DISCARD_OUTPUT
#if WAV_OUT
    HWAVEOUT hWaveOut; /* device handle */
    WAVEFORMATEX wfx_out;

#endif
#ifdef DUMP_WAV
    WavFileIO *pwfioOut = wfioNew ();
    WAVEFORMATEXTENSIBLE wfx;
#else   /* DUMP_WAV */
    FILE *pfOutPCM = NULL;
#endif /* DUMP_WAV */
#endif // !DISCARD_OUTPUT
#if defined (OBNOXIOUS) || defined (REAL_OBNOXIOUS)
    tWMA_I64       tPresTime = 0;
#endif // OBNOXIOUS || REAL_OBNOXIOUS
#ifdef REAL_OBNOXIOUS
    time_t ulObnoxiousLoopCount = 0;
#endif
#ifdef MEASURE_CLOCK
    PERFTIMERINFO  *pPerfTimerInfo;
#endif  // MEASURE_CLOCK
#ifdef PERFRM_TIMING
    TCHAR szTmp[256];
    _tcscpy(szTmp, pWMAFileName); // I'm sure Prefix would have a heart attack
    _tcscat(szTmp, TEXT(".txt"));
    g_fpPerfrmLog = _tfopen(szTmp, TEXT("wt"));
#endif

    // reset global values for each file call.
    g_ulFullSec = 0;
    g_ulOutputSamples = 0;
#ifndef ARM9
    EnableRunFast();    //for WinCE
#endif
#ifdef PROFILE
    FUNCTION_PROFILE(fpDecode);
#endif  // PROFILE
    _tprintf(TEXT("\nConverting %s to %s\n"),pWMAFileName, pWAVFileName);
#ifdef UNDER_CE
    fp_performance = fopen("test_performance_result.xls","a+");
#endif
#ifdef WMA_SEEK_MATCH
    pszTmpFilename = _tempnam(".", "wmadecS");
    pfTime = fopen(pszTmpFilename, "w+b");
    if (pfTime == NULL) {
        fputs("** Can't open temp file.\n", stderr);
        goto lexit;
    }

#endif

#ifdef TEST_SPEED

	{
		long iBytesRead = 0;
		g_cbBuffer = 0;
		g_fpperform = _tfopen (pWMAFileName, TEXT("rb"));
		if(!g_fpperform)
		{
			printf("Input File Open Failed");
		}

		g_pBuffer = (unsigned char *)malloc(MAX_PERFORM_BUFFER_SIZE);
		if(!g_pBuffer)
		{
			printf("Buffer Allocation Failed for MAX_PERFORM_BUFFER_SIZE");
			goto lexit;
		}
			iBytesRead = fread(g_pBuffer+g_cbBuffer, 1, MAX_PERFORM_BUFFER_SIZE-g_cbBuffer, g_fpperform);
			if(MAX_PERFORM_BUFFER_SIZE == iBytesRead)
			{
				printf("File is bigger than allocated size");
				goto lexit;
			}
		g_cbBuffer += iBytesRead;
		fclose(g_fpperform);

	}
#endif//TEST_SPEED
#ifdef WMALOSSLESS_TO_PCM
/*
    if (argc < 3  || argc > 4 || ((argc == 4) && (_tcscmp(argv[3], TEXT("-ext"))))) {
        fputs("Convert Lossless WMA file to PCM WAV file.\n\n", stderr);
        fputs("wmal2pcm <input.wma> <output.wav> [-ext]\n\n", stderr);
        fputs("       input.wma       Specifies the WMA file to convert\n", stderr);
        fputs("       output.wav      Specifies the output WAV file\n", stderr);
        fputs("       -ext            Force the output WAV format to be WAVEFORMATEXTENSIBLE\n", stderr);
        goto lexit;
    }
    if (argc == 4) {
        if (!_tcscmp(argv[3],TEXT("-ext"))) {
            bUseWAVEXT = TRUE;
        }
    }
*/
    if (bForceExt)
        bUseWAVEXT = TRUE;
#else
    /*
    if (argc < 3) {
        fputs("** Too few arguments.\n", stderr);
        goto lexit;
    }
    */
#endif //WMALOSSLESS_TO_PCM

    g_fp = _tfopen (pWMAFileName, TEXT("rb"));
    if (g_fp == NULL) {
        _ftprintf(stderr, TEXT("** Cannot open %s.\n"), pWMAFileName);
        goto lexit;
    }

    /* init struct */
    memset ((void *)&g_hdrstate, 0, sizeof(g_hdrstate));
    memset ((void *)&g_state, 0, sizeof(g_state));
    memset ((void *)&g_hdr, 0, sizeof(g_hdr));

#ifdef OBNOXIOUS
    // try to close interface which is not yet open
    WMAFileDecodeClose (&g_state);
    // try to get PCM data now

    num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight,
                  sizeof(g_pLeft), MAX_SAMPLES, &tPresTime);

    if ( num_samples > 0 )
    {
        fprintf( stderr, "** Obnoxious WMAFileGetPCM returns %d samples.\n", num_samples);
        assert( num_samples <= 0 );
    }
    // try to decode data

    rc = WMAFileDecodeData(g_state, &nDecodedSamples);

    if ( rc == cWMA_NoErr )
    {
        fputs("** Obnoxious WMAFileDecodeData returns NoErr.\n", stderr );
        assert( rc != cWMA_NoErr );
    }
    // try some other stuff as well
    rc = WMAFileDecodeInfo (g_state, &g_hdr);
    if ( rc == cWMA_NoErr )
    {
        fputs( "** Obnoxious WMAFileDecodeInfo returns NoErr.\n", stderr );
        assert( rc != cWMA_NoErr );
    }
    rc = WMAFileContentDesc (g_state, &pdesc);
    if ( rc == cWMA_NoErr )
    {
        fputs( "** Obnoxious WMAFileContentDesc returns NoErr.\n", stderr );
        assert( rc != cWMA_NoErr );
    }
#endif

    /* test the checking API */
    rc = WMAFileSetTargetMBRAudioStream(&g_hdrstate, nMBRTargetStream);
    if(rc != cWMA_NoErr)
    {
        fputs("** Error while setting target stream number.\n", stderr);
        goto lexit;
    }

    rc = WMAFileIsWMA (&g_hdrstate);
    if(rc != cWMA_NoErr)
    {
        fputs("** The file is not a WMA file.\n", stderr);
        goto lexit;
    }

    // Check for MBR
    rc = WMAFileMBRAudioStreams(&g_hdrstate, &wMBRTotalStreams);
    if(rc != cWMA_NoErr)
    {
        fputs("** Error while verifying MBR information.\n", stderr);
        goto lexit;
    }

    if (wMBRTotalStreams > 1)
    {
        fputs("\n** This is an MBR (Multiple Bit Rates) file\n", stdout);
        fprintf(stdout, "Decoding audio stream %d out of %d audio streams\n",
            nMBRTargetStream, wMBRTotalStreams);
        fputs("Use -mbr option to decode a different stream\n\n", stdout);
    }

//test Marker
#ifdef TEST_MARKER
    for ( k = 0 ; k < 5 && k < WMAGetNumberOfMarkers(&g_hdrstate); k++)
    {
         WMAGetMarker(&g_hdrstate, k, &pEntry[k]);
    }
#endif

    /* init the decoder */

    rc = WMAFileDecodeCreate (&g_state);
    if(rc != cWMA_NoErr)
    {
        fputs("** Cannot create the WMA decoder.\n", stderr);
        goto lexit;
    }

#ifdef WMDRM_NETWORK
    {
        BYTE bPrivKey[ 16 * 1024 ];
        size_t cbPrivKey;

        BYTE bMessageBuf[ 16 * 1024 ];
        size_t cbMessage;

        DRM_RESULT dr;
        DRM_BYTE *pbLicense;
        DRM_DWORD cbLicense;

        //
        // For the sake of example we read the private key from "privkey.bin".
        // In the real world, HrdManufactureDevice() should be used to set up
        // the device information (including the private key). Refer to the
        // documentation for details.
        //
        // This code only demonstrates the decrypting of WMDRM-ND encrypted
        // content, so we will pass in the private key directly to the
        // functions where its needed. It is not recommend that your code pass
        // the private key around in this manner.
        //
        fpPrivKey = _tfopen( TEXT( "privkey.bin" ), TEXT( "rb" ) );
        if( NULL == fpPrivKey )
        {
            goto lexit;
        }

        cbPrivKey = fread( bPrivKey, sizeof( BYTE ), 16 * 1024, fpPrivKey );
        if( 0 == cbPrivKey )
        {
            goto lexit;
        }

        dr = OEM_DrmRsaSetPrivateKey( bPrivKey,
                                      cbPrivKey,
                                      &pPrivKey );
        if ( dr != DRM_SUCCESS ) {
            goto lexit;
        }

        //
        // For the sake of example we read the license response message from
        // "message.bin". Modify this code as needed to acquire the "real"
        // license response message.
        //
        fpMessage = _tfopen (TEXT("message.bin"), TEXT("rb"));
        if (fpMessage == NULL) {
            goto lexit;
        }

        cbMessage = fread( bMessageBuf, sizeof( BYTE ), 16 * 1024, fpMessage );
        if( 0 == cbMessage ) {
            goto lexit;
        }

        dr = WmdrmNetUnpackLicenseResponseMessage( bMessageBuf,
                                                   cbMessage,
                                                   &pbLicense,
                                                   &cbLicense );
        if ( dr != DRM_SUCCESS ) {
            goto lexit;
        }

        //
        // Per the comment above, pPrivKey should be changed to NULL in real
        // implementations.
        //
        dr = DrmXmrUnpackLicense( pPrivKey, pbLicense, cbLicense, &pXmrLicense );
        if ( dr != DRM_SUCCESS ) {
            goto lexit;
        }

        //
        // Per the comment above, pPrivKey should be changed to NULL in real
        // implementations.
        //
        dr = DrmXmrGetKeyFromLicense( pPrivKey, pXmrLicense, TRUE, &pAESKey );
        if ( dr != DRM_SUCCESS ) {
            goto lexit;
        }

        rc = WMASetWMDRMNetworkAESKey( g_state, pAESKey );
        if(rc != cWMA_NoErr)
        {
            goto lexit;
        }
    }
#endif

    rc = WMAFileDecodeInitEx (g_state, nDecoderFlags, nDRCSetting, bDropPacket,
                              nDstChannelMask, nInterpResampRate, &pcmFormat,
                              nMBRTargetStream);
    if(rc != cWMA_NoErr)
    {
        fputs("** Cannot initialize the WMA decoder.\n", stderr);
        goto lexit;
    }
#ifdef WMALOSSLESS_TO_PCM
    rc = WMAFileIsLosslessWMA (g_state);
    if (rc != cWMA_NoErr)
    {
        fputs("** Unsupported input format. Must be WMA Lossless.\n", stderr);
        goto lexit;
    }
#endif //WMALOSSLESS_TO_PCM

#ifdef OBNOXIOUS
    // Init twice for good measure
    rc = WMAFileDecodeCreate (&g_state);
    if(rc != cWMA_NoErr)
    {
        fputs("** Cannot create the WMA decoder.\n", stderr);
        goto lexit;
    }
    rc = WMAFileDecodeInitEx (g_state, nDecoderFlags, nDRCSetting, bDropPacket,
                              nDstChannelMask, nInterpResampRate, &pcmFormat,
                              nMBRTargetStream);
    if(rc != cWMA_NoErr)
    {
        fputs("** Cannot initialize the WMA decoder.\n", stderr);
        goto lexit;
    }
#endif

    /* get header information */

    rc = WMAFileDecodeInfo (g_state, &g_hdr);
    if(rc != cWMA_NoErr)
    {
        fputs("** Failed to retrieve information.\n", stderr);
        goto lexit;
    }

    /* get content description */

    rc = WMAFileContentDesc (g_state, &pdesc);
    if(rc != cWMA_NoErr)
    {
        fputs("** Failed to retrieve content description.\n", stderr);
        goto lexit;
    }

    /* display information */

    if (NULL != pdesc)
    {
        szTemp[0] = 0;
        wcstombs(szTemp, (wchar_t*)pdesc->pTitle, pdesc->title_len);
        printf("++            Song title: %s\n", szTemp);
        szTemp[0] = 0;
        wcstombs(szTemp, (wchar_t*)pdesc->pAuthor, pdesc->author_len);
        printf("++                Author: %s\n", szTemp);
        szTemp[0] = 0;
        wcstombs(szTemp, (wchar_t*)pdesc->pCopyright, pdesc->copyright_len);
        printf("++             Copyright: %s\n", szTemp);
        szTemp[0] = 0;
        wcstombs(szTemp, (wchar_t*)pdesc->pDescription, pdesc->description_len);
        printf("++           Description: %s\n", szTemp);
        szTemp[0] = 0;
        wcstombs(szTemp, (wchar_t*)pdesc->pRating, pdesc->rating_len);
        printf("++                Rating: %s\n", szTemp);
    }

    rc = WMAFileExtendedContentDesc (g_state, &pECDesc);

    if(rc != cWMA_NoErr)
    {
        fputs("** Failed to retrieve extended content description.\n", stderr);
        goto lexit;
    }

    printf("++ WMA bitstream version: %d\n", g_hdr.version);
    printf("++         sampling rate: %ld Hz\n", g_hdr.sample_rate);
    g_SampleRate = g_hdr.sample_rate;
    printf("++         # of channels: %d\n", g_hdr.num_channels);
    printf("++              bit-rate: %ld bps\n", g_hdr.bitrate);
    printf("++              duration: %ld ms\n", g_hdr.duration);
    printf("++           DRM content: %s\n", g_hdr.has_DRM ? "Yes" : "No");

    /* if DRM, init with the license file */

#ifndef WMAAPI_NO_DRM
    if(g_hdr.has_DRM)
    {
        tWMADateParams currentDate;
    	SYSTEMTIME stDate;

        g_lic.pPMID = (unsigned char *)&g_pmid;
        g_lic.cbPMID = sizeof(g_pmid);

    	GetSystemTime(&stDate);
	    SysDateToLicDate(&stDate, &currentDate);


        rc = WMAFileLicenseInit (g_state, &g_lic, WMA_SDMI_LIC, currentDate);
        if(rc != cWMA_NoErr)
        {
            fprintf(stderr, "** WMALicenseInit failed (%u).\n", rc);
            goto lexit;
        }
    }
#endif //WMAAPI_NO_DRM

#ifndef DISCARD_OUTPUT
#ifdef DUMP_WAV
    // Process the PCMFormat decoded in WMAFileDecodeInit to arrive at wav file format

    if (PCMDataIEEE_FLOAT == pcmFormat.pcmData &&
        pcmFormat.nChannels > 2)
    {
        // Floating point output beyond stereo shall use extensible file
        PCMFormat2WaveFormatExtensible(&pcmFormat, &wfx);
    }
    else if (PCMDataIEEE_FLOAT == pcmFormat.pcmData &&
        pcmFormat.nChannels <= 2)
    {
        PCMFormat2WaveFormatEx(&pcmFormat, &wfx.Format);
    }
    else if (pcmFormat.nChannels > 2 ||
             (0 != (pcmFormat.nValidBitsPerSample % 8)) ||
             pcmFormat.cbPCMContainerSize > 2 ||
             pcmFormat.cbPCMContainerSize * 8 != pcmFormat.nValidBitsPerSample)
    {
        PCMFormat2WaveFormatExtensible(&pcmFormat, &wfx);
    }
    else
    {
        PCMFormat2WaveFormatEx(&pcmFormat, &wfx.Format);
    }
    /*
    wfx.Format.wFormatTag      = g_hdr.pcm_format_tag;
    wfx.Format.nSamplesPerSec  = g_SampleRate;
    wfx.Format.nChannels       = g_hdr.num_channels;
    wfx.Format.wBitsPerSample  = g_hdr.bits_per_sample;
    wfx.Format.nBlockAlign     = ((wfx.Format.wBitsPerSample + 7) / 8) * wfx.Format.nChannels;
    wfx.Format.nAvgBytesPerSec = wfx.Format.nBlockAlign * wfx.Format.nSamplesPerSec;
    wfx.Samples.wValidBitsPerSample    = g_hdr.valid_bits_per_sample;
    wfx.dwChannelMask          = g_hdr.channel_mask;
    wfx.SubFormat.Data1        = g_hdr.subformat_data1;
    wfx.SubFormat.Data2        = g_hdr.subformat_data2;
    wfx.SubFormat.Data3        = g_hdr.subformat_data3;
    memcpy(wfx.SubFormat.Data4, g_hdr.subformat_data4, 8);
*/

#ifdef WMALOSSLESS_TO_PCM
    // Use the default WAV format.
    if (wfx.Format.wBitsPerSample  <= 16 && wfx.Format.nChannels <= 2 && wfx.Format.nSamplesPerSec <= 48000) {
        wfx.Format.wFormatTag = WAVE_FORMAT_PCM;
    }
    else {
        wfx.Format.wFormatTag = WAVE_FORMAT_EXTENSIBLE;
    }
    // Force to use EXTENSIBLE format.
    if (bUseWAVEXT) {
        wfx.Format.wFormatTag = WAVE_FORMAT_EXTENSIBLE;
    }
    wfx.dwChannelMask          = g_hdr.channel_mask;
#endif //WMALOSSLESS_TO_PCM

    if (wfx.Format.wFormatTag == WAVE_FORMAT_PCM ||
        wfx.Format.wFormatTag == WAVE_FORMAT_IEEE_FLOAT)
    {
        wfx.Format.cbSize          = 0;
    }
    else if (wfx.Format.wFormatTag == WAVE_FORMAT_EXTENSIBLE)
    {
        wfx.Format.cbSize          = 22;
    }
    else
    {
        assert(0);
    }

#ifdef USE_SPDTX
    wfx.Format.wFormatTag = 0x164;// WAVE_FORMAT_WMASPDIF;
    wfx.Format.nChannels  = 2;
    wfx.Format.nBlockAlign = 4;
    wfx.Format.nAvgBytesPerSec = wfx.Format.nSamplesPerSec * 8;
    wfx.Format.wBitsPerSample = 16;
#endif

    if(wfioOpen (pwfioOut, pWAVFileName, &wfx, sizeof(wfx), wfioModeWrite) != 0) {
        fputs("Can't create file\n", stderr);
        exit(1);
    }

#if	WAV_OUT
		 /*
		 * initialise the module variables
		 */
		waveBlocks		   = allocateBlocks(BLOCK_SIZE, BLOCK_COUNT);
		waveFreeBlockCount = BLOCK_COUNT;
		waveCurrentBlock   = 0;

		InitializeCriticalSection(&waveCriticalSection);
		/*
		 * set up the WAVEFORMATEX structure.
		 */
		wfx_out.nSamplesPerSec	= g_hdr.sample_rate;  /* sample rate */
		wfx_out.wBitsPerSample	= wfx.Format.wBitsPerSample;	 /* sample size */
		wfx_out.nChannels		= g_hdr.num_channels;	   /* channels	  */
		wfx_out.cbSize			= 0;	  /* size of _extra_ info */
		wfx_out.wFormatTag		= WAVE_FORMAT_PCM;
		wfx_out.nBlockAlign 	= (wfx_out.wBitsPerSample * wfx_out.nChannels) >> 3;
		wfx_out.nAvgBytesPerSec = wfx_out.nBlockAlign * wfx_out.nSamplesPerSec;
		if(waveOutOpen(
			&hWaveOut,
			WAVE_MAPPER,
			&wfx_out,
			(DWORD_PTR)waveOutProc,
			(DWORD_PTR)&waveFreeBlockCount,
			CALLBACK_FUNCTION
		) != MMSYSERR_NOERROR) {
			ExitProcess(1);
		}

#endif
#else   /* DUMP_WAV */
    pfOutPCM = _tfopen (pWAVFileName, TEXT("wb"));
    if (pfOutPCM == NULL) {
        _ftprintf(stderr, TEXT("** Cannot open output file %s.\n"), pWAVFileName);
        goto lexit;
    }
#endif // DUMP_WAV
#endif // !DISCARD_OUTPUT

#if defined(WMA2CMP) && defined(DUMP_WAV) && !defined(DISCARD_OUTPUT)
    if (pCMPFileName)
    {
        //setup the output bitstream file in private format
        WAVEFORMATEXTENSIBLE  wfxCMP;
        tWMAFileHdrStateInternal *pInt = (tWMAFileHdrStateInternal *)(&g_hdrstate);

        if ((pfWma2Cmp = _tfopen (pCMPFileName, TEXT("wb"))) == NULL) {
            _ftprintf (stderr, TEXT("Can't create file %s\n"), pCMPFileName);
            exit (1);
        }

        wfxCMP = wfx;
        wfxCMP.Format.nBlockAlign = (U16)(pInt->nBlockAlign);

        if (pInt->nVersion==1)         {
            wfxCMP.Format.cbSize = sizeof(MSAUDIO1WAVEFORMAT) - sizeof(WAVEFORMATEX);
            fwrite (&wfxCMP, sizeof (U8), sizeof (WAVEFORMATEX), pfWma2Cmp);
            {
                U16 dwStupidNumber = (U16)MaxSamplesPerPacket(1, pInt->nSamplesPerSec, pInt->nChannels, pInt->nAvgBytesPerSec*8);
                fwrite (&dwStupidNumber , sizeof (U16), 1, pfWma2Cmp);
            }
        } else if (pInt->nVersion >= 2) {
            wfxCMP.Format.cbSize = sizeof(WMAUDIO2WAVEFORMAT) - sizeof(WAVEFORMATEX);
            if (pInt->wFormatTag == WAVE_FORMAT_PCM) {
                fwrite (&wfxCMP, sizeof (U8), sizeof (WAVEFORMATEX), pfWma2Cmp);
            } else if (pInt->wFormatTag == WAVE_FORMAT_EXTENSIBLE) {
                assert (pInt->nVersion > 2);
                COPY_KSDATAFORMAT_SUBTYPE_PCM(&(wfxCMP.SubFormat));
                wfxCMP.SubFormat.Data1 = WAVE_FORMAT_WMAUDIO3;
                wfxCMP.Format.cbSize += 22; // Size needed for wValidBitsPerSample, dwChannelMask,  SubFormat.
                fwrite (&wfxCMP, sizeof (U8), sizeof (WAVEFORMATEXTENSIBLE), pfWma2Cmp);
            }
            //should be this; but to be compatible with V4RTM...
            //fwrite (&dwSamplesPerFrame, sizeof (U32), 1, pfWma2Cmp);
            {
                //this is sent but only used by the decoder for some unnecessary
                //computation. We need to fudge this number so that the V4 decoder
                //can work without any change. The following is the smallest
                //number that can safely fool the old decoder.
                U32 dwStupidNumber = MaxSamplesPerPacket(2, pInt->nSamplesPerSec, pInt->nChannels, pInt->nAvgBytesPerSec*8);
                fwrite (&dwStupidNumber , sizeof (U32), 1, pfWma2Cmp);
            }
        } else {
            assert(0);  // Unknown translation.
        }

        if (pInt->nVersion <= 2) {
            I16 nEncodeOpt = pInt->nEncodeOpt;
            fwrite (&nEncodeOpt, sizeof (U16), 1, pfWma2Cmp);
        }
        // V3 Pure LLM. Chao. Add.
        // syntax change for Pure LLM .cmp file.
        else if (pInt->nVersion >= 3) {
            I16 nEncodeOpt = pInt->nEncodeOpt;
            fwrite (&nEncodeOpt, sizeof (U16), 1, pfWma2Cmp);
        }

        {
            U32 nAvgBytesPerSec = pInt->nAvgBytesPerSec;
            fwrite (&nAvgBytesPerSec, sizeof (U32), 1, pfWma2Cmp);
        }
        if (pInt->nVersion > 2) {
            // Additional stuff for V3
            U16 wFormatTagOrig;
            if (wfxCMP.Format.nChannels <= 2 && wfxCMP.Format.wBitsPerSample == 16)
                wFormatTagOrig = WAVE_FORMAT_PCM;
            else
                wFormatTagOrig = WAVE_FORMAT_EXTENSIBLE;
            fwrite (&wFormatTagOrig, sizeof (U16), 1, pfWma2Cmp);
        }
    }
#endif // WMA2CMP

    HEAP_DEBUG_CHECK;

    //iMarkerNum = WMAGetMarkers(&g_hdrstate, &pEntry);

    /* decoding loop */
#ifdef MEASURE_CLOCK
    pPerfTimerInfo = PerfTimerNew( g_SampleRate * g_hdr.num_channels );
    if (NULL == pPerfTimerInfo)
    {
        fputs("Could not allocate perf timer structure\n", stderr);
        exit(1);
    }
#endif
#ifdef PROFILE
    Profiler_init(_T("profile.txt"));
#endif
#ifdef MEASURE_CLOCK
    PerfTimerStart(pPerfTimerInfo);
#endif  // MEASURE_CLOCK
#ifdef PROFILE
    FUNCTION_PROFILE_START(&fpDecode,MSAC_DECODE_PROFILE);
#endif  // PROFILE
    g_ulStartFirstSec = time(NULL);

    msSeekTo = 0;
#if defined(AUTOPC_STYLE)

    do
    {
        rc = AutoPCReadNext( MAX_SAMPLES, g_pLeft, &num_samples );
        if ( rc == WMA_S_NO_MORE_SRCDATA )
        {
            iRV = 0;
            break;
        }
        if ( rc != cWMA_NoErr )
        {   // an error occured
            iRV = 2;        // error decoding data
            goto lexit;
        }

#ifndef DISCARD_OUTPUT

#       ifdef DUMP_WAV
            wfioWrite (pwfioOut, (U8*) g_pLeft, num_samples );
#       else   /* DUMP_WAV */
            fwrite (g_pLeft, sizeof (short), num_samples / sizeof(short), pfOutPCM);
#       endif // DUMP_WAV

#endif // !DISCARD_OUTPUT
    } while (1);

#else  // so not AUTOPC_STYLE
    do
    {
#       ifdef OBNOXIOUS
            // try to get PCM data now
            num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft), MAX_SAMPLES, &tPresTime);
            if ( num_samples > 0 )
            {
                fprintf( stderr, "** Obnoxious WMAFileGetPCM returns %d samples.\n", num_samples);
                assert( num_samples <= 0 );
            }
#       endif

#ifdef UNDER_CE						//Timing starts for decode call
       Flag=QueryPerformanceFrequency(&lpFrequency);
	   Flag=QueryPerformanceCounter(&lpPerformanceCountBegin);
#endif
#ifdef USE_SPDTX
        rc = WMAFileDecodeToSpdif( g_state, &nDecodedSamples );
#else
        rc = WMAFileDecodeData(g_state, &nDecodedSamples);
#endif
#ifdef UNDER_CE						//Timing Ends for Decode call
		Flag=QueryPerformanceCounter(&lpPerformanceCountEnd);
		Temp=(((lpPerformanceCountEnd.QuadPart - lpPerformanceCountBegin.QuadPart)*1000000)/(lpFrequency.QuadPart));
		TotalDecTime += Temp;
#endif

#ifdef _MARKERDEMO_
        if (msSeekTo==0)
            msSeekTo ++;
        if (msSeekTo == 1)
        {
            tWMA_U32 msReturned;
            msSeekTo = 2;
            msSeekTo = pEntry[3].m_dwSendTime;
//            msSeekTo = pEntry[1].m_qtime.dwLo/10000;
            rc = WMAFileSeek(g_state, msSeekTo, &msReturned);
        }
#endif //_MARKERDEMO_

        if(rc != cWMA_NoErr)
        {
            g_ulEndSec = time(NULL);
            //wchen: I don't understand why failed is normal
            if ( rc == cWMA_NoMoreFrames || rc == cWMA_Failed )
            {
                iRV = 0;        // normal exit
                break;
            }
            else {
                iRV = 2;        // error decoding data
                fputs("DECODING ERR: decoding failed", stderr);
                goto lexit;
            }
        }

        cFetchedSamples = 0;

        if( 0 < nDecodedSamples ) do
        {
#ifdef USE_SPDTX
            tWMA_U8 *pB = g_pBurst;
#else
            short *pL = g_pLeft;
            short *pR = g_pRight;
#endif
            tWMA_I64 tPresTime = 0;
            float    fltDiff = 0;

#ifdef REAL_OBNOXIOUS
            if ( (++ulObnoxiousLoopCount % 101) == 0 || (ulObnoxiousLoopCount%1009)==0 )
            {
                // skip getting these PCM samples and see if interface recovers
                break;
            }
#endif
            HEAP_DEBUG_CHECK;
            cCountGetPCM++;

#ifdef USE_SPDTX
            num_samples = WMAFileGetSpdifBurst (g_state, g_pBurst, MAX_BURST, &tPresTime);
#else
            assert(cFetchedSamples <= nDecodedSamples);
            num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft),
                nDecodedSamples - cFetchedSamples, &tPresTime);
#endif
            if (num_samples != 0)
            {
                fltDiff = 0;
                // TODO: I think after checkin 92712 we don't need below block anymore. We should
                // get tPresTime == 0 at the beginning.
                if (fltTimeExpected != 0)
                {
                    fltDiff = (float) tPresTime / 10000.0F - fltTimeExpected;
                    if (fabs(fltDiff) > fltDiffMax)
                        fltDiffMax = fltDiff;
                }
#ifndef USE_SPDTX
#ifndef PERFRM_TIMING
                if (!(nDecoderFlags & DECOPT_HALF_TRANSFORM) &&
                     (fltDiff > 2.0F || fltDiff < -2.0F) &&
                     (cPTSErrors < cMaxPTSErrors || !bLimitPTSErrors))
                {
                    printf("Presentation time is off by: %f ms\n", fltDiff);
                    printf("Presentation time expected: %f ms\n", fltTimeExpected);
                    printf("Presentation time received: %f ms\n", tPresTime / 10000.0F);
                    fflush (stdout);
                    if (bLimitPTSErrors)
                    {
                        cPTSErrors++;
                        if (cPTSErrors == cMaxPTSErrors)
                        {
                            printf("Reached max Presentation time error count. "
                "Further Presentation time errors will not be reported.\n");
                        }
                    }
                }
#endif
#endif
                fltTimeExpected = (float) tPresTime / 10000.0F + (float) num_samples / g_SampleRate * 1000;

#ifdef WMA_SEEK_MATCH
                //tPresTime = ((tPresTime + 5000) / 10000) * 10000; //round to ms
                fwrite (&tPresTime, sizeof (tWMA_I64), 1, pfTime);
                fwrite (&iSampleTotal, sizeof (tWMA_I64), 1, pfTime);
                iSampleTotal += num_samples;
#endif // WMA_SEEK_MATCH

            }

            cFetchedSamples += num_samples;
            if (num_samples == 0)
            {
                /* no more, so on with the decoding... */
                break;
            }

#ifndef DISCARD_OUTPUT

#   ifdef MEASURE_CLOCK
            PerfTimerStop(pPerfTimerInfo, num_samples * g_hdr.num_channels );
#   endif  // MEASURE_CLOCK
#ifdef PROFILE
            FUNCTION_PROFILE_STOP(&fpDecode);
#endif  // PROFILE

#ifdef USE_SPDTX
            wfioWrite (pwfioOut, (U8*) g_pBurst, num_samples * wfx.Format.nChannels * wfx.Format.wBitsPerSample/8);
#else
#   ifdef TEST_INTERLEAVED_DATA
#       ifdef DUMP_WAV
#if WAV_OUT
	{
		int out_bytes = 	num_samples * wfx.Format.nChannels * wfx.Format.wBitsPerSample/8;
		writeAudio(hWaveOut, (U8*) g_pLeft, out_bytes);
	}
#else
			wfioWrite (pwfioOut, (U8*) g_pLeft, num_samples * wfx.Format.nChannels * wfx.Format.wBitsPerSample/8);
#endif
#       else   /* DUMP_WAV */
            fwrite (g_pLeft, 1, num_samples * g_hdr.num_channels * g_hdr.bits_per_sample/8, pfOutPCM);
#       endif // DUMP_WAV
#   else    // TEST_INTERLEAVED_DATA
            {
                unsigned int i;
                for( i = 0; i < num_samples; i++ ) {
#                   ifdef DUMP_WAV
                        wfioWrite (pwfioOut, (U8*)(g_pLeft+i), sizeof (short));
                        if ( g_hdr.num_channels == 2 )
                            wfioWrite (pwfioOut, (U8*)(g_pRight+i), sizeof (short));
#                   else   /* DUMP_WAV */
                        fwrite (g_pLeft+i, sizeof (short), 1, pfOutPCM);
                        if ( g_hdr.num_channels == 2 )
                            fwrite (g_pRight+i, sizeof (short), 1, pfOutPCM);
#                   endif // DUMP_WAV
                }
            }
#   endif   // TEST_INTERLEAVED_DATA
#endif
#ifdef PROFILE
            FUNCTION_PROFILE_START(&fpDecode,MSAC_DECODE_PROFILE);
#endif  // PROFILE

#   ifdef MEASURE_CLOCK
            PerfTimerStart(pPerfTimerInfo);
#   endif  // MEASURE_CLOCK

#endif // !DISCARD_OUTPUT

// #define BREAK_AT_SAMPLE 146431 /* tough_16m_16.wma overflow of noise_subst_level in next frame */
//#define BREAK_AT_SAMPLE 50680  /* dire_200k_wmaV1_16k16kHzM.wma unstable frame after this */
#define BREAK_AT_SAMPLE 68000
#ifdef BREAK_AT_SAMPLE
            if ( g_ulOutputSamples <= BREAK_AT_SAMPLE && BREAK_AT_SAMPLE < (g_ulOutputSamples+num_samples) )
            { int j; j = (int)g_ulOutputSamples; }
#endif //BREAK_AT_SAMPLE

#if defined(PRINT_FROM_SAMPLE) && defined(PRINT_TO_SAMPLE)
            if ( g_ulOutputSamples <= PRINT_FROM_SAMPLE && PRINT_FROM_SAMPLE < (g_ulOutputSamples+num_samples) )
            { bPrintDctAtFrame = 0xff0; }   // flag wma_api.cpp to print coefs
            else if ( g_ulOutputSamples <= PRINT_TO_SAMPLE && PRINT_TO_SAMPLE < (g_ulOutputSamples+num_samples) )
            { bPrintDctAtFrame = 0; }
#endif

            g_ulOutputSamples += num_samples;

        } while(cFetchedSamples <  nDecodedSamples);
        assert (cFetchedSamples == nDecodedSamples);

    } while (1);
#endif // not AUTOPC_STYLE
#if WAV_OUT
 {
    int i;
    while(waveFreeBlockCount < BLOCK_COUNT)
        Sleep(10);

    /*
     * unprepare any blocks that are still prepared
     */
    for(i = 0; i < waveFreeBlockCount; i++)
        if(waveBlocks[i].dwFlags & WHDR_PREPARED)
            waveOutUnprepareHeader(hWaveOut, &waveBlocks[i], sizeof(WAVEHDR));


    DeleteCriticalSection(&waveCriticalSection);
    freeBlocks(waveBlocks);
    waveOutClose(hWaveOut);
 }
#endif // not AUTOPC_STYLE

    g_ulFullSec   = g_ulEndSec - g_ulStartFirstSec;

#ifdef PROFILE
    FUNCTION_PROFILE_STOP(&fpDecode);
#endif  // PROFILE
#ifdef MEASURE_CLOCK
    PerfTimerStopElapsed(pPerfTimerInfo);
#   ifndef DISCARD_OUTPUT
        PerfTimerStop(pPerfTimerInfo, 0 );
#   else
        PerfTimerStop(pPerfTimerInfo, g_ulOutputSamples * g_hdr.num_channels );
#   endif
#endif  // MEASURE_CLOCK

    HEAP_DEBUG_CHECK;

    printf("Full Read and Decode took %d s.\r\nPlay Time would be %d s.\r\n",
        (UInt)g_ulFullSec, (UInt)(g_ulOutputSamples/g_SampleRate));


#ifdef UNDER_CE
	//printf("\n lpPerformanceCount in us =%ld\n",TotalDecTime);
	_ftprintf(fp_performance, TEXT("%s \t"), pWMAFileName);
	fprintf(fp_performance,"%d \t%ld \t \t%ld\n",g_SampleRate,g_ulOutputSamples,TotalDecTime);
	fclose(fp_performance);
#endif //UNDER_CE
#if defined (TEST_PEAKRATE)
    _ftprintf (stderr, TEXT("%s %f\n"), pWMAFileName, (Float)g_iLargestFrame * (Float)g_hdr.sample_rate/(Float)g_cSamplesPerFrame);
#endif


#ifdef PROFILE
    {
        char szProfileMsg[400];
        DWORD dwDecodeTime = g_ulFullSec*1000;
#       ifdef MEASURE_CLOCK
            dwDecodeTime = (DWORD)(fltPerfTimerDecodeTime(pPerfTimerInfo)*1000);
#       endif // MEASURE_CLOCK
        if (NULL != pdesc)
        {
           sprintf( szProfileMsg, "%d bps\r\n%d Hz,%d chans\r\n%d ms\r\n%s\r\n%s\r\n%s\r\nTrack = %d\r\nClock = %d\r\nIdle  = %d\r\n\r\n",
                g_hdr.bitrate, g_SampleRate, g_hdr.num_channels, g_hdr.duration,
                pdesc->pTitle, pdesc->pAuthor, pdesc->pDescription,
                0, dwDecodeTime, 0
                );
        }
        else
        {
           sprintf( szProfileMsg, "%d bps\r\n%d Hz,%d chans\r\n%d ms\r\nTrack = %d\r\nClock = %d\r\nIdle  = %d\r\n\r\n",
                g_hdr.bitrate, g_SampleRate, g_hdr.num_channels, g_hdr.duration,
                0, dwDecodeTime, 0
                );



        }
        Profiler_closeEX((unsigned int)(g_hdr.duration),dwDecodeTime,szProfileMsg);
    }
#endif  // PROFILE

#ifdef MEASURE_CLOCK
    PerfTimerReport(pPerfTimerInfo);
    PerfTimerFree(pPerfTimerInfo);
#endif  // MEASURE_CLOCK

#ifdef OBNOXIOUS
    // try to get PCM data now
    num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft), MAX_SAMPLES, &tPresTime);
    if ( num_samples > 0 )
        fprintf(stderr, "** Obnoxious WMAFileGetPCM returns %d samples.\n", num_samples);
    // try to decode data
    rc = WMAFileDecodeData(g_state, &nDecodedSamples);
    if ( rc == cWMA_NoErr )
        fputs("** Obnoxious WMAFileDecodeData returns NoErr.\n", stderr );
#endif

#ifdef WMA_SEEK_TEST
//    #define SEEK_TEST_EVERYPACKET
    #define MAX_SEEK_TEST 100
    #define MAX_SEEK_DECODE 100
    #define MIN_SEEK_MATCH 64

    #if !defined (TEST_INTERLEAVED_DATA)
    #error Must define TEST_INTERLEAVED_DATA
    #endif

    #if !defined (DUMP_WAV)
    #error Must define DUMP_WAV
    #endif

    #if defined (DISCARD_OUTPUT)
    #error Can't define DISCARD_OUTPUT
    #endif

    #if defined (AUTOPC_STYLE)
    #error Can't define AUTOPC_STYLE
    #endif

    if (pwfioOut)
        wfioDelete(pwfioOut);
    else
    {
        iRV = 9;
        fputs("SEEK ERR: Can't reopen input file\n", stderr);
        goto lexit;
    }
    pwfioOut = wfioNew ();
    if(wfioOpen (pwfioOut, pWAVFileName, &wfx, sizeof(wfx), wfioModeRead) != 0)
    {
        fputs("SEEK ERR: Can't reopen input file\n", stderr);
        iRV = 10;
        goto lexit;
    }

    {
        unsigned randVal = (unsigned)time( NULL );
        printf("Random Seed for WMA_SEEK_TEST = %d\n", randVal);
        srand( randVal );
    }

    cSeek = MAX_SEEK_TEST;
#ifdef SEEK_TEST_EVERYPACKET
    cSeek = g_hdr.duration;
#endif
    // skip seek test for LBR versions >= 2 for now
    if (g_hdr.version >= 3 && WMAFileLBRVersion(g_state) >= 2)
    {
        fputs("Seek test skipped for LBR version >= 2\n", stderr);
        goto seekTestDone;
    }

    if (g_hdr.version <= 2 && WMAFileNoiseSubUsed(g_state) == 1)
    {
        fputs("Seek test skipped for noise sub\n", stderr);
        goto seekTestDone;
    }

    while (cSeek > 0)
    {
        int iDecode = MAX_SEEK_DECODE;

#       ifdef DUMP_WAV
        int iBlockAlign = (wfx.Format.wBitsPerSample) * wfx.Format.nChannels / 8;
#       else
        int iBlockAlign = (g_hdr.bits_per_sample) * g_hdr.num_channels / 8;
#       endif // DUMP_WAV

        int cbToRead = 0, cbRead = 0, cbSeek = -1;
        int imsSeek = rand() * g_hdr.duration / RAND_MAX;
        // TODO: But there is still problem in seek test. imsSeekActual
        // is asf file level variable it does not know wheather one packet is seekable
        // or now. If the matching uses a small window, it may fail.
        /*
            ------------------------------------------------------
                    ^           ^                   ^
                    |           |                   |
                    imsSeek    imsSeekActuall      real recon PCM in seek test starts here
        */
        // This need to be I64.
        tWMA_I64  imsSeekActual;
        tWMA_U32 dwmsActual =0;
#ifdef SEEK_TEST_EVERYPACKET
        imsSeek = cSeek;
        fprintf(stderr, "seeking to %d\n", imsSeek);
#endif
//imsSeek = 357111;
//imsSeek = (g_iSeekIndex++)  * g_hdr.duration / 117.5;
        //fprintf(stderr, "seeking to %d\n", imsSeek);
        imsSeekActual = imsSeek;
        rc = WMAFileSeek (g_state, imsSeek, &dwmsActual);
        imsSeekActual = (tWMA_I64)dwmsActual;

        if (rc != cWMA_NoErr)
        {
            fprintf( stderr, "SEEK ERR: WMAFileSeek failed when seek to %d ms\n", imsSeek);
            iRV = 11;
            goto lexit;
        }

        //decode
        while (1)
        {
            I32 cFetchedSamples;
#ifdef USE_SPDTX
            rc = WMAFileDecodeToSpdif( g_state, &nDecodedSamples );
#else
            rc = WMAFileDecodeData(g_state, &nDecodedSamples);
#endif
            if(rc != cWMA_NoErr && rc != cWMA_NoMoreFrames) //no mor frame is okay
            {
                iRV = 12;
                fprintf(stderr, "SEEK ERR: decoding failed when seek to %d ms\n", imsSeek);
                assert (0);
                goto lexit;
            }

            num_samples = nDecodedSamples;
#ifdef WMA_SEEK_MATCH
            //due to inaccuracy of time stamps (ms) we need to do some matching here
            if (num_samples != 0 && cbSeek < 0) //only do first time
            {
                unsigned char* pbLeft;
                unsigned char* pbPos;
                unsigned int   cSampleMarker = 0;
                unsigned int   cDiff = 0;
                short          iPrev = 0; //min
                tWMA_I64       tPresTime = 0;
                tWMA_I64       tPresFirst = 0;
                tWMA_I64       iSamplePos = 0;
                tWMA_I64       tPresFirstTemp = 0;
                tWMA_I64       iSamplePosTemp = 0;
                tWMA_I64       tPresFirstPrev = 0;
                tWMA_I64       iSamplePosPrev = 0;
#ifdef USE_SPDTX
                num_samples = WMAFileGetSpdifBurst( g_state, g_pBurst, MAX_BURST, &tPresTime );
#else
                num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft), nDecodedSamples, &tPresTime);
#endif
                //tPresTime = ((tPresTime + 5000) / 10000) * 10000; //round to ms

                iSamplePos = -1;
                fseek (pfTime, 0, SEEK_SET);
                while (fread (&tPresFirstTemp, sizeof (tWMA_I64), 1, pfTime) != 0 &&
                       fread (&iSamplePosTemp, sizeof (tWMA_I64), 1, pfTime) != 0)
                {
                    if (tPresFirstTemp > imsSeekActual * 10000)
                    {
                        tPresFirst = tPresFirstPrev;
                        iSamplePos = iSamplePosPrev;
                        break;
                    }

                    tPresFirstPrev = tPresFirstTemp;
                    iSamplePosPrev = iSamplePosTemp;
                }

                if( iSamplePos < 0 ){
                    break;      // we reach the end of file and still can not find the position
                }

                //adding seek adjustment; -1 to be safe
                cbSeek = (int) iSamplePos;
                cbSeek *= iBlockAlign;
                wfioSeek( pwfioOut, cbSeek, SEEK_SET );

                iPrev = g_pLeft [0];
                while (1)
                {
                    //more than half of the samples have differences
                    if (cDiff > cSampleMarker / 2 || cSampleMarker >= num_samples)
                        break;
                    if (g_pLeft [cSampleMarker] != iPrev)
                        cDiff++;
                    iPrev = g_pLeft [cSampleMarker];
                    cSampleMarker++;
                }
                cSampleMarker++;
                if (cSampleMarker < MIN_SEEK_MATCH)
                    cSampleMarker = MIN_SEEK_MATCH;
                //64ms is maximum seek adj
                cbToRead = (int) ((cSampleMarker + 64 * g_SampleRate / 1000) * iBlockAlign);
                if (cSampleMarker >= num_samples || cbToRead >= MAX_SAMPLES * 10)
                {
                    break;  //seems to be an all flat region try somewhere else
                }
                //read
                cbRead = wfioRead(pwfioOut, g_pFirst, cbToRead);
                //find match
                pbPos = g_pFirst;
                while ((pbPos - g_pFirst) < cbRead)  //g_pFirst loop
                {
                    unsigned int cMatch = 0;
                    unsigned char* pbPosTemp = pbPos;
                    pbLeft = (unsigned char*) g_pLeft;
                    while (*pbLeft == *pbPosTemp)
                    {
                        cMatch++;
                        pbLeft++;
                        pbPosTemp++;
                        if (cMatch == cSampleMarker * iBlockAlign)
                        {
                            goto MATCHFOUND;
                        }
                    }
                    pbPos++;
                }
                fprintf(stderr, "SEEK ERR: no sync point found when seek to %d ms\n", imsSeek);
                assert (0);
                pbPos = NULL;
                iRV = 13;
                goto lexit;

MATCHFOUND:
                cbSeek += (pbPos - g_pFirst);  //adjust
#if 0
                // alternative way of finding amount to seek instead
                // of doing correlation matching
                {
                    tWMA_I64 iTestSeek = (tPresTime - tPresFirst);
                    iTestSeek = (iTestSeek*g_hdr.sample_rate+5000000)/10000000;
                    iTestSeek += iSamplePos;
                    iTestSeek = iTestSeek*iBlockAlign;
                    assert(cbSeek == iTestSeek);
                }
#endif

                wfioSeek( pwfioOut, cbSeek, SEEK_SET );
                cbToRead = num_samples * iBlockAlign;
                cbRead = wfioRead(pwfioOut, g_pFirst, cbToRead);
                cbSeek += cbRead; //advance
                assert (num_samples == (unsigned)cbRead / iBlockAlign);
                num_samples = nDecodedSamples - cbRead / iBlockAlign;

                //and match the rest
                pbPos = g_pFirst;
                pbLeft = (unsigned char*) g_pLeft;
                while (cbRead > 0)
                {
                    if (*pbPos != *pbLeft)
                    {
                        fprintf(stderr, "SEEK ERR: mismatch found when seek to %d ms\n", imsSeek);
                        fprintf(stderr, "SEEK ERR: decode run %d expected %d actual %d\n", iDecode,
                                                                                           *pbPos, *pbLeft);
                        assert (0);
                        iRV = 14;
                        goto lexit;
                    }
                    pbPos++;
                    pbLeft++;
                    cbRead--;
                }
            }
#endif //WMA_SEEK_MATCH
            cFetchedSamples = 0;
            while (num_samples > 0)
            {
                short *pL = g_pLeft;
                short *pR = g_pRight;
                unsigned char* pbDecoded = (unsigned char*) pL;
                unsigned char* pbFirst = g_pFirst;
                tWMA_I64 tPresTime = 0;

                HEAP_DEBUG_CHECK;
#ifdef USE_SPDTX
                num_samples = WMAFileGetSpdifBurst (g_state, g_pBurst, MAX_BURST,
                                    nDecodedSamples - cFetchedSamples, &tPresTime);
#else
                num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft),
                                          nDecodedSamples - cFetchedSamples, &tPresTime);
#endif
                cFetchedSamples += num_samples;

#ifdef WMA_SEEK_MATCH
                wfioSeek( pwfioOut, cbSeek, SEEK_SET );
                assert (cbToRead <= MAX_SAMPLES * 10);
                //read
                cbToRead = num_samples * iBlockAlign;
                cbRead = wfioRead(pwfioOut, g_pFirst, cbToRead);
                cbSeek += cbRead;
                //and match
                while (cbRead > 0)
                {
                    if (*pbFirst != *pbDecoded)
                    {
                        fprintf(stderr, "SEEK ERR: mismatch found when seek to %d ms\n", imsSeek);
                        fprintf(stderr, "SEEK ERR: decode run %d expected %d actual %d\n", iDecode,
                                        *pbFirst, *pbDecoded);
                        assert (0);
                        iRV = 14;
                        goto lexit;
                    }
                    cbRead--;
                }
#endif //WMA_SEEK_MATCH
            }
            iDecode--;
            if(rc != cWMA_NoErr || iDecode < 0)
            {
                break;  //try to seek again and do
            }
        }//end of seek decode
        --cSeek;
#ifdef SEEK_TEST_EVERYPACKET
        cSeek = cSeek - 10;
#endif
    }//end of all seeks
    fputs("Seek test passed\n", stderr);
seekTestDone:
#endif //WMA_SEEK_MATCH

lexit:
#ifdef WMA_SEEK_MATCH
    if (pfTime)
        fclose(pfTime);

    _unlink(pszTmpFilename);
    free(pszTmpFilename);
#endif // WMA_SEEK_MATCH

#ifdef PERFRM_TIMING
    fclose(g_fpPerfrmLog);
#endif

    /* clean up */

    HEAP_DEBUG_CHECK;

#ifdef WMDRM_NETWORK
    if( NULL != fpPrivKey )
    {
        fclose( fpPrivKey );
    }

    if( NULL != fpMessage )
    {
        fclose( fpMessage );
    }

    if( NULL != pPrivKey )
    {
        OEM_free( pPrivKey );
    }

    if( NULL != pXmrLicense )
    {
        DrmXmrFreeLicense( pXmrLicense );
    }

    if( NULL != pAESKey )
    {
        OEM_DrmAesDeleteKey( pAESKey );
    }
#endif

    if (g_fpLic) {
        fclose (g_fpLic);
        g_fpLic = NULL;
    }

#ifndef DISCARD_OUTPUT
#ifdef DUMP_WAV
    if (pwfioOut)
    {
        wfioClose(pwfioOut);
        wfioDelete (pwfioOut);
    }
#else   /* DUMP_WAV */
    if (pfOutPCM) {
        fclose (pfOutPCM);
        pfOutPCM = NULL;
    }
#endif // DUMP_WAV
#endif // !DISCARD_OUTPUT


    if (g_fp) {
        fclose (g_fp);
        g_fp = NULL;
    }

#ifdef OBNOXIOUS
    // try to get PCM data now
    num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft), MAX_SAMPLES, &tPresTime);
    if ( num_samples > 0 )
    {
        fprintf( stderr, "** Obnoxious WMAFileGetPCM returns %d samples.\n", num_samples);
        assert( num_samples <= 0 );
    }
#endif
    WMAFreeHeader(&g_hdrstate);
    WMAFileDecodeClose (&g_state);

    HEAP_DEBUG_CHECK;

#ifdef OBNOXIOUS
    // try to close interface a second time
    WMAFileDecodeClose (&g_state);
    // try to get PCM data now
    num_samples = WMAFileGetPCM (g_state, g_pLeft, g_pRight, sizeof(g_pLeft), MAX_SAMPLES, &tPresTime);
    if ( num_samples > 0 )
    {
        fprintf( stderr, "** Obnoxious WMAFileGetPCM returns %d samples.\n", num_samples);
        assert( num_samples <= 0 );
    }
    // try to decode data
    rc = WMAFileDecodeData(g_state, &nDecodedSamples);
    if ( rc == cWMA_NoErr )
    {
        fputs("** Obnoxious WMAFileDecodeData returns NoErr.\n", stderr );
        assert( rc != cWMA_NoErr );
    }
    // try to close a third time
    WMAFileDecodeClose (&g_state);
#endif

    HEAP_DEBUG_CHECK;

    return(iRV);
}

// Some compile time warning messages
#ifndef PLATFORM_SPECIFIC_COMPILER_MESSAGE
#   define COMPILER_MESSAGE(x)         message(x)
#endif
#ifdef MEASURE_CLOCK
#   pragma COMPILER_MESSAGE(__FILE__ "(927) : Warning - MEASURE_CLOCK Enabled.")
#endif
#ifdef PROFILE
#   pragma COMPILER_MESSAGE(__FILE__ "(930) : Warning - PROFILE Enabled.")
#endif
#ifdef DISCARD_OUTPUT
#ifndef PERFRM_TIMING
#   pragma COMPILER_MESSAGE(__FILE__ "(933) : Warning - DISCARD_OUTPUT Enabled.")
#endif
#endif
#ifdef OBNOXIOUS
#   pragma COMPILER_MESSAGE(__FILE__ "(936) : Warning - OBNOXIOUS tests Enabled.")
#endif
#ifdef REAL_OBNOXIOUS
#   pragma COMPILER_MESSAGE(__FILE__ "(939) : Warning - REAL OBNOXIOUS tests Enabled - output will be incorrect.")
#endif

#endif //MICROSOFT_API
