/*
 * Copyright 2001-2003, FireGL, ATI
 *
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 * THE XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 * 
 */
/* based on XFree86: xc/programs/xgamma/xgamma.c,v 1.4 1999/04/25 10:02:57 */

/*

    Main formula:
        -------------------------------------------------------------
        |    L' = L ^ (1/DISPLAY_GAMMA) in a range of 0 <= L <= 1   |
        -------------------------------------------------------------

*/


//////////////////////////////////////////////////////////////////////////////
// includes

// global includes
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <math.h>

#ifdef WIN32 // M$ Win specific include

#include <windows.h>
#define Bool int
#define True    1
#define False   0
#define CARD16 unsigned short
#define SET_GAMMA_VALUE_XXL         0xF00b    // Set Gamma Correction XXL
typedef struct GAMMA_CORRECTION_VALUE_EX_XXL {
    ULONG   ulAdapter;              // board number
    DWORD   dwIndex;                // entry to be set
    DWORD   dwGammaValueR;          // red
    DWORD   dwGammaValueG;          // green
    DWORD   deGammaValueB;          // blue
}  GAMMA_CORR_VALUE_EX_XXL, *PGAMMA_CORR_VALUE_EX_XXL;
#define FGLRX_GAMMA_RAMP_SIZE 256
typedef struct {
    unsigned short  RGamma[FGLRX_GAMMA_RAMP_SIZE];    /* red color value for gamma correction table */
    unsigned short  GGamma[FGLRX_GAMMA_RAMP_SIZE];    /* green color value for gamma correction table */
    unsigned short  BGamma[FGLRX_GAMMA_RAMP_SIZE];    /* blue color value for gamma correction table */
} FGLRX_X11Gamma_C16native, FGLRX_X11Gamma_C16native_1024;

#else    // X11 specific

#include <X11/Xlib.h>
#ifdef FGL_DK
#include <fglrx_gamma.h>
#else
#include <X11/extensions/fglrx_gamma.h>
#endif
#include <ctype.h>
#include <stdlib.h>

#endif

//////////////////////////////////////////////////////////////////////////////
// global variables

char *ProgramName;


/* Maximum and Minimum gamma values */
#define GAMMA_MIN 0.1
#define GAMMA_MAX 10.0


//////////////////////////////////////////////////////////////////////////////
// functions

static void 
Syntax(void)
{
    fprintf (stderr, "usage:  %s [-options]\n\n", 
    	     ProgramName);
    fprintf (stderr, "where the available options are:\n");
#ifndef WIN32
    fprintf (stderr, "    -display host:dpy       or -d\n");
#endif
    fprintf (stderr, "    -quiet                  or -q\n");
    fprintf (stderr, "    -controller 0           or -c 0\n");
    fprintf (stderr, "    -controller 1           or -c 1\n");
#ifndef WIN32
    fprintf (stderr, "    -screen                 or -s\n");
#endif
    fprintf (stderr, "    -gamma f.f              Gamma Value\n");
    fprintf (stderr, "    -rgamma f.f             Red Gamma Value\n");
    fprintf (stderr, "    -ggamma f.f             Green Gamma Value\n");
    fprintf (stderr, "    -bgamma f.f             Blue Gamma Value\n\n");

    fprintf (stderr, "If no gamma is specified, returns the current setting\n");
    exit (1);
}


/*
 * The following is a hack until XrmParseCommand is ready.  It determines
 * whether or not the given string is an abbreviation of the arg.
 */

static Bool 
isabbreviation(char *arg, char *s, int minslen)
{
    int arglen;
    int slen;

    /* exact match */
    if (strcmp (arg, s) == 0) return (True);

    arglen = strlen (arg);
    slen = strlen (s);

    /* too long or too short */
    if (slen >= arglen || slen < minslen) return (False);

    /* abbreviation */
    if (strncmp (arg, s, slen) == 0) return (True);

    /* bad */
    return (False);
}




int
main(int argc, char *argv[])
{
    int i;
    int ret = 0;
    char *displayname = NULL;
#ifndef WIN32
    Display *dpy;
#endif
    float gam = -1., rgam = -1., ggam = -1., bgam = -1.;
    FGLRX_X11Gamma_float gamma;
    Bool quiet = False;
    int screen = -1;
    int controller = 0;

    ProgramName = argv[0];
    for (i = 1; i < argc; i++) {
        char *arg = argv[i];

        if (arg[0] == '-') {
#ifndef WIN32
            if (isabbreviation ("-display", arg, 1)) {
                if (++i >= argc) Syntax ();
                displayname = argv[i];
                continue;
            } else 
#endif				
			if (isabbreviation ("-quiet", arg, 1)) {
                quiet = True;
                continue;
            } else if (isabbreviation ("-screen", arg, 1)) {
                if (++i >= argc) Syntax ();
                screen = atoi(argv[i]);
                continue;
            } else if (isabbreviation ("-controller", arg, 1)) {
                if (++i >= argc) Syntax ();
                controller = atoi(argv[i]);
                continue;
            } else if (isabbreviation ("-gamma", arg, 2)) {
                if (++i >= argc) Syntax ();
                if ((rgam >= 0.) || (ggam >= 0.) || (bgam >= 0.))
                    Syntax ();
                gam = (float)atof(argv[i]);
                if ((gam < GAMMA_MIN) || (gam > GAMMA_MAX)) {
                    fprintf(stderr,
                        "Gamma values must be between %6.3f and %6.3f\n",
                        GAMMA_MIN, GAMMA_MAX);
                    exit(1);
                }
                continue;
            } else if (isabbreviation ("-rgamma", arg, 2)) {
                if (++i >= argc) Syntax ();
                if (gam >= 0.) Syntax ();
                rgam = (float)atof(argv[i]);
                if ((rgam < GAMMA_MIN) || (rgam > GAMMA_MAX)) {
                    fprintf(stderr,"Gamma values must be between %6.3f and %6.3f\n",
                    GAMMA_MIN, GAMMA_MAX);
                    exit(1);
                }
                continue;
            } else if (isabbreviation ("-ggamma", arg, 2)) {
                if (++i >= argc) Syntax ();
                if (gam >= 0.) Syntax ();
                ggam = (float)atof(argv[i]);
                if ((ggam < GAMMA_MIN) || (ggam > GAMMA_MAX)) {
                    fprintf(stderr,"Gamma values must be between %6.3f and %6.3f\n",
                    GAMMA_MIN, GAMMA_MAX);
                    exit(1);
                }
                continue;
            } else if (isabbreviation ("-bgamma", arg, 2)) {
                if (++i >= argc) Syntax ();
                if (gam >= 0.) Syntax ();
                bgam = (float)atof(argv[i]);
                if ((bgam < GAMMA_MIN) || (bgam > GAMMA_MAX)) {
                    fprintf(stderr,
                        "Gamma values must be between %6.3f and %6.3f\n",
                        GAMMA_MIN, GAMMA_MAX);
                    exit(1);
                }
                continue;
            } else
                Syntax ();
        } else
            Syntax ();
    }

#ifndef WIN32
    if ((dpy = XOpenDisplay(displayname)) == NULL) {
        fprintf (stderr, "%s:  unable to open display '%s'\n",
            ProgramName, XDisplayName (displayname));
        exit(1);
    } else if (screen == -1)
        screen = DefaultScreen(dpy);
#endif

    if(1)
    {
        if (rgam != -1)
	{
	    if (ggam == -1)
		ggam = 1.0;		
	    if (bgam == -1)
		bgam = 1.0;
	}
	if (ggam != -1)
	{
	    if (rgam == -1)
		rgam = 1.0;		
	    if (bgam == -1)
		bgam = 1.0;
	}
	if (bgam != -1)
	{
	    if (rgam == -1)
		rgam = 1.0;		
	    if (ggam == -1)
		ggam = 1.0;
	}
	
        if (gam != -1)
        {
            rgam = ggam = bgam = gam;
        }

        if ((rgam != -1) && (ggam != -1) && (bgam != -1))
        {
            gamma.red = rgam;
            gamma.green = ggam;
            gamma.blue = bgam;

            if (!FGLRX_X11SetGamma(dpy, screen, controller, &gamma))
            {
                fprintf(stderr, "Unable to set gamma correction\n");
                ret = 2;
            }
            else
            {
                if( !quiet )
                    printf("Gamma successfully setup\n");
            }
        }
    }

#ifndef WIN32
    XCloseDisplay (dpy);
#endif

    return(ret);
}
