/*
 * $Id: power_supply_at.c,v 1.7 2009-01-28 12:59:21 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "power_supply_at.h"

#define COMP "power_supply_at"

struct cpssp {
	/* Config */

	/* Ports */
	struct sig_boolean *port_power_230v;
	unsigned int state_power_230v;

	struct sig_boolean *port_mech_power_switch;
	unsigned int state_mech_power_switch;

	struct sig_boolean *port_power_board__plus_5V;
	struct sig_boolean *port_power_board__minus_5V;
	struct sig_boolean *port_power_board__plus_12V;
	struct sig_boolean *port_power_board__minus_12V;

	struct sig_boolean *port_power_device_power_5V[8];
	struct sig_boolean *port_power_device_power_12V[8];
};

static void
power_supply_at_power_update(struct cpssp *cpssp)
{
	unsigned int core_well;
	unsigned int i;

	/* Core Well Power */
	core_well = cpssp->state_power_230v
		&& cpssp->state_mech_power_switch;
	
	sig_boolean_set(cpssp->port_power_board__plus_5V, cpssp, core_well);
	sig_boolean_set(cpssp->port_power_board__minus_5V, cpssp, core_well);
	sig_boolean_set(cpssp->port_power_board__plus_12V, cpssp, core_well);
	sig_boolean_set(cpssp->port_power_board__minus_12V, cpssp, core_well);
	for (i = 0; i < 8; i++) {
		sig_boolean_set(cpssp->port_power_device_power_5V[i], cpssp, core_well);
		sig_boolean_set(cpssp->port_power_device_power_12V[i], cpssp, core_well);
	}
}

static void
power_supply_at_power_230V_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_power_230v = val;

	power_supply_at_power_update(cpssp);
}

static void
power_supply_at_switch_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->state_mech_power_switch = val;

	power_supply_at_power_update(cpssp);
}

void
power_supply_at_init(
	unsigned int nr,
	struct sig_boolean *port_power_230v,
	struct sig_boolean *port_mech_power_switch,
	struct sig_power_board_at *port_power_board,
	struct sig_power_device *port_power_dev0,
	struct sig_power_device *port_power_dev1,
	struct sig_power_device *port_power_dev2,
	struct sig_power_device *port_power_dev3,
	struct sig_power_device *port_power_dev4,
	struct sig_power_device *port_power_dev5,
	struct sig_power_device *port_power_dev6,
	struct sig_power_device *port_power_dev7
)
{
	static const struct sig_boolean_funcs power_230V_funcs = {
		.set = power_supply_at_power_230V_set,
	};
	static const struct sig_boolean_funcs switch_funcs = {
		.set = power_supply_at_switch_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->port_power_230v = port_power_230v;
	cpssp->port_mech_power_switch = port_mech_power_switch;

	cpssp->port_power_board__plus_5V = port_power_board->_plus_5V;
	cpssp->port_power_board__minus_5V = port_power_board->_minus_5V;
	cpssp->port_power_board__plus_12V = port_power_board->_plus_12V;
	cpssp->port_power_board__minus_12V = port_power_board->_minus_12V;

	cpssp->port_power_device_power_5V[0] = port_power_dev0->power_5V;
	cpssp->port_power_device_power_12V[0] = port_power_dev0->power_12V;
	cpssp->port_power_device_power_5V[1] = port_power_dev1->power_5V;
	cpssp->port_power_device_power_12V[1] = port_power_dev1->power_12V;
	cpssp->port_power_device_power_5V[2] = port_power_dev2->power_5V;
	cpssp->port_power_device_power_12V[2] = port_power_dev2->power_12V;
	cpssp->port_power_device_power_5V[3] = port_power_dev3->power_5V;
	cpssp->port_power_device_power_12V[3] = port_power_dev3->power_12V;
	cpssp->port_power_device_power_5V[4] = port_power_dev4->power_5V;
	cpssp->port_power_device_power_12V[4] = port_power_dev4->power_12V;
	cpssp->port_power_device_power_5V[5] = port_power_dev5->power_5V;
	cpssp->port_power_device_power_12V[5] = port_power_dev5->power_12V;
	cpssp->port_power_device_power_5V[6] = port_power_dev6->power_5V;
	cpssp->port_power_device_power_12V[6] = port_power_dev6->power_12V;
	cpssp->port_power_device_power_5V[7] = port_power_dev7->power_5V;
	cpssp->port_power_device_power_12V[7] = port_power_dev7->power_12V;

	/* Output */
	sig_boolean_connect_out(cpssp->port_power_board__plus_5V, cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_board__minus_5V, cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_board__plus_12V, cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_board__minus_12V, cpssp, 0);

	sig_boolean_connect_out(cpssp->port_power_device_power_5V[0], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[0], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[1], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[1], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[2], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[2], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[3], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[3], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[4], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[4], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[5], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[5], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[6], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[6], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_5V[7], cpssp, 0);
	sig_boolean_connect_out(cpssp->port_power_device_power_12V[7], cpssp, 0);

	/* Input */
	cpssp->state_power_230v = 0;
	sig_boolean_connect_in(port_power_230v, cpssp, &power_230V_funcs);

	cpssp->state_mech_power_switch = 0;
	sig_boolean_connect_in(port_mech_power_switch, cpssp, &switch_funcs);
}

void
power_supply_at_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
power_supply_at_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
