/*
 * $Id: loudspeaker_aui_gen.c,v 1.3 2009-01-28 12:59:20 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue-aui-gen.h"

#include "loudspeaker_aui.h"

#define COMP "loudspeaker"

struct cpssp {
	AuiGenChannel *channel;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */
static void
loudspeaker_aui_audio_sound_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	aui_gen_channel_play(cpssp->channel, samples);
}

void
loudspeaker_aui_init(
	unsigned int nr,
	struct sig_sound *port_sound_in,
	struct sig_sound *port_audio_sound
)
{
	static const struct sig_sound_funcs audio_sound_funcs = {
		.samples_set = loudspeaker_aui_audio_sound_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	sig_sound_connect(port_audio_sound, cpssp, &audio_sound_funcs);
}

void
loudspeaker_aui_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->channel = aui_gen_channel_new();

	iface[nr] = cpssp;
}

void
loudspeaker_aui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
