/* $Id: cpu_intel_80386.c,v 1.12 2009-01-28 12:59:19 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "chip_intel_80386.h"

#include "cpu_intel_80386.h"

#define COMP	"cpu_intel_80386"

struct cpssp {
	unsigned int chip;
};

void
cpu_intel_80386_init(
	unsigned int nr,
	struct sig_host_bus *port_conn
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_intel_80386_init(cpssp->chip,
			port_conn->power,
			port_conn->n_reset,
			port_conn->lint0,
			port_conn->lint1,
			port_conn->smi,
			port_conn->n_ferr,
			port_conn->n_ignne,
			port_conn->a20,
			port_conn->main);
}

void
cpu_intel_80386_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->chip = chip_intel_80386_create();

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
cpu_intel_80386_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_intel_80386_destroy(cpssp->chip);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
