/*
 * $Id: chassis_at_gui_gtk.c,v 1.13 2009-01-28 12:59:17 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "chassis_at_gui.h"

#define COMP "chassis_at"

struct cpssp {
	unsigned int speaker;

	GtkWidget *power_led;
	GtkWidget *reset_button;

	struct sig_boolean *port_mech_reset_button;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */
static void
gui_chassis_opt_power_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->power_led), val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
gui_chassis_reset_button_press_event(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_reset_button, cpssp, 1);
}

static void
gui_chassis_reset_button_release_event(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_reset_button, cpssp, 0);
}

void
chassis_at_gui_init(
	unsigned int nr,
	struct sig_boolean *port_mech_reset_button,
	struct sig_std_logic *port_n_reset_button,
	struct sig_boolean *port_power_led,
	struct sig_boolean *port_opt_power_led,
	struct sig_sound *port_speaker,
	struct sig_sound *port_audio_speaker
)
{
	static const struct sig_boolean_funcs opt_power_led_funcs = {
		.set = gui_chassis_opt_power_led_set,
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	/* Out */
	cpssp->port_mech_reset_button = port_mech_reset_button;
	sig_boolean_connect_out(port_mech_reset_button, cpssp, 0);

	/* In */
	sig_boolean_connect_in(port_opt_power_led, cpssp, &opt_power_led_funcs);
}

void
chassis_at_gui_create(unsigned int page, unsigned int nr, const char *name)
{
	struct cpssp *cpssp;
	GtkWidget *vbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	/* Power LED */
	cpssp->power_led = gui_gtk_led_new("Power");
	gtk_widget_show(cpssp->power_led);
	gtk_box_pack_start(GTK_BOX(vbox), cpssp->power_led, TRUE, FALSE, 10);

	/* Reset Button */
	cpssp->reset_button = gui_gtk_button_new("Reset");
	g_signal_connect(G_OBJECT(cpssp->reset_button), "button-pressed",
			G_CALLBACK(gui_chassis_reset_button_press_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->reset_button), "button-released",
			G_CALLBACK(gui_chassis_reset_button_release_event), cpssp);
	gtk_widget_show(cpssp->reset_button);
	gtk_box_pack_end(GTK_BOX(vbox), cpssp->reset_button, TRUE, FALSE, 0);

	gtk_widget_show(vbox);
	gui_comp_add(page, COMP, nr, name, vbox, FALSE, FALSE, NULL);

	iface[nr] = cpssp;
}

void
chassis_at_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
