/*
 * $Id: branch_pci.c,v 1.4 2009-01-28 12:59:16 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "branch_pci.h"

#define COMP "branch_pci"

struct cpssp {
	unsigned int generic_idsel;
	struct sig_pci_bus_idsel *port_idsel;
};

static int
branch_pci_c0r(
	void *_f,
	uint32_t addr,
	unsigned int bs,
	uint32_t *valp
)
{
	struct cpssp *f = (struct cpssp *) _f;

	if ((addr >> (11 + f->generic_idsel)) & 1) {
		return sig_pci_bus_idsel_c0r(f->port_idsel, f, addr, bs, valp);
	} else {
		return 1;
	}
}

static int
branch_pci_c0w(
	void *_f,
	uint32_t addr,
	unsigned int bs,
	uint32_t val
)
{
	struct cpssp *f = (struct cpssp *) _f;

	if ((addr >> (11 + f->generic_idsel)) & 1) {
		return sig_pci_bus_idsel_c0w(f->port_idsel, f, addr, bs, val);
	} else {
		return 1;
	}
}

void
branch_pci_init(
	unsigned int nr,
	struct sig_pci_bus_main *port_pci_bus,
	struct sig_pci_bus_idsel *port_idsel
)
{
	static const struct sig_pci_bus_main_funcs pci_bus_funcs = {
		.c0r = branch_pci_c0r,
		.c0w = branch_pci_c0w,
	};
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	/* Out */
	/* Call */
	sig_pci_bus_main_connect(port_pci_bus, cpssp, &pci_bus_funcs);

	cpssp->port_idsel = port_idsel;

	/* In */
}

unsigned int
branch_pci_create(unsigned int generic_idsel)
{
	static unsigned int nr = 0;
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->generic_idsel = generic_idsel;

	shm_unmap(cpssp, sizeof(*cpssp));

	return nr++;
}

void
branch_pci_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
