/*
 * $Id: sig_opt_rgb.c,v 1.3 2009-01-27 17:06:42 potyra Exp $
 *
 * Optical RGB signal.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "fixme.h"

#include "glue-shm.h"

#include "sig_opt_rgb.h"

void
sig_opt_rgb_pixel_set(
	struct sig_opt_rgb *b,
	void *s,
	unsigned int x,
	unsigned int y,
	uint8_t red,
	uint8_t green,
	uint8_t blue
)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *, unsigned int, unsigned int,
				uint8_t, uint8_t, uint8_t);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->pixel_set;
		if (func) {
			func(b->member[nr].s, x, y, red, green, blue);
		}
	}
}

void
sig_opt_rgb_size_set(
	struct sig_opt_rgb *b,
	void *s,
	unsigned int width,
	unsigned int height
)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *, unsigned int, unsigned int);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->size_set;
		if (func) {
			func(b->member[nr].s, width, height);
		}
	}
}

void
sig_opt_rgb_sync(
	struct sig_opt_rgb *b,
	void *s
)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->sync;
		if (func) {
			func(b->member[nr].s);
		}
	}
}

void
sig_opt_rgb_connect(
	struct sig_opt_rgb *b,
	void *s,
	const struct sig_opt_rgb_funcs *f
)
{
	assert(b);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));
	assert(b->type == SIG_GEN_OPT_RGB);

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

struct sig_opt_rgb *
sig_opt_rgb_init(const char *name, unsigned int nr)
{
	struct sig_opt_rgb *b;

	b = shm_map(name, nr, sizeof(*b), 0);

	b->member_count = 0;
	b->type = SIG_GEN_OPT_RGB;

	return b;
}

static void
sig_opt_rgb_s0_pixel_set(
	void *_f,
	unsigned int x,
	unsigned int y,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct sig_opt_rgb_merge *f = (struct sig_opt_rgb_merge *) _f;

	sig_opt_rgb_pixel_set(f->s1, f, x, y, r, g, b);
}

static void
sig_opt_rgb_s0_size_set(
	void *_f,
	unsigned int width,
	unsigned int height
)
{
	struct sig_opt_rgb_merge *f = (struct sig_opt_rgb_merge *) _f;

	sig_opt_rgb_size_set(f->s1, f, width, height);
}

static void
sig_opt_rgb_s0_sync(void *_f)
{
	struct sig_opt_rgb_merge *f = (struct sig_opt_rgb_merge *) _f;

	sig_opt_rgb_sync(f->s1, f);
}

static void
sig_opt_rgb_s1_pixel_set(
	void *_f,
	unsigned int x,
	unsigned int y,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct sig_opt_rgb_merge *f = (struct sig_opt_rgb_merge *) _f;

	sig_opt_rgb_pixel_set(f->s0, f, x, y, r, g, b);
}

static void
sig_opt_rgb_s1_size_set(
	void *_f,
	unsigned int width,
	unsigned int height
)
{
	struct sig_opt_rgb_merge *f = (struct sig_opt_rgb_merge *) _f;

	sig_opt_rgb_size_set(f->s0, f, width, height);
}

static void
sig_opt_rgb_s1_sync(void *_f)
{
	struct sig_opt_rgb_merge *f = (struct sig_opt_rgb_merge *) _f;

	sig_opt_rgb_sync(f->s0, f);
}

struct sig_opt_rgb_merge *
sig_opt_rgb_merge(struct sig_opt_rgb *s0, struct sig_opt_rgb *s1)
{
	static const struct sig_opt_rgb_funcs s0_funcs = {
		.pixel_set = sig_opt_rgb_s0_pixel_set,
		.size_set = sig_opt_rgb_s0_size_set,
		.sync = sig_opt_rgb_s0_sync,
	};
	static const struct sig_opt_rgb_funcs s1_funcs = {
		.pixel_set = sig_opt_rgb_s1_pixel_set,
		.size_set = sig_opt_rgb_s1_size_set,
		.sync = sig_opt_rgb_s1_sync,
	};
	struct sig_opt_rgb_merge *m;

	m = malloc(sizeof(*m));
	assert(m);

	m->s0 = s0;
	sig_opt_rgb_connect(s0, m, &s0_funcs);
	m->s1 = s1;
	sig_opt_rgb_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_opt_rgb_split(struct sig_opt_rgb_merge *m)
{
	fixme();
}

void
sig_opt_rgb_create(const char *name, unsigned int nr)
{
	shm_create(name, nr, sizeof(struct sig_opt_rgb));
}

void
sig_opt_rgb_destroy(const char *name, unsigned int nr)
{
	shm_destroy(name, nr);
}
