/*
 * $Id: sig_eth.c,v 1.6 2009-01-27 17:06:41 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>

#include "glue-log.h"
#include "glue-shm.h"

#include "sig_eth.h"

void
sig_eth_send(
	struct sig_eth *b,
	void *s,
	const void *buf,
	unsigned int buflen
)
{
	unsigned int nr;

	for (nr = 0; nr < b->nmembers; nr++) {
		if (b->member[nr].s == s) {
			continue;
		}
		(*b->member[nr].f->recv)(b->member[nr].s, buf, buflen);
	}
}

void
sig_eth_connect(struct sig_eth *b, void *s, const struct sig_eth_funcs *f)
{
	assert(b);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));
	assert(b->type == SIG_GEN_ETH);

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_eth *
sig_eth_init(const char *name, int nr)
{
	struct sig_eth *b;

	b = shm_map(name, nr, sizeof(*b), 0);

	b->nmembers = 0;
	b->type = SIG_GEN_ETH;

	return b;
}

void
sig_eth_create(const char *name, int nr)
{
	shm_create(name, nr, sizeof(struct sig_eth));
}

void
sig_eth_destroy(const char *name, int nr)
{
	shm_destroy(name, nr);
}
