/* $Id: glue-setup.c,v 1.6 2009-02-03 17:49:16 potyra Exp $
 *
 *  Glue layer to setup components/signals. Should replace mssetup.h/c from
 *  expect.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include "glue-setup.h"
#include "fauhdli.h"
#include "simsetup.h"
#include "glue-main.h"
#include <assert.h>
#include <stdio.h>

/** (only) fauhdli interpreter instance. */
static struct fauhdli *fauhdli = NULL;

void
glue_setup_create(void)
{
	int ret;
	char top_entity[2048];

	assert(fauhdli == NULL);

	fauhdli = fauhdli_create(simsetup.vhdl_model, NULL, 0 < loglevel);

	/* FIXME really use expect as library name space, or rather
	 *       define that in simulation.setup? 
	 *       (there is the possibility to override this via fauhdlc!)
	 */
	ret = snprintf(top_entity, sizeof(top_entity), "expect:%s", 
			simsetup.base_entity);
	assert(ret < sizeof(top_entity));

	fauhdli_init(fauhdli, top_entity);
}

void
glue_setup_destroy(void)
{
	assert(fauhdli != NULL);
	fauhdli_destroy(fauhdli);
	fauhdli = NULL;
}
