/*
 * $Id: glue-gui-gtk-fi.c,v 1.33 2009-01-27 17:06:40 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk-fi.h"

typedef struct {
	GtkVBoxClass parent_class;

	void (*fi_change) (GuiGtkFI *fi);
} GuiGtkFIClass;

static guint gui_gtk_fi_signal_change;

static void
gui_gtk_fi_class_init(GuiGtkFIClass *class)
{
	gui_gtk_fi_signal_change = g_signal_new("fi-change",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkFIClass, fi_change),
			NULL, NULL,
			g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE,
			1, G_TYPE_POINTER);
}

static void
gui_gtk_fi_init(GuiGtkFI *fi)
{
}

GType
gui_gtk_fi_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkFIClass),
			NULL,   /* base_init */
			NULL,   /* base_finalize */
			(GClassInitFunc) gui_gtk_fi_class_init,
			NULL,   /* class_finalize */
			NULL,   /* class_data */
			sizeof(GuiGtkFI),
			0,      /* n_preallocs */
			(GInstanceInitFunc) gui_gtk_fi_init,
		};

		ttt_type = g_type_register_static(GTK_TYPE_VBOX,
				"FaultInject", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKFI_TYPE  gui_gtk_fi_get_type()

static void
gui_gtk_fi_start_event(GtkWidget *w, gpointer *_fi)
{
	GuiGtkFI *fi = (GuiGtkFI *) _fi;

	gtk_widget_show(fi->dialog);
}

static void
gui_gtk_event(gpointer _fi)
{
	GuiGtkFI *fi = (GuiGtkFI *) _fi;
	unsigned int fault;

	for (fault = 0; fault < fi->nfault_actuals; fault++) {
		int send;

		send = 0;
		if (strcmp(fi->activator, "Boolean") == 0) {
			int active;

			active = gtk_toggle_button_get_active(
					GTK_TOGGLE_BUTTON(fi->fault_actual[fault].active));
			if (active != fi->fault_actual[fault].state) {
				fi->fault_actual[fault].state = active;
				send = 1;
			}

		} else if (strcmp(fi->activator, "Percentage") == 0) {
			int percentage;

			percentage = (int) gtk_range_get_value(
					GTK_RANGE(fi->fault_actual[fault].range));
			assert(0 <= percentage && percentage <= 100);

			if (percentage != fi->fault_actual[fault].state) {
				fi->fault_actual[fault].state = percentage;
				send = 1;
			}

		} else if (strcmp(fi->activator, "Trigger") == 0) {
			int trigger;

			trigger = gtk_toggle_button_get_active(
					GTK_TOGGLE_BUTTON(fi->fault_actual[fault].trigger));

			if (trigger) {
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(fi->fault_actual[fault].trigger), 0);
				send = 1;
			}
		}

		if (send) {
			/* Ugly! FIXME */
			struct {
				unsigned int state;
				const char *loc0[4];
				const char *loc1[4];
			} *change;
			unsigned int addr;

			change = malloc(sizeof(*change));
			assert(change);

			change->state = fi->fault_actual[fault].state;
			for (addr = 0; addr < fi->nloc0s; addr++) {
				change->loc0[addr] = fi->fault_actual[fault].loc0[addr];
			}
			for (addr = 0; addr < fi->nloc1s; addr++) {
				change->loc1[addr] = fi->fault_actual[fault].loc1[addr];
			}

			g_signal_emit(G_OBJECT(fi),
					gui_gtk_fi_signal_change,
					0, change);
		}
	}
}

static void
gui_gtk_toggle_event(GtkWidget *w, gpointer _fi)
{
	gui_gtk_event(_fi);
}

static gchar *
gui_gtk_range_event(GtkWidget *w, gdouble _value, gpointer _fi)
{
	unsigned int value;

	gui_gtk_event(_fi);

	if (_value < 0.0) {
		value = 0;
	} else if (100.0 < _value) {
		value = 100;
	} else {
		value = (unsigned int) _value;
	}

	return g_strdup_printf("%u%%", (int) value);
}

static void
gui_gtk_fi_add(
	GuiGtkFI *fi,
	const char *type,
	const char *loc0[],
	const char *loc1[]
)
{
	int addr;
	GtkWidget *w;

	fi->fault_actual[fi->nfault_actuals].state = 0;
	for (addr = 0; addr < sizeof(fi->loc0) / sizeof(fi->loc0[0]); addr++) {
		fi->fault_actual[fi->nfault_actuals].loc0[addr] = loc0[addr];
		fi->fault_actual[fi->nfault_actuals].loc1[addr] = loc1[addr];
	}

	gtk_table_resize(GTK_TABLE(fi->table),
			fi->nfault_actuals + 1, 2 + 4*2 + 4*2);

	w = gtk_label_new(fi->type);
	gtk_widget_show(w);
	gtk_table_attach_defaults(GTK_TABLE(fi->table),
			w,
			0,
			1,
			fi->nfault_actuals,
			fi->nfault_actuals + 1);

	if (strcmp(fi->activator, "Boolean") == 0) {
		GtkWidget *off;
		GtkWidget *active;

		w = gtk_hbox_new(FALSE, 1);

		off = gtk_radio_button_new_with_label(NULL, "off");
		gtk_widget_show(off);
		gtk_box_pack_start(GTK_BOX(w), off,
				FALSE, FALSE, 1);
		active = gtk_radio_button_new_with_label_from_widget(
				GTK_RADIO_BUTTON(off), "active");
		g_signal_connect(G_OBJECT(active), "toggled",
				G_CALLBACK(gui_gtk_toggle_event),
				fi);

		gtk_widget_show(active);
		gtk_box_pack_start(GTK_BOX(w), active,
				FALSE, FALSE, 1);

		fi->fault_actual[fi->nfault_actuals].active = active;

	} else if (strcmp(fi->activator, "Percentage") == 0) {
		w = gtk_hscale_new_with_range(0, 100, 1);
		gtk_widget_set_size_request(w, 100, 35);
		g_signal_connect(G_OBJECT(w), "format-value",
				G_CALLBACK(gui_gtk_range_event),
				fi);

		fi->fault_actual[fi->nfault_actuals].range = w;

	} else if (strcmp(fi->activator, "Trigger") == 0) {
		w = gtk_toggle_button_new_with_label("Trigger");
		g_signal_connect(G_OBJECT(w), "toggled",
				G_CALLBACK(gui_gtk_toggle_event),
				fi);

		fi->fault_actual[fi->nfault_actuals].trigger = w;

	} else {
		assert(0);
	}
	gtk_widget_show(w);
	gtk_table_attach_defaults(GTK_TABLE(fi->table),
			w,
			1,
			2,
			fi->nfault_actuals,
			fi->nfault_actuals + 1);

	for (addr = 0; addr < fi->nloc0s; addr++) {
		w = gtk_label_new(fi->loc0[addr].name);
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(fi->table),
				w,
				addr * 2 + 2,
				addr * 2 + 3,
				fi->nfault_actuals,
				fi->nfault_actuals + 1);

		w = gtk_label_new(loc0[addr]);
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(fi->table),
				w,
				addr * 2 + 3,
				addr * 2 + 4,
				fi->nfault_actuals,
				fi->nfault_actuals + 1);
	}
	for (addr = 0; addr < fi->nloc1s; addr++) {
		w = gtk_label_new(fi->loc1[addr].name);
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(fi->table),
				w,
				addr * 2 + 8 + 2,
				addr * 2 + 8 + 3,
				fi->nfault_actuals,
				fi->nfault_actuals + 1);

		w = gtk_label_new(loc1[addr]);
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(fi->table),
				w,
				addr * 2 + 8 + 3,
				addr * 2 + 8 + 4,
				fi->nfault_actuals,
				fi->nfault_actuals + 1);
	}

	fi->nfault_actuals++;
}

static void
gui_gtk_fi_add_event(GtkWidget *w, gpointer *_fi)
{
	GuiGtkFI *fi = (GuiGtkFI *) _fi;
	unsigned int addr;
	const char *loc0[4];
	const char *loc1[4];

	for (addr = 0; addr < fi->nloc0s; addr++) {
		loc0[addr] = gtk_entry_get_text(GTK_ENTRY(fi->loc0[addr].entry));
	}
	for (addr = 0; addr < fi->nloc1s; addr++) {
		loc1[addr] = gtk_entry_get_text(GTK_ENTRY(fi->loc1[addr].entry));
	}

	gui_gtk_fi_add(fi, fi->type, loc0, loc1);

	gtk_widget_hide(fi->dialog);
}

static void
gui_gtk_fi_close_event(GtkWidget *w, gpointer *_fi)
{
	GuiGtkFI *fi = (GuiGtkFI *) _fi;

	gtk_widget_hide(fi->dialog);
}

GtkWidget *
gui_gtk_fi_new(const char *type, const char *activator)
{
	GuiGtkFI *fi;
	const char *loc0[4];
	const char *loc1[4];

	fi = GUI_GTK_FI(g_object_new(GUIGTKFI_TYPE, NULL));

	/*
	 * Read fault types into object.
	 */
	fi->type = type;
	fi->activator = activator;
	fi->nloc0s = 0;
	fi->nloc1s = 0;

	fi->nfault_actuals = 0;

	/*
	 * Create Widget
	 */
	/* Current Faults Table */
	fi->table = gtk_table_new(1, 1, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(fi->table), 5);
	gtk_table_set_col_spacings(GTK_TABLE(fi->table), 5);
	gtk_widget_show(fi->table);
	gtk_box_pack_start(GTK_BOX(fi), fi->table, FALSE, FALSE, 1);

	gui_gtk_fi_add(fi, type, loc0, loc1);

	return GTK_WIDGET(fi);
}

GtkWidget *
gui_gtk_fi_pattern_new(const char *type, ...)
{
	va_list args;
	GuiGtkFI *fi;
	unsigned int addr;
	GtkDialog *dialog;
	GtkWidget *table;
	GtkWidget *w;
	char string[1000];

	fi = GUI_GTK_FI(g_object_new(GUIGTKFI_TYPE, NULL));

	/*
	 * Read fault types into object.
	 */
	va_start(args, type);

	fi->type = type;
	fi->activator = va_arg(args, const char *);
	fi->nloc0s = va_arg(args, unsigned int);
	for (addr = 0; addr < fi->nloc0s; addr++) {
		fi->loc0[addr].name = va_arg(args, const char *);
		assert(fi->loc0[addr].name);
		fi->loc0[addr].start = va_arg(args, unsigned long long);
		fi->loc0[addr].end = va_arg(args, unsigned long long);
		fi->loc0[addr].desc = va_arg(args, const char **);
	}
	fi->nloc1s = va_arg(args, unsigned int);
	for (addr = 0; addr < fi->nloc1s; addr++) {
		fi->loc1[addr].name = va_arg(args, const char *);
		assert(fi->loc1[addr].name);
		fi->loc1[addr].start = va_arg(args, unsigned long long);
		fi->loc1[addr].end = va_arg(args, unsigned long long);
		fi->loc1[addr].desc = va_arg(args, const char **);
	}

	va_end(args);

	fi->nfault_actuals = 0;

	/*
	 * Create Widget
	 */
	/* Current Faults Table */
	fi->table = gtk_table_new(1, 1, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(fi->table), 5);
	gtk_table_set_col_spacings(GTK_TABLE(fi->table), 5);
	gtk_widget_show(fi->table);
	gtk_box_pack_start(GTK_BOX(fi), fi->table, FALSE, FALSE, 1);

	/* Add Button */
	sprintf(string, "Add %s Fault", type);
	w = gtk_button_new_with_label(string);
	g_signal_connect(G_OBJECT(w), "clicked",
			  G_CALLBACK(gui_gtk_fi_start_event), fi);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(fi), w, FALSE, FALSE, 1);

	/*
	 * Create Dialog
	 */
	dialog = GTK_DIALOG(gtk_dialog_new());

	/* Head */
	sprintf(string, "%s (%s)", fi->type, fi->activator);
	w = gtk_label_new(string);

	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(dialog->vbox), w,
			FALSE, FALSE, 1);

	/* Address Parts */
	table = gtk_table_new(fi->nloc0s + fi->nloc1s, 2, 0);
	gtk_table_set_row_spacings(GTK_TABLE(table), 5);
	gtk_table_set_col_spacings(GTK_TABLE(table), 5);
	for (addr = 0; addr < fi->nloc0s; addr++) {
		/* Name (Start-End) */
		sprintf(string, "%s (0x%llx-0x%llx)",
				fi->loc0[addr].name,
				fi->loc0[addr].start,
				fi->loc0[addr].end);
		w = gtk_label_new(string);
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(table), w,
				0, 1, addr, addr + 1);

		/* User Entry */
		w = gtk_entry_new();
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(table), w,
				1, 2, addr, addr + 1);

		fi->loc0[addr].entry = w;
	}
	for ( ; addr < sizeof(fi->loc0) / sizeof(fi->loc0[0]); addr++) {
		fi->loc0[addr].entry = NULL;
	}
	for (addr = 0; addr < fi->nloc1s; addr++) {
		/* Name (Start-End) */
		sprintf(string, "%s (0x%llx-0x%llx)",
				fi->loc1[addr].name,
				fi->loc1[addr].start,
				fi->loc1[addr].end);
		w = gtk_label_new(string);
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(table), w,
				0, 1,
				fi->nloc0s + addr,
				fi->nloc0s + addr + 1);

		/* User Entry */
		w = gtk_entry_new();
		gtk_widget_show(w);
		gtk_table_attach_defaults(GTK_TABLE(table), w,
				1, 2,
				fi->nloc0s + addr,
				fi->nloc0s + addr + 1);

		fi->loc1[addr].entry = w;
	}
	for ( ; addr < sizeof(fi->loc1) / sizeof(fi->loc1[0]); addr++) {
		fi->loc1[addr].entry = NULL;
	}

	gtk_widget_show(table);
	gtk_box_pack_start(GTK_BOX(dialog->vbox), table,
			FALSE, FALSE, 1);

	/* "Add" Button */
	w = gtk_button_new_with_label("Add");
	g_signal_connect(G_OBJECT(w), "clicked",
			  G_CALLBACK(gui_gtk_fi_add_event), fi);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(dialog->action_area), w,
			FALSE, FALSE, 1);

	/* "Close" Button */
	w = gtk_button_new_with_label("Close");
	g_signal_connect(G_OBJECT(w), "clicked",
			  G_CALLBACK(gui_gtk_fi_close_event), fi);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(dialog->action_area), w,
			FALSE, FALSE, 1);

	fi->dialog = GTK_WIDGET(dialog);

	return GTK_WIDGET(fi);
}

void
gui_gtk_fi_set(
	GuiGtkFI *fi,
	const char *type,
	unsigned int activator,
	unsigned long long loc0,
	unsigned long long loc1
)
{
}
