-- $Id: test_bench.vhdl,v 1.1 2009-02-19 12:38:41 potyra Exp $
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ext_eth0 : eth;
	signal ext_eth1 : eth;
	signal ext_usb0 : usb_bus;
	signal ext_usb1 : usb_bus;
	signal ext_par : parallel;
	signal ext_ser0 : serial;
	signal ext_ser1 : serial;
	signal ext_card0 : cardbus;
	signal ext_card1 : cardbus;

	signal power_switch : boolean;
	signal power_button : boolean;
	signal reset_button : boolean;

	signal cdrom : boolean;
	signal floppy : boolean;

	signal key : boolean_array(0 to 127);

	signal mouse_dx : character;
	signal mouse_dy : character;
	signal mouse_button1 : boolean;
	signal mouse_button2 : boolean;
	signal mouse_button3 : boolean;

	signal screen_shot : integer;

begin
	pc : pc_standard
		generic map(
			memsize => 64,
			disksize => 128
		)
		port map(
			ext_eth0 => ext_eth0,
			ext_usb0 => ext_usb0,
			ext_usb1 => ext_usb1,
			ext_par => ext_par,
			ext_ser0 => ext_ser0,
			ext_ser1 => ext_ser1,
			power_switch => power_switch,
			power_button => power_button,
			reset_button => reset_button,
			cdrom => cdrom,
			floppy => floppy,
			key => key,
			mouse_dx => mouse_dx,
			mouse_dy => mouse_dy,
			mouse_button1 => mouse_button1,
			mouse_button2 => mouse_button2,
			mouse_button3 => mouse_button3,
			screen_shot => screen_shot
		);
	bridge : network_router
		port map(
			eth => ext_eth0
		);
	user : user
		port map(
			power_switch => power_switch,
			power_button => power_button,
			reset_button => reset_button,
			cdrom => cdrom,
			floppy => floppy,
			key => key,
			mouse_dx => mouse_dx,
			mouse_dy => mouse_dy,
			mouse_button1 => mouse_button1,
			mouse_button2 => mouse_button2,
			mouse_button3 => mouse_button3,
			screen_shot => screen_shot
		);
end structural;
