# This file is part of the Falcon repository manager
# Copyright (C) 2005-2008 Dennis Kaarsemaker
# See the file named COPYING in the root of the source tree for license details
#
# bc.py - Functionality for maintaining backwards compatibility

import falcon
from django.db import connection
from django.core import management
import django.conf

def upgrade_db():
    """ Upgrade the database if the database interface changes """
    falcon.util.output(_("Upgrading the database stucture from %s to %s") % (str(falcon.conf.my_database_abi), str(falcon.conf.database_abi)))
    cursor = connection.cursor()
    if falcon.conf.my_database_abi[0] < 2 and falcon.conf.database_abi[0] >= 2:
        # Mirror.rsync_opts changed from Entry to QuotedEntry and CharField to PickleField
        # 'Alter' the table
        if django.conf.settings.DATABASE_ENGINE == 'sqlite3':
            sql, ref = management._get_sql_model_create(falcon.mirror.Mirror, [])
            cursor.execute('CREATE TEMPORARY TABLE "mirrors_b" (id, name, webbase, rsync, rsync_opts, sponsor, comment);')
            cursor.execute('INSERT INTO "mirrors_b" SELECT * from "falcon_mirror";')
            cursor.execute('DROP TABLE "falcon_mirror";')
            cursor.execute(sql[0])
            cursor.execute('INSERT INTO "falcon_mirror" SELECT * from "mirrors_b";')
            cursor.execute('DROP TABLE "mirrors_b";')
        else:
            cursor.execute('ALTER TABLE falcon_mirror MODIFY rsync_opts text;')
        # Alter the data
        for m in falcon.mirror.Mirror.objects.all():
            m.rsync_opts = m.rsync_opts.split()
            m.save()
    if falcon.conf.my_database_abi[0] < 3 and falcon.conf.database_abi[0] >= 3:
        if django.conf.settings.DATABASE_ENGINE == 'sqlite3':
            sql, ref = management._get_sql_model_create(falcon.package.SourcePackage, [])
            cursor.execute('CREATE TEMPORARY TABLE "sourcepackage_b" (id, component_id, is_fake, filename, mtime, packagename, version, control, controlfields, files, sourcefiles, changelog, missing_binaries);')
            cursor.execute('INSERT INTO "sourcepackage_b" SELECT * from "falcon_sourcepackage";')
            cursor.execute('DROP TABLE "falcon_sourcepackage";')
            cursor.execute(sql[0])
            cursor.execute('INSERT INTO "falcon_sourcepackage" SELECT id, component_id, is_fake, filename, mtime, packagename, version, control, controlfields, files, sourcefiles, changelog from "sourcepackage_b";')
            cursor.execute('DROP TABLE "sourcepackage_b";')
        else:
            try:
                cursor.execute('ALTER TABLE falcon_sourcepackage DROP COLUMN missing_binaries;')
            except:
                pass

    falcon.conf.my_database_abi = falcon.conf.database_abi
