/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_WLAN_H
#define _ENM_WLAN_H

#include <wx/string.h>
#include <sdk/ENMApi.h>
#include <ENMDef.h>

wxString MacAddressToString(const unsigned char* mac);

bool StringToMacAddress(unsigned char* mac, const char* str, size_t strLen);

int CompareMacAddress(unsigned char* mac1, unsigned char* mac2);

bool operator == (const WlanSsid& ssid1, const WlanSsid& ssid2);
bool operator != (const WlanSsid& ssid1, const WlanSsid& ssid2);


#endif // _ENM_WLAN_H
