/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _WLAN_SCANNER_H
#define _WLAN_SCANNER_H

#include <wx/event.h>
#include "wlan.h"

enum WlanResult
{
    WLAN_SUCCESS = 0,
    WLAN_INVALID_HANDLE = 1,
    WLAN_NO_INTERFACE = 2,
    WLAN_INVALID_PARAMETER = 3,
    WLAN_SCAN_ERROR = 4,
    WLAN_CONNECTION_ERROR = 5,
    WLAN_REGISTER_ERROR = 6,
    WLAN_PROFILE_ERROR = 7,
    WLAN_DATA_LOST = 8,
    WLAN_UNKNOWN_AUTH = 9,
    WLAN_ERROR = 100
};

class WlanScanner : public wxEvtHandler
{
    public:
        WlanScanner();
        virtual ~WlanScanner();

        virtual wxString GetCurrentWlanAdapterId();
};


#if defined(__UNIX__)
#include "WirelessScanner.h"
#endif

#endif // _WLAN_SCANNER_H
