/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ViewMeshNeighborsDlg.h"
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>

#include <ENMDef.h>
#include <sdk/ENMApi.h>
#include "ENMUtil.h"
#include "ENMApp.h"

const long ViewMeshNeighborsDlg::ID_STATICTEXT1 = wxNewId();
const long ViewMeshNeighborsDlg::ID_LISTCTRL = wxNewId();
const long ViewMeshNeighborsDlg::ID_BUTTON_REFRESH = wxNewId();
const long ViewMeshNeighborsDlg::ID_BUTTON_OK = wxNewId();
const long ViewMeshNeighborsDlg::ID_STATICLINE1 = wxNewId();
const long ViewMeshNeighborsDlg::ID_PANEL1 = wxNewId();
const long ViewMeshNeighborsDlg::ID_STATICBITMAP1 = wxNewId();

const long ViewMeshNeighborsDlg::ID_TIMER_SEARCH = wxNewId();
BEGIN_EVENT_TABLE(ViewMeshNeighborsDlg,wxDialog)
	//(*EventTable(ViewMeshNeighborsDlg)
	//*)
	EVT_CLOSE(ViewMeshNeighborsDlg::OnCloseClicked)
	EVT_TIMER(ID_TIMER_SEARCH, ViewMeshNeighborsDlg::OnTimer)
END_EVENT_TABLE()

ViewMeshNeighborsDlg::ViewMeshNeighborsDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString strImagePath = ::wxGetApp().strAppPath + _T("pic/ViewNeighbors.png");
	Create(parent, wxID_ANY, _("Mesh Neighbors"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(450,330));
	Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(0,0), wxSize(450,330), wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("View network neighbors here. Click \"Refresh\" to refresh network neighbors information..."), wxPoint(72,8), wxSize(368,48), 0, _T("ID_STATICTEXT1"));
	m_list = new wxListCtrl(Panel1, ID_LISTCTRL, wxPoint(15,56), wxSize(420,200), wxLC_REPORT, wxDefaultValidator, _T("ID_LISTCTRL"));
	ButtonRefresh = new wxButton(Panel1, ID_BUTTON_REFRESH, _("Refresh"), wxPoint(256,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_REFRESH"));
	ButtonOK = new wxButton(Panel1, ID_BUTTON_OK, _("OK"), wxPoint(352,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	StaticLine1 = new wxStaticLine(Panel1, ID_STATICLINE1, wxPoint(0,275), wxSize(450,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
	StaticBitmap1 = new wxStaticBitmap(Panel1, ID_STATICBITMAP1, wxBitmap(wxImage(strImagePath).Rescale(wxSize(48,48).GetWidth(),wxSize(48,48).GetHeight())), wxPoint(15,8), wxSize(48,48), 0, _T("ID_STATICBITMAP1"));

	Connect(ID_BUTTON_REFRESH,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ViewMeshNeighborsDlg::OnButtonRefreshClick);
	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ViewMeshNeighborsDlg::OnButtonOKClick);

	wxListItem itemCol;
    itemCol.SetText(_("Hostname "));
    m_list->InsertColumn(0, itemCol);
    m_list->SetColumnWidth(0, 180);

    itemCol.SetText(_("MAC Address"));
    m_list->InsertColumn(1, itemCol);
    m_list->SetColumnWidth(1, 160);

    itemCol.SetText(_("Strength"));
    m_list->InsertColumn(2, itemCol);
    m_list->SetColumnWidth(2, 80);
    wxIcon icon;
    wxBitmap bitmap(strImagePath, wxBITMAP_TYPE_PNG);
    icon.CopyFromBitmap(bitmap);
    SetIcon(icon);

    itemCol.SetAlign(wxLIST_FORMAT_CENTRE);
    m_pGaugeDialog = new GaugeDialog(this);
    m_searchTimer.SetOwner(this, ID_TIMER_SEARCH);
}

ViewMeshNeighborsDlg::~ViewMeshNeighborsDlg()
{
	//(*Destroy(ViewMeshNeighborsDlg)
	//*)
    m_pGaugeDialog->Destroy();
    m_pGaugeDialog = NULL;
}

bool ViewMeshNeighborsDlg::Show(bool ifShow)
{
    wxDialog::Show(ifShow);
    if ( ifShow )
    {
        m_list->DeleteAllItems();
        BeginSearch();
    }
}

void ViewMeshNeighborsDlg::OnButtonRefreshClick(wxCommandEvent& event)
{
    m_list->DeleteAllItems();
    BeginSearch();
}

void ViewMeshNeighborsDlg::OnButtonOKClick(wxCommandEvent& event)
{
    SetReturnCode(wxID_OK);
    Show(false);
}

void ViewMeshNeighborsDlg::Refresh()
{
    printf("ViewMeshNeighborsDlg::Refresh start\n");
    //m_list->DeleteAllItems();

    MESH_NEIGHBOR_INFO meshNeighInfo;
    memset(&meshNeighInfo, 0, sizeof(MESH_NEIGHBOR_INFO));
    DCS_ListAllNeighborMPs(&meshNeighInfo);

    int iCount = meshNeighInfo.num;
    printf("[ViewMeshNeighborsDlg]Get list count= %d \n", iCount);
    m_pGaugeDialog->Show(false);
    if ( iCount > 0 )
    {
        wxString buf;
        buf = _T("13");
        for ( int i = 0; i < iCount; i++ )
        {
            MESH_NEIGHBOR_ENTRY_INFO mesh_entry = meshNeighInfo.Entry[i];
            m_list->InsertItem(i, buf);
            char* strServerNameAll = (char*)(mesh_entry.HostName);
            printf("[ViewMeshNeighborsDlg]All Server name: %s\n", (const char*)(mesh_entry.HostName));

            wxString wxHostName;
            int iNameLen = strlen(strServerNameAll);
            if ( strServerNameAll[iNameLen-1] == '?')
            {
                strServerNameAll += 12;
                printf("[ViewMeshNeighborsDlg]HostName= %s", strServerNameAll);
                wxHostName = ENMUtil::StringToWxString(strServerNameAll);
                m_list->SetItem(i,0,wxHostName.Left(wxHostName.Length()-1));
            }
            else
            {
                printf("[ViewMeshNeighborsDlg]HostName= %s", strServerNameAll);
                wxHostName = ENMUtil::StringToWxString(strServerNameAll);
                m_list->SetItem(i,0,wxHostName);
            }

            char mac[256] = {'\0'};
            sprintf(mac, "%02x:%02x:%02x:%02x:%02x:%02x",
					mesh_entry.MacAddr[0],
					mesh_entry.MacAddr[1],
					mesh_entry.MacAddr[2],
					mesh_entry.MacAddr[3],
					mesh_entry.MacAddr[4],
					mesh_entry.MacAddr[5]);

            m_list->SetItem(i, 1, ENMUtil::StringToWxString(mac));

            int nRSSI = 0;
            nRSSI = 2 * mesh_entry.Rssi + 200;
            if(nRSSI>100)
                nRSSI =100;
            if(nRSSI<0)
                nRSSI =0;

            m_list->SetItem(i,2, wxString::Format(wxT("%d"), nRSSI));

        }
    }
    else
    {
        printf("Could not find any neighbor\n");
        wxMessageDialog dlg(this, _("Could not find any neighbor!"), _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }
    printf("ViewMeshNeighborsDlg::Refresh end\n");
}

//void ViewMeshNeighborsDlg::OnInit(wxInitDialogEvent& event)
//{
//    BeginSearch();
//
//}

void ViewMeshNeighborsDlg::OnCloseClicked(wxCloseEvent& event)
{
    SetReturnCode(wxID_CANCEL);
    Show(false);
}

void ViewMeshNeighborsDlg::BeginSearch()
{
    //start scan channel
    DCS_SetMeshChannelOFFSET(6);

    m_pGaugeDialog->SetProcessLabel(_("Searching for network neighbors..."));
    m_pGaugeDialog->Move(377, 270);
    m_pGaugeDialog->Show(true);
    m_searchTimer.Start(2000, true);
}

void ViewMeshNeighborsDlg::OnTimer(wxTimerEvent& event)
{
    Refresh();
}

